/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.InfoRegistryConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.test.serdes.JSONSamples;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.annotations.Test;

public class InfoTest {
    @Test
    public void serder1Json() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().constructType(Info.class);
        Info info = (Info)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "info/1.json", type);
        List<List> driverStatus = Arrays.asList(Arrays.asList("Root Dir", "/mnt/sda1/var/lib/docker/aufs"), Arrays.asList("Backing Filesystem", "extfs"), Arrays.asList("Dirs", "31"), Arrays.asList("Dirperm1 Supported", "true"));
        LinkedHashMap<String, List<String>> plugins = new LinkedHashMap<String, List<String>>();
        plugins.put("Volume", Collections.singletonList("local"));
        plugins.put("Network", Arrays.asList("bridge", "null", "host"));
        plugins.put("Authorization", null);
        MatcherAssert.assertThat((Object)info, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)info.getArchitecture(), (Matcher)Matchers.equalTo((Object)"x86_64"));
        MatcherAssert.assertThat((Object)info.getContainersStopped(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)info.getContainersPaused(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)info.getContainersRunning(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)info.getCpuCfsPeriod(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getCpuCfsQuota(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getDiscoveryBackend(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)info.getOomScoreAdj(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)info.getDriverStatuses(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)info.getDriverStatuses(), (Matcher)Matchers.hasSize((int)4));
        MatcherAssert.assertThat((Object)info.getDriverStatuses(), (Matcher)Matchers.equalTo(driverStatus));
        MatcherAssert.assertThat((Object)info.getNGoroutines(), (Matcher)CoreMatchers.is((Object)40));
        MatcherAssert.assertThat((Object)info.getSystemStatus(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)info.getPlugins(), (Matcher)Matchers.equalTo(plugins));
        MatcherAssert.assertThat((Object)info.getPlugins(), (Matcher)Matchers.hasEntry((Object)"Volume", Collections.singletonList("local")));
        MatcherAssert.assertThat((Object)info.getPlugins(), (Matcher)Matchers.hasEntry((Object)"Authorization", null));
        MatcherAssert.assertThat((Object)info.getExperimentalBuild(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)info.getHttpProxy(), (Matcher)Matchers.isEmptyString());
        MatcherAssert.assertThat((Object)info.getHttpsProxy(), (Matcher)Matchers.isEmptyString());
        MatcherAssert.assertThat((Object)info.getNoProxy(), (Matcher)Matchers.isEmptyString());
        MatcherAssert.assertThat((Object)info.getOomKillDisable(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getOsType(), (Matcher)Matchers.equalTo((Object)"linux"));
        InfoRegistryConfig registryConfig = info.getRegistryConfig();
        MatcherAssert.assertThat((Object)registryConfig, (Matcher)Matchers.notNullValue());
        List cidRs = registryConfig.getInsecureRegistryCIDRs();
        MatcherAssert.assertThat((Object)cidRs, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)cidRs, (Matcher)Matchers.contains((Object[])new String[]{"127.0.0.0/8"}));
        Map indexConfigs = registryConfig.getIndexConfigs();
        MatcherAssert.assertThat((Object)indexConfigs, (Matcher)Matchers.notNullValue());
        InfoRegistryConfig.IndexConfig indexConfig = new InfoRegistryConfig.IndexConfig().withMirrors(null).withName("docker.io").withSecure(Boolean.valueOf(true)).withOfficial(Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)indexConfigs, (Matcher)Matchers.hasEntry((Object)"docker.io", (Object)indexConfig));
        MatcherAssert.assertThat((Object)registryConfig.getMirrors(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)info.getSystemTime(), (Matcher)CoreMatchers.is((Object)"2016-02-17T14:56:35.212841831Z"));
        MatcherAssert.assertThat((Object)info.getServerVersion(), (Matcher)CoreMatchers.is((Object)"1.10.1"));
        MatcherAssert.assertThat((Object)info.getCpuSet(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getCpuShares(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getIPv4Forwarding(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getBridgeNfIptables(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getBridgeNfIp6tables(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getDebug(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getNFd(), (Matcher)CoreMatchers.is((Object)24));
        MatcherAssert.assertThat((Object)info.getOomKillDisable(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getLoggingDriver(), (Matcher)CoreMatchers.is((Object)"json-file"));
        MatcherAssert.assertThat((Object)info.getOperatingSystem(), (Matcher)CoreMatchers.is((Object)"Boot2Docker 1.10.1 (TCL 6.4.1); master : b03e158 - Thu Feb 11 22:34:01 UTC 2016"));
        MatcherAssert.assertThat((Object)info.getClusterStore(), (Matcher)CoreMatchers.is((Object)""));
        Info withInfo = new Info().withArchitecture("x86_64").withContainers(Integer.valueOf(2)).withContainersRunning(Integer.valueOf(2)).withContainersPaused(Integer.valueOf(10)).withContainersStopped(Integer.valueOf(3)).withImages(Integer.valueOf(13)).withId("HLN2:5SBU:SRQR:CQI6:AB52:LZZ2:DED5:REDM:BU73:JFHE:R37A:5HMX").withDriver("aufs").withDriverStatuses(driverStatus).withSystemStatus(null).withPlugins(plugins).withMemoryLimit(Boolean.valueOf(true)).withSwapLimit(Boolean.valueOf(true)).withCpuCfsPeriod(Boolean.valueOf(true)).withCpuCfsQuota(Boolean.valueOf(true)).withCpuShares(Boolean.valueOf(true)).withCpuSet(Boolean.valueOf(true)).withIPv4Forwarding(Boolean.valueOf(true)).withBridgeNfIptables(Boolean.valueOf(true)).withBridgeNfIp6tables(Boolean.valueOf(true)).withDebug(Boolean.valueOf(true)).withNFd(Integer.valueOf(24)).withOomKillDisable(Boolean.valueOf(true)).withNGoroutines(Integer.valueOf(40)).withSystemTime("2016-02-17T14:56:35.212841831Z").withExecutionDriver("native-0.2").withLoggingDriver("json-file").withNEventsListener(Integer.valueOf(0)).withKernelVersion("4.1.17-boot2docker").withOperatingSystem("Boot2Docker 1.10.1 (TCL 6.4.1); master : b03e158 - Thu Feb 11 22:34:01 UTC 2016").withOsType("linux").withIndexServerAddress("https://index.docker.io/v1/").withRegistryConfig(registryConfig).withInitSha1("").withInitPath("/usr/local/bin/docker").withNCPU(Integer.valueOf(1)).withMemTotal(Long.valueOf(1044574208L)).withDockerRootDir("/mnt/sda1/var/lib/docker").withHttpProxy("").withHttpsProxy("").withNoProxy("").withName("docker-java").withLabels(new String[]{"provider=virtualbox"}).withExperimentalBuild(Boolean.valueOf(false)).withServerVersion("1.10.1").withClusterStore("").withClusterAdvertise("").withDiscoveryBackend(null).withOomScoreAdj(null).withSockets(null);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.is((Object)withInfo));
    }

    @Test
    public void serder2Json() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JavaType type = mapper.getTypeFactory().constructType(Info.class);
        Info info = (Info)JSONSamples.testRoundTrip(RemoteApiVersion.VERSION_1_22, "info/2.json", type);
        List<List> driverStatus = Arrays.asList(Arrays.asList("Pool Name", "docker-253:2-17567992-pool"), Arrays.asList("Pool Blocksize", "65.54 kB"), Arrays.asList("Base Device Size", "107.4 GB"), Arrays.asList("Backing Filesystem", "ext4"), Arrays.asList("Data file", "/dev/loop0"), Arrays.asList("Metadata file", "/dev/loop1"), Arrays.asList("Data Space Used", "3.89 GB"), Arrays.asList("Data Space Total", "107.4 GB"), Arrays.asList("Data Space Available", "103.5 GB"), Arrays.asList("Metadata Space Used", "5.46 MB"), Arrays.asList("Metadata Space Total", "2.147 GB"), Arrays.asList("Metadata Space Available", "2.142 GB"), Arrays.asList("Udev Sync Supported", "true"), Arrays.asList("Deferred Removal Enabled", "false"), Arrays.asList("Deferred Deletion Enabled", "false"), Arrays.asList("Deferred Deleted Device Count", "0"), Arrays.asList("Data loop file", "/var/lib/docker/devicemapper/devicemapper/data"), Arrays.asList("Metadata loop file", "/var/lib/docker/devicemapper/devicemapper/metadata"), Arrays.asList("Library Version", "1.02.107-RHEL7 (2015-12-01)"));
        LinkedHashMap<String, List<String>> plugins = new LinkedHashMap<String, List<String>>();
        plugins.put("Volume", Collections.singletonList("local"));
        plugins.put("Network", Arrays.asList("null", "host", "bridge"));
        plugins.put("Authorization", null);
        MatcherAssert.assertThat((Object)info, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)info.getArchitecture(), (Matcher)Matchers.equalTo((Object)"x86_64"));
        MatcherAssert.assertThat((Object)info.getContainersStopped(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)info.getContainersPaused(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)info.getContainersRunning(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)info.getCpuCfsPeriod(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getCpuCfsQuota(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getDiscoveryBackend(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)info.getOomScoreAdj(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)info.getDriverStatuses(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)info.getDriverStatuses(), (Matcher)Matchers.hasSize((int)19));
        MatcherAssert.assertThat((Object)info.getDriverStatuses(), (Matcher)Matchers.equalTo(driverStatus));
        MatcherAssert.assertThat((Object)info.getNGoroutines(), (Matcher)CoreMatchers.is((Object)30));
        MatcherAssert.assertThat((Object)info.getSystemStatus(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)info.getPlugins(), (Matcher)Matchers.equalTo(plugins));
        MatcherAssert.assertThat((Object)info.getPlugins(), (Matcher)Matchers.hasEntry((Object)"Volume", Collections.singletonList("local")));
        MatcherAssert.assertThat((Object)info.getPlugins(), (Matcher)Matchers.hasEntry((Object)"Authorization", null));
        MatcherAssert.assertThat((Object)info.getExperimentalBuild(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)info.getHttpProxy(), (Matcher)Matchers.isEmptyString());
        MatcherAssert.assertThat((Object)info.getHttpsProxy(), (Matcher)Matchers.isEmptyString());
        MatcherAssert.assertThat((Object)info.getNoProxy(), (Matcher)Matchers.isEmptyString());
        MatcherAssert.assertThat((Object)info.getOomKillDisable(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getOsType(), (Matcher)Matchers.equalTo((Object)"linux"));
        InfoRegistryConfig registryConfig = info.getRegistryConfig();
        MatcherAssert.assertThat((Object)registryConfig, (Matcher)Matchers.notNullValue());
        List cidRs = registryConfig.getInsecureRegistryCIDRs();
        MatcherAssert.assertThat((Object)cidRs, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)cidRs, (Matcher)Matchers.contains((Object[])new String[]{"127.0.0.0/8"}));
        Map indexConfigs = registryConfig.getIndexConfigs();
        MatcherAssert.assertThat((Object)indexConfigs, (Matcher)Matchers.notNullValue());
        InfoRegistryConfig.IndexConfig indexConfig = new InfoRegistryConfig.IndexConfig().withMirrors(null).withName("docker.io").withSecure(Boolean.valueOf(true)).withOfficial(Boolean.valueOf(true));
        MatcherAssert.assertThat((Object)indexConfigs, (Matcher)Matchers.hasEntry((Object)"docker.io", (Object)indexConfig));
        InfoRegistryConfig.IndexConfig indexConfig2 = new InfoRegistryConfig.IndexConfig().withMirrors(Collections.emptyList()).withName("somehost:80").withSecure(Boolean.valueOf(false)).withOfficial(Boolean.valueOf(false));
        MatcherAssert.assertThat((Object)indexConfigs, (Matcher)Matchers.hasEntry((Object)"somehost:80", (Object)indexConfig2));
        MatcherAssert.assertThat((Object)registryConfig.getMirrors(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)info.getSystemTime(), (Matcher)CoreMatchers.is((Object)"2016-03-20T17:32:06.598846244+01:00"));
        MatcherAssert.assertThat((Object)info.getServerVersion(), (Matcher)CoreMatchers.is((Object)"1.10.2"));
        MatcherAssert.assertThat((Object)info.getCpuSet(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getCpuShares(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getIPv4Forwarding(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getBridgeNfIptables(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)info.getBridgeNfIp6tables(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)info.getDebug(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)info.getNFd(), (Matcher)CoreMatchers.is((Object)13));
        MatcherAssert.assertThat((Object)info.getOomKillDisable(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)info.getLoggingDriver(), (Matcher)CoreMatchers.is((Object)"json-file"));
        MatcherAssert.assertThat((Object)info.getOperatingSystem(), (Matcher)CoreMatchers.is((Object)"Red Hat Enterprise Linux Workstation 7.2 (Maipo)"));
        MatcherAssert.assertThat((Object)info.getClusterStore(), (Matcher)CoreMatchers.is((Object)""));
        Info withInfo = new Info().withArchitecture("x86_64").withContainers(Integer.valueOf(2)).withContainersRunning(Integer.valueOf(0)).withContainersPaused(Integer.valueOf(0)).withContainersStopped(Integer.valueOf(2)).withImages(Integer.valueOf(55)).withId("H52J:52LG:YP4W:EHKY:SRK5:RYG6:ETWR:7AR3:MTFJ:PC6C:4YF2:NTN2").withDriver("devicemapper").withDriverStatuses(driverStatus).withSystemStatus(null).withPlugins(plugins).withMemoryLimit(Boolean.valueOf(true)).withSwapLimit(Boolean.valueOf(true)).withCpuCfsPeriod(Boolean.valueOf(true)).withCpuCfsQuota(Boolean.valueOf(true)).withCpuShares(Boolean.valueOf(true)).withCpuSet(Boolean.valueOf(true)).withIPv4Forwarding(Boolean.valueOf(true)).withBridgeNfIptables(Boolean.valueOf(false)).withBridgeNfIp6tables(Boolean.valueOf(false)).withDebug(Boolean.valueOf(false)).withNFd(Integer.valueOf(13)).withOomKillDisable(Boolean.valueOf(true)).withNGoroutines(Integer.valueOf(30)).withSystemTime("2016-03-20T17:32:06.598846244+01:00").withExecutionDriver("native-0.2").withLoggingDriver("json-file").withNEventsListener(Integer.valueOf(0)).withKernelVersion("3.10.0-327.10.1.el7.x86_64").withOperatingSystem("Red Hat Enterprise Linux Workstation 7.2 (Maipo)").withOsType("linux").withIndexServerAddress("https://index.docker.io/v1/").withRegistryConfig(registryConfig).withInitSha1("672d65f3cf8816fbda421afeed7e52c0ca17d5e7").withInitPath("/usr/libexec/docker/dockerinit").withNCPU(Integer.valueOf(8)).withMemTotal(Long.valueOf(33350918144L)).withDockerRootDir("/var/lib/docker").withHttpProxy("").withHttpsProxy("").withNoProxy("").withName("somename").withLabels(null).withExperimentalBuild(Boolean.valueOf(false)).withServerVersion("1.10.2").withClusterStore("").withClusterAdvertise("").withDiscoveryBackend(null).withOomScoreAdj(null).withSockets(null);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.is((Object)withInfo));
    }
}

