/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.PullResponseJSONSamples;
import com.github.dockerjava.test.serdes.JSONTestHelper;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PullResponseItemTest {
    @Test
    public void pullNewerImage() throws IOException {
        PullResponseItem response = JSONTestHelper.testRoundTrip(PullResponseJSONSamples.pullImageResponse_newerImage, PullResponseItem.class);
        Assert.assertTrue((boolean)response.isPullSuccessIndicated());
        Assert.assertFalse((boolean)response.isErrorIndicated());
    }

    @Test
    public void pullUpToDate() throws IOException {
        PullResponseItem response = JSONTestHelper.testRoundTrip(PullResponseJSONSamples.pullImageResponse_upToDate, PullResponseItem.class);
        Assert.assertTrue((boolean)response.isPullSuccessIndicated());
        Assert.assertFalse((boolean)response.isErrorIndicated());
    }

    @Test
    public void pullLegacyRegistry() throws IOException {
        PullResponseItem response = JSONTestHelper.testRoundTrip(PullResponseJSONSamples.pullImageResponse_legacy, PullResponseItem.class);
        Assert.assertTrue((boolean)response.isPullSuccessIndicated());
        Assert.assertFalse((boolean)response.isErrorIndicated());
    }

    @Test
    public void pullAndEncounterError() throws IOException {
        PullResponseItem response = JSONTestHelper.testRoundTrip(PullResponseJSONSamples.pullImageResponse_error, PullResponseItem.class);
        Assert.assertFalse((boolean)response.isPullSuccessIndicated());
        Assert.assertTrue((boolean)response.isErrorIndicated());
    }
}

