/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.RestartPolicy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RestartPolicy_SerializingTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Test
    public void noRestart() throws Exception {
        String json = this.objectMapper.writeValueAsString((Object)RestartPolicy.noRestart());
        Assert.assertEquals((String)json, (String)"{\"MaximumRetryCount\":0,\"Name\":\"\"}");
    }

    @Test
    public void alwaysRestart() throws Exception {
        String json = this.objectMapper.writeValueAsString((Object)RestartPolicy.alwaysRestart());
        Assert.assertEquals((String)json, (String)"{\"MaximumRetryCount\":0,\"Name\":\"always\"}");
    }

    @Test
    public void unlessStoppedRestart() throws Exception {
        String json = this.objectMapper.writeValueAsString((Object)RestartPolicy.unlessStoppedRestart());
        Assert.assertEquals((String)json, (String)"{\"MaximumRetryCount\":0,\"Name\":\"unless-stopped\"}");
    }

    @Test
    public void onFailureRestart() throws Exception {
        String json = this.objectMapper.writeValueAsString((Object)RestartPolicy.onFailureRestart((int)0));
        Assert.assertEquals((String)json, (String)"{\"MaximumRetryCount\":0,\"Name\":\"on-failure\"}");
    }

    @Test
    public void onFailureRestartWithCount() throws Exception {
        String json = this.objectMapper.writeValueAsString((Object)RestartPolicy.onFailureRestart((int)2));
        Assert.assertEquals((String)json, (String)"{\"MaximumRetryCount\":2,\"Name\":\"on-failure\"}");
    }
}

