/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateImageResponse;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.CreateVolumeCmd;
import com.github.dockerjava.api.command.CreateVolumeResponse;
import com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import com.github.dockerjava.api.command.DockerCmd;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectExecCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.InspectNetworkCmd;
import com.github.dockerjava.api.command.InspectVolumeCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.ListNetworksCmd;
import com.github.dockerjava.api.command.ListVolumesCmd;
import com.github.dockerjava.api.command.LoadImageCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RemoveNetworkCmd;
import com.github.dockerjava.api.command.RemoveVolumeCmd;
import com.github.dockerjava.api.command.RenameContainerCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.UpdateContainerCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.DockerClientConfig;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public class TestDockerCmdExecFactory
implements DockerCmdExecFactory {
    private List<String> containerNames = new ArrayList<String>();
    private List<String> imageNames = new ArrayList<String>();
    private List<String> volumeNames = new ArrayList<String>();
    private List<String> networkIds = new ArrayList<String>();
    private DockerCmdExecFactory delegate;

    public TestDockerCmdExecFactory(DockerCmdExecFactory delegate) {
        this.delegate = delegate;
    }

    public void init(DockerClientConfig dockerClientConfig) {
        this.delegate.init(dockerClientConfig);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        return new CreateContainerCmd.Exec(){

            public CreateContainerResponse exec(CreateContainerCmd command) {
                CreateContainerResponse createContainerResponse = (CreateContainerResponse)TestDockerCmdExecFactory.this.delegate.createCreateContainerCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.containerNames.add(createContainerResponse.getId());
                return createContainerResponse;
            }
        };
    }

    public RemoveContainerCmd.Exec createRemoveContainerCmdExec() {
        return new RemoveContainerCmd.Exec(){

            public Void exec(RemoveContainerCmd command) {
                TestDockerCmdExecFactory.this.delegate.createRemoveContainerCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.containerNames.remove(command.getContainerId());
                return null;
            }
        };
    }

    public CreateImageCmd.Exec createCreateImageCmdExec() {
        return new CreateImageCmd.Exec(){

            public CreateImageResponse exec(CreateImageCmd command) {
                CreateImageResponse createImageResponse = (CreateImageResponse)TestDockerCmdExecFactory.this.delegate.createCreateImageCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.imageNames.add(createImageResponse.getId());
                return createImageResponse;
            }
        };
    }

    public LoadImageCmd.Exec createLoadImageCmdExec() {
        return new LoadImageCmd.Exec(){

            public Void exec(LoadImageCmd command) {
                TestDockerCmdExecFactory.this.delegate.createLoadImageCmdExec().exec((DockerCmd)command);
                return null;
            }
        };
    }

    public RemoveImageCmd.Exec createRemoveImageCmdExec() {
        return new RemoveImageCmd.Exec(){

            public Void exec(RemoveImageCmd command) {
                TestDockerCmdExecFactory.this.delegate.createRemoveImageCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.imageNames.remove(command.getImageId());
                return null;
            }
        };
    }

    public BuildImageCmd.Exec createBuildImageCmdExec() {
        return new BuildImageCmd.Exec(){

            public Void exec(BuildImageCmd command, ResultCallback<BuildResponseItem> resultCallback) {
                String tag = command.getTag();
                if (tag == null || "".equals(tag.trim())) {
                    tag = "" + new SecureRandom().nextInt(Integer.MAX_VALUE);
                    command.withTag(tag);
                }
                TestDockerCmdExecFactory.this.delegate.createBuildImageCmdExec().exec((DockerCmd)command, resultCallback);
                TestDockerCmdExecFactory.this.imageNames.add(tag);
                return null;
            }
        };
    }

    public AuthCmd.Exec createAuthCmdExec() {
        return this.delegate.createAuthCmdExec();
    }

    public InfoCmd.Exec createInfoCmdExec() {
        return this.delegate.createInfoCmdExec();
    }

    public PingCmd.Exec createPingCmdExec() {
        return this.delegate.createPingCmdExec();
    }

    public ExecCreateCmd.Exec createExecCmdExec() {
        return this.delegate.createExecCmdExec();
    }

    public VersionCmd.Exec createVersionCmdExec() {
        return this.delegate.createVersionCmdExec();
    }

    public PullImageCmd.Exec createPullImageCmdExec() {
        return this.delegate.createPullImageCmdExec();
    }

    public PushImageCmd.Exec createPushImageCmdExec() {
        return this.delegate.createPushImageCmdExec();
    }

    public SaveImageCmd.Exec createSaveImageCmdExec() {
        return this.delegate.createSaveImageCmdExec();
    }

    public SearchImagesCmd.Exec createSearchImagesCmdExec() {
        return this.delegate.createSearchImagesCmdExec();
    }

    public ListImagesCmd.Exec createListImagesCmdExec() {
        return this.delegate.createListImagesCmdExec();
    }

    public InspectImageCmd.Exec createInspectImageCmdExec() {
        return this.delegate.createInspectImageCmdExec();
    }

    public ListContainersCmd.Exec createListContainersCmdExec() {
        return this.delegate.createListContainersCmdExec();
    }

    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return this.delegate.createStartContainerCmdExec();
    }

    public InspectContainerCmd.Exec createInspectContainerCmdExec() {
        return this.delegate.createInspectContainerCmdExec();
    }

    public WaitContainerCmd.Exec createWaitContainerCmdExec() {
        return this.delegate.createWaitContainerCmdExec();
    }

    public AttachContainerCmd.Exec createAttachContainerCmdExec() {
        return this.delegate.createAttachContainerCmdExec();
    }

    public ExecStartCmd.Exec createExecStartCmdExec() {
        return this.delegate.createExecStartCmdExec();
    }

    public InspectExecCmd.Exec createInspectExecCmdExec() {
        return this.delegate.createInspectExecCmdExec();
    }

    public LogContainerCmd.Exec createLogContainerCmdExec() {
        return this.delegate.createLogContainerCmdExec();
    }

    public CopyFileFromContainerCmd.Exec createCopyFileFromContainerCmdExec() {
        return this.delegate.createCopyFileFromContainerCmdExec();
    }

    public CopyArchiveFromContainerCmd.Exec createCopyArchiveFromContainerCmdExec() {
        return this.delegate.createCopyArchiveFromContainerCmdExec();
    }

    public CopyArchiveToContainerCmd.Exec createCopyArchiveToContainerCmdExec() {
        return this.delegate.createCopyArchiveToContainerCmdExec();
    }

    public StopContainerCmd.Exec createStopContainerCmdExec() {
        return this.delegate.createStopContainerCmdExec();
    }

    public ContainerDiffCmd.Exec createContainerDiffCmdExec() {
        return this.delegate.createContainerDiffCmdExec();
    }

    public KillContainerCmd.Exec createKillContainerCmdExec() {
        return this.delegate.createKillContainerCmdExec();
    }

    public UpdateContainerCmd.Exec createUpdateContainerCmdExec() {
        return this.delegate.createUpdateContainerCmdExec();
    }

    public RenameContainerCmd.Exec createRenameContainerCmdExec() {
        return this.delegate.createRenameContainerCmdExec();
    }

    public RestartContainerCmd.Exec createRestartContainerCmdExec() {
        return this.delegate.createRestartContainerCmdExec();
    }

    public CommitCmd.Exec createCommitCmdExec() {
        return this.delegate.createCommitCmdExec();
    }

    public TopContainerCmd.Exec createTopContainerCmdExec() {
        return this.delegate.createTopContainerCmdExec();
    }

    public TagImageCmd.Exec createTagImageCmdExec() {
        return this.delegate.createTagImageCmdExec();
    }

    public PauseContainerCmd.Exec createPauseContainerCmdExec() {
        return this.delegate.createPauseContainerCmdExec();
    }

    public UnpauseContainerCmd.Exec createUnpauseContainerCmdExec() {
        return this.delegate.createUnpauseContainerCmdExec();
    }

    public EventsCmd.Exec createEventsCmdExec() {
        return this.delegate.createEventsCmdExec();
    }

    public StatsCmd.Exec createStatsCmdExec() {
        return this.delegate.createStatsCmdExec();
    }

    public CreateVolumeCmd.Exec createCreateVolumeCmdExec() {
        return new CreateVolumeCmd.Exec(){

            public CreateVolumeResponse exec(CreateVolumeCmd command) {
                CreateVolumeResponse result = (CreateVolumeResponse)TestDockerCmdExecFactory.this.delegate.createCreateVolumeCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.volumeNames.add(command.getName());
                return result;
            }
        };
    }

    public InspectVolumeCmd.Exec createInspectVolumeCmdExec() {
        return this.delegate.createInspectVolumeCmdExec();
    }

    public RemoveVolumeCmd.Exec createRemoveVolumeCmdExec() {
        return new RemoveVolumeCmd.Exec(){

            public Void exec(RemoveVolumeCmd command) {
                TestDockerCmdExecFactory.this.delegate.createRemoveVolumeCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.volumeNames.remove(command.getName());
                return null;
            }
        };
    }

    public ListVolumesCmd.Exec createListVolumesCmdExec() {
        return this.delegate.createListVolumesCmdExec();
    }

    public ListNetworksCmd.Exec createListNetworksCmdExec() {
        return this.delegate.createListNetworksCmdExec();
    }

    public InspectNetworkCmd.Exec createInspectNetworkCmdExec() {
        return this.delegate.createInspectNetworkCmdExec();
    }

    public CreateNetworkCmd.Exec createCreateNetworkCmdExec() {
        return new CreateNetworkCmd.Exec(){

            public CreateNetworkResponse exec(CreateNetworkCmd command) {
                CreateNetworkResponse result = (CreateNetworkResponse)TestDockerCmdExecFactory.this.delegate.createCreateNetworkCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.networkIds.add(result.getId());
                return result;
            }
        };
    }

    public RemoveNetworkCmd.Exec createRemoveNetworkCmdExec() {
        return new RemoveNetworkCmd.Exec(){

            public Void exec(RemoveNetworkCmd command) {
                TestDockerCmdExecFactory.this.delegate.createRemoveNetworkCmdExec().exec((DockerCmd)command);
                TestDockerCmdExecFactory.this.networkIds.remove(command.getNetworkId());
                return null;
            }
        };
    }

    public ConnectToNetworkCmd.Exec createConnectToNetworkCmdExec() {
        return this.delegate.createConnectToNetworkCmdExec();
    }

    public DisconnectFromNetworkCmd.Exec createDisconnectFromNetworkCmdExec() {
        return this.delegate.createDisconnectFromNetworkCmdExec();
    }

    public List<String> getContainerNames() {
        return new ArrayList<String>(this.containerNames);
    }

    public List<String> getImageNames() {
        return new ArrayList<String>(this.imageNames);
    }

    public List<String> getVolumeNames() {
        return new ArrayList<String>(this.volumeNames);
    }

    public List<String> getNetworkIds() {
        return new ArrayList<String>(this.networkIds);
    }
}

