/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.utils.TestUtils;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class CopyFileFromContainerCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void copyFromContainer() throws Exception {
        if (TestUtils.getVersion(this.dockerClient).isGreaterOrEqual(RemoteApiVersion.VERSION_1_24)) {
            throw new SkipException("Doesn't work since 1.24");
        }
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withName("docker-java-itest-copyFromContainer").withCmd(new String[]{"touch", "/copyFromContainer"}).exec();
        LOG.info("Created container: {}", (Object)container);
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InputStream response = this.dockerClient.copyFileFromContainerCmd(container.getId(), "/copyFromContainer").exec();
        Boolean bytesAvailable = response.available() > 0;
        CopyFileFromContainerCmdImplTest.assertTrue((boolean)bytesAvailable, (String)"The file was not copied from the container.");
        String responseAsString = this.asString(response);
        CopyFileFromContainerCmdImplTest.assertNotNull((Object)responseAsString);
        CopyFileFromContainerCmdImplTest.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void copyFromNonExistingContainer() throws Exception {
        this.dockerClient.copyFileFromContainerCmd("non-existing", "/test").exec();
    }
}

