/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.command.EventsResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class EventsCmdImplTest
extends AbstractDockerClientTest {
    private static String getEpochTime() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testEventStreamTimeBound() throws Exception {
        TimeUnit.SECONDS.sleep(1L);
        String startTime = EventsCmdImplTest.getEpochTime();
        int expectedEvents = this.generateEvents();
        String endTime = EventsCmdImplTest.getEpochTime();
        EventsTestCallback eventCallback = new EventsTestCallback(expectedEvents);
        this.dockerClient.eventsCmd().withSince(startTime).withUntil(endTime).exec((ResultCallback)eventCallback);
        List<Event> events = eventCallback.awaitExpectedEvents(3L, TimeUnit.MINUTES);
        EventsCmdImplTest.assertTrue((events.size() >= expectedEvents ? 1 : 0) != 0, (String)("Received events: " + events));
    }

    @Test
    public void testEventStreaming() throws Exception {
        TimeUnit.SECONDS.sleep(1L);
        String startTime = EventsCmdImplTest.getEpochTime();
        int expectedEvents = this.generateEvents();
        EventsTestCallback eventCallback = new EventsTestCallback(expectedEvents);
        this.dockerClient.eventsCmd().withSince(startTime).exec((ResultCallback)eventCallback);
        this.generateEvents();
        List<Event> events = eventCallback.awaitExpectedEvents(3L, TimeUnit.MINUTES);
        EventsCmdImplTest.assertTrue((events.size() >= expectedEvents ? 1 : 0) != 0, (String)("Received events: " + events));
    }

    public void testEventStreamingWithFilter() throws Exception {
        TimeUnit.SECONDS.sleep(1L);
        String startTime = EventsCmdImplTest.getEpochTime();
        int expectedEvents = 1;
        EventsTestCallback eventCallback = new EventsTestCallback(expectedEvents);
        this.dockerClient.eventsCmd().withSince(startTime).withEventFilter(new String[]{"start"}).exec((ResultCallback)eventCallback);
        this.generateEvents();
        List<Event> events = eventCallback.awaitExpectedEvents(3L, TimeUnit.MINUTES);
        EventsCmdImplTest.assertEquals((int)events.size(), (int)expectedEvents, (String)("Received events: " + events));
    }

    private int generateEvents() throws Exception {
        String testImage = "busybox:latest";
        ((PullImageResultCallback)this.dockerClient.pullImageCmd(testImage).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
        CreateContainerResponse container = this.dockerClient.createContainerCmd(testImage).withCmd(new String[]{"sleep", "9999"}).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        this.dockerClient.stopContainerCmd(container.getId()).withTimeout(Integer.valueOf(1)).exec();
        return 5;
    }

    private class EventsTestCallback
    extends EventsResultCallback {
        private final CountDownLatch countDownLatch;
        private final List<Event> events = new ArrayList<Event>();

        public EventsTestCallback(int expextedEvents) {
            this.countDownLatch = new CountDownLatch(expextedEvents);
        }

        public void onNext(Event event) {
            AbstractDockerClientTest.LOG.info("Received event #{}: {}", (Object)this.countDownLatch.getCount(), (Object)event);
            this.events.add(event);
            this.countDownLatch.countDown();
        }

        public List<Event> awaitExpectedEvents(long timeout, TimeUnit unit) {
            try {
                this.countDownLatch.await(timeout, unit);
                this.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new ArrayList<Event>(this.events);
        }
    }
}

