/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.client.AbstractDockerClientTest;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class ExecStartCmdImplTest
extends AbstractDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void execStart() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"top"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/execStartTest.log"}).withUser("root").exec();
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InputStream response = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), "/execStartTest.log").exec();
        Boolean bytesAvailable = response.available() > 0;
        ExecStartCmdImplTest.assertTrue((boolean)bytesAvailable, (String)"The file was not copied from the container.");
        String responseAsString = this.asString(response);
        ExecStartCmdImplTest.assertNotNull((Object)responseAsString);
        ExecStartCmdImplTest.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test(groups={"ignoreInCircleCi"})
    public void execStartAttached() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/execStartTest.log"}).exec();
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(true)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        InputStream response = this.dockerClient.copyArchiveFromContainerCmd(container.getId(), "/execStartTest.log").exec();
        Boolean bytesAvailable = response.available() > 0;
        ExecStartCmdImplTest.assertTrue((boolean)bytesAvailable, (String)"The file was not copied from the container.");
        String responseAsString = this.asString(response);
        ExecStartCmdImplTest.assertNotNull((Object)responseAsString);
        ExecStartCmdImplTest.assertTrue((responseAsString.length() > 0 ? 1 : 0) != 0);
    }

    @Test(groups={"ignoreInCircleCi"}, expectedExceptions={NotFoundException.class})
    public void execStartWithNonExistentUser() throws Exception {
        String containerName = "generated_" + new SecureRandom().nextInt();
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(containerName).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(container.getId()).withAttachStdout(Boolean.valueOf(true)).withCmd(new String[]{"touch", "/execStartTest.log"}).withUser("NonExistentUser").exec();
        ((ExecStartResultCallback)this.dockerClient.execStartCmd(execCreateCmdResponse.getId()).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(true)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)System.out, (OutputStream)System.err))).awaitCompletion();
        this.dockerClient.copyArchiveFromContainerCmd(container.getId(), "/execStartTest.log").exec();
    }
}

