/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.dockerfile;

import com.github.dockerjava.core.dockerfile.Dockerfile;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class DockerfileAddMultipleFilesTest {
    private static final Logger log = LoggerFactory.getLogger(DockerfileAddMultipleFilesTest.class);
    private static final Function<File, String> TO_FILE_NAMES = new Function<File, String>(){

        public String apply(File file) {
            return file.getName();
        }
    };

    @Test
    public void nestedDirsPatterns() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/NestedDirsDockerignore");
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Dockerfile", ".dockerignore", "README.md", "README-grand.md", "b.txt"}));
    }

    @Test
    public void effectiveIgnorePatterns() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/EffectiveDockerignorePatterns");
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Dockerfile", ".dockerignore", "README.md"}));
    }

    @Test
    public void ineffectiveIgnorePattern() throws Exception {
        File baseDir = this.fileFromBuildTestResource("dockerignore/IneffectiveDockerignorePattern");
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Dockerfile", ".dockerignore", "README.md", "README-secret.md"}));
    }

    @Test
    public void addFiles() throws IOException {
        File baseDir = this.fileFromBuildTestResource("ADD/files");
        Dockerfile dockerfile = new Dockerfile(new File(baseDir, "Dockerfile"), baseDir);
        Dockerfile.ScannedResult result = dockerfile.parse();
        Collection filesToAdd = Collections2.transform((Collection)result.filesToAdd, TO_FILE_NAMES);
        MatcherAssert.assertThat((Object)filesToAdd, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Dockerfile", "src1", "src2"}));
    }

    private File fileFromBuildTestResource(String resource) {
        return new File(Thread.currentThread().getContextClassLoader().getResource("buildTests/" + resource).getFile());
    }
}

