/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.util;

import com.github.dockerjava.core.util.CertificateUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CertificateUtilsTest {
    private static final String baseDir = CertificateUtilsTest.class.getResource(CertificateUtilsTest.class.getSimpleName() + "/").getFile();

    @BeforeClass
    public static void init() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @AfterClass
    public static void tearDown() {
        Security.removeProvider("BC");
    }

    @Test
    public void allFilesExist() {
        MatcherAssert.assertThat((Object)CertificateUtils.verifyCertificatesExist((String)(baseDir + "allFilesExist")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void caAndCertAndKeyMissing() {
        MatcherAssert.assertThat((Object)CertificateUtils.verifyCertificatesExist((String)(baseDir + "caAndCertAndKeyMissing")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void caAndCertMissing() {
        MatcherAssert.assertThat((Object)CertificateUtils.verifyCertificatesExist((String)(baseDir + "caAndCertMissing")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void caAndKeyMissing() {
        MatcherAssert.assertThat((Object)CertificateUtils.verifyCertificatesExist((String)(baseDir + "caAndKeyMissing")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void caMissing() {
        MatcherAssert.assertThat((Object)CertificateUtils.verifyCertificatesExist((String)(baseDir + "caMissing")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void certAndKeyMissing() {
        MatcherAssert.assertThat((Object)CertificateUtils.verifyCertificatesExist((String)(baseDir + "certAndKeyMissing")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void certMissing() {
        MatcherAssert.assertThat((Object)CertificateUtils.verifyCertificatesExist((String)(baseDir + "certMissing")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void keyMissing() {
        MatcherAssert.assertThat((Object)CertificateUtils.verifyCertificatesExist((String)(baseDir + "keyMissing")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void readCaCert() throws Exception {
        String capem = this.readFileAsString("caTest/single_ca.pem");
        KeyStore keyStore = CertificateUtils.createTrustStore((String)capem);
        MatcherAssert.assertThat((Object)keyStore.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)keyStore.isCertificateEntry("ca-1"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void readMultipleCaCerts() throws Exception {
        String capem = this.readFileAsString("caTest/multiple_ca.pem");
        KeyStore keyStore = CertificateUtils.createTrustStore((String)capem);
        MatcherAssert.assertThat((Object)keyStore.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)keyStore.isCertificateEntry("ca-1"), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)keyStore.isCertificateEntry("ca-2"), (Matcher)Is.is((Object)true));
    }

    private String readFileAsString(String path) throws IOException {
        return new String(Files.readAllBytes(Paths.get(baseDir + path, new String[0])));
    }
}

