/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NettyDockerCmdExecFactoryConfigTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyDockerCmdExecFactoryConfigWithApiVersion() throws Exception {
        int dockerPort = this.getFreePort();
        NettyDockerCmdExecFactory factory = new NettyDockerCmdExecFactory();
        DefaultDockerClientConfig.Builder configBuilder = new DefaultDockerClientConfig.Builder().withDockerTlsVerify(Boolean.valueOf(false)).withDockerHost("tcp://localhost:" + dockerPort).withApiVersion("1.23");
        DockerClient client = DockerClientBuilder.getInstance((DefaultDockerClientConfig.Builder)configBuilder).withDockerCmdExecFactory((DockerCmdExecFactory)factory).build();
        FakeDockerServer server = new FakeDockerServer(dockerPort);
        server.start();
        try {
            client.versionCmd().exec();
            List requests = server.getRequests();
            Assert.assertEquals((int)requests.size(), (int)1);
            Assert.assertEquals((String)((HttpRequest)requests.get(0)).uri(), (String)"/v1.23/version");
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyDockerCmdExecFactoryConfigWithoutApiVersion() throws Exception {
        int dockerPort = this.getFreePort();
        NettyDockerCmdExecFactory factory = new NettyDockerCmdExecFactory();
        DefaultDockerClientConfig.Builder configBuilder = new DefaultDockerClientConfig.Builder().withDockerTlsVerify(Boolean.valueOf(false)).withDockerHost("tcp://localhost:" + dockerPort);
        DockerClient client = DockerClientBuilder.getInstance((DefaultDockerClientConfig.Builder)configBuilder).withDockerCmdExecFactory((DockerCmdExecFactory)factory).build();
        FakeDockerServer server = new FakeDockerServer(dockerPort);
        server.start();
        try {
            client.versionCmd().exec();
            List requests = server.getRequests();
            Assert.assertEquals((int)requests.size(), (int)1);
            Assert.assertEquals((String)((HttpRequest)requests.get(0)).uri(), (String)"/version");
        }
        finally {
            server.stop();
        }
    }

    private int getFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int freePort = socket.getLocalPort();
        socket.close();
        return freePort;
    }

    private class FakeDockerServer {
        private final int port;
        private final NioEventLoopGroup parent;
        private final NioEventLoopGroup child;
        private final List<HttpRequest> requests = new ArrayList<HttpRequest>();
        private Channel channel;

        private FakeDockerServer(int port) {
            this.port = port;
            this.parent = new NioEventLoopGroup();
            this.child = new NioEventLoopGroup();
        }

        private void start() throws Exception {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group((EventLoopGroup)this.parent, (EventLoopGroup)this.child).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec());
                    pipeline.addLast("httpHandler", (ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                        protected void channelRead0(ChannelHandlerContext context, Object message) throws Exception {
                            if (message instanceof HttpRequest) {
                                HttpRequest request = (HttpRequest)message;
                                FakeDockerServer.this.requests.add(request);
                            }
                            if (message instanceof HttpContent) {
                                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"{}", (Charset)CharsetUtil.UTF_8));
                                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
                                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
                                context.writeAndFlush((Object)response);
                            }
                        }
                    });
                }
            });
            this.channel = bootstrap.bind(this.port).syncUninterruptibly().channel();
        }

        private void stop() throws Exception {
            this.parent.shutdownGracefully();
            this.child.shutdownGracefully();
            this.channel.closeFuture().sync();
        }

        private List<HttpRequest> getRequests() {
            return this.requests;
        }
    }
}

