/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import com.github.dockerjava.utils.TestUtils;
import java.lang.reflect.Method;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class AuthCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testAuth() throws Exception {
        RemoteApiVersion apiVersion = TestUtils.getVersion(this.dockerClient);
        if (!apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_23)) {
            throw new SkipException("Fails on 1.22. Temporary disabled.");
        }
        AuthResponse response = this.dockerClient.authCmd().exec();
        AuthCmdExecTest.assertEquals((String)response.getStatus(), (String)"Login Succeeded");
    }

    @Test(expectedExceptions={UnauthorizedException.class})
    public void testAuthInvalid() throws Exception {
        RemoteApiVersion apiVersion = TestUtils.getVersion(this.dockerClient);
        if (!apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_23)) {
            throw new SkipException("Fails on 1.22. Temporary disabled.");
        }
        DockerClientBuilder.getInstance((DockerClientConfig)this.config("garbage")).build().authCmd().exec();
    }
}

