/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class RenameContainerCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void renameContainer() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        String name1 = inspectContainerResponse.getName();
        this.dockerClient.renameContainerCmd(container.getId()).withName(((Object)((Object)this)).getClass().getCanonicalName() + "renameContainer").exec();
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect After Rename: {}", (Object)inspectContainerResponse2.toString());
        String name2 = inspectContainerResponse2.getName();
        RenameContainerCmdExecTest.assertNotEquals((Object)name1, (Object)name2);
        this.dockerClient.killContainerCmd(container.getId()).exec();
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void renameNonExistingContainer() throws DockerException, InterruptedException {
        this.dockerClient.renameContainerCmd("non-existing").withName(((Object)((Object)this)).getClass().getCanonicalName() + "renameExistingContainer").exec();
    }
}

