/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class StartContainerCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void startContainerWithVolumes() throws DockerException {
        Volume volume1 = new Volume("/opt/webapp1");
        Volume volume2 = new Volume("/opt/webapp2");
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withVolumes(new Volume[]{volume1, volume2}).withCmd(new String[]{"true"}).withBinds(new Bind[]{new Bind("/src/webapp1", volume1, AccessMode.ro), new Bind("/src/webapp2", volume2)}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(inspectContainerResponse.getConfig().getVolumes().keySet(), (Matcher)Matchers.contains((Object[])new String[]{"/opt/webapp1", "/opt/webapp2"}));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse, (Matcher)this.mountedVolumes((Matcher<? super List<Volume>>)Matchers.containsInAnyOrder((Object[])new Volume[]{volume1, volume2})));
        List mounts = inspectContainerResponse.getMounts();
        MatcherAssert.assertThat((Object)mounts, (Matcher)Matchers.hasSize((int)2));
        InspectContainerResponse.Mount mount1 = new InspectContainerResponse.Mount().withRw(Boolean.valueOf(false)).withMode("ro").withDestination(volume1).withSource("/src/webapp1");
        InspectContainerResponse.Mount mount2 = new InspectContainerResponse.Mount().withRw(Boolean.valueOf(true)).withMode("rw").withDestination(volume2).withSource("/src/webapp2");
        MatcherAssert.assertThat((Object)mounts, (Matcher)Matchers.containsInAnyOrder((Object[])new InspectContainerResponse.Mount[]{mount1, mount2}));
    }

    @Test
    public void startContainerWithVolumesFrom() throws DockerException {
        Volume volume1 = new Volume("/opt/webapp1");
        Volume volume2 = new Volume("/opt/webapp2");
        String container1Name = UUID.randomUUID().toString();
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName(container1Name).withBinds(new Bind[]{new Bind("/src/webapp1", volume1), new Bind("/src/webapp2", volume2)}).exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        LOG.info("Started container1 {}", (Object)container1.toString());
        InspectContainerResponse inspectContainerResponse1 = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse1, (Matcher)this.mountedVolumes((Matcher<? super List<Volume>>)Matchers.containsInAnyOrder((Object[])new Volume[]{volume1, volume2})));
        CreateContainerResponse container2 = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withVolumesFrom(new VolumesFrom[]{new VolumesFrom(container1Name)}).exec();
        LOG.info("Created container2 {}", (Object)container2.toString());
        this.dockerClient.startContainerCmd(container2.getId()).exec();
        LOG.info("Started container2 {}", (Object)container2.toString());
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse2, (Matcher)this.mountedVolumes((Matcher<? super List<Volume>>)Matchers.containsInAnyOrder((Object[])new Volume[]{volume1, volume2})));
    }

    @Test
    public void startContainerWithDns() throws DockerException {
        String aDnsServer = "8.8.8.8";
        String anotherDnsServer = "8.8.4.4";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).withDns(new String[]{aDnsServer, anotherDnsServer}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDns()), (Matcher)Matchers.contains((Object[])new String[]{aDnsServer, anotherDnsServer}));
    }

    @Test
    public void startContainerWithDnsSearch() throws DockerException {
        String dnsSearch = "example.com";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).withDnsSearch(new String[]{dnsSearch}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDnsSearch()), (Matcher)Matchers.contains((Object[])new String[]{dnsSearch}));
    }

    @Test
    public void startContainerWithPortBindings() throws DockerException {
        ExposedPort tcp22 = ExposedPort.tcp((int)22);
        ExposedPort tcp23 = ExposedPort.tcp((int)23);
        Ports portBindings = new Ports();
        portBindings.bind(tcp22, Ports.Binding.bindPort((int)11022));
        portBindings.bind(tcp23, Ports.Binding.bindPort((int)11023));
        portBindings.bind(tcp23, Ports.Binding.bindPort((int)11024));
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).withExposedPorts(new ExposedPort[]{tcp22, tcp23}).withPortBindings(portBindings).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getExposedPorts()), (Matcher)Matchers.contains((Object[])new ExposedPort[]{tcp22, tcp23}));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp22))[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)11022))));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp23))[0], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)11023))));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getHostConfig().getPortBindings().getBindings().get(tcp23))[1], (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Ports.Binding.bindPort((int)11024))));
    }

    @Test
    public void startContainerWithRandomPortBindings() throws DockerException {
        ExposedPort tcp22 = ExposedPort.tcp((int)22);
        ExposedPort tcp23 = ExposedPort.tcp((int)23);
        Ports portBindings = new Ports();
        portBindings.bind(tcp22, Ports.Binding.empty());
        portBindings.bind(tcp23, Ports.Binding.empty());
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withExposedPorts(new ExposedPort[]{tcp22, tcp23}).withPortBindings(portBindings).withPublishAllPorts(Boolean.valueOf(true)).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getConfig().getExposedPorts()), (Matcher)Matchers.contains((Object[])new ExposedPort[]{tcp22, tcp23}));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getNetworkSettings().getPorts().getBindings().get(tcp22))[0].getHostPortSpec(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)String.valueOf(tcp22.getPort())))));
        MatcherAssert.assertThat((Object)((Ports.Binding[])inspectContainerResponse.getNetworkSettings().getPorts().getBindings().get(tcp23))[0].getHostPortSpec(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)String.valueOf(tcp23.getPort())))));
    }

    @Test(expectedExceptions={InternalServerErrorException.class})
    public void startContainerWithConflictingPortBindings() throws DockerException {
        ExposedPort tcp22 = ExposedPort.tcp((int)22);
        ExposedPort tcp23 = ExposedPort.tcp((int)23);
        Ports portBindings = new Ports();
        portBindings.bind(tcp22, Ports.Binding.bindPort((int)11022));
        portBindings.bind(tcp23, Ports.Binding.bindPort((int)11022));
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).withExposedPorts(new ExposedPort[]{tcp22, tcp23}).withPortBindings(portBindings).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
    }

    @Test
    public void startContainerWithLinkingDeprecated() throws DockerException {
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName("container1").exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.startsWith((String)container1.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getName(), (Matcher)Matchers.equalTo((Object)"/container1"));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        if (!inspectContainerResponse1.getState().getRunning().booleanValue()) {
            MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
        CreateContainerResponse container2 = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName("container2").withLinks(new Link[]{new Link("container1", "container1Link")}).exec();
        LOG.info("Created container2 {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container2.getId()).exec();
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        LOG.info("Container2 Inspect: {}", (Object)inspectContainerResponse2.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.equalTo((Object)new Link[]{new Link("container1", "container1Link")}));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.startsWith((String)container2.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getName(), (Matcher)Matchers.equalTo((Object)"/container2"));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getState().getRunning(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void startContainerWithLinking() throws DockerException {
        CreateContainerResponse container1 = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName("container1").exec();
        LOG.info("Created container1 {}", (Object)container1.toString());
        MatcherAssert.assertThat((Object)container1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container1.getId()).exec();
        InspectContainerResponse inspectContainerResponse1 = this.dockerClient.inspectContainerCmd(container1.getId()).exec();
        LOG.info("Container1 Inspect: {}", (Object)inspectContainerResponse1.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getId(), (Matcher)Matchers.startsWith((String)container1.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getName(), (Matcher)Matchers.equalTo((Object)"/container1"));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        if (!inspectContainerResponse1.getState().getRunning().booleanValue()) {
            MatcherAssert.assertThat((Object)inspectContainerResponse1.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
        CreateContainerResponse container2 = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withName("container2").withLinks(new Link[]{new Link("container1", "container1Link")}).exec();
        LOG.info("Created container2 {}", (Object)container2.toString());
        MatcherAssert.assertThat((Object)container2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container2.getId()).exec();
        InspectContainerResponse inspectContainerResponse2 = this.dockerClient.inspectContainerCmd(container2.getId()).exec();
        LOG.info("Container2 Inspect: {}", (Object)inspectContainerResponse2.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getHostConfig().getLinks(), (Matcher)Matchers.equalTo((Object)new Link[]{new Link("container1", "container1Link")}));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getId(), (Matcher)Matchers.startsWith((String)container2.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getName(), (Matcher)Matchers.equalTo((Object)"/container2"));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse2.getState().getRunning(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void startContainer() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"top"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getId(), (Matcher)Matchers.startsWith((String)container.getId()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getImageId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        if (!inspectContainerResponse.getState().getRunning().booleanValue()) {
            MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0)));
        }
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void testStartNonExistingContainer() throws DockerException {
        this.dockerClient.startContainerCmd("non-existing").exec();
    }

    @Test
    public void startContainerWithNetworkMode() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).withNetworkMode("host").exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        this.dockerClient.startContainerCmd(container.getId()).exec();
        inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getNetworkMode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"host")));
    }

    @Test
    public void startContainerWithCapAddAndCapDrop() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withCapAdd(new Capability[]{Capability.NET_ADMIN}).withCapDrop(new Capability[]{Capability.MKNOD}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getCapAdd()), (Matcher)Matchers.contains((Object[])new Capability[]{Capability.NET_ADMIN}));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getCapDrop()), (Matcher)Matchers.contains((Object[])new Capability[]{Capability.MKNOD}));
    }

    @Test
    public void startContainerWithDevices() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withDevices(new Device[]{new Device("rwm", "/dev/nulo", "/dev/zero")}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDevices()), (Matcher)Matchers.contains((Object[])new Device[]{new Device("rwm", "/dev/nulo", "/dev/zero")}));
    }

    @Test
    public void startContainerWithExtraHosts() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withExtraHosts(new String[]{"dockerhost:127.0.0.1"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getExtraHosts()), (Matcher)Matchers.contains((Object[])new String[]{"dockerhost:127.0.0.1"}));
    }

    @Test
    public void startContainerWithRestartPolicy() throws DockerException {
        RestartPolicy restartPolicy = RestartPolicy.onFailureRestart((int)5);
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).withRestartPolicy(restartPolicy).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getRestartPolicy(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)restartPolicy)));
    }

    @Test
    public void existingHostConfigIsPreservedByBlankStartCmd() throws DockerException {
        String dnsServer = "8.8.8.8";
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withDns(new String[]{dnsServer}).withCmd(new String[]{"true"}).exec();
        LOG.info("Created container {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        MatcherAssert.assertThat((Object)inspectContainerResponse.getHostConfig().getDns(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat(Arrays.asList(inspectContainerResponse.getHostConfig().getDns()), (Matcher)Matchers.contains((Object[])new String[]{dnsServer}));
    }

    @Test
    public void anUnconfiguredCommandSerializesToEmptyJson() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        StartContainerCmd command = this.dockerClient.startContainerCmd("");
        MatcherAssert.assertThat((Object)objectMapper.writeValueAsString((Object)command), (Matcher)Matchers.is((Object)"{}"));
    }
}

