/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.netty.exec;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.WaitResponse;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import com.github.dockerjava.netty.AbstractNettyDockerClientTest;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class WaitContainerCmdExecTest
extends AbstractNettyDockerClientTest {
    @Override
    @BeforeTest
    public void beforeTest() throws Exception {
        super.beforeTest();
    }

    @Override
    @AfterTest
    public void afterTest() {
        super.afterTest();
    }

    @Override
    @BeforeMethod
    public void beforeMethod(Method method) {
        super.beforeMethod(method);
    }

    @Override
    @AfterMethod
    public void afterMethod(ITestResult result) {
        super.afterMethod(result);
    }

    @Test
    public void testWaitContainer() throws DockerException {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"true"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        int exitCode = ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
        LOG.info("Container exit code: {}", (Object)exitCode);
        MatcherAssert.assertThat((Object)exitCode, (Matcher)Matchers.equalTo((Object)0));
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getExitCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)exitCode)));
    }

    @Test(expectedExceptions={NotFoundException.class})
    public void testWaitNonExistingContainer() throws DockerException {
        WaitContainerResultCallback callback = new WaitContainerResultCallback(){

            public void onNext(WaitResponse waitResponse) {
                Assert.fail((String)"expected NotFoundException");
            }
        };
        ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd("non-existing").exec((ResultCallback)callback)).awaitStatusCode();
    }

    @Test
    public void testWaitContainerAbort() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "9999"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        WaitContainerResultCallback callback = (WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback());
        Thread.sleep(5000L);
        System.err.println("closing callback");
        callback.close();
        this.dockerClient.killContainerCmd(container.getId()).exec();
        InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(container.getId()).exec();
        LOG.info("Container Inspect: {}", (Object)inspectContainerResponse.toString());
        MatcherAssert.assertThat((Object)inspectContainerResponse.getState().getRunning(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
    }

    @Test
    public void testWaitContainerTimeout() throws Exception {
        CreateContainerResponse container = this.dockerClient.createContainerCmd("busybox").withCmd(new String[]{"sleep", "10"}).exec();
        LOG.info("Created container: {}", (Object)container.toString());
        MatcherAssert.assertThat((Object)container.getId(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyString()));
        this.dockerClient.startContainerCmd(container.getId()).exec();
        WaitContainerResultCallback callback = (WaitContainerResultCallback)this.dockerClient.waitContainerCmd(container.getId()).exec((ResultCallback)new WaitContainerResultCallback());
        try {
            callback.awaitStatusCode(100L, TimeUnit.MILLISECONDS);
            WaitContainerCmdExecTest.fail((String)"Should throw exception on timeout.");
        }
        catch (DockerClientException e) {
            LOG.info(e.getMessage());
        }
    }
}

