/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.test.serdes;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.core.RemoteApiVersion;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.testng.Assert;

public class JSONSamples {
    public static String getSampleContent(RemoteApiVersion version, String context) throws IOException {
        File resource = new File("src/test/resources/samples/" + version.getVersion() + "/" + context);
        return FileUtils.readFileToString((File)resource, (String)"UTF-8");
    }

    public static <TClass> TClass testRoundTrip(RemoteApiVersion version, String context, JavaType type) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object tObject = mapper.readValue(JSONSamples.getSampleContent(version, context), type);
        return (TClass)JSONSamples.testRoundTrip(tObject, type);
    }

    public static <TClass> TClass testRoundTrip(TClass item, JavaType type) throws IOException, AssertionError {
        ObjectMapper mapper = new ObjectMapper();
        String serialized1 = mapper.writeValueAsString(item);
        JsonNode json1 = mapper.readTree(serialized1);
        Object deserialized1 = mapper.readValue(serialized1, type);
        String serialized2 = mapper.writeValueAsString(deserialized1);
        JsonNode json2 = mapper.readTree(serialized2);
        Object deserialized2 = mapper.readValue(serialized2, type);
        Assert.assertEquals((Iterable)json2, (Iterable)json1, (String)"JSONs must be equal after the second roundtrip");
        Assert.assertEquals((Object)deserialized2, (Object)deserialized2, (String)"Objects must be equal after the second roundtrip");
        Assert.assertNotSame((Object)deserialized2, (Object)deserialized1, (String)"Objects must be not the same");
        return (TClass)deserialized2;
    }
}

