/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.core;

import com.github.dockerunit.core.ServiceInstance;
import com.github.dockerunit.core.internal.ServiceDescriptor;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Service {
    private final String name;
    private final Set<ServiceInstance> instances;
    private final ServiceDescriptor descriptor;

    public boolean isHealthy() {
        return !this.instances.stream().filter(this::isAborted).findFirst().isPresent();
    }

    public boolean checkStatus(ServiceInstance.Status status) {
        return this.instances.stream().allMatch(si -> si.hasStatus(status));
    }

    public String getName() {
        return this.name;
    }

    public Set<ServiceInstance> getInstances() {
        return this.instances;
    }

    public ServiceDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List<String> getWarnings() {
        return this.instances.stream().filter(this::isAborted).map(i -> i.getStatusDetails()).collect(Collectors.toList());
    }

    private boolean isAborted(ServiceInstance i) {
        return i.hasStatus(ServiceInstance.Status.ABORTED);
    }

    public Service withName(String name) {
        return this.name == name ? this : new Service(name, this.instances, this.descriptor);
    }

    public Service withInstances(Set<ServiceInstance> instances) {
        return this.instances == instances ? this : new Service(this.name, instances, this.descriptor);
    }

    public Service withDescriptor(ServiceDescriptor descriptor) {
        return this.descriptor == descriptor ? this : new Service(this.name, this.instances, descriptor);
    }

    public Service(String name, Set<ServiceInstance> instances, ServiceDescriptor descriptor) {
        this.name = name;
        this.instances = instances;
        this.descriptor = descriptor;
    }
}

