/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.core.internal.service;

import com.github.dockerunit.core.Service;
import com.github.dockerunit.core.ServiceContext;
import com.github.dockerunit.core.ServiceInstance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultServiceContext
implements ServiceContext {
    private final Map<String, Service> services = new HashMap<String, Service>();

    public DefaultServiceContext(Set<Service> services) {
        services.forEach(s -> this.services.put(s.getName(), (Service)s));
    }

    @Override
    public Set<Service> getServices() {
        return this.services.values().stream().collect(Collectors.toSet());
    }

    @Override
    public Service getService(String name) {
        return this.services.get(name);
    }

    @Override
    public ServiceContext merge(ServiceContext context) {
        DefaultServiceContext clone = new DefaultServiceContext(new HashSet<Service>(this.services.values()));
        if (context != null) {
            Set<Service> servicesSet = clone.getServices().stream().map(s -> {
                Service s2 = context.getService(s.getName());
                if (s2 == null) {
                    return s;
                }
                Set<ServiceInstance> augmented = s.getInstances();
                augmented.addAll(s2.getInstances());
                return s.withInstances(augmented);
            }).collect(Collectors.toSet());
            Set toAdd = context.getServices().stream().filter(s -> clone.getService(s.getName()) == null).collect(Collectors.toSet());
            servicesSet.addAll(toAdd);
            return new DefaultServiceContext(servicesSet);
        }
        return clone;
    }

    @Override
    public boolean allHealthy() {
        return this.services.isEmpty() || this.services.values().stream().map(s -> s.isHealthy()).reduce((b1, b2) -> b1 != false && b2 != false).get() != false;
    }

    @Override
    public boolean checkStatus(ServiceInstance.Status status) {
        return this.services.isEmpty() || this.services.values().stream().map(s -> s.checkStatus(status)).reduce((b1, b2) -> b1 != false && b2 != false).get() != false;
    }

    @Override
    public String getFormattedErrors() {
        List orderedServices = this.services.values().stream().collect(Collectors.toList());
        orderedServices.sort((a, b) -> a.getDescriptor().getPriority() < b.getDescriptor().getPriority() ? -1 : 1);
        return orderedServices.stream().map(s -> "\nService: " + s.getName() + "\nErrors:\n\t" + s.getWarnings().stream().reduce((w1, w2) -> w1 + "\n\t" + w2).orElseGet(() -> "")).reduce((s1, s2) -> s1 + "\n" + s2).get();
    }

    @Override
    public ServiceContext subtract(ServiceContext context) {
        DefaultServiceContext clone = new DefaultServiceContext(new HashSet<Service>(this.services.values()));
        if (context != null) {
            Set<Service> servicesSet = clone.getServices().stream().map(s -> {
                Service s2 = context.getService(s.getName());
                if (s2 == null) {
                    return s;
                }
                HashSet<ServiceInstance> remaining = new HashSet<ServiceInstance>(s.getInstances());
                remaining.removeAll(s2.getInstances());
                return remaining.size() > 0 ? s.withInstances(remaining) : null;
            }).filter(s -> s != null).collect(Collectors.toSet());
            return new DefaultServiceContext(servicesSet);
        }
        return clone;
    }
}

