/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.core.internal.service;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerunit.core.Service;
import com.github.dockerunit.core.ServiceContext;
import com.github.dockerunit.core.internal.ServiceBuilder;
import com.github.dockerunit.core.internal.ServiceBuilderFactory;
import com.github.dockerunit.core.internal.ServiceContextBuilder;
import com.github.dockerunit.core.internal.ServiceDescriptor;
import com.github.dockerunit.core.internal.UsageDescriptor;
import com.github.dockerunit.core.internal.docker.DockerClientProviderFactory;
import com.github.dockerunit.core.internal.service.DefaultServiceContext;
import java.util.HashSet;
import java.util.stream.Collectors;

public class DefaultServiceContextBuilder
implements ServiceContextBuilder {
    private final DockerClient client = DockerClientProviderFactory.create().getClient();
    private final ServiceBuilder serviceBuilder = ServiceBuilderFactory.create();

    @Override
    public ServiceContext buildContext(UsageDescriptor descriptor) {
        return new DefaultServiceContext(descriptor.getUsages().stream().map(d -> this.serviceBuilder.build((ServiceDescriptor)d, this.client)).collect(Collectors.toSet()));
    }

    @Override
    public ServiceContext clearContext(ServiceContext context) {
        return new DefaultServiceContext(context.getServices().stream().map(s -> this.serviceBuilder.cleanup((Service)s, this.client)).collect(Collectors.toSet()));
    }

    @Override
    public ServiceContext buildServiceContext(ServiceDescriptor descriptor) {
        HashSet<Service> services = new HashSet<Service>();
        services.add(this.serviceBuilder.build(descriptor, this.client));
        return new DefaultServiceContext(services);
    }
}

