/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.core.internal.service;

import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import java.util.HashMap;
import java.util.Map;

public class DockerPullStatusManager {
    private final String imageName;
    private Map<String, ItemStatus> statuses = new HashMap<String, ItemStatus>();

    public String update(PullResponseItem item) {
        int previousVerticalBufferSize = this.statuses.size();
        if (item != null && item.getId() != null) {
            this.statuses.put(item.getId(), this.createStatusItem(item, this.statuses.get(item.getId())));
        }
        return this.computeStatus(previousVerticalBufferSize);
    }

    private ItemStatus createStatusItem(PullResponseItem item, ItemStatus previousStatus) {
        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
        if (progressDetail != null && progressDetail.getTotal() != null && progressDetail.getTotal() > 0L) {
            int currentPct = this.computePercentage(previousStatus, progressDetail);
            return ItemStatus.builder().id(item.getId()).percentage(currentPct).pullStatus(this.statusNotNull(item.getStatus()) ? item.getStatus() : "").build();
        }
        return ItemStatus.builder().id(item.getId()).percentage(0).pullStatus(this.statusNotNull(item.getStatus()) ? item.getStatus() : "").build();
    }

    private int computePercentage(ItemStatus previousStatus, ResponseItem.ProgressDetail progressDetail) {
        int currentPct = (int)((float)progressDetail.getCurrent().longValue() / (float)progressDetail.getTotal().longValue() * 100.0f);
        currentPct = previousStatus != null && previousStatus.getPercentage() > currentPct ? previousStatus.getPercentage() : currentPct;
        return currentPct;
    }

    private boolean statusNotNull(String status) {
        return status != null && !status.trim().equals("null");
    }

    private String computeStatus(int previousVerticalBufferSize) {
        StringBuffer status = new StringBuffer();
        status.append("\rPulling image ").append(this.imageName);
        for (int i = 0; i < previousVerticalBufferSize; ++i) {
            status.append("\u001b[F").append("                                                                                              ").append("\r");
        }
        this.statuses.values().forEach(item -> status.append("\r").append(item.toString()).append("\n"));
        return status.toString();
    }

    public DockerPullStatusManager(String imageName) {
        this.imageName = imageName;
    }

    static class ItemStatus {
        private static final int PROGRESS_BAR_STRING_LENGTH = 20;
        private String id;
        private int percentage;
        private String pullStatus;

        public String toString() {
            StringBuffer buffer = new StringBuffer().append(this.id).append("\t\t");
            if (this.percentage > 0) {
                buffer.append(this.computePctString()).append(" ").append("[").append(this.computeProgressBar()).append("]").append(" ");
            }
            return buffer.append(this.pullStatus).toString();
        }

        private String computeProgressBar() {
            StringBuffer progress = new StringBuffer();
            for (int i = 1; i <= 20; ++i) {
                if (this.percentage >= 5 * i) {
                    progress.append("=");
                    continue;
                }
                progress.append(" ");
            }
            return progress.toString();
        }

        private String computePctString() {
            return (this.percentage < 100 ? " " : "") + (this.percentage < 10 ? " " : "") + this.percentage + "%";
        }

        ItemStatus(String id, int percentage, String pullStatus) {
            this.id = id;
            this.percentage = percentage;
            this.pullStatus = pullStatus;
        }

        public static ItemStatusBuilder builder() {
            return new ItemStatusBuilder();
        }

        public String getId() {
            return this.id;
        }

        public int getPercentage() {
            return this.percentage;
        }

        public String getPullStatus() {
            return this.pullStatus;
        }

        public static class ItemStatusBuilder {
            private String id;
            private int percentage;
            private String pullStatus;

            ItemStatusBuilder() {
            }

            public ItemStatusBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ItemStatusBuilder percentage(int percentage) {
                this.percentage = percentage;
                return this;
            }

            public ItemStatusBuilder pullStatus(String pullStatus) {
                this.pullStatus = pullStatus;
                return this;
            }

            public ItemStatus build() {
                return new ItemStatus(this.id, this.percentage, this.pullStatus);
            }

            public String toString() {
                return "DockerPullStatusManager.ItemStatus.ItemStatusBuilder(id=" + this.id + ", percentage=" + this.percentage + ", pullStatus=" + this.pullStatus + ")";
            }
        }
    }
}

