/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.StrUtils;
import java.util.HashMap;
import java.util.Map;

public class ReservedDBWords {
    private static final Map<String, String> RESERVED_WORDS = new HashMap<String, String>();

    private ReservedDBWords() {
    }

    private static void addWord(String word, String databaseName) {
        String value = RESERVED_WORDS.get(word.toUpperCase());
        if (value == null || value.length() == 0) {
            RESERVED_WORDS.put(word.toUpperCase(), databaseName);
        } else if (value.indexOf(databaseName) < 0) {
            RESERVED_WORDS.put(word.toUpperCase(), value + "/" + databaseName);
        }
    }

    public static boolean isReservedWord(Dialect dialect, String word) {
        if (!ReservedDBWords.isReservedWord(word)) {
            return false;
        }
        String fitDatabases = RESERVED_WORDS.get(word.toUpperCase()).toUpperCase();
        if (fitDatabases.contains("ANSI")) {
            return true;
        }
        String dia = dialect.toString().replace("Dialect", "").toUpperCase();
        if (dia.length() >= 4) {
            dia = dia.substring(0, 4);
        }
        return fitDatabases.contains(dia);
    }

    public static boolean isReservedWord(String word) {
        return !StrUtils.isEmpty(word) && RESERVED_WORDS.containsKey(word.toUpperCase());
    }

    public static String reservedForDB(String word) {
        return RESERVED_WORDS.get(word.toUpperCase());
    }

    static {
        ReservedDBWords.addWord("ABSOLUTE", "ANSI-SQL");
        ReservedDBWords.addWord("ACTION", "ANSI-SQL");
        ReservedDBWords.addWord("ADD", "ANSI-SQL");
        ReservedDBWords.addWord("AFTER", "ANSI-SQL");
        ReservedDBWords.addWord("ALL", "ANSI-SQL");
        ReservedDBWords.addWord("ALLOCATE", "ANSI-SQL");
        ReservedDBWords.addWord("ALTER", "ANSI-SQL");
        ReservedDBWords.addWord("AND", "ANSI-SQL");
        ReservedDBWords.addWord("ANY", "ANSI-SQL");
        ReservedDBWords.addWord("ARE", "ANSI-SQL");
        ReservedDBWords.addWord("ARRAY", "ANSI-SQL");
        ReservedDBWords.addWord("AS", "ANSI-SQL");
        ReservedDBWords.addWord("ASC", "ANSI-SQL");
        ReservedDBWords.addWord("ASENSITIVE", "ANSI-SQL");
        ReservedDBWords.addWord("ASSERTION", "ANSI-SQL");
        ReservedDBWords.addWord("ASYMMETRIC", "ANSI-SQL");
        ReservedDBWords.addWord("AT", "ANSI-SQL");
        ReservedDBWords.addWord("ATOMIC", "ANSI-SQL");
        ReservedDBWords.addWord("AUTHORIZATION", "ANSI-SQL");
        ReservedDBWords.addWord("AVG", "ANSI-SQL");
        ReservedDBWords.addWord("BEFORE", "ANSI-SQL");
        ReservedDBWords.addWord("BEGIN", "ANSI-SQL");
        ReservedDBWords.addWord("BETWEEN", "ANSI-SQL");
        ReservedDBWords.addWord("BIGINT", "ANSI-SQL");
        ReservedDBWords.addWord("BINARY", "ANSI-SQL");
        ReservedDBWords.addWord("BIT", "ANSI-SQL");
        ReservedDBWords.addWord("BIT_LENGTH", "ANSI-SQL");
        ReservedDBWords.addWord("BLOB", "ANSI-SQL");
        ReservedDBWords.addWord("BOOLEAN", "ANSI-SQL");
        ReservedDBWords.addWord("BOTH", "ANSI-SQL");
        ReservedDBWords.addWord("BREADTH", "ANSI-SQL");
        ReservedDBWords.addWord("BY", "ANSI-SQL");
        ReservedDBWords.addWord("CALL", "ANSI-SQL");
        ReservedDBWords.addWord("CALLED", "ANSI-SQL");
        ReservedDBWords.addWord("CASCADE", "ANSI-SQL");
        ReservedDBWords.addWord("CASCADED", "ANSI-SQL");
        ReservedDBWords.addWord("CASE", "ANSI-SQL");
        ReservedDBWords.addWord("CAST", "ANSI-SQL");
        ReservedDBWords.addWord("CATALOG", "ANSI-SQL");
        ReservedDBWords.addWord("CHAR", "ANSI-SQL");
        ReservedDBWords.addWord("CHAR_LENGTH", "ANSI-SQL");
        ReservedDBWords.addWord("CHARACTER", "ANSI-SQL");
        ReservedDBWords.addWord("CHARACTER_LENGTH", "ANSI-SQL");
        ReservedDBWords.addWord("CHECK", "ANSI-SQL");
        ReservedDBWords.addWord("CLOB", "ANSI-SQL");
        ReservedDBWords.addWord("CLOSE", "ANSI-SQL");
        ReservedDBWords.addWord("COALESCE", "ANSI-SQL");
        ReservedDBWords.addWord("COLLATE", "ANSI-SQL");
        ReservedDBWords.addWord("COLLATION", "ANSI-SQL");
        ReservedDBWords.addWord("COLUMN", "ANSI-SQL");
        ReservedDBWords.addWord("COMMIT", "ANSI-SQL");
        ReservedDBWords.addWord("CONDITION", "ANSI-SQL");
        ReservedDBWords.addWord("CONNECT", "ANSI-SQL");
        ReservedDBWords.addWord("CONNECTION", "ANSI-SQL");
        ReservedDBWords.addWord("CONSTRAINT", "ANSI-SQL");
        ReservedDBWords.addWord("CONSTRAINTS", "ANSI-SQL");
        ReservedDBWords.addWord("CONSTRUCTOR", "ANSI-SQL");
        ReservedDBWords.addWord("CONTAINS", "ANSI-SQL");
        ReservedDBWords.addWord("CONTINUE", "ANSI-SQL");
        ReservedDBWords.addWord("CONVERT", "ANSI-SQL");
        ReservedDBWords.addWord("CORRESPONDING", "ANSI-SQL");
        ReservedDBWords.addWord("COUNT", "ANSI-SQL");
        ReservedDBWords.addWord("CREATE", "ANSI-SQL");
        ReservedDBWords.addWord("CROSS", "ANSI-SQL");
        ReservedDBWords.addWord("CUBE", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT_DATE", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT_DEFAULT_TRANSFORM_GROUP", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT_PATH", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT_ROLE", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT_TIME", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT_TRANSFORM_GROUP_FOR_TYPE", "ANSI-SQL");
        ReservedDBWords.addWord("CURRENT_USER", "ANSI-SQL");
        ReservedDBWords.addWord("CURSOR", "ANSI-SQL");
        ReservedDBWords.addWord("CYCLE", "ANSI-SQL");
        ReservedDBWords.addWord("DATA", "ANSI-SQL");
        ReservedDBWords.addWord("DATE", "ANSI-SQL");
        ReservedDBWords.addWord("DAY", "ANSI-SQL");
        ReservedDBWords.addWord("DEALLOCATE", "ANSI-SQL");
        ReservedDBWords.addWord("DEC", "ANSI-SQL");
        ReservedDBWords.addWord("DECIMAL", "ANSI-SQL");
        ReservedDBWords.addWord("DECLARE", "ANSI-SQL");
        ReservedDBWords.addWord("DEFAULT", "ANSI-SQL");
        ReservedDBWords.addWord("DEFERRABLE", "ANSI-SQL");
        ReservedDBWords.addWord("DEFERRED", "ANSI-SQL");
        ReservedDBWords.addWord("DELETE", "ANSI-SQL");
        ReservedDBWords.addWord("DEPTH", "ANSI-SQL");
        ReservedDBWords.addWord("DEREF", "ANSI-SQL");
        ReservedDBWords.addWord("DESC", "ANSI-SQL");
        ReservedDBWords.addWord("DESCRIBE", "ANSI-SQL");
        ReservedDBWords.addWord("DESCRIPTOR", "ANSI-SQL");
        ReservedDBWords.addWord("DETERMINISTIC", "ANSI-SQL");
        ReservedDBWords.addWord("DIAGNOSTICS", "ANSI-SQL");
        ReservedDBWords.addWord("DISCONNECT", "ANSI-SQL");
        ReservedDBWords.addWord("DISTINCT", "ANSI-SQL");
        ReservedDBWords.addWord("DO", "ANSI-SQL");
        ReservedDBWords.addWord("DOMAIN", "ANSI-SQL");
        ReservedDBWords.addWord("DOUBLE", "ANSI-SQL");
        ReservedDBWords.addWord("DROP", "ANSI-SQL");
        ReservedDBWords.addWord("DYNAMIC", "ANSI-SQL");
        ReservedDBWords.addWord("EACH", "ANSI-SQL");
        ReservedDBWords.addWord("ELEMENT", "ANSI-SQL");
        ReservedDBWords.addWord("ELSE", "ANSI-SQL");
        ReservedDBWords.addWord("ELSEIF", "ANSI-SQL");
        ReservedDBWords.addWord("END", "ANSI-SQL");
        ReservedDBWords.addWord("EQUALS", "ANSI-SQL");
        ReservedDBWords.addWord("ESCAPE", "ANSI-SQL");
        ReservedDBWords.addWord("EXCEPT", "ANSI-SQL");
        ReservedDBWords.addWord("EXCEPTION", "ANSI-SQL");
        ReservedDBWords.addWord("EXEC", "ANSI-SQL");
        ReservedDBWords.addWord("EXECUTE", "ANSI-SQL");
        ReservedDBWords.addWord("EXISTS", "ANSI-SQL");
        ReservedDBWords.addWord("EXIT", "ANSI-SQL");
        ReservedDBWords.addWord("EXTERNAL", "ANSI-SQL");
        ReservedDBWords.addWord("EXTRACT", "ANSI-SQL");
        ReservedDBWords.addWord("FETCH", "ANSI-SQL");
        ReservedDBWords.addWord("FILTER", "ANSI-SQL");
        ReservedDBWords.addWord("FIRST", "ANSI-SQL");
        ReservedDBWords.addWord("FLOAT", "ANSI-SQL");
        ReservedDBWords.addWord("FOR", "ANSI-SQL");
        ReservedDBWords.addWord("FOREIGN", "ANSI-SQL");
        ReservedDBWords.addWord("FOUND", "ANSI-SQL");
        ReservedDBWords.addWord("FREE", "ANSI-SQL");
        ReservedDBWords.addWord("FROM", "ANSI-SQL");
        ReservedDBWords.addWord("FULL", "ANSI-SQL");
        ReservedDBWords.addWord("FUNCTION", "ANSI-SQL");
        ReservedDBWords.addWord("GENERAL", "ANSI-SQL");
        ReservedDBWords.addWord("GET", "ANSI-SQL");
        ReservedDBWords.addWord("GLOBAL", "ANSI-SQL");
        ReservedDBWords.addWord("GO", "ANSI-SQL");
        ReservedDBWords.addWord("GOTO", "ANSI-SQL");
        ReservedDBWords.addWord("GRANT", "ANSI-SQL");
        ReservedDBWords.addWord("GROUP", "ANSI-SQL");
        ReservedDBWords.addWord("GROUPING", "ANSI-SQL");
        ReservedDBWords.addWord("HANDLER", "ANSI-SQL");
        ReservedDBWords.addWord("HAVING", "ANSI-SQL");
        ReservedDBWords.addWord("HOLD", "ANSI-SQL");
        ReservedDBWords.addWord("HOUR", "ANSI-SQL");
        ReservedDBWords.addWord("IDENTITY", "ANSI-SQL");
        ReservedDBWords.addWord("IF", "ANSI-SQL");
        ReservedDBWords.addWord("IMMEDIATE", "ANSI-SQL");
        ReservedDBWords.addWord("IN", "ANSI-SQL");
        ReservedDBWords.addWord("INDICATOR", "ANSI-SQL");
        ReservedDBWords.addWord("INITIALLY", "ANSI-SQL");
        ReservedDBWords.addWord("INNER", "ANSI-SQL");
        ReservedDBWords.addWord("INOUT", "ANSI-SQL");
        ReservedDBWords.addWord("INPUT", "ANSI-SQL");
        ReservedDBWords.addWord("INSENSITIVE", "ANSI-SQL");
        ReservedDBWords.addWord("INSERT", "ANSI-SQL");
        ReservedDBWords.addWord("INT", "ANSI-SQL");
        ReservedDBWords.addWord("INTEGER", "ANSI-SQL");
        ReservedDBWords.addWord("INTERSECT", "ANSI-SQL");
        ReservedDBWords.addWord("INTERVAL", "ANSI-SQL");
        ReservedDBWords.addWord("INTO", "ANSI-SQL");
        ReservedDBWords.addWord("IS", "ANSI-SQL");
        ReservedDBWords.addWord("ISOLATION", "ANSI-SQL");
        ReservedDBWords.addWord("ITERATE", "ANSI-SQL");
        ReservedDBWords.addWord("JOIN", "ANSI-SQL");
        ReservedDBWords.addWord("KEY", "ANSI-SQL");
        ReservedDBWords.addWord("LANGUAGE", "ANSI-SQL");
        ReservedDBWords.addWord("LARGE", "ANSI-SQL");
        ReservedDBWords.addWord("LAST", "ANSI-SQL");
        ReservedDBWords.addWord("LATERAL", "ANSI-SQL");
        ReservedDBWords.addWord("LEADING", "ANSI-SQL");
        ReservedDBWords.addWord("LEAVE", "ANSI-SQL");
        ReservedDBWords.addWord("LEFT", "ANSI-SQL");
        ReservedDBWords.addWord("LEVEL", "ANSI-SQL");
        ReservedDBWords.addWord("LIKE", "ANSI-SQL");
        ReservedDBWords.addWord("LOCAL", "ANSI-SQL");
        ReservedDBWords.addWord("LOCALTIME", "ANSI-SQL");
        ReservedDBWords.addWord("LOCALTIMESTAMP", "ANSI-SQL");
        ReservedDBWords.addWord("LOCATOR", "ANSI-SQL");
        ReservedDBWords.addWord("LOOP", "ANSI-SQL");
        ReservedDBWords.addWord("LOWER", "ANSI-SQL");
        ReservedDBWords.addWord("MAP", "ANSI-SQL");
        ReservedDBWords.addWord("MATCH", "ANSI-SQL");
        ReservedDBWords.addWord("MAX", "ANSI-SQL");
        ReservedDBWords.addWord("MEMBER", "ANSI-SQL");
        ReservedDBWords.addWord("MERGE", "ANSI-SQL");
        ReservedDBWords.addWord("METHOD", "ANSI-SQL");
        ReservedDBWords.addWord("MIN", "ANSI-SQL");
        ReservedDBWords.addWord("MINUTE", "ANSI-SQL");
        ReservedDBWords.addWord("MODIFIES", "ANSI-SQL");
        ReservedDBWords.addWord("MODULE", "ANSI-SQL");
        ReservedDBWords.addWord("MONTH", "ANSI-SQL");
        ReservedDBWords.addWord("MULTISET", "ANSI-SQL");
        ReservedDBWords.addWord("NAMES", "ANSI-SQL");
        ReservedDBWords.addWord("NATIONAL", "ANSI-SQL");
        ReservedDBWords.addWord("NATURAL", "ANSI-SQL");
        ReservedDBWords.addWord("NCHAR", "ANSI-SQL");
        ReservedDBWords.addWord("NCLOB", "ANSI-SQL");
        ReservedDBWords.addWord("NEW", "ANSI-SQL");
        ReservedDBWords.addWord("NEXT", "ANSI-SQL");
        ReservedDBWords.addWord("NO", "ANSI-SQL");
        ReservedDBWords.addWord("NONE", "ANSI-SQL");
        ReservedDBWords.addWord("NOT", "ANSI-SQL");
        ReservedDBWords.addWord("NULL", "ANSI-SQL");
        ReservedDBWords.addWord("NULLIF", "ANSI-SQL");
        ReservedDBWords.addWord("NUMERIC", "ANSI-SQL");
        ReservedDBWords.addWord("OBJECT", "ANSI-SQL");
        ReservedDBWords.addWord("OCTET_LENGTH", "ANSI-SQL");
        ReservedDBWords.addWord("OF", "ANSI-SQL");
        ReservedDBWords.addWord("OLD", "ANSI-SQL");
        ReservedDBWords.addWord("ON", "ANSI-SQL");
        ReservedDBWords.addWord("ONLY", "ANSI-SQL");
        ReservedDBWords.addWord("OPEN", "ANSI-SQL");
        ReservedDBWords.addWord("OPTION", "ANSI-SQL");
        ReservedDBWords.addWord("OR", "ANSI-SQL");
        ReservedDBWords.addWord("ORDER", "ANSI-SQL");
        ReservedDBWords.addWord("ORDINALITY", "ANSI-SQL");
        ReservedDBWords.addWord("OUT", "ANSI-SQL");
        ReservedDBWords.addWord("OUTER", "ANSI-SQL");
        ReservedDBWords.addWord("OUTPUT", "ANSI-SQL");
        ReservedDBWords.addWord("OVER", "ANSI-SQL");
        ReservedDBWords.addWord("OVERLAPS", "ANSI-SQL");
        ReservedDBWords.addWord("PAD", "ANSI-SQL");
        ReservedDBWords.addWord("PARAMETER", "ANSI-SQL");
        ReservedDBWords.addWord("PARTIAL", "ANSI-SQL");
        ReservedDBWords.addWord("PARTITION", "ANSI-SQL");
        ReservedDBWords.addWord("PATH", "ANSI-SQL");
        ReservedDBWords.addWord("POSITION", "ANSI-SQL");
        ReservedDBWords.addWord("PRECISION", "ANSI-SQL");
        ReservedDBWords.addWord("PREPARE", "ANSI-SQL");
        ReservedDBWords.addWord("PRESERVE", "ANSI-SQL");
        ReservedDBWords.addWord("PRIMARY", "ANSI-SQL");
        ReservedDBWords.addWord("PRIOR", "ANSI-SQL");
        ReservedDBWords.addWord("PRIVILEGES", "ANSI-SQL");
        ReservedDBWords.addWord("PROCEDURE", "ANSI-SQL");
        ReservedDBWords.addWord("PUBLIC", "ANSI-SQL");
        ReservedDBWords.addWord("RANGE", "ANSI-SQL");
        ReservedDBWords.addWord("READ", "ANSI-SQL");
        ReservedDBWords.addWord("READS", "ANSI-SQL");
        ReservedDBWords.addWord("REAL", "ANSI-SQL");
        ReservedDBWords.addWord("RECURSIVE", "ANSI-SQL");
        ReservedDBWords.addWord("REF", "ANSI-SQL");
        ReservedDBWords.addWord("REFERENCES", "ANSI-SQL");
        ReservedDBWords.addWord("REFERENCING", "ANSI-SQL");
        ReservedDBWords.addWord("RELATIVE", "ANSI-SQL");
        ReservedDBWords.addWord("RELEASE", "ANSI-SQL");
        ReservedDBWords.addWord("REPEAT", "ANSI-SQL");
        ReservedDBWords.addWord("RESIGNAL", "ANSI-SQL");
        ReservedDBWords.addWord("RESTRICT", "ANSI-SQL");
        ReservedDBWords.addWord("RESULT", "ANSI-SQL");
        ReservedDBWords.addWord("RETURN", "ANSI-SQL");
        ReservedDBWords.addWord("RETURNS", "ANSI-SQL");
        ReservedDBWords.addWord("REVOKE", "ANSI-SQL");
        ReservedDBWords.addWord("RIGHT", "ANSI-SQL");
        ReservedDBWords.addWord("ROLE", "ANSI-SQL");
        ReservedDBWords.addWord("ROLLBACK", "ANSI-SQL");
        ReservedDBWords.addWord("ROLLUP", "ANSI-SQL");
        ReservedDBWords.addWord("ROUTINE", "ANSI-SQL");
        ReservedDBWords.addWord("ROW", "ANSI-SQL");
        ReservedDBWords.addWord("ROWS", "ANSI-SQL");
        ReservedDBWords.addWord("SAVEPOINT", "ANSI-SQL");
        ReservedDBWords.addWord("SCHEMA", "ANSI-SQL");
        ReservedDBWords.addWord("SCOPE", "ANSI-SQL");
        ReservedDBWords.addWord("SCROLL", "ANSI-SQL");
        ReservedDBWords.addWord("SEARCH", "ANSI-SQL");
        ReservedDBWords.addWord("SECOND", "ANSI-SQL");
        ReservedDBWords.addWord("SECTION", "ANSI-SQL");
        ReservedDBWords.addWord("SELECT", "ANSI-SQL");
        ReservedDBWords.addWord("SENSITIVE", "ANSI-SQL");
        ReservedDBWords.addWord("SESSION", "ANSI-SQL");
        ReservedDBWords.addWord("SESSION_USER", "ANSI-SQL");
        ReservedDBWords.addWord("SET", "ANSI-SQL");
        ReservedDBWords.addWord("SETS", "ANSI-SQL");
        ReservedDBWords.addWord("SIGNAL", "ANSI-SQL");
        ReservedDBWords.addWord("SIMILAR", "ANSI-SQL");
        ReservedDBWords.addWord("SIZE", "ANSI-SQL");
        ReservedDBWords.addWord("SMALLINT", "ANSI-SQL");
        ReservedDBWords.addWord("SOME", "ANSI-SQL");
        ReservedDBWords.addWord("SPACE", "ANSI-SQL");
        ReservedDBWords.addWord("SPECIFIC", "ANSI-SQL");
        ReservedDBWords.addWord("SPECIFICTYPE", "ANSI-SQL");
        ReservedDBWords.addWord("SQL", "ANSI-SQL");
        ReservedDBWords.addWord("SQLCODE", "ANSI-SQL");
        ReservedDBWords.addWord("SQLERROR", "ANSI-SQL");
        ReservedDBWords.addWord("SQLEXCEPTION", "ANSI-SQL");
        ReservedDBWords.addWord("SQLSTATE", "ANSI-SQL");
        ReservedDBWords.addWord("SQLWARNING", "ANSI-SQL");
        ReservedDBWords.addWord("START", "ANSI-SQL");
        ReservedDBWords.addWord("STATE", "ANSI-SQL");
        ReservedDBWords.addWord("STATIC", "ANSI-SQL");
        ReservedDBWords.addWord("SUBMULTISET", "ANSI-SQL");
        ReservedDBWords.addWord("SUBSTRING", "ANSI-SQL");
        ReservedDBWords.addWord("SUM", "ANSI-SQL");
        ReservedDBWords.addWord("SYMMETRIC", "ANSI-SQL");
        ReservedDBWords.addWord("SYSTEM", "ANSI-SQL");
        ReservedDBWords.addWord("SYSTEM_USER", "ANSI-SQL");
        ReservedDBWords.addWord("TABLE", "ANSI-SQL");
        ReservedDBWords.addWord("TABLESAMPLE", "ANSI-SQL");
        ReservedDBWords.addWord("TEMPORARY", "ANSI-SQL");
        ReservedDBWords.addWord("THEN", "ANSI-SQL");
        ReservedDBWords.addWord("TIME", "ANSI-SQL");
        ReservedDBWords.addWord("TIMESTAMP", "ANSI-SQL");
        ReservedDBWords.addWord("TIMEZONE_HOUR", "ANSI-SQL");
        ReservedDBWords.addWord("TIMEZONE_MINUTE", "ANSI-SQL");
        ReservedDBWords.addWord("TO", "ANSI-SQL");
        ReservedDBWords.addWord("TRAILING", "ANSI-SQL");
        ReservedDBWords.addWord("TRANSACTION", "ANSI-SQL");
        ReservedDBWords.addWord("TRANSLATE", "ANSI-SQL");
        ReservedDBWords.addWord("TRANSLATION", "ANSI-SQL");
        ReservedDBWords.addWord("TREAT", "ANSI-SQL");
        ReservedDBWords.addWord("TRIGGER", "ANSI-SQL");
        ReservedDBWords.addWord("TRIM", "ANSI-SQL");
        ReservedDBWords.addWord("UNDER", "ANSI-SQL");
        ReservedDBWords.addWord("UNDO", "ANSI-SQL");
        ReservedDBWords.addWord("UNION", "ANSI-SQL");
        ReservedDBWords.addWord("UNIQUE", "ANSI-SQL");
        ReservedDBWords.addWord("UNKNOWN", "ANSI-SQL");
        ReservedDBWords.addWord("UNNEST", "ANSI-SQL");
        ReservedDBWords.addWord("UNTIL", "ANSI-SQL");
        ReservedDBWords.addWord("UPDATE", "ANSI-SQL");
        ReservedDBWords.addWord("UPPER", "ANSI-SQL");
        ReservedDBWords.addWord("USAGE", "ANSI-SQL");
        ReservedDBWords.addWord("USER", "ANSI-SQL");
        ReservedDBWords.addWord("USING", "ANSI-SQL");
        ReservedDBWords.addWord("VALUE", "ANSI-SQL");
        ReservedDBWords.addWord("VALUES", "ANSI-SQL");
        ReservedDBWords.addWord("VARCHAR", "ANSI-SQL");
        ReservedDBWords.addWord("VARYING", "ANSI-SQL");
        ReservedDBWords.addWord("VIEW", "ANSI-SQL");
        ReservedDBWords.addWord("WHEN", "ANSI-SQL");
        ReservedDBWords.addWord("WHENEVER", "ANSI-SQL");
        ReservedDBWords.addWord("WHERE", "ANSI-SQL");
        ReservedDBWords.addWord("WHILE", "ANSI-SQL");
        ReservedDBWords.addWord("WINDOW", "ANSI-SQL");
        ReservedDBWords.addWord("WITH", "ANSI-SQL");
        ReservedDBWords.addWord("WITHIN", "ANSI-SQL");
        ReservedDBWords.addWord("WITHOUT", "ANSI-SQL");
        ReservedDBWords.addWord("WORK", "ANSI-SQL");
        ReservedDBWords.addWord("WRITE", "ANSI-SQL");
        ReservedDBWords.addWord("YEAR", "ANSI-SQL");
        ReservedDBWords.addWord("ZONE", "ANSI-SQL");
        ReservedDBWords.addWord("FALSE", "ANSI-SQL");
        ReservedDBWords.addWord("TRUE", "ANSI-SQL");
        ReservedDBWords.addWord("ACCESSIBLE", "MySQL");
        ReservedDBWords.addWord("ADD", "MySQL");
        ReservedDBWords.addWord("ALL", "MySQL");
        ReservedDBWords.addWord("ALTER", "MySQL");
        ReservedDBWords.addWord("ANALYZE", "MySQL");
        ReservedDBWords.addWord("AND", "MySQL");
        ReservedDBWords.addWord("AS", "MySQL");
        ReservedDBWords.addWord("ASC", "MySQL");
        ReservedDBWords.addWord("ASENSITIVE", "MySQL");
        ReservedDBWords.addWord("BEFORE", "MySQL");
        ReservedDBWords.addWord("BETWEEN", "MySQL");
        ReservedDBWords.addWord("BIGINT", "MySQL");
        ReservedDBWords.addWord("BINARY", "MySQL");
        ReservedDBWords.addWord("BLOB", "MySQL");
        ReservedDBWords.addWord("BOTH", "MySQL");
        ReservedDBWords.addWord("BY", "MySQL");
        ReservedDBWords.addWord("CALL", "MySQL");
        ReservedDBWords.addWord("CASCADE", "MySQL");
        ReservedDBWords.addWord("CASE", "MySQL");
        ReservedDBWords.addWord("CHANGE", "MySQL");
        ReservedDBWords.addWord("CHAR", "MySQL");
        ReservedDBWords.addWord("CHARACTER", "MySQL");
        ReservedDBWords.addWord("CHECK", "MySQL");
        ReservedDBWords.addWord("COLLATE", "MySQL");
        ReservedDBWords.addWord("COLUMN", "MySQL");
        ReservedDBWords.addWord("CONDITION", "MySQL");
        ReservedDBWords.addWord("CONSTRAINT", "MySQL");
        ReservedDBWords.addWord("CONTINUE", "MySQL");
        ReservedDBWords.addWord("CONVERT", "MySQL");
        ReservedDBWords.addWord("CREATE", "MySQL");
        ReservedDBWords.addWord("CROSS", "MySQL");
        ReservedDBWords.addWord("CURRENT_DATE", "MySQL");
        ReservedDBWords.addWord("CURRENT_TIME", "MySQL");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "MySQL");
        ReservedDBWords.addWord("CURRENT_USER", "MySQL");
        ReservedDBWords.addWord("CURSOR", "MySQL");
        ReservedDBWords.addWord("DATABASE", "MySQL");
        ReservedDBWords.addWord("DATABASES", "MySQL");
        ReservedDBWords.addWord("DAY_HOUR", "MySQL");
        ReservedDBWords.addWord("DAY_MICROSECOND", "MySQL");
        ReservedDBWords.addWord("DAY_MINUTE", "MySQL");
        ReservedDBWords.addWord("DAY_SECOND", "MySQL");
        ReservedDBWords.addWord("DEC", "MySQL");
        ReservedDBWords.addWord("DECIMAL", "MySQL");
        ReservedDBWords.addWord("DECLARE", "MySQL");
        ReservedDBWords.addWord("DEFAULT", "MySQL");
        ReservedDBWords.addWord("DELAYED", "MySQL");
        ReservedDBWords.addWord("DELETE", "MySQL");
        ReservedDBWords.addWord("DESC", "MySQL");
        ReservedDBWords.addWord("DESCRIBE", "MySQL");
        ReservedDBWords.addWord("DETERMINISTIC", "MySQL");
        ReservedDBWords.addWord("DISTINCT", "MySQL");
        ReservedDBWords.addWord("DISTINCTROW", "MySQL");
        ReservedDBWords.addWord("DIV", "MySQL");
        ReservedDBWords.addWord("DOUBLE", "MySQL");
        ReservedDBWords.addWord("DROP", "MySQL");
        ReservedDBWords.addWord("DUAL", "MySQL");
        ReservedDBWords.addWord("EACH", "MySQL");
        ReservedDBWords.addWord("ELSE", "MySQL");
        ReservedDBWords.addWord("ELSEIF", "MySQL");
        ReservedDBWords.addWord("ENCLOSED", "MySQL");
        ReservedDBWords.addWord("ESCAPED", "MySQL");
        ReservedDBWords.addWord("EXISTS", "MySQL");
        ReservedDBWords.addWord("EXIT", "MySQL");
        ReservedDBWords.addWord("EXPLAIN", "MySQL");
        ReservedDBWords.addWord("FALSE", "MySQL");
        ReservedDBWords.addWord("FETCH", "MySQL");
        ReservedDBWords.addWord("FLOAT", "MySQL");
        ReservedDBWords.addWord("FLOAT4", "MySQL");
        ReservedDBWords.addWord("FLOAT8", "MySQL");
        ReservedDBWords.addWord("FOR", "MySQL");
        ReservedDBWords.addWord("FORCE", "MySQL");
        ReservedDBWords.addWord("FOREIGN", "MySQL");
        ReservedDBWords.addWord("FROM", "MySQL");
        ReservedDBWords.addWord("FULLTEXT", "MySQL");
        ReservedDBWords.addWord("GENERATED[i]", "MySQL");
        ReservedDBWords.addWord("GET", "MySQL");
        ReservedDBWords.addWord("GRANT", "MySQL");
        ReservedDBWords.addWord("GROUP", "MySQL");
        ReservedDBWords.addWord("HAVING", "MySQL");
        ReservedDBWords.addWord("HIGH_PRIORITY", "MySQL");
        ReservedDBWords.addWord("HOUR_MICROSECOND", "MySQL");
        ReservedDBWords.addWord("HOUR_MINUTE", "MySQL");
        ReservedDBWords.addWord("HOUR_SECOND", "MySQL");
        ReservedDBWords.addWord("IF", "MySQL");
        ReservedDBWords.addWord("IGNORE", "MySQL");
        ReservedDBWords.addWord("IN", "MySQL");
        ReservedDBWords.addWord("INDEX", "MySQL");
        ReservedDBWords.addWord("INFILE", "MySQL");
        ReservedDBWords.addWord("INNER", "MySQL");
        ReservedDBWords.addWord("INOUT", "MySQL");
        ReservedDBWords.addWord("INSENSITIVE", "MySQL");
        ReservedDBWords.addWord("INSERT", "MySQL");
        ReservedDBWords.addWord("INT", "MySQL");
        ReservedDBWords.addWord("INT1", "MySQL");
        ReservedDBWords.addWord("INT2", "MySQL");
        ReservedDBWords.addWord("INT3", "MySQL");
        ReservedDBWords.addWord("INT4", "MySQL");
        ReservedDBWords.addWord("INT8", "MySQL");
        ReservedDBWords.addWord("INTEGER", "MySQL");
        ReservedDBWords.addWord("INTERVAL", "MySQL");
        ReservedDBWords.addWord("INTO", "MySQL");
        ReservedDBWords.addWord("IO_AFTER_GTIDS", "MySQL");
        ReservedDBWords.addWord("IO_BEFORE_GTIDS", "MySQL");
        ReservedDBWords.addWord("IS", "MySQL");
        ReservedDBWords.addWord("ITERATE", "MySQL");
        ReservedDBWords.addWord("JOIN", "MySQL");
        ReservedDBWords.addWord("KEY", "MySQL");
        ReservedDBWords.addWord("KEYS", "MySQL");
        ReservedDBWords.addWord("KILL", "MySQL");
        ReservedDBWords.addWord("LEADING", "MySQL");
        ReservedDBWords.addWord("LEAVE", "MySQL");
        ReservedDBWords.addWord("LEFT", "MySQL");
        ReservedDBWords.addWord("LIKE", "MySQL");
        ReservedDBWords.addWord("LIMIT", "MySQL");
        ReservedDBWords.addWord("LINEAR", "MySQL");
        ReservedDBWords.addWord("LINES", "MySQL");
        ReservedDBWords.addWord("LOAD", "MySQL");
        ReservedDBWords.addWord("LOCALTIME", "MySQL");
        ReservedDBWords.addWord("LOCALTIMESTAMP", "MySQL");
        ReservedDBWords.addWord("LOCK", "MySQL");
        ReservedDBWords.addWord("LONG", "MySQL");
        ReservedDBWords.addWord("LONGBLOB", "MySQL");
        ReservedDBWords.addWord("LONGTEXT", "MySQL");
        ReservedDBWords.addWord("LOOP", "MySQL");
        ReservedDBWords.addWord("LOW_PRIORITY", "MySQL");
        ReservedDBWords.addWord("MASTER_BIND", "MySQL");
        ReservedDBWords.addWord("MASTER_SSL_VERIFY_SERVER_CERT", "MySQL");
        ReservedDBWords.addWord("MATCH", "MySQL");
        ReservedDBWords.addWord("MAXVALUE", "MySQL");
        ReservedDBWords.addWord("MEDIUMBLOB", "MySQL");
        ReservedDBWords.addWord("MEDIUMINT", "MySQL");
        ReservedDBWords.addWord("MEDIUMTEXT", "MySQL");
        ReservedDBWords.addWord("MIDDLEINT", "MySQL");
        ReservedDBWords.addWord("MINUTE_MICROSECOND", "MySQL");
        ReservedDBWords.addWord("MINUTE_SECOND", "MySQL");
        ReservedDBWords.addWord("MOD", "MySQL");
        ReservedDBWords.addWord("MODIFIES", "MySQL");
        ReservedDBWords.addWord("NATURAL", "MySQL");
        ReservedDBWords.addWord("NOT", "MySQL");
        ReservedDBWords.addWord("NO_WRITE_TO_BINLOG", "MySQL");
        ReservedDBWords.addWord("NULL", "MySQL");
        ReservedDBWords.addWord("NUMERIC", "MySQL");
        ReservedDBWords.addWord("ON", "MySQL");
        ReservedDBWords.addWord("OPTIMIZE", "MySQL");
        ReservedDBWords.addWord("OPTIMIZER_COSTS[r]", "MySQL");
        ReservedDBWords.addWord("OPTION", "MySQL");
        ReservedDBWords.addWord("OPTIONALLY", "MySQL");
        ReservedDBWords.addWord("OR", "MySQL");
        ReservedDBWords.addWord("ORDER", "MySQL");
        ReservedDBWords.addWord("OUT", "MySQL");
        ReservedDBWords.addWord("OUTER", "MySQL");
        ReservedDBWords.addWord("OUTFILE", "MySQL");
        ReservedDBWords.addWord("PARTITION", "MySQL");
        ReservedDBWords.addWord("PRECISION", "MySQL");
        ReservedDBWords.addWord("PRIMARY", "MySQL");
        ReservedDBWords.addWord("PROCEDURE", "MySQL");
        ReservedDBWords.addWord("PURGE", "MySQL");
        ReservedDBWords.addWord("RANGE", "MySQL");
        ReservedDBWords.addWord("READ", "MySQL");
        ReservedDBWords.addWord("READS", "MySQL");
        ReservedDBWords.addWord("READ_WRITE", "MySQL");
        ReservedDBWords.addWord("REAL", "MySQL");
        ReservedDBWords.addWord("REFERENCES", "MySQL");
        ReservedDBWords.addWord("REGEXP", "MySQL");
        ReservedDBWords.addWord("RELEASE", "MySQL");
        ReservedDBWords.addWord("RENAME", "MySQL");
        ReservedDBWords.addWord("REPEAT", "MySQL");
        ReservedDBWords.addWord("REPLACE", "MySQL");
        ReservedDBWords.addWord("REQUIRE", "MySQL");
        ReservedDBWords.addWord("RESIGNAL", "MySQL");
        ReservedDBWords.addWord("RESTRICT", "MySQL");
        ReservedDBWords.addWord("RETURN", "MySQL");
        ReservedDBWords.addWord("REVOKE", "MySQL");
        ReservedDBWords.addWord("RIGHT", "MySQL");
        ReservedDBWords.addWord("RLIKE", "MySQL");
        ReservedDBWords.addWord("SCHEMA", "MySQL");
        ReservedDBWords.addWord("SCHEMAS", "MySQL");
        ReservedDBWords.addWord("SECOND_MICROSECOND", "MySQL");
        ReservedDBWords.addWord("SELECT", "MySQL");
        ReservedDBWords.addWord("SENSITIVE", "MySQL");
        ReservedDBWords.addWord("SEPARATOR", "MySQL");
        ReservedDBWords.addWord("SET", "MySQL");
        ReservedDBWords.addWord("SHOW", "MySQL");
        ReservedDBWords.addWord("SIGNAL", "MySQL");
        ReservedDBWords.addWord("SMALLINT", "MySQL");
        ReservedDBWords.addWord("SPATIAL", "MySQL");
        ReservedDBWords.addWord("SPECIFIC", "MySQL");
        ReservedDBWords.addWord("SQL", "MySQL");
        ReservedDBWords.addWord("SQLEXCEPTION", "MySQL");
        ReservedDBWords.addWord("SQLSTATE", "MySQL");
        ReservedDBWords.addWord("SQLWARNING", "MySQL");
        ReservedDBWords.addWord("SQL_BIG_RESULT", "MySQL");
        ReservedDBWords.addWord("SQL_CALC_FOUND_ROWS", "MySQL");
        ReservedDBWords.addWord("SQL_SMALL_RESULT", "MySQL");
        ReservedDBWords.addWord("SSL", "MySQL");
        ReservedDBWords.addWord("STARTING", "MySQL");
        ReservedDBWords.addWord("STORED[ac]", "MySQL");
        ReservedDBWords.addWord("STRAIGHT_JOIN", "MySQL");
        ReservedDBWords.addWord("TABLE", "MySQL");
        ReservedDBWords.addWord("TERMINATED", "MySQL");
        ReservedDBWords.addWord("THEN", "MySQL");
        ReservedDBWords.addWord("TINYBLOB", "MySQL");
        ReservedDBWords.addWord("TINYINT", "MySQL");
        ReservedDBWords.addWord("TINYTEXT", "MySQL");
        ReservedDBWords.addWord("TO", "MySQL");
        ReservedDBWords.addWord("TRAILING", "MySQL");
        ReservedDBWords.addWord("TRIGGER", "MySQL");
        ReservedDBWords.addWord("TRUE", "MySQL");
        ReservedDBWords.addWord("UNDO", "MySQL");
        ReservedDBWords.addWord("UNION", "MySQL");
        ReservedDBWords.addWord("UNIQUE", "MySQL");
        ReservedDBWords.addWord("UNLOCK", "MySQL");
        ReservedDBWords.addWord("UNSIGNED", "MySQL");
        ReservedDBWords.addWord("UPDATE", "MySQL");
        ReservedDBWords.addWord("USAGE", "MySQL");
        ReservedDBWords.addWord("USE", "MySQL");
        ReservedDBWords.addWord("USING", "MySQL");
        ReservedDBWords.addWord("UTC_DATE", "MySQL");
        ReservedDBWords.addWord("UTC_TIME", "MySQL");
        ReservedDBWords.addWord("UTC_TIMESTAMP", "MySQL");
        ReservedDBWords.addWord("VALUES", "MySQL");
        ReservedDBWords.addWord("VARBINARY", "MySQL");
        ReservedDBWords.addWord("VARCHAR", "MySQL");
        ReservedDBWords.addWord("VARCHARACTER", "MySQL");
        ReservedDBWords.addWord("VARYING", "MySQL");
        ReservedDBWords.addWord("VIRTUAL[ae]", "MySQL");
        ReservedDBWords.addWord("WHEN", "MySQL");
        ReservedDBWords.addWord("WHERE", "MySQL");
        ReservedDBWords.addWord("WHILE", "MySQL");
        ReservedDBWords.addWord("WITH", "MySQL");
        ReservedDBWords.addWord("WRITE", "MySQL");
        ReservedDBWords.addWord("XOR", "MySQL");
        ReservedDBWords.addWord("YEAR_MONTH", "MySQL");
        ReservedDBWords.addWord("ZEROFILL", "MySQL");
        ReservedDBWords.addWord("ADD", "SQLServer");
        ReservedDBWords.addWord("ALL", "SQLServer");
        ReservedDBWords.addWord("ALTER", "SQLServer");
        ReservedDBWords.addWord("AND", "SQLServer");
        ReservedDBWords.addWord("ANY", "SQLServer");
        ReservedDBWords.addWord("AS", "SQLServer");
        ReservedDBWords.addWord("ASC", "SQLServer");
        ReservedDBWords.addWord("AUTHORIZATION", "SQLServer");
        ReservedDBWords.addWord("BACKUP", "SQLServer");
        ReservedDBWords.addWord("BEGIN", "SQLServer");
        ReservedDBWords.addWord("BETWEEN", "SQLServer");
        ReservedDBWords.addWord("BREAK", "SQLServer");
        ReservedDBWords.addWord("BROWSE", "SQLServer");
        ReservedDBWords.addWord("BULK", "SQLServer");
        ReservedDBWords.addWord("BY", "SQLServer");
        ReservedDBWords.addWord("CASCADE", "SQLServer");
        ReservedDBWords.addWord("CASE", "SQLServer");
        ReservedDBWords.addWord("CHECK", "SQLServer");
        ReservedDBWords.addWord("CHECKPOINT", "SQLServer");
        ReservedDBWords.addWord("CLOSE", "SQLServer");
        ReservedDBWords.addWord("CLUSTERED", "SQLServer");
        ReservedDBWords.addWord("COALESCE", "SQLServer");
        ReservedDBWords.addWord("COLLATE", "SQLServer");
        ReservedDBWords.addWord("COLUMN", "SQLServer");
        ReservedDBWords.addWord("COMMIT", "SQLServer");
        ReservedDBWords.addWord("COMPUTE", "SQLServer");
        ReservedDBWords.addWord("CONSTRAINT", "SQLServer");
        ReservedDBWords.addWord("CONTAINS", "SQLServer");
        ReservedDBWords.addWord("CONTAINSTABLE", "SQLServer");
        ReservedDBWords.addWord("CONTINUE", "SQLServer");
        ReservedDBWords.addWord("CONVERT", "SQLServer");
        ReservedDBWords.addWord("CREATE", "SQLServer");
        ReservedDBWords.addWord("CROSS", "SQLServer");
        ReservedDBWords.addWord("CURRENT", "SQLServer");
        ReservedDBWords.addWord("CURRENT_DATE", "SQLServer");
        ReservedDBWords.addWord("CURRENT_TIME", "SQLServer");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "SQLServer");
        ReservedDBWords.addWord("CURRENT_USER", "SQLServer");
        ReservedDBWords.addWord("CURSOR", "SQLServer");
        ReservedDBWords.addWord("DATABASE", "SQLServer");
        ReservedDBWords.addWord("DBCC", "SQLServer");
        ReservedDBWords.addWord("DEALLOCATE", "SQLServer");
        ReservedDBWords.addWord("DECLARE", "SQLServer");
        ReservedDBWords.addWord("DEFAULT", "SQLServer");
        ReservedDBWords.addWord("DELETE", "SQLServer");
        ReservedDBWords.addWord("DENY", "SQLServer");
        ReservedDBWords.addWord("DESC", "SQLServer");
        ReservedDBWords.addWord("DISK", "SQLServer");
        ReservedDBWords.addWord("DISTINCT", "SQLServer");
        ReservedDBWords.addWord("DISTRIBUTED", "SQLServer");
        ReservedDBWords.addWord("DOUBLE", "SQLServer");
        ReservedDBWords.addWord("DROP", "SQLServer");
        ReservedDBWords.addWord("DUMP", "SQLServer");
        ReservedDBWords.addWord("ELSE", "SQLServer");
        ReservedDBWords.addWord("END", "SQLServer");
        ReservedDBWords.addWord("ERRLVL", "SQLServer");
        ReservedDBWords.addWord("ESCAPE", "SQLServer");
        ReservedDBWords.addWord("EXCEPT", "SQLServer");
        ReservedDBWords.addWord("EXEC", "SQLServer");
        ReservedDBWords.addWord("EXECUTE", "SQLServer");
        ReservedDBWords.addWord("EXISTS", "SQLServer");
        ReservedDBWords.addWord("EXIT", "SQLServer");
        ReservedDBWords.addWord("EXTERNAL", "SQLServer");
        ReservedDBWords.addWord("FETCH", "SQLServer");
        ReservedDBWords.addWord("FILE", "SQLServer");
        ReservedDBWords.addWord("FILLFACTOR", "SQLServer");
        ReservedDBWords.addWord("FOR", "SQLServer");
        ReservedDBWords.addWord("FOREIGN", "SQLServer");
        ReservedDBWords.addWord("FREETEXT", "SQLServer");
        ReservedDBWords.addWord("FREETEXTTABLE", "SQLServer");
        ReservedDBWords.addWord("FROM", "SQLServer");
        ReservedDBWords.addWord("FULL", "SQLServer");
        ReservedDBWords.addWord("FUNCTION", "SQLServer");
        ReservedDBWords.addWord("GOTO", "SQLServer");
        ReservedDBWords.addWord("GRANT", "SQLServer");
        ReservedDBWords.addWord("GROUP", "SQLServer");
        ReservedDBWords.addWord("HAVING", "SQLServer");
        ReservedDBWords.addWord("HOLDLOCK", "SQLServer");
        ReservedDBWords.addWord("IDENTITY", "SQLServer");
        ReservedDBWords.addWord("IDENTITY_INSERT", "SQLServer");
        ReservedDBWords.addWord("IDENTITYCOL", "SQLServer");
        ReservedDBWords.addWord("IF", "SQLServer");
        ReservedDBWords.addWord("IN", "SQLServer");
        ReservedDBWords.addWord("INDEX", "SQLServer");
        ReservedDBWords.addWord("INNER", "SQLServer");
        ReservedDBWords.addWord("INSERT", "SQLServer");
        ReservedDBWords.addWord("INTERSECT", "SQLServer");
        ReservedDBWords.addWord("INTO", "SQLServer");
        ReservedDBWords.addWord("IS", "SQLServer");
        ReservedDBWords.addWord("JOIN", "SQLServer");
        ReservedDBWords.addWord("KEY", "SQLServer");
        ReservedDBWords.addWord("KILL", "SQLServer");
        ReservedDBWords.addWord("LEFT", "SQLServer");
        ReservedDBWords.addWord("LIKE", "SQLServer");
        ReservedDBWords.addWord("LINENO", "SQLServer");
        ReservedDBWords.addWord("LOAD", "SQLServer");
        ReservedDBWords.addWord("MERGE", "SQLServer");
        ReservedDBWords.addWord("NATIONAL", "SQLServer");
        ReservedDBWords.addWord("NOCHECK", "SQLServer");
        ReservedDBWords.addWord("NONCLUSTERED", "SQLServer");
        ReservedDBWords.addWord("NOT", "SQLServer");
        ReservedDBWords.addWord("NULL", "SQLServer");
        ReservedDBWords.addWord("NULLIF", "SQLServer");
        ReservedDBWords.addWord("OF", "SQLServer");
        ReservedDBWords.addWord("OFF", "SQLServer");
        ReservedDBWords.addWord("OFFSETS", "SQLServer");
        ReservedDBWords.addWord("ON", "SQLServer");
        ReservedDBWords.addWord("OPEN", "SQLServer");
        ReservedDBWords.addWord("OPENDATASOURCE", "SQLServer");
        ReservedDBWords.addWord("OPENQUERY", "SQLServer");
        ReservedDBWords.addWord("OPENROWSET", "SQLServer");
        ReservedDBWords.addWord("OPENXML", "SQLServer");
        ReservedDBWords.addWord("OPTION", "SQLServer");
        ReservedDBWords.addWord("OR", "SQLServer");
        ReservedDBWords.addWord("ORDER", "SQLServer");
        ReservedDBWords.addWord("OUTER", "SQLServer");
        ReservedDBWords.addWord("OVER", "SQLServer");
        ReservedDBWords.addWord("PERCENT", "SQLServer");
        ReservedDBWords.addWord("PIVOT", "SQLServer");
        ReservedDBWords.addWord("PLAN", "SQLServer");
        ReservedDBWords.addWord("PRECISION", "SQLServer");
        ReservedDBWords.addWord("PRIMARY", "SQLServer");
        ReservedDBWords.addWord("PRINT", "SQLServer");
        ReservedDBWords.addWord("PROC", "SQLServer");
        ReservedDBWords.addWord("PROCEDURE", "SQLServer");
        ReservedDBWords.addWord("PUBLIC", "SQLServer");
        ReservedDBWords.addWord("RAISERROR", "SQLServer");
        ReservedDBWords.addWord("READ", "SQLServer");
        ReservedDBWords.addWord("READTEXT", "SQLServer");
        ReservedDBWords.addWord("RECONFIGURE", "SQLServer");
        ReservedDBWords.addWord("REFERENCES", "SQLServer");
        ReservedDBWords.addWord("REPLICATION", "SQLServer");
        ReservedDBWords.addWord("RESTORE", "SQLServer");
        ReservedDBWords.addWord("RESTRICT", "SQLServer");
        ReservedDBWords.addWord("RETURN", "SQLServer");
        ReservedDBWords.addWord("REVERT", "SQLServer");
        ReservedDBWords.addWord("REVOKE", "SQLServer");
        ReservedDBWords.addWord("RIGHT", "SQLServer");
        ReservedDBWords.addWord("ROLLBACK", "SQLServer");
        ReservedDBWords.addWord("ROWCOUNT", "SQLServer");
        ReservedDBWords.addWord("ROWGUIDCOL", "SQLServer");
        ReservedDBWords.addWord("RULE", "SQLServer");
        ReservedDBWords.addWord("SAVE", "SQLServer");
        ReservedDBWords.addWord("SCHEMA", "SQLServer");
        ReservedDBWords.addWord("SECURITYAUDIT", "SQLServer");
        ReservedDBWords.addWord("SELECT", "SQLServer");
        ReservedDBWords.addWord("SEMANTICKEYPHRASETABLE", "SQLServer");
        ReservedDBWords.addWord("SEMANTICSIMILARITYDETAILSTABLE", "SQLServer");
        ReservedDBWords.addWord("SEMANTICSIMILARITYTABLE", "SQLServer");
        ReservedDBWords.addWord("SESSION_USER", "SQLServer");
        ReservedDBWords.addWord("SET", "SQLServer");
        ReservedDBWords.addWord("SETUSER", "SQLServer");
        ReservedDBWords.addWord("SHUTDOWN", "SQLServer");
        ReservedDBWords.addWord("SOME", "SQLServer");
        ReservedDBWords.addWord("STATISTICS", "SQLServer");
        ReservedDBWords.addWord("SYSTEM_USER", "SQLServer");
        ReservedDBWords.addWord("TABLE", "SQLServer");
        ReservedDBWords.addWord("TABLESAMPLE", "SQLServer");
        ReservedDBWords.addWord("TEXTSIZE", "SQLServer");
        ReservedDBWords.addWord("THEN", "SQLServer");
        ReservedDBWords.addWord("TO", "SQLServer");
        ReservedDBWords.addWord("TOP", "SQLServer");
        ReservedDBWords.addWord("TRAN", "SQLServer");
        ReservedDBWords.addWord("TRANSACTION", "SQLServer");
        ReservedDBWords.addWord("TRIGGER", "SQLServer");
        ReservedDBWords.addWord("TRUNCATE", "SQLServer");
        ReservedDBWords.addWord("TRY_CONVERT", "SQLServer");
        ReservedDBWords.addWord("TSEQUAL", "SQLServer");
        ReservedDBWords.addWord("UNION", "SQLServer");
        ReservedDBWords.addWord("UNIQUE", "SQLServer");
        ReservedDBWords.addWord("UNPIVOT", "SQLServer");
        ReservedDBWords.addWord("UPDATE", "SQLServer");
        ReservedDBWords.addWord("UPDATETEXT", "SQLServer");
        ReservedDBWords.addWord("USE", "SQLServer");
        ReservedDBWords.addWord("USER", "SQLServer");
        ReservedDBWords.addWord("VALUES", "SQLServer");
        ReservedDBWords.addWord("VARYING", "SQLServer");
        ReservedDBWords.addWord("VIEW", "SQLServer");
        ReservedDBWords.addWord("WAITFOR", "SQLServer");
        ReservedDBWords.addWord("WHEN", "SQLServer");
        ReservedDBWords.addWord("WHERE", "SQLServer");
        ReservedDBWords.addWord("WHILE", "SQLServer");
        ReservedDBWords.addWord("WITH", "SQLServer");
        ReservedDBWords.addWord("WITHINGROUP", "SQLServer");
        ReservedDBWords.addWord("WRITETEXT", "SQLServer");
        ReservedDBWords.addWord("ACCESS", "Oracle");
        ReservedDBWords.addWord("ADD", "Oracle");
        ReservedDBWords.addWord("ALL", "Oracle");
        ReservedDBWords.addWord("ALTER", "Oracle");
        ReservedDBWords.addWord("AND", "Oracle");
        ReservedDBWords.addWord("ANY", "Oracle");
        ReservedDBWords.addWord("ARRAYLEN", "Oracle");
        ReservedDBWords.addWord("AS", "Oracle");
        ReservedDBWords.addWord("ASC", "Oracle");
        ReservedDBWords.addWord("AUDIT", "Oracle");
        ReservedDBWords.addWord("BETWEEN", "Oracle");
        ReservedDBWords.addWord("BY", "Oracle");
        ReservedDBWords.addWord("CHAR", "Oracle");
        ReservedDBWords.addWord("CHECK", "Oracle");
        ReservedDBWords.addWord("CLUSTER", "Oracle");
        ReservedDBWords.addWord("COLUMN", "Oracle");
        ReservedDBWords.addWord("COMMENT", "Oracle");
        ReservedDBWords.addWord("COMPRESS", "Oracle");
        ReservedDBWords.addWord("CONNECT", "Oracle");
        ReservedDBWords.addWord("CREATE", "Oracle");
        ReservedDBWords.addWord("CURRENT", "Oracle");
        ReservedDBWords.addWord("DATE", "Oracle");
        ReservedDBWords.addWord("DECIMAL", "Oracle");
        ReservedDBWords.addWord("DEFAULT", "Oracle");
        ReservedDBWords.addWord("DELETE", "Oracle");
        ReservedDBWords.addWord("DESC", "Oracle");
        ReservedDBWords.addWord("DISTINCT", "Oracle");
        ReservedDBWords.addWord("DROP", "Oracle");
        ReservedDBWords.addWord("ELSE", "Oracle");
        ReservedDBWords.addWord("EXCLUSIVE", "Oracle");
        ReservedDBWords.addWord("EXISTS", "Oracle");
        ReservedDBWords.addWord("FILE", "Oracle");
        ReservedDBWords.addWord("FLOAT", "Oracle");
        ReservedDBWords.addWord("FOR", "Oracle");
        ReservedDBWords.addWord("FROM", "Oracle");
        ReservedDBWords.addWord("GRANT", "Oracle");
        ReservedDBWords.addWord("GROUP", "Oracle");
        ReservedDBWords.addWord("HAVING", "Oracle");
        ReservedDBWords.addWord("IDENTIFIED", "Oracle");
        ReservedDBWords.addWord("IMMEDIATE", "Oracle");
        ReservedDBWords.addWord("IN", "Oracle");
        ReservedDBWords.addWord("INCREMENT", "Oracle");
        ReservedDBWords.addWord("INDEX", "Oracle");
        ReservedDBWords.addWord("INITIAL", "Oracle");
        ReservedDBWords.addWord("INSERT", "Oracle");
        ReservedDBWords.addWord("INTEGER", "Oracle");
        ReservedDBWords.addWord("INTERSECT", "Oracle");
        ReservedDBWords.addWord("INTO", "Oracle");
        ReservedDBWords.addWord("IS", "Oracle");
        ReservedDBWords.addWord("LEVEL", "Oracle");
        ReservedDBWords.addWord("LIKE", "Oracle");
        ReservedDBWords.addWord("LOCK", "Oracle");
        ReservedDBWords.addWord("LONG", "Oracle");
        ReservedDBWords.addWord("MAXEXTENTS", "Oracle");
        ReservedDBWords.addWord("MINUS", "Oracle");
        ReservedDBWords.addWord("MODE", "Oracle");
        ReservedDBWords.addWord("MODIFY", "Oracle");
        ReservedDBWords.addWord("NOAUDIT", "Oracle");
        ReservedDBWords.addWord("NOCOMPRESS", "Oracle");
        ReservedDBWords.addWord("NOT", "Oracle");
        ReservedDBWords.addWord("NOTFOUND", "Oracle");
        ReservedDBWords.addWord("NOWAIT", "Oracle");
        ReservedDBWords.addWord("NULL", "Oracle");
        ReservedDBWords.addWord("NUMBER", "Oracle");
        ReservedDBWords.addWord("OF", "Oracle");
        ReservedDBWords.addWord("OFFLINE", "Oracle");
        ReservedDBWords.addWord("ON", "Oracle");
        ReservedDBWords.addWord("ONLINE", "Oracle");
        ReservedDBWords.addWord("OPTION", "Oracle");
        ReservedDBWords.addWord("OR", "Oracle");
        ReservedDBWords.addWord("ORDER", "Oracle");
        ReservedDBWords.addWord("PCTFREE", "Oracle");
        ReservedDBWords.addWord("PRIOR", "Oracle");
        ReservedDBWords.addWord("PRIVILEGES", "Oracle");
        ReservedDBWords.addWord("PUBLIC", "Oracle");
        ReservedDBWords.addWord("RAW", "Oracle");
        ReservedDBWords.addWord("RENAME", "Oracle");
        ReservedDBWords.addWord("RESOURCE", "Oracle");
        ReservedDBWords.addWord("REVOKE", "Oracle");
        ReservedDBWords.addWord("ROW", "Oracle");
        ReservedDBWords.addWord("ROWID", "Oracle");
        ReservedDBWords.addWord("ROWLABEL", "Oracle");
        ReservedDBWords.addWord("ROWNUM", "Oracle");
        ReservedDBWords.addWord("ROWS", "Oracle");
        ReservedDBWords.addWord("SELECT", "Oracle");
        ReservedDBWords.addWord("SESSION", "Oracle");
        ReservedDBWords.addWord("SET", "Oracle");
        ReservedDBWords.addWord("SHARE", "Oracle");
        ReservedDBWords.addWord("SIZE", "Oracle");
        ReservedDBWords.addWord("SMALLINT", "Oracle");
        ReservedDBWords.addWord("SQLBUF", "Oracle");
        ReservedDBWords.addWord("START", "Oracle");
        ReservedDBWords.addWord("SUCCESSFUL", "Oracle");
        ReservedDBWords.addWord("SYNONYM", "Oracle");
        ReservedDBWords.addWord("SYSDATE", "Oracle");
        ReservedDBWords.addWord("TABLE", "Oracle");
        ReservedDBWords.addWord("THEN", "Oracle");
        ReservedDBWords.addWord("TO", "Oracle");
        ReservedDBWords.addWord("TRIGGER", "Oracle");
        ReservedDBWords.addWord("UID", "Oracle");
        ReservedDBWords.addWord("UNION", "Oracle");
        ReservedDBWords.addWord("UNIQUE", "Oracle");
        ReservedDBWords.addWord("UPDATE", "Oracle");
        ReservedDBWords.addWord("USER", "Oracle");
        ReservedDBWords.addWord("VALIDATE", "Oracle");
        ReservedDBWords.addWord("VALUES", "Oracle");
        ReservedDBWords.addWord("VARCHAR", "Oracle");
        ReservedDBWords.addWord("VARCHAR2", "Oracle");
        ReservedDBWords.addWord("VIEW", "Oracle");
        ReservedDBWords.addWord("WHENEVER", "Oracle");
        ReservedDBWords.addWord("WHERE", "Oracle");
        ReservedDBWords.addWord("WITH", "Oracle");
        ReservedDBWords.addWord("ALL", "PostgreSQL");
        ReservedDBWords.addWord("ANALYSE", "PostgreSQL");
        ReservedDBWords.addWord("ANALYZE", "PostgreSQL");
        ReservedDBWords.addWord("AND", "PostgreSQL");
        ReservedDBWords.addWord("ANY", "PostgreSQL");
        ReservedDBWords.addWord("AS", "PostgreSQL");
        ReservedDBWords.addWord("ASC", "PostgreSQL");
        ReservedDBWords.addWord("AUTHORIZATION", "PostgreSQL");
        ReservedDBWords.addWord("BETWEEN", "PostgreSQL");
        ReservedDBWords.addWord("BINARY", "PostgreSQL");
        ReservedDBWords.addWord("BOTH", "PostgreSQL");
        ReservedDBWords.addWord("CASE", "PostgreSQL");
        ReservedDBWords.addWord("CAST", "PostgreSQL");
        ReservedDBWords.addWord("CHECK", "PostgreSQL");
        ReservedDBWords.addWord("COLLATE", "PostgreSQL");
        ReservedDBWords.addWord("COLUMN", "PostgreSQL");
        ReservedDBWords.addWord("CONSTRAINT", "PostgreSQL");
        ReservedDBWords.addWord("CREATE", "PostgreSQL");
        ReservedDBWords.addWord("CROSS", "PostgreSQL");
        ReservedDBWords.addWord("CURRENT_DATE", "PostgreSQL");
        ReservedDBWords.addWord("CURRENT_TIME", "PostgreSQL");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "PostgreSQL");
        ReservedDBWords.addWord("CURRENT_USER", "PostgreSQL");
        ReservedDBWords.addWord("DEFAULT", "PostgreSQL");
        ReservedDBWords.addWord("DEFERRABLE", "PostgreSQL");
        ReservedDBWords.addWord("DESC", "PostgreSQL");
        ReservedDBWords.addWord("DISTINCT", "PostgreSQL");
        ReservedDBWords.addWord("DO", "PostgreSQL");
        ReservedDBWords.addWord("ELSE", "PostgreSQL");
        ReservedDBWords.addWord("END", "PostgreSQL");
        ReservedDBWords.addWord("EXCEPT", "PostgreSQL");
        ReservedDBWords.addWord("FOR", "PostgreSQL");
        ReservedDBWords.addWord("FOREIGN", "PostgreSQL");
        ReservedDBWords.addWord("FREEZE", "PostgreSQL");
        ReservedDBWords.addWord("FROM", "PostgreSQL");
        ReservedDBWords.addWord("FULL", "PostgreSQL");
        ReservedDBWords.addWord("GRANT", "PostgreSQL");
        ReservedDBWords.addWord("GROUP", "PostgreSQL");
        ReservedDBWords.addWord("HAVING", "PostgreSQL");
        ReservedDBWords.addWord("ILIKE", "PostgreSQL");
        ReservedDBWords.addWord("IN", "PostgreSQL");
        ReservedDBWords.addWord("INITIALLY", "PostgreSQL");
        ReservedDBWords.addWord("INNER", "PostgreSQL");
        ReservedDBWords.addWord("INTERSECT", "PostgreSQL");
        ReservedDBWords.addWord("INTO", "PostgreSQL");
        ReservedDBWords.addWord("IS", "PostgreSQL");
        ReservedDBWords.addWord("ISNULL", "PostgreSQL");
        ReservedDBWords.addWord("JOIN", "PostgreSQL");
        ReservedDBWords.addWord("LEADING", "PostgreSQL");
        ReservedDBWords.addWord("LEFT", "PostgreSQL");
        ReservedDBWords.addWord("LIKE", "PostgreSQL");
        ReservedDBWords.addWord("LIMIT", "PostgreSQL");
        ReservedDBWords.addWord("LOCALTIME", "PostgreSQL");
        ReservedDBWords.addWord("LOCALTIMESTAMP", "PostgreSQL");
        ReservedDBWords.addWord("NATURAL", "PostgreSQL");
        ReservedDBWords.addWord("NEW", "PostgreSQL");
        ReservedDBWords.addWord("NOT", "PostgreSQL");
        ReservedDBWords.addWord("NOTNULL", "PostgreSQL");
        ReservedDBWords.addWord("NULL", "PostgreSQL");
        ReservedDBWords.addWord("OFF", "PostgreSQL");
        ReservedDBWords.addWord("OFFSET", "PostgreSQL");
        ReservedDBWords.addWord("OLD", "PostgreSQL");
        ReservedDBWords.addWord("ON", "PostgreSQL");
        ReservedDBWords.addWord("ONLY", "PostgreSQL");
        ReservedDBWords.addWord("OR", "PostgreSQL");
        ReservedDBWords.addWord("ORDER", "PostgreSQL");
        ReservedDBWords.addWord("OUTER", "PostgreSQL");
        ReservedDBWords.addWord("OVERLAPS", "PostgreSQL");
        ReservedDBWords.addWord("PLACING", "PostgreSQL");
        ReservedDBWords.addWord("PRIMARY", "PostgreSQL");
        ReservedDBWords.addWord("REFERENCES", "PostgreSQL");
        ReservedDBWords.addWord("RIGHT", "PostgreSQL");
        ReservedDBWords.addWord("SELECT", "PostgreSQL");
        ReservedDBWords.addWord("SESSION_USER", "PostgreSQL");
        ReservedDBWords.addWord("SIMILAR", "PostgreSQL");
        ReservedDBWords.addWord("SOME", "PostgreSQL");
        ReservedDBWords.addWord("TABLE", "PostgreSQL");
        ReservedDBWords.addWord("THEN", "PostgreSQL");
        ReservedDBWords.addWord("TO", "PostgreSQL");
        ReservedDBWords.addWord("TRAILING", "PostgreSQL");
        ReservedDBWords.addWord("UNION", "PostgreSQL");
        ReservedDBWords.addWord("UNIQUE", "PostgreSQL");
        ReservedDBWords.addWord("USER", "PostgreSQL");
        ReservedDBWords.addWord("USING", "PostgreSQL");
        ReservedDBWords.addWord("VERBOSE", "PostgreSQL");
        ReservedDBWords.addWord("WHEN", "PostgreSQL");
        ReservedDBWords.addWord("WHERE", "PostgreSQL");
        ReservedDBWords.addWord("FALSE", "PostgreSQL");
        ReservedDBWords.addWord("TRUE", "PostgreSQL");
        ReservedDBWords.addWord("ACTIVATE", "DB2");
        ReservedDBWords.addWord("ADD", "DB2");
        ReservedDBWords.addWord("AFTER", "DB2");
        ReservedDBWords.addWord("ALIAS", "DB2");
        ReservedDBWords.addWord("ALL", "DB2");
        ReservedDBWords.addWord("ALLOCATE", "DB2");
        ReservedDBWords.addWord("ALLOW", "DB2");
        ReservedDBWords.addWord("ALTER", "DB2");
        ReservedDBWords.addWord("AND", "DB2");
        ReservedDBWords.addWord("ANY", "DB2");
        ReservedDBWords.addWord("AS", "DB2");
        ReservedDBWords.addWord("ASENSITIVE", "DB2");
        ReservedDBWords.addWord("ASSOCIATE", "DB2");
        ReservedDBWords.addWord("ASUTIME", "DB2");
        ReservedDBWords.addWord("AT", "DB2");
        ReservedDBWords.addWord("ATTRIBUTES", "DB2");
        ReservedDBWords.addWord("AUDIT", "DB2");
        ReservedDBWords.addWord("AUTHORIZATION", "DB2");
        ReservedDBWords.addWord("AUX", "DB2");
        ReservedDBWords.addWord("AUXILIARY", "DB2");
        ReservedDBWords.addWord("BEFORE", "DB2");
        ReservedDBWords.addWord("BEGIN", "DB2");
        ReservedDBWords.addWord("BETWEEN", "DB2");
        ReservedDBWords.addWord("BINARY", "DB2");
        ReservedDBWords.addWord("BUFFERPOOL", "DB2");
        ReservedDBWords.addWord("BY", "DB2");
        ReservedDBWords.addWord("CACHE", "DB2");
        ReservedDBWords.addWord("CALL", "DB2");
        ReservedDBWords.addWord("CALLED", "DB2");
        ReservedDBWords.addWord("CAPTURE", "DB2");
        ReservedDBWords.addWord("CARDINALITY", "DB2");
        ReservedDBWords.addWord("CASCADED", "DB2");
        ReservedDBWords.addWord("CASE", "DB2");
        ReservedDBWords.addWord("CAST", "DB2");
        ReservedDBWords.addWord("CCSID", "DB2");
        ReservedDBWords.addWord("CHAR", "DB2");
        ReservedDBWords.addWord("CHARACTER", "DB2");
        ReservedDBWords.addWord("CHECK", "DB2");
        ReservedDBWords.addWord("CLONE", "DB2");
        ReservedDBWords.addWord("CLOSE", "DB2");
        ReservedDBWords.addWord("CLUSTER", "DB2");
        ReservedDBWords.addWord("COLLECTION", "DB2");
        ReservedDBWords.addWord("COLLID", "DB2");
        ReservedDBWords.addWord("COLUMN", "DB2");
        ReservedDBWords.addWord("COMMENT", "DB2");
        ReservedDBWords.addWord("COMMIT", "DB2");
        ReservedDBWords.addWord("CONCAT", "DB2");
        ReservedDBWords.addWord("CONDITION", "DB2");
        ReservedDBWords.addWord("CONNECT", "DB2");
        ReservedDBWords.addWord("CONNECTION", "DB2");
        ReservedDBWords.addWord("CONSTRAINT", "DB2");
        ReservedDBWords.addWord("CONTAINS", "DB2");
        ReservedDBWords.addWord("CONTINUE", "DB2");
        ReservedDBWords.addWord("COUNT", "DB2");
        ReservedDBWords.addWord("COUNT_BIG", "DB2");
        ReservedDBWords.addWord("CREATE", "DB2");
        ReservedDBWords.addWord("CROSS", "DB2");
        ReservedDBWords.addWord("CURRENT", "DB2");
        ReservedDBWords.addWord("CURRENT_DATE", "DB2");
        ReservedDBWords.addWord("CURRENT_LC_CTYPE", "DB2");
        ReservedDBWords.addWord("CURRENT_PATH", "DB2");
        ReservedDBWords.addWord("CURRENT_SCHEMA", "DB2");
        ReservedDBWords.addWord("CURRENT_SERVER", "DB2");
        ReservedDBWords.addWord("CURRENT_TIME", "DB2");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "DB2");
        ReservedDBWords.addWord("CURRENT_TIMEZONE", "DB2");
        ReservedDBWords.addWord("CURRENT_USER", "DB2");
        ReservedDBWords.addWord("CURSOR", "DB2");
        ReservedDBWords.addWord("CYCLE", "DB2");
        ReservedDBWords.addWord("DATA", "DB2");
        ReservedDBWords.addWord("DATABASE", "DB2");
        ReservedDBWords.addWord("DATAPARTITIONNAME", "DB2");
        ReservedDBWords.addWord("DATAPARTITIONNUM", "DB2");
        ReservedDBWords.addWord("DATE", "DB2");
        ReservedDBWords.addWord("DAY", "DB2");
        ReservedDBWords.addWord("DAYS", "DB2");
        ReservedDBWords.addWord("DB2GENERAL", "DB2");
        ReservedDBWords.addWord("DB2GENRL", "DB2");
        ReservedDBWords.addWord("DB2SQL", "DB2");
        ReservedDBWords.addWord("DBINFO", "DB2");
        ReservedDBWords.addWord("DBPARTITIONNAME", "DB2");
        ReservedDBWords.addWord("DBPARTITIONNUM", "DB2");
        ReservedDBWords.addWord("DEALLOCATE", "DB2");
        ReservedDBWords.addWord("DECLARE", "DB2");
        ReservedDBWords.addWord("DEFAULT", "DB2");
        ReservedDBWords.addWord("DEFAULTS", "DB2");
        ReservedDBWords.addWord("DEFINITION", "DB2");
        ReservedDBWords.addWord("DELETE", "DB2");
        ReservedDBWords.addWord("DENSE_RANK", "DB2");
        ReservedDBWords.addWord("DENSERANK", "DB2");
        ReservedDBWords.addWord("DESCRIBE", "DB2");
        ReservedDBWords.addWord("DESCRIPTOR", "DB2");
        ReservedDBWords.addWord("DETERMINISTIC", "DB2");
        ReservedDBWords.addWord("DIAGNOSTICS", "DB2");
        ReservedDBWords.addWord("DISABLE", "DB2");
        ReservedDBWords.addWord("DISALLOW", "DB2");
        ReservedDBWords.addWord("DISCONNECT", "DB2");
        ReservedDBWords.addWord("DISTINCT", "DB2");
        ReservedDBWords.addWord("DO", "DB2");
        ReservedDBWords.addWord("DOCUMENT", "DB2");
        ReservedDBWords.addWord("DOUBLE", "DB2");
        ReservedDBWords.addWord("DROP", "DB2");
        ReservedDBWords.addWord("DSSIZE", "DB2");
        ReservedDBWords.addWord("DYNAMIC", "DB2");
        ReservedDBWords.addWord("EACH", "DB2");
        ReservedDBWords.addWord("EDITPROC", "DB2");
        ReservedDBWords.addWord("ELSE", "DB2");
        ReservedDBWords.addWord("ELSEIF", "DB2");
        ReservedDBWords.addWord("ENABLE", "DB2");
        ReservedDBWords.addWord("ENCODING", "DB2");
        ReservedDBWords.addWord("ENCRYPTION", "DB2");
        ReservedDBWords.addWord("END", "DB2");
        ReservedDBWords.addWord("END-EXEC", "DB2");
        ReservedDBWords.addWord("ENDING", "DB2");
        ReservedDBWords.addWord("ERASE", "DB2");
        ReservedDBWords.addWord("ESCAPE", "DB2");
        ReservedDBWords.addWord("EVERY", "DB2");
        ReservedDBWords.addWord("EXCEPT", "DB2");
        ReservedDBWords.addWord("EXCEPTION", "DB2");
        ReservedDBWords.addWord("EXCLUDING", "DB2");
        ReservedDBWords.addWord("EXCLUSIVE", "DB2");
        ReservedDBWords.addWord("EXECUTE", "DB2");
        ReservedDBWords.addWord("EXISTS", "DB2");
        ReservedDBWords.addWord("EXIT", "DB2");
        ReservedDBWords.addWord("EXPLAIN", "DB2");
        ReservedDBWords.addWord("EXTENDED", "DB2");
        ReservedDBWords.addWord("EXTERNAL", "DB2");
        ReservedDBWords.addWord("EXTRACT", "DB2");
        ReservedDBWords.addWord("FENCED", "DB2");
        ReservedDBWords.addWord("FETCH", "DB2");
        ReservedDBWords.addWord("FIELDPROC", "DB2");
        ReservedDBWords.addWord("FILE", "DB2");
        ReservedDBWords.addWord("FINAL", "DB2");
        ReservedDBWords.addWord("FOR", "DB2");
        ReservedDBWords.addWord("FOREIGN", "DB2");
        ReservedDBWords.addWord("FREE", "DB2");
        ReservedDBWords.addWord("FROM", "DB2");
        ReservedDBWords.addWord("FULL", "DB2");
        ReservedDBWords.addWord("FUNCTION", "DB2");
        ReservedDBWords.addWord("GENERAL", "DB2");
        ReservedDBWords.addWord("GENERATED", "DB2");
        ReservedDBWords.addWord("GET", "DB2");
        ReservedDBWords.addWord("GLOBAL", "DB2");
        ReservedDBWords.addWord("GO", "DB2");
        ReservedDBWords.addWord("GOTO", "DB2");
        ReservedDBWords.addWord("GRANT", "DB2");
        ReservedDBWords.addWord("GRAPHIC", "DB2");
        ReservedDBWords.addWord("GROUP", "DB2");
        ReservedDBWords.addWord("HANDLER", "DB2");
        ReservedDBWords.addWord("HASH", "DB2");
        ReservedDBWords.addWord("HASHED_VALUE", "DB2");
        ReservedDBWords.addWord("HAVING", "DB2");
        ReservedDBWords.addWord("HINT", "DB2");
        ReservedDBWords.addWord("HOLD", "DB2");
        ReservedDBWords.addWord("HOUR", "DB2");
        ReservedDBWords.addWord("HOURS", "DB2");
        ReservedDBWords.addWord("IDENTITY", "DB2");
        ReservedDBWords.addWord("IF", "DB2");
        ReservedDBWords.addWord("IMMEDIATE", "DB2");
        ReservedDBWords.addWord("IN", "DB2");
        ReservedDBWords.addWord("INCLUDING", "DB2");
        ReservedDBWords.addWord("INCLUSIVE", "DB2");
        ReservedDBWords.addWord("INCREMENT", "DB2");
        ReservedDBWords.addWord("INDEX", "DB2");
        ReservedDBWords.addWord("INDICATOR", "DB2");
        ReservedDBWords.addWord("INDICATORS", "DB2");
        ReservedDBWords.addWord("INF", "DB2");
        ReservedDBWords.addWord("INFINITY", "DB2");
        ReservedDBWords.addWord("INHERIT", "DB2");
        ReservedDBWords.addWord("INNER", "DB2");
        ReservedDBWords.addWord("INOUT", "DB2");
        ReservedDBWords.addWord("INSENSITIVE", "DB2");
        ReservedDBWords.addWord("INSERT", "DB2");
        ReservedDBWords.addWord("INTEGRITY", "DB2");
        ReservedDBWords.addWord("INTERSECT", "DB2");
        ReservedDBWords.addWord("INTO", "DB2");
        ReservedDBWords.addWord("IS", "DB2");
        ReservedDBWords.addWord("ISOBID", "DB2");
        ReservedDBWords.addWord("ISOLATION", "DB2");
        ReservedDBWords.addWord("ITERATE", "DB2");
        ReservedDBWords.addWord("JAR", "DB2");
        ReservedDBWords.addWord("JAVA", "DB2");
        ReservedDBWords.addWord("JOIN", "DB2");
        ReservedDBWords.addWord("KEEP", "DB2");
        ReservedDBWords.addWord("KEY", "DB2");
        ReservedDBWords.addWord("LABEL", "DB2");
        ReservedDBWords.addWord("LANGUAGE", "DB2");
        ReservedDBWords.addWord("LATERAL", "DB2");
        ReservedDBWords.addWord("LC_CTYPE", "DB2");
        ReservedDBWords.addWord("LEAVE", "DB2");
        ReservedDBWords.addWord("LEFT", "DB2");
        ReservedDBWords.addWord("LIKE", "DB2");
        ReservedDBWords.addWord("LIMIT", "DB2");
        ReservedDBWords.addWord("LINKTYPE", "DB2");
        ReservedDBWords.addWord("LOCAL", "DB2");
        ReservedDBWords.addWord("LOCALDATE", "DB2");
        ReservedDBWords.addWord("LOCALE", "DB2");
        ReservedDBWords.addWord("LOCALTIME", "DB2");
        ReservedDBWords.addWord("LOCALTIMESTAMP", "DB2");
        ReservedDBWords.addWord("LOCATOR", "DB2");
        ReservedDBWords.addWord("LOCATORS", "DB2");
        ReservedDBWords.addWord("LOCK", "DB2");
        ReservedDBWords.addWord("LOCKMAX", "DB2");
        ReservedDBWords.addWord("LOCKSIZE", "DB2");
        ReservedDBWords.addWord("LONG", "DB2");
        ReservedDBWords.addWord("LOOP", "DB2");
        ReservedDBWords.addWord("MAINTAINED", "DB2");
        ReservedDBWords.addWord("MATERIALIZED", "DB2");
        ReservedDBWords.addWord("MAXVALUE", "DB2");
        ReservedDBWords.addWord("MICROSECOND", "DB2");
        ReservedDBWords.addWord("MICROSECONDS", "DB2");
        ReservedDBWords.addWord("MINUTE", "DB2");
        ReservedDBWords.addWord("MINUTES", "DB2");
        ReservedDBWords.addWord("MINVALUE", "DB2");
        ReservedDBWords.addWord("MODE", "DB2");
        ReservedDBWords.addWord("MODIFIES", "DB2");
        ReservedDBWords.addWord("MONTH", "DB2");
        ReservedDBWords.addWord("MONTHS", "DB2");
        ReservedDBWords.addWord("NAN", "DB2");
        ReservedDBWords.addWord("NEW", "DB2");
        ReservedDBWords.addWord("NEW_TABLE", "DB2");
        ReservedDBWords.addWord("NEXTVAL", "DB2");
        ReservedDBWords.addWord("NO", "DB2");
        ReservedDBWords.addWord("NOCACHE", "DB2");
        ReservedDBWords.addWord("NOCYCLE", "DB2");
        ReservedDBWords.addWord("NODENAME", "DB2");
        ReservedDBWords.addWord("NODENUMBER", "DB2");
        ReservedDBWords.addWord("NOMAXVALUE", "DB2");
        ReservedDBWords.addWord("NOMINVALUE", "DB2");
        ReservedDBWords.addWord("NONE", "DB2");
        ReservedDBWords.addWord("NOORDER", "DB2");
        ReservedDBWords.addWord("NORMALIZED", "DB2");
        ReservedDBWords.addWord("NOT", "DB2");
        ReservedDBWords.addWord("NULL", "DB2");
        ReservedDBWords.addWord("NULLS", "DB2");
        ReservedDBWords.addWord("NUMPARTS", "DB2");
        ReservedDBWords.addWord("OBID", "DB2");
        ReservedDBWords.addWord("OF", "DB2");
        ReservedDBWords.addWord("OFFSET", "DB2");
        ReservedDBWords.addWord("OLD", "DB2");
        ReservedDBWords.addWord("OLD_TABLE", "DB2");
        ReservedDBWords.addWord("ON", "DB2");
        ReservedDBWords.addWord("OPEN", "DB2");
        ReservedDBWords.addWord("OPTIMIZATION", "DB2");
        ReservedDBWords.addWord("OPTIMIZE", "DB2");
        ReservedDBWords.addWord("OPTION", "DB2");
        ReservedDBWords.addWord("OR", "DB2");
        ReservedDBWords.addWord("ORDER", "DB2");
        ReservedDBWords.addWord("OUT", "DB2");
        ReservedDBWords.addWord("OUTER", "DB2");
        ReservedDBWords.addWord("OVER", "DB2");
        ReservedDBWords.addWord("OVERRIDING", "DB2");
        ReservedDBWords.addWord("PACKAGE", "DB2");
        ReservedDBWords.addWord("PADDED", "DB2");
        ReservedDBWords.addWord("PAGESIZE", "DB2");
        ReservedDBWords.addWord("PARAMETER", "DB2");
        ReservedDBWords.addWord("PART", "DB2");
        ReservedDBWords.addWord("PARTITION", "DB2");
        ReservedDBWords.addWord("PARTITIONED", "DB2");
        ReservedDBWords.addWord("PARTITIONING", "DB2");
        ReservedDBWords.addWord("PARTITIONS", "DB2");
        ReservedDBWords.addWord("PASSWORD", "DB2");
        ReservedDBWords.addWord("PATH", "DB2");
        ReservedDBWords.addWord("PIECESIZE", "DB2");
        ReservedDBWords.addWord("PLAN", "DB2");
        ReservedDBWords.addWord("POSITION", "DB2");
        ReservedDBWords.addWord("PRECISION", "DB2");
        ReservedDBWords.addWord("PREPARE", "DB2");
        ReservedDBWords.addWord("PREVVAL", "DB2");
        ReservedDBWords.addWord("PRIMARY", "DB2");
        ReservedDBWords.addWord("PRIQTY", "DB2");
        ReservedDBWords.addWord("PRIVILEGES", "DB2");
        ReservedDBWords.addWord("PROCEDURE", "DB2");
        ReservedDBWords.addWord("PROGRAM", "DB2");
        ReservedDBWords.addWord("PSID", "DB2");
        ReservedDBWords.addWord("PUBLIC", "DB2");
        ReservedDBWords.addWord("QUERY", "DB2");
        ReservedDBWords.addWord("QUERYNO", "DB2");
        ReservedDBWords.addWord("RANGE", "DB2");
        ReservedDBWords.addWord("RANK", "DB2");
        ReservedDBWords.addWord("READ", "DB2");
        ReservedDBWords.addWord("READS", "DB2");
        ReservedDBWords.addWord("RECOVERY", "DB2");
        ReservedDBWords.addWord("REFERENCES", "DB2");
        ReservedDBWords.addWord("REFERENCING", "DB2");
        ReservedDBWords.addWord("REFRESH", "DB2");
        ReservedDBWords.addWord("RELEASE", "DB2");
        ReservedDBWords.addWord("RENAME", "DB2");
        ReservedDBWords.addWord("REPEAT", "DB2");
        ReservedDBWords.addWord("RESET", "DB2");
        ReservedDBWords.addWord("RESIGNAL", "DB2");
        ReservedDBWords.addWord("RESTART", "DB2");
        ReservedDBWords.addWord("RESTRICT", "DB2");
        ReservedDBWords.addWord("RESULT", "DB2");
        ReservedDBWords.addWord("RESULT_SET_LOCATOR", "DB2");
        ReservedDBWords.addWord("RETURN", "DB2");
        ReservedDBWords.addWord("RETURNS", "DB2");
        ReservedDBWords.addWord("REVOKE", "DB2");
        ReservedDBWords.addWord("RIGHT", "DB2");
        ReservedDBWords.addWord("ROLE", "DB2");
        ReservedDBWords.addWord("ROLLBACK", "DB2");
        ReservedDBWords.addWord("ROUND_CEILING", "DB2");
        ReservedDBWords.addWord("ROUND_DOWN", "DB2");
        ReservedDBWords.addWord("ROUND_FLOOR", "DB2");
        ReservedDBWords.addWord("ROUND_HALF_DOWN", "DB2");
        ReservedDBWords.addWord("ROUND_HALF_EVEN", "DB2");
        ReservedDBWords.addWord("ROUND_HALF_UP", "DB2");
        ReservedDBWords.addWord("ROUND_UP", "DB2");
        ReservedDBWords.addWord("ROUTINE", "DB2");
        ReservedDBWords.addWord("ROW", "DB2");
        ReservedDBWords.addWord("ROW_NUMBER", "DB2");
        ReservedDBWords.addWord("ROWNUMBER", "DB2");
        ReservedDBWords.addWord("ROWS", "DB2");
        ReservedDBWords.addWord("ROWSET", "DB2");
        ReservedDBWords.addWord("RRN", "DB2");
        ReservedDBWords.addWord("RUN", "DB2");
        ReservedDBWords.addWord("SAVEPOINT", "DB2");
        ReservedDBWords.addWord("SCHEMA", "DB2");
        ReservedDBWords.addWord("SCRATCHPAD", "DB2");
        ReservedDBWords.addWord("SCROLL", "DB2");
        ReservedDBWords.addWord("SEARCH", "DB2");
        ReservedDBWords.addWord("SECOND", "DB2");
        ReservedDBWords.addWord("SECONDS", "DB2");
        ReservedDBWords.addWord("SECQTY", "DB2");
        ReservedDBWords.addWord("SECURITY", "DB2");
        ReservedDBWords.addWord("SELECT", "DB2");
        ReservedDBWords.addWord("SENSITIVE", "DB2");
        ReservedDBWords.addWord("SEQUENCE", "DB2");
        ReservedDBWords.addWord("SESSION", "DB2");
        ReservedDBWords.addWord("SESSION_USER", "DB2");
        ReservedDBWords.addWord("SET", "DB2");
        ReservedDBWords.addWord("SIGNAL", "DB2");
        ReservedDBWords.addWord("SIMPLE", "DB2");
        ReservedDBWords.addWord("SNAN", "DB2");
        ReservedDBWords.addWord("SOME", "DB2");
        ReservedDBWords.addWord("SOURCE", "DB2");
        ReservedDBWords.addWord("SPECIFIC", "DB2");
        ReservedDBWords.addWord("SQL", "DB2");
        ReservedDBWords.addWord("SQLID", "DB2");
        ReservedDBWords.addWord("STACKED", "DB2");
        ReservedDBWords.addWord("STANDARD", "DB2");
        ReservedDBWords.addWord("START", "DB2");
        ReservedDBWords.addWord("STARTING", "DB2");
        ReservedDBWords.addWord("STATEMENT", "DB2");
        ReservedDBWords.addWord("STATIC", "DB2");
        ReservedDBWords.addWord("STATMENT", "DB2");
        ReservedDBWords.addWord("STAY", "DB2");
        ReservedDBWords.addWord("STOGROUP", "DB2");
        ReservedDBWords.addWord("STORES", "DB2");
        ReservedDBWords.addWord("STYLE", "DB2");
        ReservedDBWords.addWord("SUBSTRING", "DB2");
        ReservedDBWords.addWord("SUMMARY", "DB2");
        ReservedDBWords.addWord("SYNONYM", "DB2");
        ReservedDBWords.addWord("SYSFUN", "DB2");
        ReservedDBWords.addWord("SYSIBM", "DB2");
        ReservedDBWords.addWord("SYSPROC", "DB2");
        ReservedDBWords.addWord("SYSTEM", "DB2");
        ReservedDBWords.addWord("SYSTEM_USER", "DB2");
        ReservedDBWords.addWord("TABLE", "DB2");
        ReservedDBWords.addWord("TABLESPACE", "DB2");
        ReservedDBWords.addWord("THEN", "DB2");
        ReservedDBWords.addWord("TIME", "DB2");
        ReservedDBWords.addWord("TIMESTAMP", "DB2");
        ReservedDBWords.addWord("TO", "DB2");
        ReservedDBWords.addWord("TRANSACTION", "DB2");
        ReservedDBWords.addWord("TRIGGER", "DB2");
        ReservedDBWords.addWord("TRIM", "DB2");
        ReservedDBWords.addWord("TRUNCATE", "DB2");
        ReservedDBWords.addWord("TYPE", "DB2");
        ReservedDBWords.addWord("UNDO", "DB2");
        ReservedDBWords.addWord("UNION", "DB2");
        ReservedDBWords.addWord("UNIQUE", "DB2");
        ReservedDBWords.addWord("UNTIL", "DB2");
        ReservedDBWords.addWord("UPDATE", "DB2");
        ReservedDBWords.addWord("USAGE", "DB2");
        ReservedDBWords.addWord("USER", "DB2");
        ReservedDBWords.addWord("USING", "DB2");
        ReservedDBWords.addWord("VALIDPROC", "DB2");
        ReservedDBWords.addWord("VALUE", "DB2");
        ReservedDBWords.addWord("VALUES", "DB2");
        ReservedDBWords.addWord("VARIABLE", "DB2");
        ReservedDBWords.addWord("VARIANT", "DB2");
        ReservedDBWords.addWord("VCAT", "DB2");
        ReservedDBWords.addWord("VERSION", "DB2");
        ReservedDBWords.addWord("VIEW", "DB2");
        ReservedDBWords.addWord("VOLATILE", "DB2");
        ReservedDBWords.addWord("VOLUMES", "DB2");
        ReservedDBWords.addWord("WHEN", "DB2");
        ReservedDBWords.addWord("WHENEVER", "DB2");
        ReservedDBWords.addWord("WHERE", "DB2");
        ReservedDBWords.addWord("WHILE", "DB2");
        ReservedDBWords.addWord("WITH", "DB2");
        ReservedDBWords.addWord("WITHOUT", "DB2");
        ReservedDBWords.addWord("WLM", "DB2");
        ReservedDBWords.addWord("WRITE", "DB2");
        ReservedDBWords.addWord("XMLELEMENT", "DB2");
        ReservedDBWords.addWord("XMLEXISTS", "DB2");
        ReservedDBWords.addWord("XMLNAMESPACES", "DB2");
        ReservedDBWords.addWord("YEAR", "DB2");
        ReservedDBWords.addWord("YEARS", "DB2");
        ReservedDBWords.addWord("ABSOLUTE", "Access");
        ReservedDBWords.addWord("ANY", "Access");
        ReservedDBWords.addWord("ADD", "Access");
        ReservedDBWords.addWord("ARE", "Access");
        ReservedDBWords.addWord("ADMINDB", "Access");
        ReservedDBWords.addWord("AS", "Access");
        ReservedDBWords.addWord("ALL", "Access");
        ReservedDBWords.addWord("ASC", "Access");
        ReservedDBWords.addWord("Alphanumeric", "Access");
        ReservedDBWords.addWord("ASSERTION", "Access");
        ReservedDBWords.addWord("ALTER", "Access");
        ReservedDBWords.addWord("AUTHORIZATION", "Access");
        ReservedDBWords.addWord("ALTER TABLE", "Access");
        ReservedDBWords.addWord("AUTOINCREMENT", "Access");
        ReservedDBWords.addWord("And", "Access");
        ReservedDBWords.addWord("Avg", "Access");
        ReservedDBWords.addWord("BEGIN", "Access");
        ReservedDBWords.addWord("COLLATION", "Access");
        ReservedDBWords.addWord("Between", "Access");
        ReservedDBWords.addWord("COLUMN", "Access");
        ReservedDBWords.addWord("BINARY", "Access");
        ReservedDBWords.addWord("COMMIT", "Access");
        ReservedDBWords.addWord("BIT", "Access");
        ReservedDBWords.addWord("COMP", "Access");
        ReservedDBWords.addWord("COMPRESSION", "Access");
        ReservedDBWords.addWord("BIT_LENGTH", "Access");
        ReservedDBWords.addWord("CONNECT", "Access");
        ReservedDBWords.addWord("BOOLEAN", "Access");
        ReservedDBWords.addWord("CONNECTION", "Access");
        ReservedDBWords.addWord("BOTH", "Access");
        ReservedDBWords.addWord("CONSTRAINT", "Access");
        ReservedDBWords.addWord("CONSTRAINTS", "Access");
        ReservedDBWords.addWord("BY", "Access");
        ReservedDBWords.addWord("CONTAINER", "Access");
        ReservedDBWords.addWord("BYTE", "Access");
        ReservedDBWords.addWord("CONTAINS", "Access");
        ReservedDBWords.addWord("CASCADE", "Access");
        ReservedDBWords.addWord("CONVERT", "Access");
        ReservedDBWords.addWord("CATALOG", "Access");
        ReservedDBWords.addWord("Count", "Access");
        ReservedDBWords.addWord("CHAR", "Access");
        ReservedDBWords.addWord("CHARACTER", "Access");
        ReservedDBWords.addWord("COUNTER", "Access");
        ReservedDBWords.addWord("CHAR_LENGTH", "Access");
        ReservedDBWords.addWord("CREATE", "Access");
        ReservedDBWords.addWord("CHARACTER_LENGTH", "Access");
        ReservedDBWords.addWord("CURRENCY", "Access");
        ReservedDBWords.addWord("CHECK", "Access");
        ReservedDBWords.addWord("CURRENT_DATE", "Access");
        ReservedDBWords.addWord("CLOSE", "Access");
        ReservedDBWords.addWord("CURRENT_TIME", "Access");
        ReservedDBWords.addWord("CLUSTERED", "Access");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "Access");
        ReservedDBWords.addWord("COALESCE", "Access");
        ReservedDBWords.addWord("CURRENT_USER", "Access");
        ReservedDBWords.addWord("COLLATE", "Access");
        ReservedDBWords.addWord("CURSOR", "Access");
        ReservedDBWords.addWord("DATABASE", "Access");
        ReservedDBWords.addWord("DISALLOW", "Access");
        ReservedDBWords.addWord("DATE", "Access");
        ReservedDBWords.addWord("DISCONNECT", "Access");
        ReservedDBWords.addWord("DATETIME", "Access");
        ReservedDBWords.addWord("DISTINCT", "Access");
        ReservedDBWords.addWord("DAY", "Access");
        ReservedDBWords.addWord("DISTINCTROW", "Access");
        ReservedDBWords.addWord("DEC", "Access");
        ReservedDBWords.addWord("DECIMAL", "Access");
        ReservedDBWords.addWord("DOMAIN", "Access");
        ReservedDBWords.addWord("DECLARE", "Access");
        ReservedDBWords.addWord("DOUBLE", "Access");
        ReservedDBWords.addWord("DELETE", "Access");
        ReservedDBWords.addWord("DROP", "Access");
        ReservedDBWords.addWord("DESC", "Access");
        ReservedDBWords.addWord("Eqv", "Access");
        ReservedDBWords.addWord("FOREIGN", "Access");
        ReservedDBWords.addWord("EXCLUSIVECONNECT", "Access");
        ReservedDBWords.addWord("FROM", "Access");
        ReservedDBWords.addWord("EXEC", "Access");
        ReservedDBWords.addWord("EXECUTE", "Access");
        ReservedDBWords.addWord("FROM Clause", "Access");
        ReservedDBWords.addWord("EXISTS", "Access");
        ReservedDBWords.addWord("GENERAL", "Access");
        ReservedDBWords.addWord("EXTRACT", "Access");
        ReservedDBWords.addWord("GRANT", "Access");
        ReservedDBWords.addWord("FALSE", "Access");
        ReservedDBWords.addWord("GROUP", "Access");
        ReservedDBWords.addWord("FETCH", "Access");
        ReservedDBWords.addWord("GUID", "Access");
        ReservedDBWords.addWord("FIRST", "Access");
        ReservedDBWords.addWord("HAVING", "Access");
        ReservedDBWords.addWord("FLOAT", "Access");
        ReservedDBWords.addWord("FLOAT8", "Access");
        ReservedDBWords.addWord("HOUR", "Access");
        ReservedDBWords.addWord("FLOAT4", "Access");
        ReservedDBWords.addWord("IDENTITY", "Access");
        ReservedDBWords.addWord("INPUT", "Access");
        ReservedDBWords.addWord("IEEEDOUBLE", "Access");
        ReservedDBWords.addWord("INSENSITIVE", "Access");
        ReservedDBWords.addWord("IEEESINGLE", "Access");
        ReservedDBWords.addWord("INSERT", "Access");
        ReservedDBWords.addWord("IGNORE", "Access");
        ReservedDBWords.addWord("INSERT INTO", "Access");
        ReservedDBWords.addWord("IMAGE", "Access");
        ReservedDBWords.addWord("INT", "Access");
        ReservedDBWords.addWord("INTEGER", "Access");
        ReservedDBWords.addWord("INTEGER4", "Access");
        ReservedDBWords.addWord("Imp", "Access");
        ReservedDBWords.addWord("INTEGER1", "Access");
        ReservedDBWords.addWord("In", "Access");
        ReservedDBWords.addWord("INTEGER2", "Access");
        ReservedDBWords.addWord("INTERVAL", "Access");
        ReservedDBWords.addWord("INDEX", "Access");
        ReservedDBWords.addWord("INTO", "Access");
        ReservedDBWords.addWord("INDEXCREATEDB", "Access");
        ReservedDBWords.addWord("Is", "Access");
        ReservedDBWords.addWord("INNER", "Access");
        ReservedDBWords.addWord("ISOLATION", "Access");
        ReservedDBWords.addWord("JOIN", "Access");
        ReservedDBWords.addWord("LONGTEXT", "Access");
        ReservedDBWords.addWord("KEY", "Access");
        ReservedDBWords.addWord("LOWER", "Access");
        ReservedDBWords.addWord("LANGUAGE", "Access");
        ReservedDBWords.addWord("MATCH", "Access");
        ReservedDBWords.addWord("LAST", "Access");
        ReservedDBWords.addWord("Max", "Access");
        ReservedDBWords.addWord("LEFT", "Access");
        ReservedDBWords.addWord("MEMO", "Access");
        ReservedDBWords.addWord("Level", "Access");
        ReservedDBWords.addWord("Min", "Access");
        ReservedDBWords.addWord("Like", "Access");
        ReservedDBWords.addWord("MINUTE", "Access");
        ReservedDBWords.addWord("LOGICAL", "Access");
        ReservedDBWords.addWord("LOGICAL1", "Access");
        ReservedDBWords.addWord("Mod", "Access");
        ReservedDBWords.addWord("LONG", "Access");
        ReservedDBWords.addWord("MONEY", "Access");
        ReservedDBWords.addWord("LONGBINARY", "Access");
        ReservedDBWords.addWord("MONTH", "Access");
        ReservedDBWords.addWord("LONGCHAR", "Access");
        ReservedDBWords.addWord("NATIONAL", "Access");
        ReservedDBWords.addWord("Outer", "Access");
        ReservedDBWords.addWord("NCHAR", "Access");
        ReservedDBWords.addWord("OUTPUT", "Access");
        ReservedDBWords.addWord("NONCLUSTERED", "Access");
        ReservedDBWords.addWord("OWNERACCESS", "Access");
        ReservedDBWords.addWord("Not", "Access");
        ReservedDBWords.addWord("PAD", "Access");
        ReservedDBWords.addWord("NTEXT", "Access");
        ReservedDBWords.addWord("PARAMETERS", "Access");
        ReservedDBWords.addWord("NULL", "Access");
        ReservedDBWords.addWord("PARTIAL", "Access");
        ReservedDBWords.addWord("NUMBER", "Access");
        ReservedDBWords.addWord("PASSWORD", "Access");
        ReservedDBWords.addWord("NUMERIC", "Access");
        ReservedDBWords.addWord("PERCENT", "Access");
        ReservedDBWords.addWord("NVARCHAR", "Access");
        ReservedDBWords.addWord("PIVOT", "Access");
        ReservedDBWords.addWord("OCTET_LENGTH", "Access");
        ReservedDBWords.addWord("POSITION", "Access");
        ReservedDBWords.addWord("OLEOBJECT", "Access");
        ReservedDBWords.addWord("PRECISION", "Access");
        ReservedDBWords.addWord("ON", "Access");
        ReservedDBWords.addWord("PREPARE", "Access");
        ReservedDBWords.addWord("OPEN", "Access");
        ReservedDBWords.addWord("PRIMARY", "Access");
        ReservedDBWords.addWord("OPTION", "Access");
        ReservedDBWords.addWord("PRIVILEGES", "Access");
        ReservedDBWords.addWord("Or", "Access");
        ReservedDBWords.addWord("PROC", "Access");
        ReservedDBWords.addWord("PROCEDURE", "Access");
        ReservedDBWords.addWord("ORDER", "Access");
        ReservedDBWords.addWord("PUBLIC", "Access");
        ReservedDBWords.addWord("REAL", "Access");
        ReservedDBWords.addWord("SMALLDATETIME", "Access");
        ReservedDBWords.addWord("REFERENCES", "Access");
        ReservedDBWords.addWord("SMALLINT", "Access");
        ReservedDBWords.addWord("RESTRICT", "Access");
        ReservedDBWords.addWord("SMALLMONEY", "Access");
        ReservedDBWords.addWord("REVOKE", "Access");
        ReservedDBWords.addWord("SOME", "Access");
        ReservedDBWords.addWord("RIGHT", "Access");
        ReservedDBWords.addWord("SPACE", "Access");
        ReservedDBWords.addWord("ROLLBACK", "Access");
        ReservedDBWords.addWord("SQL", "Access");
        ReservedDBWords.addWord("SCHEMA", "Access");
        ReservedDBWords.addWord("SQLCODE", "Access");
        ReservedDBWords.addWord("SQLERROR", "Access");
        ReservedDBWords.addWord("SQLSTATE", "Access");
        ReservedDBWords.addWord("SECOND", "Access");
        ReservedDBWords.addWord("StDev", "Access");
        ReservedDBWords.addWord("SELECT", "Access");
        ReservedDBWords.addWord("StDevP", "Access");
        ReservedDBWords.addWord("SELECTSCHEMA", "Access");
        ReservedDBWords.addWord("STRING", "Access");
        ReservedDBWords.addWord("SELECTSECURITY", "Access");
        ReservedDBWords.addWord("SUBSTRING", "Access");
        ReservedDBWords.addWord("SET", "Access");
        ReservedDBWords.addWord("Sum", "Access");
        ReservedDBWords.addWord("SHORT", "Access");
        ReservedDBWords.addWord("SYSNAME", "Access");
        ReservedDBWords.addWord("SINGLE", "Access");
        ReservedDBWords.addWord("SYSTEM_USER", "Access");
        ReservedDBWords.addWord("SIZE", "Access");
        ReservedDBWords.addWord("TABLE", "Access");
        ReservedDBWords.addWord("UPDATEOWNER", "Access");
        ReservedDBWords.addWord("TableID", "Access");
        ReservedDBWords.addWord("UPDATESECURITY", "Access");
        ReservedDBWords.addWord("TEMPORARY", "Access");
        ReservedDBWords.addWord("UPPER", "Access");
        ReservedDBWords.addWord("TEXT", "Access");
        ReservedDBWords.addWord("USAGE", "Access");
        ReservedDBWords.addWord("TIME", "Access");
        ReservedDBWords.addWord("USER", "Access");
        ReservedDBWords.addWord("TIMESTAMP", "Access");
        ReservedDBWords.addWord("USING", "Access");
        ReservedDBWords.addWord("TIMEZONE_HOUR", "Access");
        ReservedDBWords.addWord("VALUE", "Access");
        ReservedDBWords.addWord("TIMEZONE_MINUTE", "Access");
        ReservedDBWords.addWord("VALUES", "Access");
        ReservedDBWords.addWord("TINYINT", "Access");
        ReservedDBWords.addWord("Var", "Access");
        ReservedDBWords.addWord("TO", "Access");
        ReservedDBWords.addWord("VARBINARY", "Access");
        ReservedDBWords.addWord("TOP", "Access");
        ReservedDBWords.addWord("VARCHAR", "Access");
        ReservedDBWords.addWord("TRAILING", "Access");
        ReservedDBWords.addWord("VarP", "Access");
        ReservedDBWords.addWord("TRANSACTION", "Access");
        ReservedDBWords.addWord("VARYING", "Access");
        ReservedDBWords.addWord("TRANSFORM", "Access");
        ReservedDBWords.addWord("VIEW", "Access");
        ReservedDBWords.addWord("TRANSLATE", "Access");
        ReservedDBWords.addWord("WHEN", "Access");
        ReservedDBWords.addWord("TRANSLATION", "Access");
        ReservedDBWords.addWord("WHENEVER", "Access");
        ReservedDBWords.addWord("TRIM", "Access");
        ReservedDBWords.addWord("WHERE", "Access");
        ReservedDBWords.addWord("TRUE", "Access");
        ReservedDBWords.addWord("WITH", "Access");
        ReservedDBWords.addWord("UNION", "Access");
        ReservedDBWords.addWord("WORK", "Access");
        ReservedDBWords.addWord("UNIQUE", "Access");
        ReservedDBWords.addWord("Xor", "Access");
        ReservedDBWords.addWord("UNIQUEIDENTIFIER", "Access");
        ReservedDBWords.addWord("YEAR", "Access");
        ReservedDBWords.addWord("UNKNOWN", "Access");
        ReservedDBWords.addWord("YESNO", "Access");
        ReservedDBWords.addWord("UPDATE", "Access");
        ReservedDBWords.addWord("ZONE", "Access");
        ReservedDBWords.addWord("UPDATEIDENTITY", "Access");
        ReservedDBWords.addWord("ABORT", "SQLite");
        ReservedDBWords.addWord("ACTION", "SQLite");
        ReservedDBWords.addWord("ADD", "SQLite");
        ReservedDBWords.addWord("AFTER", "SQLite");
        ReservedDBWords.addWord("ALL", "SQLite");
        ReservedDBWords.addWord("ALTER", "SQLite");
        ReservedDBWords.addWord("ANALYZE", "SQLite");
        ReservedDBWords.addWord("AND", "SQLite");
        ReservedDBWords.addWord("AS", "SQLite");
        ReservedDBWords.addWord("ASC", "SQLite");
        ReservedDBWords.addWord("ATTACH", "SQLite");
        ReservedDBWords.addWord("AUTOINCREMENT", "SQLite");
        ReservedDBWords.addWord("BEFORE", "SQLite");
        ReservedDBWords.addWord("BEGIN", "SQLite");
        ReservedDBWords.addWord("BETWEEN", "SQLite");
        ReservedDBWords.addWord("BY", "SQLite");
        ReservedDBWords.addWord("CASCADE", "SQLite");
        ReservedDBWords.addWord("CASE", "SQLite");
        ReservedDBWords.addWord("CAST", "SQLite");
        ReservedDBWords.addWord("CHECK", "SQLite");
        ReservedDBWords.addWord("COLLATE", "SQLite");
        ReservedDBWords.addWord("COLUMN", "SQLite");
        ReservedDBWords.addWord("COMMIT", "SQLite");
        ReservedDBWords.addWord("CONFLICT", "SQLite");
        ReservedDBWords.addWord("CONSTRAINT", "SQLite");
        ReservedDBWords.addWord("CREATE", "SQLite");
        ReservedDBWords.addWord("CROSS", "SQLite");
        ReservedDBWords.addWord("CURRENT_DATE", "SQLite");
        ReservedDBWords.addWord("CURRENT_TIME", "SQLite");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "SQLite");
        ReservedDBWords.addWord("DATABASE", "SQLite");
        ReservedDBWords.addWord("DEFAULT", "SQLite");
        ReservedDBWords.addWord("DEFERRABLE", "SQLite");
        ReservedDBWords.addWord("DEFERRED", "SQLite");
        ReservedDBWords.addWord("DELETE", "SQLite");
        ReservedDBWords.addWord("DESC", "SQLite");
        ReservedDBWords.addWord("DETACH", "SQLite");
        ReservedDBWords.addWord("DISTINCT", "SQLite");
        ReservedDBWords.addWord("DROP", "SQLite");
        ReservedDBWords.addWord("EACH", "SQLite");
        ReservedDBWords.addWord("ELSE", "SQLite");
        ReservedDBWords.addWord("END", "SQLite");
        ReservedDBWords.addWord("ESCAPE", "SQLite");
        ReservedDBWords.addWord("EXCEPT", "SQLite");
        ReservedDBWords.addWord("EXCLUSIVE", "SQLite");
        ReservedDBWords.addWord("EXISTS", "SQLite");
        ReservedDBWords.addWord("EXPLAIN", "SQLite");
        ReservedDBWords.addWord("FAIL", "SQLite");
        ReservedDBWords.addWord("FOR", "SQLite");
        ReservedDBWords.addWord("FOREIGN", "SQLite");
        ReservedDBWords.addWord("FROM", "SQLite");
        ReservedDBWords.addWord("FULL", "SQLite");
        ReservedDBWords.addWord("GLOB", "SQLite");
        ReservedDBWords.addWord("GROUP", "SQLite");
        ReservedDBWords.addWord("HAVING", "SQLite");
        ReservedDBWords.addWord("IF", "SQLite");
        ReservedDBWords.addWord("IGNORE", "SQLite");
        ReservedDBWords.addWord("IMMEDIATE", "SQLite");
        ReservedDBWords.addWord("IN", "SQLite");
        ReservedDBWords.addWord("INDEX", "SQLite");
        ReservedDBWords.addWord("INDEXED", "SQLite");
        ReservedDBWords.addWord("INITIALLY", "SQLite");
        ReservedDBWords.addWord("INNER", "SQLite");
        ReservedDBWords.addWord("INSERT", "SQLite");
        ReservedDBWords.addWord("INSTEAD", "SQLite");
        ReservedDBWords.addWord("INTERSECT", "SQLite");
        ReservedDBWords.addWord("INTO", "SQLite");
        ReservedDBWords.addWord("IS", "SQLite");
        ReservedDBWords.addWord("ISNULL", "SQLite");
        ReservedDBWords.addWord("JOIN", "SQLite");
        ReservedDBWords.addWord("KEY", "SQLite");
        ReservedDBWords.addWord("LEFT", "SQLite");
        ReservedDBWords.addWord("LIKE", "SQLite");
        ReservedDBWords.addWord("LIMIT", "SQLite");
        ReservedDBWords.addWord("MATCH", "SQLite");
        ReservedDBWords.addWord("NATURAL", "SQLite");
        ReservedDBWords.addWord("NO", "SQLite");
        ReservedDBWords.addWord("NOT", "SQLite");
        ReservedDBWords.addWord("NOTNULL", "SQLite");
        ReservedDBWords.addWord("NULL", "SQLite");
        ReservedDBWords.addWord("OF", "SQLite");
        ReservedDBWords.addWord("OFFSET", "SQLite");
        ReservedDBWords.addWord("ON", "SQLite");
        ReservedDBWords.addWord("OR", "SQLite");
        ReservedDBWords.addWord("ORDER", "SQLite");
        ReservedDBWords.addWord("OUTER", "SQLite");
        ReservedDBWords.addWord("PLAN", "SQLite");
        ReservedDBWords.addWord("PRAGMA", "SQLite");
        ReservedDBWords.addWord("PRIMARY", "SQLite");
        ReservedDBWords.addWord("QUERY", "SQLite");
        ReservedDBWords.addWord("RAISE", "SQLite");
        ReservedDBWords.addWord("RECURSIVE", "SQLite");
        ReservedDBWords.addWord("REFERENCES", "SQLite");
        ReservedDBWords.addWord("REGEXP", "SQLite");
        ReservedDBWords.addWord("REINDEX", "SQLite");
        ReservedDBWords.addWord("RELEASE", "SQLite");
        ReservedDBWords.addWord("RENAME", "SQLite");
        ReservedDBWords.addWord("REPLACE", "SQLite");
        ReservedDBWords.addWord("RESTRICT", "SQLite");
        ReservedDBWords.addWord("RIGHT", "SQLite");
        ReservedDBWords.addWord("ROLLBACK", "SQLite");
        ReservedDBWords.addWord("ROW", "SQLite");
        ReservedDBWords.addWord("SAVEPOINT", "SQLite");
        ReservedDBWords.addWord("SELECT", "SQLite");
        ReservedDBWords.addWord("SET", "SQLite");
        ReservedDBWords.addWord("TABLE", "SQLite");
        ReservedDBWords.addWord("TEMP", "SQLite");
        ReservedDBWords.addWord("TEMPORARY", "SQLite");
        ReservedDBWords.addWord("THEN", "SQLite");
        ReservedDBWords.addWord("TO", "SQLite");
        ReservedDBWords.addWord("TRANSACTION", "SQLite");
        ReservedDBWords.addWord("TRIGGER", "SQLite");
        ReservedDBWords.addWord("UNION", "SQLite");
        ReservedDBWords.addWord("UNIQUE", "SQLite");
        ReservedDBWords.addWord("UPDATE", "SQLite");
        ReservedDBWords.addWord("USING", "SQLite");
        ReservedDBWords.addWord("VACUUM", "SQLite");
        ReservedDBWords.addWord("VALUES", "SQLite");
        ReservedDBWords.addWord("VIEW", "SQLite");
        ReservedDBWords.addWord("VIRTUAL", "SQLite");
        ReservedDBWords.addWord("WHEN", "SQLite");
        ReservedDBWords.addWord("WHERE", "SQLite");
        ReservedDBWords.addWord("WITH", "SQLite");
        ReservedDBWords.addWord("WITHOUT", "SQLite");
        ReservedDBWords.addWord("ABORT", "Teradata");
        ReservedDBWords.addWord("ABORTSESSION", "Teradata");
        ReservedDBWords.addWord("ABS", "Teradata");
        ReservedDBWords.addWord("ACCESS_LOCK", "Teradata");
        ReservedDBWords.addWord("ACCOUNT", "Teradata");
        ReservedDBWords.addWord("ACOS", "Teradata");
        ReservedDBWords.addWord("ACOSH", "Teradata");
        ReservedDBWords.addWord("ADD", "Teradata");
        ReservedDBWords.addWord("ADD_MONTHS", "Teradata");
        ReservedDBWords.addWord("ADMIN", "Teradata");
        ReservedDBWords.addWord("AFTER", "Teradata");
        ReservedDBWords.addWord("AGGREGATE", "Teradata");
        ReservedDBWords.addWord("ALIAS", "Teradata");
        ReservedDBWords.addWord("ALL", "Teradata");
        ReservedDBWords.addWord("ALTER", "Teradata");
        ReservedDBWords.addWord("AMP", "Teradata");
        ReservedDBWords.addWord("AND", "Teradata");
        ReservedDBWords.addWord("ANSIDATE", "Teradata");
        ReservedDBWords.addWord("ANY", "Teradata");
        ReservedDBWords.addWord("AS", "Teradata");
        ReservedDBWords.addWord("ASC", "Teradata");
        ReservedDBWords.addWord("ASIN", "Teradata");
        ReservedDBWords.addWord("ASINH", "Teradata");
        ReservedDBWords.addWord("AT", "Teradata");
        ReservedDBWords.addWord("ATAN", "Teradata");
        ReservedDBWords.addWord("ATAN2", "Teradata");
        ReservedDBWords.addWord("ATANH", "Teradata");
        ReservedDBWords.addWord("ATOMIC", "Teradata");
        ReservedDBWords.addWord("AUTHORIZATION", "Teradata");
        ReservedDBWords.addWord("AVE", "Teradata");
        ReservedDBWords.addWord("AVERAGE", "Teradata");
        ReservedDBWords.addWord("AVG", "Teradata");
        ReservedDBWords.addWord("BEFORE", "Teradata");
        ReservedDBWords.addWord("BEGIN", "Teradata");
        ReservedDBWords.addWord("BETWEEN", "Teradata");
        ReservedDBWords.addWord("BLOB", "Teradata");
        ReservedDBWords.addWord("BOTH", "Teradata");
        ReservedDBWords.addWord("BT", "Teradata");
        ReservedDBWords.addWord("BUT", "Teradata");
        ReservedDBWords.addWord("BY", "Teradata");
        ReservedDBWords.addWord("BYTE", "Teradata");
        ReservedDBWords.addWord("BYTEINT", "Teradata");
        ReservedDBWords.addWord("BYTES", "Teradata");
        ReservedDBWords.addWord("CALL", "Teradata");
        ReservedDBWords.addWord("CASE", "Teradata");
        ReservedDBWords.addWord("CASE_N", "Teradata");
        ReservedDBWords.addWord("CASESPECIFIC", "Teradata");
        ReservedDBWords.addWord("CAST", "Teradata");
        ReservedDBWords.addWord("CD", "Teradata");
        ReservedDBWords.addWord("CHAR", "Teradata");
        ReservedDBWords.addWord("CHAR_LENGTH", "Teradata");
        ReservedDBWords.addWord("CHAR2HEXINT", "Teradata");
        ReservedDBWords.addWord("CHARACTER", "Teradata");
        ReservedDBWords.addWord("CHARACTER_LENGTH", "Teradata");
        ReservedDBWords.addWord("CHARACTERS", "Teradata");
        ReservedDBWords.addWord("CHARS", "Teradata");
        ReservedDBWords.addWord("CHECK", "Teradata");
        ReservedDBWords.addWord("CHECKPOINT", "Teradata");
        ReservedDBWords.addWord("CLASS", "Teradata");
        ReservedDBWords.addWord("CLOSE", "Teradata");
        ReservedDBWords.addWord("CLUSTER", "Teradata");
        ReservedDBWords.addWord("CM", "Teradata");
        ReservedDBWords.addWord("COALESCE", "Teradata");
        ReservedDBWords.addWord("COLLATION", "Teradata");
        ReservedDBWords.addWord("COLLECT", "Teradata");
        ReservedDBWords.addWord("COLUMN", "Teradata");
        ReservedDBWords.addWord("COMMENT", "Teradata");
        ReservedDBWords.addWord("COMMIT", "Teradata");
        ReservedDBWords.addWord("COMPRESS", "Teradata");
        ReservedDBWords.addWord("CONSTRAINT", "Teradata");
        ReservedDBWords.addWord("CONTINUE", "Teradata");
        ReservedDBWords.addWord("CONVERT_TABLE_HEADER", "Teradata");
        ReservedDBWords.addWord("CORR", "Teradata");
        ReservedDBWords.addWord("COS", "Teradata");
        ReservedDBWords.addWord("COSH", "Teradata");
        ReservedDBWords.addWord("COUNT", "Teradata");
        ReservedDBWords.addWord("COVAR_POP", "Teradata");
        ReservedDBWords.addWord("COVAR_SAMP", "Teradata");
        ReservedDBWords.addWord("CREATE", "Teradata");
        ReservedDBWords.addWord("CROSS", "Teradata");
        ReservedDBWords.addWord("CS", "Teradata");
        ReservedDBWords.addWord("CSUM", "Teradata");
        ReservedDBWords.addWord("CT", "Teradata");
        ReservedDBWords.addWord("CURRENT", "Teradata");
        ReservedDBWords.addWord("CURRENT_DATE", "Teradata");
        ReservedDBWords.addWord("CURRENT_TIME", "Teradata");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "Teradata");
        ReservedDBWords.addWord("CURSOR", "Teradata");
        ReservedDBWords.addWord("CV", "Teradata");
        ReservedDBWords.addWord("CYCLE", "Teradata");
        ReservedDBWords.addWord("DATABASE", "Teradata");
        ReservedDBWords.addWord("DATABLOCKSIZE", "Teradata");
        ReservedDBWords.addWord("DATE", "Teradata");
        ReservedDBWords.addWord("DATEFORM", "Teradata");
        ReservedDBWords.addWord("DAY", "Teradata");
        ReservedDBWords.addWord("DEC", "Teradata");
        ReservedDBWords.addWord("DECIMAL", "Teradata");
        ReservedDBWords.addWord("DECLARE", "Teradata");
        ReservedDBWords.addWord("DEFAULT", "Teradata");
        ReservedDBWords.addWord("DEGREES", "Teradata");
        ReservedDBWords.addWord("DEL", "Teradata");
        ReservedDBWords.addWord("DELETE", "Teradata");
        ReservedDBWords.addWord("DESC", "Teradata");
        ReservedDBWords.addWord("DESCRIPTOR", "Teradata");
        ReservedDBWords.addWord("DETERMINISTIC", "Teradata");
        ReservedDBWords.addWord("DIAGNOSTIC", "Teradata");
        ReservedDBWords.addWord("DISABLED", "Teradata");
        ReservedDBWords.addWord("DISTINCT", "Teradata");
        ReservedDBWords.addWord("DO", "Teradata");
        ReservedDBWords.addWord("DOUBLE", "Teradata");
        ReservedDBWords.addWord("DROP", "Teradata");
        ReservedDBWords.addWord("DUAL", "Teradata");
        ReservedDBWords.addWord("DUMP", "Teradata");
        ReservedDBWords.addWord("EACH", "Teradata");
        ReservedDBWords.addWord("ECHO", "Teradata");
        ReservedDBWords.addWord("ELSE", "Teradata");
        ReservedDBWords.addWord("ELSEIF", "Teradata");
        ReservedDBWords.addWord("ENABLED", "Teradata");
        ReservedDBWords.addWord("END", "Teradata");
        ReservedDBWords.addWord("EQ", "Teradata");
        ReservedDBWords.addWord("ERROR", "Teradata");
        ReservedDBWords.addWord("ERRORFILES", "Teradata");
        ReservedDBWords.addWord("ERRORTABLES", "Teradata");
        ReservedDBWords.addWord("ESCAPE", "Teradata");
        ReservedDBWords.addWord("ET", "Teradata");
        ReservedDBWords.addWord("EXCEPT", "Teradata");
        ReservedDBWords.addWord("EXEC", "Teradata");
        ReservedDBWords.addWord("EXECUTE", "Teradata");
        ReservedDBWords.addWord("EXISTS", "Teradata");
        ReservedDBWords.addWord("EXIT", "Teradata");
        ReservedDBWords.addWord("EXP", "Teradata");
        ReservedDBWords.addWord("EXPLAIN", "Teradata");
        ReservedDBWords.addWord("EXTERNAL", "Teradata");
        ReservedDBWords.addWord("EXTRACT", "Teradata");
        ReservedDBWords.addWord("FALLBACK", "Teradata");
        ReservedDBWords.addWord("FASTEXPORT", "Teradata");
        ReservedDBWords.addWord("FETCH", "Teradata");
        ReservedDBWords.addWord("FIRST", "Teradata");
        ReservedDBWords.addWord("FLOAT", "Teradata");
        ReservedDBWords.addWord("FOR", "Teradata");
        ReservedDBWords.addWord("FOREIGN", "Teradata");
        ReservedDBWords.addWord("FORMAT", "Teradata");
        ReservedDBWords.addWord("FOUND", "Teradata");
        ReservedDBWords.addWord("FREESPACE", "Teradata");
        ReservedDBWords.addWord("FROM", "Teradata");
        ReservedDBWords.addWord("FULL", "Teradata");
        ReservedDBWords.addWord("FUNCTION", "Teradata");
        ReservedDBWords.addWord("GE", "Teradata");
        ReservedDBWords.addWord("GENERATED", "Teradata");
        ReservedDBWords.addWord("GIVE", "Teradata");
        ReservedDBWords.addWord("GO", "Teradata");
        ReservedDBWords.addWord("GOTO", "Teradata");
        ReservedDBWords.addWord("GRANT", "Teradata");
        ReservedDBWords.addWord("GRAPHIC", "Teradata");
        ReservedDBWords.addWord("GROUP", "Teradata");
        ReservedDBWords.addWord("GT", "Teradata");
        ReservedDBWords.addWord("HANDLER", "Teradata");
        ReservedDBWords.addWord("HASH", "Teradata");
        ReservedDBWords.addWord("HASHAMP", "Teradata");
        ReservedDBWords.addWord("HASHBAKAMP", "Teradata");
        ReservedDBWords.addWord("HASHBUCKET", "Teradata");
        ReservedDBWords.addWord("HASHROW", "Teradata");
        ReservedDBWords.addWord("HAVING", "Teradata");
        ReservedDBWords.addWord("HELP", "Teradata");
        ReservedDBWords.addWord("HOUR", "Teradata");
        ReservedDBWords.addWord("IDENTITY", "Teradata");
        ReservedDBWords.addWord("IF", "Teradata");
        ReservedDBWords.addWord("IMMEDIATE", "Teradata");
        ReservedDBWords.addWord("IN", "Teradata");
        ReservedDBWords.addWord("INCONSISTENT", "Teradata");
        ReservedDBWords.addWord("INDEX", "Teradata");
        ReservedDBWords.addWord("INDICATOR", "Teradata");
        ReservedDBWords.addWord("INITIATE", "Teradata");
        ReservedDBWords.addWord("INNER", "Teradata");
        ReservedDBWords.addWord("INOUT", "Teradata");
        ReservedDBWords.addWord("INPUT", "Teradata");
        ReservedDBWords.addWord("INS", "Teradata");
        ReservedDBWords.addWord("INSERT", "Teradata");
        ReservedDBWords.addWord("INSTEAD", "Teradata");
        ReservedDBWords.addWord("INT", "Teradata");
        ReservedDBWords.addWord("INTEGER", "Teradata");
        ReservedDBWords.addWord("INTEGERDATE", "Teradata");
        ReservedDBWords.addWord("INTERSECT", "Teradata");
        ReservedDBWords.addWord("INTERVAL", "Teradata");
        ReservedDBWords.addWord("INTO", "Teradata");
        ReservedDBWords.addWord("IS", "Teradata");
        ReservedDBWords.addWord("ITERATE", "Teradata");
        ReservedDBWords.addWord("JOIN", "Teradata");
        ReservedDBWords.addWord("JOURNAL", "Teradata");
        ReservedDBWords.addWord("KEY", "Teradata");
        ReservedDBWords.addWord("KURTOSIS", "Teradata");
        ReservedDBWords.addWord("LANGUAGE", "Teradata");
        ReservedDBWords.addWord("LE", "Teradata");
        ReservedDBWords.addWord("LEADING", "Teradata");
        ReservedDBWords.addWord("LEAVE", "Teradata");
        ReservedDBWords.addWord("LEFT", "Teradata");
        ReservedDBWords.addWord("LIKE", "Teradata");
        ReservedDBWords.addWord("LIMIT", "Teradata");
        ReservedDBWords.addWord("LN", "Teradata");
        ReservedDBWords.addWord("LOADING", "Teradata");
        ReservedDBWords.addWord("LOCAL", "Teradata");
        ReservedDBWords.addWord("LOCATOR", "Teradata");
        ReservedDBWords.addWord("LOCK", "Teradata");
        ReservedDBWords.addWord("LOCKING", "Teradata");
        ReservedDBWords.addWord("LOG", "Teradata");
        ReservedDBWords.addWord("LOGGING", "Teradata");
        ReservedDBWords.addWord("LOGON", "Teradata");
        ReservedDBWords.addWord("LONG", "Teradata");
        ReservedDBWords.addWord("LOOP", "Teradata");
        ReservedDBWords.addWord("LOWER", "Teradata");
        ReservedDBWords.addWord("LT", "Teradata");
        ReservedDBWords.addWord("MACRO", "Teradata");
        ReservedDBWords.addWord("MAVG", "Teradata");
        ReservedDBWords.addWord("MAX", "Teradata");
        ReservedDBWords.addWord("MAXIMUM", "Teradata");
        ReservedDBWords.addWord("MCHARACTERS", "Teradata");
        ReservedDBWords.addWord("MDIFF", "Teradata");
        ReservedDBWords.addWord("MERGE", "Teradata");
        ReservedDBWords.addWord("MIN", "Teradata");
        ReservedDBWords.addWord("MINDEX", "Teradata");
        ReservedDBWords.addWord("MINIMUM", "Teradata");
        ReservedDBWords.addWord("MINUS", "Teradata");
        ReservedDBWords.addWord("MINUTE", "Teradata");
        ReservedDBWords.addWord("MLINREG", "Teradata");
        ReservedDBWords.addWord("MLOAD", "Teradata");
        ReservedDBWords.addWord("MOD", "Teradata");
        ReservedDBWords.addWord("MODE", "Teradata");
        ReservedDBWords.addWord("MODIFY", "Teradata");
        ReservedDBWords.addWord("MONITOR", "Teradata");
        ReservedDBWords.addWord("MONRESOURCE", "Teradata");
        ReservedDBWords.addWord("MONSESSION", "Teradata");
        ReservedDBWords.addWord("MONTH", "Teradata");
        ReservedDBWords.addWord("MSUBSTR", "Teradata");
        ReservedDBWords.addWord("MSUM", "Teradata");
        ReservedDBWords.addWord("MULTISET", "Teradata");
        ReservedDBWords.addWord("NAMED", "Teradata");
        ReservedDBWords.addWord("NATURAL", "Teradata");
        ReservedDBWords.addWord("NE", "Teradata");
        ReservedDBWords.addWord("NEW", "Teradata");
        ReservedDBWords.addWord("NEW_TABLE", "Teradata");
        ReservedDBWords.addWord("NEXT", "Teradata");
        ReservedDBWords.addWord("NO", "Teradata");
        ReservedDBWords.addWord("NONE", "Teradata");
        ReservedDBWords.addWord("NOT", "Teradata");
        ReservedDBWords.addWord("NOWAIT", "Teradata");
        ReservedDBWords.addWord("NULL", "Teradata");
        ReservedDBWords.addWord("NULLIF", "Teradata");
        ReservedDBWords.addWord("NULLIFZERO", "Teradata");
        ReservedDBWords.addWord("NUMERIC", "Teradata");
        ReservedDBWords.addWord("OBJECTS", "Teradata");
        ReservedDBWords.addWord("OCTET_LENGTH", "Teradata");
        ReservedDBWords.addWord("OF", "Teradata");
        ReservedDBWords.addWord("OFF", "Teradata");
        ReservedDBWords.addWord("OLD", "Teradata");
        ReservedDBWords.addWord("OLD_TABLE", "Teradata");
        ReservedDBWords.addWord("ON", "Teradata");
        ReservedDBWords.addWord("ONLY", "Teradata");
        ReservedDBWords.addWord("OPEN", "Teradata");
        ReservedDBWords.addWord("OPTION", "Teradata");
        ReservedDBWords.addWord("OR", "Teradata");
        ReservedDBWords.addWord("ORDER", "Teradata");
        ReservedDBWords.addWord("OUT", "Teradata");
        ReservedDBWords.addWord("OUTER", "Teradata");
        ReservedDBWords.addWord("OVER", "Teradata");
        ReservedDBWords.addWord("OVERLAPS", "Teradata");
        ReservedDBWords.addWord("OVERRIDE", "Teradata");
        ReservedDBWords.addWord("PARAMETER", "Teradata");
        ReservedDBWords.addWord("PASSWORD", "Teradata");
        ReservedDBWords.addWord("PERCENT", "Teradata");
        ReservedDBWords.addWord("PERCENT_RANK", "Teradata");
        ReservedDBWords.addWord("PERM", "Teradata");
        ReservedDBWords.addWord("PERMANENT", "Teradata");
        ReservedDBWords.addWord("POSITION", "Teradata");
        ReservedDBWords.addWord("PRECISION", "Teradata");
        ReservedDBWords.addWord("PREPARE", "Teradata");
        ReservedDBWords.addWord("PRESERVE", "Teradata");
        ReservedDBWords.addWord("PRIMARY", "Teradata");
        ReservedDBWords.addWord("PRIVATE", "Teradata");
        ReservedDBWords.addWord("PRIVILEGES", "Teradata");
        ReservedDBWords.addWord("PROCEDURE", "Teradata");
        ReservedDBWords.addWord("PROFILE", "Teradata");
        ReservedDBWords.addWord("PROPORTIONAL", "Teradata");
        ReservedDBWords.addWord("PROTECTION", "Teradata");
        ReservedDBWords.addWord("PUBLIC", "Teradata");
        ReservedDBWords.addWord("QUALIFIED", "Teradata");
        ReservedDBWords.addWord("QUALIFY", "Teradata");
        ReservedDBWords.addWord("QUANTILE", "Teradata");
        ReservedDBWords.addWord("RADIANS", "Teradata");
        ReservedDBWords.addWord("RANDOM", "Teradata");
        ReservedDBWords.addWord("RANGE_N", "Teradata");
        ReservedDBWords.addWord("RANK", "Teradata");
        ReservedDBWords.addWord("REAL", "Teradata");
        ReservedDBWords.addWord("REFERENCES", "Teradata");
        ReservedDBWords.addWord("REFERENCING", "Teradata");
        ReservedDBWords.addWord("REGR_AVGX", "Teradata");
        ReservedDBWords.addWord("REGR_AVGY", "Teradata");
        ReservedDBWords.addWord("REGR_COUNT", "Teradata");
        ReservedDBWords.addWord("REGR_INTERCEPT", "Teradata");
        ReservedDBWords.addWord("REGR_R2", "Teradata");
        ReservedDBWords.addWord("REGR_SLOPE", "Teradata");
        ReservedDBWords.addWord("REGR_SXX", "Teradata");
        ReservedDBWords.addWord("REGR_SXY", "Teradata");
        ReservedDBWords.addWord("REGR_SYY", "Teradata");
        ReservedDBWords.addWord("RELEASE", "Teradata");
        ReservedDBWords.addWord("RENAME", "Teradata");
        ReservedDBWords.addWord("REPEAT", "Teradata");
        ReservedDBWords.addWord("REPLACE", "Teradata");
        ReservedDBWords.addWord("REPLICATION", "Teradata");
        ReservedDBWords.addWord("REPOVERRIDE", "Teradata");
        ReservedDBWords.addWord("REQUEST", "Teradata");
        ReservedDBWords.addWord("RESTART", "Teradata");
        ReservedDBWords.addWord("RESTORE", "Teradata");
        ReservedDBWords.addWord("RESUME", "Teradata");
        ReservedDBWords.addWord("RET", "Teradata");
        ReservedDBWords.addWord("RETRIEVE", "Teradata");
        ReservedDBWords.addWord("RETURNS", "Teradata");
        ReservedDBWords.addWord("REVALIDATE", "Teradata");
        ReservedDBWords.addWord("REVOKE", "Teradata");
        ReservedDBWords.addWord("RIGHT", "Teradata");
        ReservedDBWords.addWord("RIGHTS", "Teradata");
        ReservedDBWords.addWord("ROLE", "Teradata");
        ReservedDBWords.addWord("ROLLBACK", "Teradata");
        ReservedDBWords.addWord("ROLLFORWARD", "Teradata");
        ReservedDBWords.addWord("ROW", "Teradata");
        ReservedDBWords.addWord("ROW_NUMBER", "Teradata");
        ReservedDBWords.addWord("ROWID", "Teradata");
        ReservedDBWords.addWord("ROWS", "Teradata");
        ReservedDBWords.addWord("SAMPLE", "Teradata");
        ReservedDBWords.addWord("SAMPLEID", "Teradata");
        ReservedDBWords.addWord("SCROLL", "Teradata");
        ReservedDBWords.addWord("SECOND", "Teradata");
        ReservedDBWords.addWord("SEL", "Teradata");
        ReservedDBWords.addWord("SELECT", "Teradata");
        ReservedDBWords.addWord("SESSION", "Teradata");
        ReservedDBWords.addWord("SET", "Teradata");
        ReservedDBWords.addWord("SETRESRATE", "Teradata");
        ReservedDBWords.addWord("SETSESSRATE", "Teradata");
        ReservedDBWords.addWord("SHOW", "Teradata");
        ReservedDBWords.addWord("SIMPLE", "Teradata");
        ReservedDBWords.addWord("SIN", "Teradata");
        ReservedDBWords.addWord("SINH", "Teradata");
        ReservedDBWords.addWord("SKEW", "Teradata");
        ReservedDBWords.addWord("SMALLINT", "Teradata");
        ReservedDBWords.addWord("SOME", "Teradata");
        ReservedDBWords.addWord("SOUNDEX", "Teradata");
        ReservedDBWords.addWord("SPECIFIC", "Teradata");
        ReservedDBWords.addWord("SPOOL", "Teradata");
        ReservedDBWords.addWord("SQL", "Teradata");
        ReservedDBWords.addWord("SQLEXCEPTION", "Teradata");
        ReservedDBWords.addWord("SQLTEXT", "Teradata");
        ReservedDBWords.addWord("SQLWARNING", "Teradata");
        ReservedDBWords.addWord("SQRT", "Teradata");
        ReservedDBWords.addWord("SS", "Teradata");
        ReservedDBWords.addWord("START", "Teradata");
        ReservedDBWords.addWord("STARTUP", "Teradata");
        ReservedDBWords.addWord("ALL", "Hana");
        ReservedDBWords.addWord("ALTER", "Hana");
        ReservedDBWords.addWord("AS", "Hana");
        ReservedDBWords.addWord("BEFORE", "Hana");
        ReservedDBWords.addWord("BEGIN", "Hana");
        ReservedDBWords.addWord("BOTH", "Hana");
        ReservedDBWords.addWord("CASE", "Hana");
        ReservedDBWords.addWord("CHAR", "Hana");
        ReservedDBWords.addWord("CONDITION", "Hana");
        ReservedDBWords.addWord("CONNECT", "Hana");
        ReservedDBWords.addWord("CROSS", "Hana");
        ReservedDBWords.addWord("CUBE", "Hana");
        ReservedDBWords.addWord("CURRENT_CONNECTION", "Hana");
        ReservedDBWords.addWord("CURRENT_DATE", "Hana");
        ReservedDBWords.addWord("CURRENT_SCHEMA", "Hana");
        ReservedDBWords.addWord("CURRENT_TIME", "Hana");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "Hana");
        ReservedDBWords.addWord("CURRENT_TRANSACTION_ISOLATION_LEVEL", "Hana");
        ReservedDBWords.addWord("CURRENT_USER", "Hana");
        ReservedDBWords.addWord("CURRENT_UTCDATE", "Hana");
        ReservedDBWords.addWord("CURRENT_UTCTIME", "Hana");
        ReservedDBWords.addWord("CURRENT_UTCTIMESTAMP", "Hana");
        ReservedDBWords.addWord("CURRVAL", "Hana");
        ReservedDBWords.addWord("CURSOR", "Hana");
        ReservedDBWords.addWord("DECLARE", "Hana");
        ReservedDBWords.addWord("DISTINCT", "Hana");
        ReservedDBWords.addWord("ELSE", "Hana");
        ReservedDBWords.addWord("ELSEIF", "Hana");
        ReservedDBWords.addWord("END", "Hana");
        ReservedDBWords.addWord("EXCEPT", "Hana");
        ReservedDBWords.addWord("EXCEPTION", "Hana");
        ReservedDBWords.addWord("EXEC", "Hana");
        ReservedDBWords.addWord("FALSE", "Hana");
        ReservedDBWords.addWord("FOR", "Hana");
        ReservedDBWords.addWord("FROM", "Hana");
        ReservedDBWords.addWord("FULL", "Hana");
        ReservedDBWords.addWord("GROUP", "Hana");
        ReservedDBWords.addWord("HAVING", "Hana");
        ReservedDBWords.addWord("IF", "Hana");
        ReservedDBWords.addWord("IN", "Hana");
        ReservedDBWords.addWord("INNER", "Hana");
        ReservedDBWords.addWord("INOUT", "Hana");
        ReservedDBWords.addWord("INTERSECT", "Hana");
        ReservedDBWords.addWord("INTO", "Hana");
        ReservedDBWords.addWord("IS", "Hana");
        ReservedDBWords.addWord("JOIN", "Hana");
        ReservedDBWords.addWord("LEADING", "Hana");
        ReservedDBWords.addWord("LEFT", "Hana");
        ReservedDBWords.addWord("LIMIT", "Hana");
        ReservedDBWords.addWord("LOOP", "Hana");
        ReservedDBWords.addWord("MINUS", "Hana");
        ReservedDBWords.addWord("NATURAL", "Hana");
        ReservedDBWords.addWord("NCHAR", "Hana");
        ReservedDBWords.addWord("NEXTVAL", "Hana");
        ReservedDBWords.addWord("NULL", "Hana");
        ReservedDBWords.addWord("ON", "Hana");
        ReservedDBWords.addWord("ORDER", "Hana");
        ReservedDBWords.addWord("OUT", "Hana");
        ReservedDBWords.addWord("PRIOR", "Hana");
        ReservedDBWords.addWord("RETURN", "Hana");
        ReservedDBWords.addWord("RETURNS", "Hana");
        ReservedDBWords.addWord("REVERSE", "Hana");
        ReservedDBWords.addWord("RIGHT", "Hana");
        ReservedDBWords.addWord("ROLLUP", "Hana");
        ReservedDBWords.addWord("ROWID", "Hana");
        ReservedDBWords.addWord("SELECT", "Hana");
        ReservedDBWords.addWord("SESSION_USER", "Hana");
        ReservedDBWords.addWord("SET", "Hana");
        ReservedDBWords.addWord("SQL", "Hana");
        ReservedDBWords.addWord("START", "Hana");
        ReservedDBWords.addWord("SYSUUID", "Hana");
        ReservedDBWords.addWord("TABLESAMPLE", "Hana");
        ReservedDBWords.addWord("TOP", "Hana");
        ReservedDBWords.addWord("TRAILING", "Hana");
        ReservedDBWords.addWord("TRUE", "Hana");
        ReservedDBWords.addWord("UNION", "Hana");
        ReservedDBWords.addWord("UNKNOWN", "Hana");
        ReservedDBWords.addWord("USING", "Hana");
        ReservedDBWords.addWord("UTCTIMESTAMP", "Hana");
        ReservedDBWords.addWord("VALUES", "Hana");
        ReservedDBWords.addWord("WHEN", "Hana");
        ReservedDBWords.addWord("WHERE", "Hana");
        ReservedDBWords.addWord("WHILE", "Hana");
        ReservedDBWords.addWord("WITH", "Hana");
        ReservedDBWords.addWord("ACCESSIBLE", "Maria");
        ReservedDBWords.addWord("ADD", "Maria");
        ReservedDBWords.addWord("ALL", "Maria");
        ReservedDBWords.addWord("ALTER", "Maria");
        ReservedDBWords.addWord("ANALYZE", "Maria");
        ReservedDBWords.addWord("AND", "Maria");
        ReservedDBWords.addWord("AS", "Maria");
        ReservedDBWords.addWord("ASC", "Maria");
        ReservedDBWords.addWord("ASENSITIVE", "Maria");
        ReservedDBWords.addWord("BEFORE", "Maria");
        ReservedDBWords.addWord("BETWEEN", "Maria");
        ReservedDBWords.addWord("BIGINT", "Maria");
        ReservedDBWords.addWord("BINARY", "Maria");
        ReservedDBWords.addWord("BLOB", "Maria");
        ReservedDBWords.addWord("BOTH", "Maria");
        ReservedDBWords.addWord("BY", "Maria");
        ReservedDBWords.addWord("CALL", "Maria");
        ReservedDBWords.addWord("CASCADE", "Maria");
        ReservedDBWords.addWord("CASE", "Maria");
        ReservedDBWords.addWord("CHANGE", "Maria");
        ReservedDBWords.addWord("CHAR", "Maria");
        ReservedDBWords.addWord("CHARACTER", "Maria");
        ReservedDBWords.addWord("CHECK", "Maria");
        ReservedDBWords.addWord("COLLATE", "Maria");
        ReservedDBWords.addWord("COLUMN", "Maria");
        ReservedDBWords.addWord("CONDITION", "Maria");
        ReservedDBWords.addWord("CONSTRAINT", "Maria");
        ReservedDBWords.addWord("CONTINUE", "Maria");
        ReservedDBWords.addWord("CONVERT", "Maria");
        ReservedDBWords.addWord("CREATE", "Maria");
        ReservedDBWords.addWord("CROSS", "Maria");
        ReservedDBWords.addWord("CURRENT_DATE", "Maria");
        ReservedDBWords.addWord("CURRENT_TIME", "Maria");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "Maria");
        ReservedDBWords.addWord("CURRENT_USER", "Maria");
        ReservedDBWords.addWord("CURSOR", "Maria");
        ReservedDBWords.addWord("DATABASE", "Maria");
        ReservedDBWords.addWord("DATABASES", "Maria");
        ReservedDBWords.addWord("DAY_HOUR", "Maria");
        ReservedDBWords.addWord("DAY_MICROSECOND", "Maria");
        ReservedDBWords.addWord("DAY_MINUTE", "Maria");
        ReservedDBWords.addWord("DAY_SECOND", "Maria");
        ReservedDBWords.addWord("DEC", "Maria");
        ReservedDBWords.addWord("DECIMAL", "Maria");
        ReservedDBWords.addWord("DECLARE", "Maria");
        ReservedDBWords.addWord("DEFAULT", "Maria");
        ReservedDBWords.addWord("DELAYED", "Maria");
        ReservedDBWords.addWord("DELETE", "Maria");
        ReservedDBWords.addWord("DESC", "Maria");
        ReservedDBWords.addWord("DESCRIBE", "Maria");
        ReservedDBWords.addWord("DETERMINISTIC", "Maria");
        ReservedDBWords.addWord("DISTINCT", "Maria");
        ReservedDBWords.addWord("DISTINCTROW", "Maria");
        ReservedDBWords.addWord("DIV", "Maria");
        ReservedDBWords.addWord("DOUBLE", "Maria");
        ReservedDBWords.addWord("DROP", "Maria");
        ReservedDBWords.addWord("DUAL", "Maria");
        ReservedDBWords.addWord("EACH", "Maria");
        ReservedDBWords.addWord("ELSE", "Maria");
        ReservedDBWords.addWord("ELSEIF", "Maria");
        ReservedDBWords.addWord("ENCLOSED", "Maria");
        ReservedDBWords.addWord("ESCAPED", "Maria");
        ReservedDBWords.addWord("EXISTS", "Maria");
        ReservedDBWords.addWord("EXIT", "Maria");
        ReservedDBWords.addWord("EXPLAIN", "Maria");
        ReservedDBWords.addWord("FETCH", "Maria");
        ReservedDBWords.addWord("FLOAT", "Maria");
        ReservedDBWords.addWord("FLOAT4", "Maria");
        ReservedDBWords.addWord("FLOAT8", "Maria");
        ReservedDBWords.addWord("FOR", "Maria");
        ReservedDBWords.addWord("FORCE", "Maria");
        ReservedDBWords.addWord("FOREIGN", "Maria");
        ReservedDBWords.addWord("FROM", "Maria");
        ReservedDBWords.addWord("FULLTEXT", "Maria");
        ReservedDBWords.addWord("GENERAL", "Maria");
        ReservedDBWords.addWord("GRANT", "Maria");
        ReservedDBWords.addWord("GROUP", "Maria");
        ReservedDBWords.addWord("HAVING", "Maria");
        ReservedDBWords.addWord("HIGH_PRIORITY", "Maria");
        ReservedDBWords.addWord("HOUR_MICROSECOND", "Maria");
        ReservedDBWords.addWord("HOUR_MINUTE", "Maria");
        ReservedDBWords.addWord("HOUR_SECOND", "Maria");
        ReservedDBWords.addWord("IF", "Maria");
        ReservedDBWords.addWord("IGNORE", "Maria");
        ReservedDBWords.addWord("IGNORE_SERVER_IDS", "Maria");
        ReservedDBWords.addWord("IN", "Maria");
        ReservedDBWords.addWord("INDEX", "Maria");
        ReservedDBWords.addWord("INFILE", "Maria");
        ReservedDBWords.addWord("INNER", "Maria");
        ReservedDBWords.addWord("INOUT", "Maria");
        ReservedDBWords.addWord("INSENSITIVE", "Maria");
        ReservedDBWords.addWord("INSERT", "Maria");
        ReservedDBWords.addWord("INT", "Maria");
        ReservedDBWords.addWord("INT1", "Maria");
        ReservedDBWords.addWord("INT2", "Maria");
        ReservedDBWords.addWord("INT3", "Maria");
        ReservedDBWords.addWord("INT4", "Maria");
        ReservedDBWords.addWord("INT8", "Maria");
        ReservedDBWords.addWord("INTEGER", "Maria");
        ReservedDBWords.addWord("INTERVAL", "Maria");
        ReservedDBWords.addWord("INTO", "Maria");
        ReservedDBWords.addWord("IS", "Maria");
        ReservedDBWords.addWord("ITERATE", "Maria");
        ReservedDBWords.addWord("JOIN", "Maria");
        ReservedDBWords.addWord("KEY", "Maria");
        ReservedDBWords.addWord("KEYS", "Maria");
        ReservedDBWords.addWord("KILL", "Maria");
        ReservedDBWords.addWord("LEADING", "Maria");
        ReservedDBWords.addWord("LEAVE", "Maria");
        ReservedDBWords.addWord("LEFT", "Maria");
        ReservedDBWords.addWord("LIKE", "Maria");
        ReservedDBWords.addWord("LIMIT", "Maria");
        ReservedDBWords.addWord("LINEAR", "Maria");
        ReservedDBWords.addWord("LINES", "Maria");
        ReservedDBWords.addWord("LOAD", "Maria");
        ReservedDBWords.addWord("LOCALTIME", "Maria");
        ReservedDBWords.addWord("LOCALTIMESTAMP", "Maria");
        ReservedDBWords.addWord("LOCK", "Maria");
        ReservedDBWords.addWord("LONG", "Maria");
        ReservedDBWords.addWord("LONGBLOB", "Maria");
        ReservedDBWords.addWord("LONGTEXT", "Maria");
        ReservedDBWords.addWord("LOOP", "Maria");
        ReservedDBWords.addWord("LOW_PRIORITY", "Maria");
        ReservedDBWords.addWord("MASTER_HEARTBEAT_PERIOD", "Maria");
        ReservedDBWords.addWord("MASTER_SSL_VERIFY_SERVER_CERT", "Maria");
        ReservedDBWords.addWord("MATCH", "Maria");
        ReservedDBWords.addWord("MAXVALUE", "Maria");
        ReservedDBWords.addWord("MEDIUMBLOB", "Maria");
        ReservedDBWords.addWord("MEDIUMINT", "Maria");
        ReservedDBWords.addWord("MEDIUMTEXT", "Maria");
        ReservedDBWords.addWord("MIDDLEINT", "Maria");
        ReservedDBWords.addWord("MINUTE_MICROSECOND", "Maria");
        ReservedDBWords.addWord("MINUTE_SECOND", "Maria");
        ReservedDBWords.addWord("MOD", "Maria");
        ReservedDBWords.addWord("MODIFIES", "Maria");
        ReservedDBWords.addWord("NATURAL", "Maria");
        ReservedDBWords.addWord("NO_WRITE_TO_BINLOG", "Maria");
        ReservedDBWords.addWord("NOT", "Maria");
        ReservedDBWords.addWord("NULL", "Maria");
        ReservedDBWords.addWord("NUMERIC", "Maria");
        ReservedDBWords.addWord("ON", "Maria");
        ReservedDBWords.addWord("OPTIMIZE", "Maria");
        ReservedDBWords.addWord("OPTION", "Maria");
        ReservedDBWords.addWord("OPTIONALLY", "Maria");
        ReservedDBWords.addWord("OR", "Maria");
        ReservedDBWords.addWord("ORDER", "Maria");
        ReservedDBWords.addWord("OUT", "Maria");
        ReservedDBWords.addWord("OUTER", "Maria");
        ReservedDBWords.addWord("OUTFILE", "Maria");
        ReservedDBWords.addWord("PARTITION", "Maria");
        ReservedDBWords.addWord("PRECISION", "Maria");
        ReservedDBWords.addWord("PRIMARY", "Maria");
        ReservedDBWords.addWord("PROCEDURE", "Maria");
        ReservedDBWords.addWord("PURGE", "Maria");
        ReservedDBWords.addWord("RANGE", "Maria");
        ReservedDBWords.addWord("READ", "Maria");
        ReservedDBWords.addWord("READ_WRITE", "Maria");
        ReservedDBWords.addWord("READS", "Maria");
        ReservedDBWords.addWord("REAL", "Maria");
        ReservedDBWords.addWord("REFERENCES", "Maria");
        ReservedDBWords.addWord("REGEXP", "Maria");
        ReservedDBWords.addWord("RELEASE", "Maria");
        ReservedDBWords.addWord("RENAME", "Maria");
        ReservedDBWords.addWord("REPEAT", "Maria");
        ReservedDBWords.addWord("REPLACE", "Maria");
        ReservedDBWords.addWord("REQUIRE", "Maria");
        ReservedDBWords.addWord("RESIGNAL", "Maria");
        ReservedDBWords.addWord("RESTRICT", "Maria");
        ReservedDBWords.addWord("RETURN", "Maria");
        ReservedDBWords.addWord("REVOKE", "Maria");
        ReservedDBWords.addWord("RIGHT", "Maria");
        ReservedDBWords.addWord("RLIKE", "Maria");
        ReservedDBWords.addWord("SCHEMA", "Maria");
        ReservedDBWords.addWord("SCHEMAS", "Maria");
        ReservedDBWords.addWord("SECOND_MICROSECOND", "Maria");
        ReservedDBWords.addWord("SELECT", "Maria");
        ReservedDBWords.addWord("SENSITIVE", "Maria");
        ReservedDBWords.addWord("SEPARATOR", "Maria");
        ReservedDBWords.addWord("SET", "Maria");
        ReservedDBWords.addWord("SHOW", "Maria");
        ReservedDBWords.addWord("SIGNAL", "Maria");
        ReservedDBWords.addWord("SLOW", "Maria");
        ReservedDBWords.addWord("SMALLINT", "Maria");
        ReservedDBWords.addWord("SPATIAL", "Maria");
        ReservedDBWords.addWord("SPECIFIC", "Maria");
        ReservedDBWords.addWord("SQL", "Maria");
        ReservedDBWords.addWord("SQL_BIG_RESULT", "Maria");
        ReservedDBWords.addWord("SQL_CALC_FOUND_ROWS", "Maria");
        ReservedDBWords.addWord("SQL_SMALL_RESULT", "Maria");
        ReservedDBWords.addWord("SQLEXCEPTION", "Maria");
        ReservedDBWords.addWord("SQLSTATE", "Maria");
        ReservedDBWords.addWord("SQLWARNING", "Maria");
        ReservedDBWords.addWord("SSL", "Maria");
        ReservedDBWords.addWord("STARTING", "Maria");
        ReservedDBWords.addWord("STRAIGHT_JOIN", "Maria");
        ReservedDBWords.addWord("TABLE", "Maria");
        ReservedDBWords.addWord("TERMINATED", "Maria");
        ReservedDBWords.addWord("THEN", "Maria");
        ReservedDBWords.addWord("TINYBLOB", "Maria");
        ReservedDBWords.addWord("TINYINT", "Maria");
        ReservedDBWords.addWord("TINYTEXT", "Maria");
        ReservedDBWords.addWord("TO", "Maria");
        ReservedDBWords.addWord("TRAILING", "Maria");
        ReservedDBWords.addWord("TRIGGER", "Maria");
        ReservedDBWords.addWord("UNDO", "Maria");
        ReservedDBWords.addWord("UNION", "Maria");
        ReservedDBWords.addWord("UNIQUE", "Maria");
        ReservedDBWords.addWord("UNLOCK", "Maria");
        ReservedDBWords.addWord("UNSIGNED", "Maria");
        ReservedDBWords.addWord("UPDATE", "Maria");
        ReservedDBWords.addWord("USAGE", "Maria");
        ReservedDBWords.addWord("USE", "Maria");
        ReservedDBWords.addWord("USING", "Maria");
        ReservedDBWords.addWord("UTC_DATE", "Maria");
        ReservedDBWords.addWord("UTC_TIME", "Maria");
        ReservedDBWords.addWord("UTC_TIMESTAMP", "Maria");
        ReservedDBWords.addWord("VALUES", "Maria");
        ReservedDBWords.addWord("VARBINARY", "Maria");
        ReservedDBWords.addWord("VARCHAR", "Maria");
        ReservedDBWords.addWord("VARCHARACTER", "Maria");
        ReservedDBWords.addWord("VARYING", "Maria");
        ReservedDBWords.addWord("WHEN", "Maria");
        ReservedDBWords.addWord("WHERE", "Maria");
        ReservedDBWords.addWord("WHILE", "Maria");
        ReservedDBWords.addWord("WITH", "Maria");
        ReservedDBWords.addWord("WRITE", "Maria");
        ReservedDBWords.addWord("XOR", "Maria");
        ReservedDBWords.addWord("YEAR_MONTH", "Maria");
        ReservedDBWords.addWord("ZEROFILL", "Maria");
        ReservedDBWords.addWord("FALSE", "Maria");
        ReservedDBWords.addWord("TRUE", "Maria");
        ReservedDBWords.addWord("CROSS", "H2");
        ReservedDBWords.addWord("CURRENT_DATE", "H2");
        ReservedDBWords.addWord("CURRENT_TIME", "H2");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "H2");
        ReservedDBWords.addWord("DISTINCT", "H2");
        ReservedDBWords.addWord("EXCEPT", "H2");
        ReservedDBWords.addWord("EXISTS", "H2");
        ReservedDBWords.addWord("FALSE", "H2");
        ReservedDBWords.addWord("FETCH", "H2");
        ReservedDBWords.addWord("FOR", "H2");
        ReservedDBWords.addWord("FROM", "H2");
        ReservedDBWords.addWord("FULL", "H2");
        ReservedDBWords.addWord("GROUP", "H2");
        ReservedDBWords.addWord("HAVING", "H2");
        ReservedDBWords.addWord("INNER", "H2");
        ReservedDBWords.addWord("INTERSECT", "H2");
        ReservedDBWords.addWord("IS", "H2");
        ReservedDBWords.addWord("JOIN", "H2");
        ReservedDBWords.addWord("LIKE", "H2");
        ReservedDBWords.addWord("LIMIT", "H2");
        ReservedDBWords.addWord("MINUS", "H2");
        ReservedDBWords.addWord("NATURAL", "H2");
        ReservedDBWords.addWord("NOT", "H2");
        ReservedDBWords.addWord("NULL", "H2");
        ReservedDBWords.addWord("OFFSET", "H2");
        ReservedDBWords.addWord("ON", "H2");
        ReservedDBWords.addWord("ORDER", "H2");
        ReservedDBWords.addWord("PRIMARY", "H2");
        ReservedDBWords.addWord("ROWNUM", "H2");
        ReservedDBWords.addWord("SELECT", "H2");
        ReservedDBWords.addWord("SYSDATE", "H2");
        ReservedDBWords.addWord("SYSTIME", "H2");
        ReservedDBWords.addWord("SYSTIMESTAMP", "H2");
        ReservedDBWords.addWord("TODAY", "H2");
        ReservedDBWords.addWord("TRUE", "H2");
        ReservedDBWords.addWord("UNION", "H2");
        ReservedDBWords.addWord("UNIQUE", "H2");
        ReservedDBWords.addWord("WHERE", "H2");
        ReservedDBWords.addWord("add", "Sybase");
        ReservedDBWords.addWord("all", "Sybase");
        ReservedDBWords.addWord("alter", "Sybase");
        ReservedDBWords.addWord("and", "Sybase");
        ReservedDBWords.addWord("any", "Sybase");
        ReservedDBWords.addWord("arith_overflow", "Sybase");
        ReservedDBWords.addWord("as", "Sybase");
        ReservedDBWords.addWord("asc", "Sybase");
        ReservedDBWords.addWord("at", "Sybase");
        ReservedDBWords.addWord("authorization", "Sybase");
        ReservedDBWords.addWord("avg", "Sybase");
        ReservedDBWords.addWord("begin", "Sybase");
        ReservedDBWords.addWord("between", "Sybase");
        ReservedDBWords.addWord("break", "Sybase");
        ReservedDBWords.addWord("browse", "Sybase");
        ReservedDBWords.addWord("bulk", "Sybase");
        ReservedDBWords.addWord("by", "Sybase");
        ReservedDBWords.addWord("cascade", "Sybase");
        ReservedDBWords.addWord("case", "Sybase");
        ReservedDBWords.addWord("char_convert", "Sybase");
        ReservedDBWords.addWord("check", "Sybase");
        ReservedDBWords.addWord("checkpoint", "Sybase");
        ReservedDBWords.addWord("close", "Sybase");
        ReservedDBWords.addWord("clustered", "Sybase");
        ReservedDBWords.addWord("coalesce", "Sybase");
        ReservedDBWords.addWord("commit", "Sybase");
        ReservedDBWords.addWord("compute", "Sybase");
        ReservedDBWords.addWord("confirm", "Sybase");
        ReservedDBWords.addWord("connect", "Sybase");
        ReservedDBWords.addWord("constraint", "Sybase");
        ReservedDBWords.addWord("continue", "Sybase");
        ReservedDBWords.addWord("controlrow", "Sybase");
        ReservedDBWords.addWord("convert", "Sybase");
        ReservedDBWords.addWord("count", "Sybase");
        ReservedDBWords.addWord("create", "Sybase");
        ReservedDBWords.addWord("current", "Sybase");
        ReservedDBWords.addWord("cursor", "Sybase");
        ReservedDBWords.addWord("database", "Sybase");
        ReservedDBWords.addWord("dbcc", "Sybase");
        ReservedDBWords.addWord("deallocate", "Sybase");
        ReservedDBWords.addWord("declare", "Sybase");
        ReservedDBWords.addWord("default", "Sybase");
        ReservedDBWords.addWord("delete", "Sybase");
        ReservedDBWords.addWord("desc", "Sybase");
        ReservedDBWords.addWord("deterministic", "Sybase");
        ReservedDBWords.addWord("diskdistinct", "Sybase");
        ReservedDBWords.addWord("double", "Sybase");
        ReservedDBWords.addWord("drop", "Sybase");
        ReservedDBWords.addWord("dummy", "Sybase");
        ReservedDBWords.addWord("dump", "Sybase");
        ReservedDBWords.addWord("else", "Sybase");
        ReservedDBWords.addWord("end", "Sybase");
        ReservedDBWords.addWord("endtran", "Sybase");
        ReservedDBWords.addWord("errlvl", "Sybase");
        ReservedDBWords.addWord("errordata", "Sybase");
        ReservedDBWords.addWord("errorexit", "Sybase");
        ReservedDBWords.addWord("escape", "Sybase");
        ReservedDBWords.addWord("except", "Sybase");
        ReservedDBWords.addWord("exclusive", "Sybase");
        ReservedDBWords.addWord("exec", "Sybase");
        ReservedDBWords.addWord("execute", "Sybase");
        ReservedDBWords.addWord("exists", "Sybase");
        ReservedDBWords.addWord("exit", "Sybase");
        ReservedDBWords.addWord("exp_row_size", "Sybase");
        ReservedDBWords.addWord("external", "Sybase");
        ReservedDBWords.addWord("fetch", "Sybase");
        ReservedDBWords.addWord("fillfactor", "Sybase");
        ReservedDBWords.addWord("for", "Sybase");
        ReservedDBWords.addWord("foreign", "Sybase");
        ReservedDBWords.addWord("from", "Sybase");
        ReservedDBWords.addWord("func", "Sybase");
        ReservedDBWords.addWord("goto", "Sybase");
        ReservedDBWords.addWord("grant", "Sybase");
        ReservedDBWords.addWord("group", "Sybase");
        ReservedDBWords.addWord("having", "Sybase");
        ReservedDBWords.addWord("holdlock", "Sybase");
        ReservedDBWords.addWord("identity", "Sybase");
        ReservedDBWords.addWord("identity_gap", "Sybase");
        ReservedDBWords.addWord("identity_insert", "Sybase");
        ReservedDBWords.addWord("identity_start", "Sybase");
        ReservedDBWords.addWord("if", "Sybase");
        ReservedDBWords.addWord("in", "Sybase");
        ReservedDBWords.addWord("index", "Sybase");
        ReservedDBWords.addWord("inout", "Sybase");
        ReservedDBWords.addWord("insert", "Sybase");
        ReservedDBWords.addWord("install", "Sybase");
        ReservedDBWords.addWord("intersect", "Sybase");
        ReservedDBWords.addWord("into", "Sybase");
        ReservedDBWords.addWord("is", "Sybase");
        ReservedDBWords.addWord("isolation", "Sybase");
        ReservedDBWords.addWord("jar", "Sybase");
        ReservedDBWords.addWord("join", "Sybase");
        ReservedDBWords.addWord("key", "Sybase");
        ReservedDBWords.addWord("kill", "Sybase");
        ReservedDBWords.addWord("level", "Sybase");
        ReservedDBWords.addWord("like", "Sybase");
        ReservedDBWords.addWord("lineno", "Sybase");
        ReservedDBWords.addWord("load", "Sybase");
        ReservedDBWords.addWord("lock", "Sybase");
        ReservedDBWords.addWord("max", "Sybase");
        ReservedDBWords.addWord("max_rows_per_page", "Sybase");
        ReservedDBWords.addWord("min", "Sybase");
        ReservedDBWords.addWord("mirror", "Sybase");
        ReservedDBWords.addWord("mirrorexit", "Sybase");
        ReservedDBWords.addWord("modify", "Sybase");
        ReservedDBWords.addWord("national", "Sybase");
        ReservedDBWords.addWord("new", "Sybase");
        ReservedDBWords.addWord("noholdlock", "Sybase");
        ReservedDBWords.addWord("nonclustered", "Sybase");
        ReservedDBWords.addWord("not", "Sybase");
        ReservedDBWords.addWord("null", "Sybase");
        ReservedDBWords.addWord("nullif", "Sybase");
        ReservedDBWords.addWord("numeric_truncation", "Sybase");
        ReservedDBWords.addWord("of", "Sybase");
        ReservedDBWords.addWord("off", "Sybase");
        ReservedDBWords.addWord("offsets", "Sybase");
        ReservedDBWords.addWord("on", "Sybase");
        ReservedDBWords.addWord("once", "Sybase");
        ReservedDBWords.addWord("online", "Sybase");
        ReservedDBWords.addWord("only", "Sybase");
        ReservedDBWords.addWord("open", "Sybase");
        ReservedDBWords.addWord("option", "Sybase");
        ReservedDBWords.addWord("or", "Sybase");
        ReservedDBWords.addWord("order", "Sybase");
        ReservedDBWords.addWord("out", "Sybase");
        ReservedDBWords.addWord("output", "Sybase");
        ReservedDBWords.addWord("over", "Sybase");
        ReservedDBWords.addWord("partition", "Sybase");
        ReservedDBWords.addWord("perm", "Sybase");
        ReservedDBWords.addWord("permanent", "Sybase");
        ReservedDBWords.addWord("plan", "Sybase");
        ReservedDBWords.addWord("precision", "Sybase");
        ReservedDBWords.addWord("prepare", "Sybase");
        ReservedDBWords.addWord("primary", "Sybase");
        ReservedDBWords.addWord("print", "Sybase");
        ReservedDBWords.addWord("privileges", "Sybase");
        ReservedDBWords.addWord("proc", "Sybase");
        ReservedDBWords.addWord("procedure", "Sybase");
        ReservedDBWords.addWord("processexit", "Sybase");
        ReservedDBWords.addWord("proxy_table", "Sybase");
        ReservedDBWords.addWord("public", "Sybase");
        ReservedDBWords.addWord("quiesce", "Sybase");
        ReservedDBWords.addWord("raiserror", "Sybase");
        ReservedDBWords.addWord("read", "Sybase");
        ReservedDBWords.addWord("readpast", "Sybase");
        ReservedDBWords.addWord("readtext", "Sybase");
        ReservedDBWords.addWord("reconfigure", "Sybase");
        ReservedDBWords.addWord("referencesremove", "Sybase");
        ReservedDBWords.addWord("reorg", "Sybase");
        ReservedDBWords.addWord("replace", "Sybase");
        ReservedDBWords.addWord("replication", "Sybase");
        ReservedDBWords.addWord("reservepagegap", "Sybase");
        ReservedDBWords.addWord("return", "Sybase");
        ReservedDBWords.addWord("returns", "Sybase");
        ReservedDBWords.addWord("revoke", "Sybase");
        ReservedDBWords.addWord("role", "Sybase");
        ReservedDBWords.addWord("rollback", "Sybase");
        ReservedDBWords.addWord("rowcount", "Sybase");
        ReservedDBWords.addWord("rows", "Sybase");
        ReservedDBWords.addWord("rule", "Sybase");
        ReservedDBWords.addWord("save", "Sybase");
        ReservedDBWords.addWord("schema", "Sybase");
        ReservedDBWords.addWord("select", "Sybase");
        ReservedDBWords.addWord("set", "Sybase");
        ReservedDBWords.addWord("setuser", "Sybase");
        ReservedDBWords.addWord("shared", "Sybase");
        ReservedDBWords.addWord("shutdown", "Sybase");
        ReservedDBWords.addWord("some", "Sybase");
        ReservedDBWords.addWord("statistics", "Sybase");
        ReservedDBWords.addWord("stringsize", "Sybase");
        ReservedDBWords.addWord("stripe", "Sybase");
        ReservedDBWords.addWord("sum", "Sybase");
        ReservedDBWords.addWord("syb_identity", "Sybase");
        ReservedDBWords.addWord("syb_restree", "Sybase");
        ReservedDBWords.addWord("syb_terminate", "Sybase");
        ReservedDBWords.addWord("table", "Sybase");
        ReservedDBWords.addWord("temp", "Sybase");
        ReservedDBWords.addWord("temporary", "Sybase");
        ReservedDBWords.addWord("textsize", "Sybase");
        ReservedDBWords.addWord("to", "Sybase");
        ReservedDBWords.addWord("tran", "Sybase");
        ReservedDBWords.addWord("transaction", "Sybase");
        ReservedDBWords.addWord("trigger", "Sybase");
        ReservedDBWords.addWord("truncate", "Sybase");
        ReservedDBWords.addWord("tsequal", "Sybase");
        ReservedDBWords.addWord("union", "Sybase");
        ReservedDBWords.addWord("unique", "Sybase");
        ReservedDBWords.addWord("unpartition", "Sybase");
        ReservedDBWords.addWord("update", "Sybase");
        ReservedDBWords.addWord("use", "Sybase");
        ReservedDBWords.addWord("user", "Sybase");
        ReservedDBWords.addWord("user_option", "Sybase");
        ReservedDBWords.addWord("using", "Sybase");
        ReservedDBWords.addWord("values", "Sybase");
        ReservedDBWords.addWord("varying", "Sybase");
        ReservedDBWords.addWord("view", "Sybase");
        ReservedDBWords.addWord("waitfor", "Sybase");
        ReservedDBWords.addWord("when", "Sybase");
        ReservedDBWords.addWord("where", "Sybase");
        ReservedDBWords.addWord("while", "Sybase");
        ReservedDBWords.addWord("with", "Sybase");
        ReservedDBWords.addWord("work", "Sybase");
        ReservedDBWords.addWord("writetext", "Sybase");
        ReservedDBWords.addWord("ADD", "Firebird");
        ReservedDBWords.addWord("ADMIN", "Firebird");
        ReservedDBWords.addWord("ALL", "Firebird");
        ReservedDBWords.addWord("ALTER", "Firebird");
        ReservedDBWords.addWord("AND", "Firebird");
        ReservedDBWords.addWord("ANY", "Firebird");
        ReservedDBWords.addWord("AS", "Firebird");
        ReservedDBWords.addWord("AT", "Firebird");
        ReservedDBWords.addWord("AVG", "Firebird");
        ReservedDBWords.addWord("BEGIN", "Firebird");
        ReservedDBWords.addWord("BETWEEN", "Firebird");
        ReservedDBWords.addWord("BIGINT", "Firebird");
        ReservedDBWords.addWord("BIT_LENGTH", "Firebird");
        ReservedDBWords.addWord("BLOB", "Firebird");
        ReservedDBWords.addWord("BOTH", "Firebird");
        ReservedDBWords.addWord("BY", "Firebird");
        ReservedDBWords.addWord("CASE", "Firebird");
        ReservedDBWords.addWord("CAST", "Firebird");
        ReservedDBWords.addWord("CHAR", "Firebird");
        ReservedDBWords.addWord("CHAR_LENGTH", "Firebird");
        ReservedDBWords.addWord("CHARACTER", "Firebird");
        ReservedDBWords.addWord("CHARACTER_LENGTH", "Firebird");
        ReservedDBWords.addWord("CHECK", "Firebird");
        ReservedDBWords.addWord("CLOSE", "Firebird");
        ReservedDBWords.addWord("COLLATE", "Firebird");
        ReservedDBWords.addWord("COLUMN", "Firebird");
        ReservedDBWords.addWord("COMMIT", "Firebird");
        ReservedDBWords.addWord("CONNECT", "Firebird");
        ReservedDBWords.addWord("CONSTRAINT", "Firebird");
        ReservedDBWords.addWord("COUNT", "Firebird");
        ReservedDBWords.addWord("CREATE", "Firebird");
        ReservedDBWords.addWord("CROSS", "Firebird");
        ReservedDBWords.addWord("CURRENT", "Firebird");
        ReservedDBWords.addWord("CURRENT_CONNECTION", "Firebird");
        ReservedDBWords.addWord("CURRENT_DATE", "Firebird");
        ReservedDBWords.addWord("CURRENT_ROLE", "Firebird");
        ReservedDBWords.addWord("CURRENT_TIME", "Firebird");
        ReservedDBWords.addWord("CURRENT_TIMESTAMP", "Firebird");
        ReservedDBWords.addWord("CURRENT_TRANSACTION", "Firebird");
        ReservedDBWords.addWord("CURRENT_USER", "Firebird");
        ReservedDBWords.addWord("CURSOR", "Firebird");
        ReservedDBWords.addWord("DATE", "Firebird");
        ReservedDBWords.addWord("DAY", "Firebird");
        ReservedDBWords.addWord("DEC", "Firebird");
        ReservedDBWords.addWord("DECIMAL", "Firebird");
        ReservedDBWords.addWord("DECLARE", "Firebird");
        ReservedDBWords.addWord("DEFAULT", "Firebird");
        ReservedDBWords.addWord("DELETE", "Firebird");
        ReservedDBWords.addWord("DISCONNECT", "Firebird");
        ReservedDBWords.addWord("DISTINCT", "Firebird");
        ReservedDBWords.addWord("DOUBLE", "Firebird");
        ReservedDBWords.addWord("DROP", "Firebird");
        ReservedDBWords.addWord("ELSE", "Firebird");
        ReservedDBWords.addWord("END", "Firebird");
        ReservedDBWords.addWord("ESCAPE", "Firebird");
        ReservedDBWords.addWord("EXECUTE", "Firebird");
        ReservedDBWords.addWord("EXISTS", "Firebird");
        ReservedDBWords.addWord("EXTERNAL", "Firebird");
        ReservedDBWords.addWord("EXTRACT", "Firebird");
        ReservedDBWords.addWord("FETCH", "Firebird");
        ReservedDBWords.addWord("FILTER", "Firebird");
        ReservedDBWords.addWord("FLOAT", "Firebird");
        ReservedDBWords.addWord("FOR", "Firebird");
        ReservedDBWords.addWord("FOREIGN", "Firebird");
        ReservedDBWords.addWord("FROM", "Firebird");
        ReservedDBWords.addWord("FULL", "Firebird");
        ReservedDBWords.addWord("FUNCTION", "Firebird");
        ReservedDBWords.addWord("GDSCODE", "Firebird");
        ReservedDBWords.addWord("GLOBAL", "Firebird");
        ReservedDBWords.addWord("GRANT", "Firebird");
        ReservedDBWords.addWord("GROUP", "Firebird");
        ReservedDBWords.addWord("HAVING", "Firebird");
        ReservedDBWords.addWord("HOUR", "Firebird");
        ReservedDBWords.addWord("IN", "Firebird");
        ReservedDBWords.addWord("INDEX", "Firebird");
        ReservedDBWords.addWord("INNER", "Firebird");
        ReservedDBWords.addWord("INSENSITIVE", "Firebird");
        ReservedDBWords.addWord("INSERT", "Firebird");
        ReservedDBWords.addWord("INT", "Firebird");
        ReservedDBWords.addWord("INTEGER", "Firebird");
        ReservedDBWords.addWord("INTO", "Firebird");
        ReservedDBWords.addWord("IS", "Firebird");
        ReservedDBWords.addWord("JOIN", "Firebird");
        ReservedDBWords.addWord("LEADING", "Firebird");
        ReservedDBWords.addWord("LEFT", "Firebird");
        ReservedDBWords.addWord("LIKE", "Firebird");
        ReservedDBWords.addWord("LONG", "Firebird");
        ReservedDBWords.addWord("LOWER", "Firebird");
        ReservedDBWords.addWord("MAX", "Firebird");
        ReservedDBWords.addWord("MAXIMUM_SEGMENT", "Firebird");
        ReservedDBWords.addWord("MERGE", "Firebird");
        ReservedDBWords.addWord("MIN", "Firebird");
        ReservedDBWords.addWord("MINUTE", "Firebird");
        ReservedDBWords.addWord("MONTH", "Firebird");
        ReservedDBWords.addWord("NATIONAL", "Firebird");
        ReservedDBWords.addWord("NATURAL", "Firebird");
        ReservedDBWords.addWord("NCHAR", "Firebird");
        ReservedDBWords.addWord("NO", "Firebird");
        ReservedDBWords.addWord("NOT", "Firebird");
        ReservedDBWords.addWord("NULL", "Firebird");
        ReservedDBWords.addWord("NUMERIC", "Firebird");
        ReservedDBWords.addWord("OCTET_LENGTH", "Firebird");
        ReservedDBWords.addWord("OF", "Firebird");
        ReservedDBWords.addWord("ON", "Firebird");
        ReservedDBWords.addWord("ONLY", "Firebird");
        ReservedDBWords.addWord("OPEN", "Firebird");
        ReservedDBWords.addWord("OR", "Firebird");
        ReservedDBWords.addWord("ORDER", "Firebird");
        ReservedDBWords.addWord("OUTER", "Firebird");
        ReservedDBWords.addWord("PARAMETER", "Firebird");
        ReservedDBWords.addWord("PLAN", "Firebird");
        ReservedDBWords.addWord("POSITION", "Firebird");
        ReservedDBWords.addWord("POST_EVENT", "Firebird");
        ReservedDBWords.addWord("PRECISION", "Firebird");
        ReservedDBWords.addWord("PRIMARY", "Firebird");
        ReservedDBWords.addWord("PROCEDURE", "Firebird");
        ReservedDBWords.addWord("RDB$DB_KEY", "Firebird");
        ReservedDBWords.addWord("REAL", "Firebird");
        ReservedDBWords.addWord("RECORD_VERSION", "Firebird");
        ReservedDBWords.addWord("RECREATE", "Firebird");
        ReservedDBWords.addWord("RECURSIVE", "Firebird");
        ReservedDBWords.addWord("REFERENCES", "Firebird");
        ReservedDBWords.addWord("RELEASE", "Firebird");
        ReservedDBWords.addWord("RETURNING_VALUES", "Firebird");
        ReservedDBWords.addWord("RETURNS", "Firebird");
        ReservedDBWords.addWord("REVOKE", "Firebird");
        ReservedDBWords.addWord("RIGHT", "Firebird");
        ReservedDBWords.addWord("ROLLBACK", "Firebird");
        ReservedDBWords.addWord("ROW_COUNT", "Firebird");
        ReservedDBWords.addWord("ROWS", "Firebird");
        ReservedDBWords.addWord("SAVEPOINT", "Firebird");
        ReservedDBWords.addWord("SECOND", "Firebird");
        ReservedDBWords.addWord("SELECT", "Firebird");
        ReservedDBWords.addWord("SENSITIVE", "Firebird");
        ReservedDBWords.addWord("SET", "Firebird");
        ReservedDBWords.addWord("SIMILAR", "Firebird");
        ReservedDBWords.addWord("SMALLINT", "Firebird");
        ReservedDBWords.addWord("SOME", "Firebird");
        ReservedDBWords.addWord("SQLCODE", "Firebird");
        ReservedDBWords.addWord("SQLSTATE(2.5.1)", "Firebird");
        ReservedDBWords.addWord("START", "Firebird");
        ReservedDBWords.addWord("SUM", "Firebird");
        ReservedDBWords.addWord("TABLE", "Firebird");
        ReservedDBWords.addWord("THEN", "Firebird");
        ReservedDBWords.addWord("TIME", "Firebird");
        ReservedDBWords.addWord("TIMESTAMP", "Firebird");
        ReservedDBWords.addWord("TO", "Firebird");
        ReservedDBWords.addWord("TRAILING", "Firebird");
        ReservedDBWords.addWord("TRIGGER", "Firebird");
        ReservedDBWords.addWord("TRIM", "Firebird");
        ReservedDBWords.addWord("UNION", "Firebird");
        ReservedDBWords.addWord("UNIQUE", "Firebird");
        ReservedDBWords.addWord("UPDATE", "Firebird");
        ReservedDBWords.addWord("UPPER", "Firebird");
        ReservedDBWords.addWord("USER", "Firebird");
        ReservedDBWords.addWord("USING", "Firebird");
        ReservedDBWords.addWord("VALUE", "Firebird");
        ReservedDBWords.addWord("VALUES", "Firebird");
        ReservedDBWords.addWord("VARCHAR", "Firebird");
        ReservedDBWords.addWord("VARIABLE", "Firebird");
        ReservedDBWords.addWord("VARYING", "Firebird");
        ReservedDBWords.addWord("VIEW", "Firebird");
        ReservedDBWords.addWord("WHEN", "Firebird");
        ReservedDBWords.addWord("WHERE", "Firebird");
        ReservedDBWords.addWord("WHILE", "Firebird");
        ReservedDBWords.addWord("WITH", "Firebird");
        ReservedDBWords.addWord("YEAR", "Firebird");
    }
}

