/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.DialectLogger;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.model.AutoIdGenerator;
import com.github.drinkjava2.jdialects.model.Column;
import com.github.drinkjava2.jdialects.model.FKeyConstraint;
import com.github.drinkjava2.jdialects.model.InlineFKeyConstraint;
import com.github.drinkjava2.jdialects.model.Sequence;
import com.github.drinkjava2.jdialects.model.Table;
import com.github.drinkjava2.jdialects.model.TableGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DDLCreateUtils {
    private static DialectLogger logger = DialectLogger.getLog(DDLCreateUtils.class);

    public static String[] toCreateDDL(Dialect dialect, Table ... tables) {
        ArrayList<Object> objectResultList = new ArrayList<Object>();
        for (Table table : tables) {
            DDLCreateUtils.transferTableToObjectList(dialect, table, objectResultList);
        }
        ArrayList<String> stringResultList = new ArrayList<String>();
        ArrayList<TableGenerator> tbGeneratorList = new ArrayList<TableGenerator>();
        ArrayList<Sequence> sequenceList = new ArrayList<Sequence>();
        ArrayList<AutoIdGenerator> autoIdGeneratorList = new ArrayList<AutoIdGenerator>();
        ArrayList<InlineFKeyConstraint> inlinefKeyConstraintList = new ArrayList<InlineFKeyConstraint>();
        ArrayList<FKeyConstraint> fKeyConstraintList = new ArrayList<FKeyConstraint>();
        for (Object e : objectResultList) {
            if (StrUtils.isEmpty(e)) continue;
            if (e instanceof String) {
                stringResultList.add((String)e);
                continue;
            }
            if (e instanceof TableGenerator) {
                tbGeneratorList.add((TableGenerator)e);
                continue;
            }
            if (e instanceof Sequence) {
                sequenceList.add((Sequence)e);
                continue;
            }
            if (e instanceof AutoIdGenerator) {
                autoIdGeneratorList.add((AutoIdGenerator)e);
                continue;
            }
            if (e instanceof InlineFKeyConstraint) {
                inlinefKeyConstraintList.add((InlineFKeyConstraint)e);
                continue;
            }
            if (!(e instanceof FKeyConstraint)) continue;
            fKeyConstraintList.add((FKeyConstraint)e);
        }
        DDLCreateUtils.buildSequenceDDL(dialect, stringResultList, sequenceList);
        DDLCreateUtils.buildTableGeneratorDDL(dialect, stringResultList, tbGeneratorList);
        DDLCreateUtils.buildAutoIdGeneratorDDL(dialect, stringResultList, autoIdGeneratorList);
        DDLCreateUtils.buildFKeyConstraintDDL(dialect, stringResultList, inlinefKeyConstraintList);
        DDLCreateUtils.outputFKeyConstraintDDL(dialect, stringResultList, fKeyConstraintList);
        return stringResultList.toArray(new String[stringResultList.size()]);
    }

    private static void transferTableToObjectList(Dialect dialect, Table t, List<Object> objectResultList) {
        DDLFeatures features = dialect.ddlFeatures;
        StringBuilder buf = new StringBuilder();
        boolean hasPkey = false;
        String pkeys = "";
        String tableName = t.getTableName();
        Map<String, Column> columns = t.getColumns();
        dialect.checkNotEmptyReservedWords(tableName, "Table name can not be empty");
        for (Column col : columns.values()) {
            dialect.checkNotEmptyReservedWords(col.getColumnName(), "Column name can not be empty");
            dialect.checkReservedWords(col.getPkeyName());
            dialect.checkReservedWords(col.getUniqueConstraintNames());
            dialect.checkReservedWords(col.getIndexNames());
        }
        for (Column col : columns.values()) {
            if (col.getAutoGenerator().booleanValue()) {
                if (features.supportBasicOrPooledSequence()) {
                    objectResultList.add(new Sequence("jdialects_autoid", "jdialects_autoid", 1, 1));
                } else {
                    objectResultList.add(new AutoIdGenerator());
                }
            }
            if (StrUtils.isEmpty(col.getFkeyReferenceTable())) continue;
            objectResultList.add(new InlineFKeyConstraint(tableName, col.getColumnName(), col.getFkeyReferenceTable(), col.getFkeyReferenceColumns()));
        }
        for (Sequence seq : t.getSequences().values()) {
            objectResultList.add(seq);
        }
        for (TableGenerator tableGenerator : t.getTableGenerators().values()) {
            objectResultList.add(tableGenerator);
        }
        for (FKeyConstraint fkey : t.getFkeyConstraints()) {
            objectResultList.add(fkey);
        }
        for (Column col : columns.values()) {
            if (!col.getPkey().booleanValue()) continue;
            hasPkey = true;
            if (StrUtils.isEmpty(pkeys)) {
                pkeys = col.getColumnName();
                continue;
            }
            pkeys = pkeys + "," + col.getColumnName();
        }
        buf.append(hasPkey ? dialect.ddlFeatures.createTableString : dialect.ddlFeatures.createMultisetTableString).append(" ").append(tableName).append(" (");
        for (Column c : columns.values()) {
            if (c.getColumnType() == null) {
                DialectException.throwEX("Type not set on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\"");
            }
            buf.append(c.getColumnName()).append(" ");
            if (c.getIdentity().booleanValue() && !features.supportsIdentityColumns.booleanValue()) {
                DialectException.throwEX("Unsupported identity setting for dialect \"" + (Object)((Object)dialect) + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\"");
            }
            if (c.getIdentity().booleanValue()) {
                if (features.hasDataTypeInIdentityColumn.booleanValue()) {
                    buf.append(dialect.translateToDDLType(c.getColumnType(), c.getLengths()));
                }
                buf.append(' ');
                if (Type.BIGINT.equals((Object)c.getColumnType())) {
                    buf.append(features.identityColumnStringBigINT);
                } else {
                    buf.append(features.identityColumnString);
                }
            } else {
                buf.append(dialect.translateToDDLType(c.getColumnType(), c.getLengths()));
                String defaultValue = c.getDefaultValue();
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (c.getNotNull().booleanValue()) {
                    buf.append(" not null");
                } else {
                    buf.append(features.nullColumnString);
                }
            }
            if (!StrUtils.isEmpty(c.getCheck())) {
                if (features.supportsColumnCheck.booleanValue()) {
                    buf.append(" check (").append(c.getCheck()).append(")");
                } else {
                    logger.warn("Ignore unsupported check setting for dialect \"" + (Object)((Object)dialect) + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\" with value: " + c.getCheck());
                }
            }
            if (c.getComment() != null) {
                if (StrUtils.isEmpty(features.columnComment) && !features.supportsCommentOn.booleanValue()) {
                    logger.warn("Ignore unsupported comment setting for dialect \"" + (Object)((Object)dialect) + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\" with value: " + c.getComment());
                } else {
                    buf.append(StrUtils.replace(features.columnComment, "_COMMENT", c.getComment()));
                }
            }
            if (!StrUtils.isEmpty(c.getTail())) {
                buf.append(c.getTail());
            }
            buf.append(",");
        }
        if (!StrUtils.isEmpty(pkeys)) {
            buf.append(" primary key (").append(pkeys).append("),");
        }
        if (!StrUtils.isEmpty(t.getCheck())) {
            if (features.supportsTableCheck.booleanValue()) {
                buf.append(" check (").append(t.getCheck()).append("),");
            } else {
                logger.warn("Ignore unsupported table check setting for dialect \"" + (Object)((Object)dialect) + "\" on table \"" + tableName + "\" with value: " + t.getCheck());
            }
        }
        buf.setLength(buf.length() - 1);
        buf.append(")");
        String tableTypeString = features.tableTypeString;
        if (!StrUtils.isEmpty(tableTypeString) && !"NOT_SUPPORT".equals(tableTypeString)) {
            buf.append(tableTypeString);
            if (!StrUtils.isEmpty(t.getEngineTail())) {
                buf.append(t.getEngineTail());
            }
        }
        objectResultList.add(buf.toString());
        if (t.getComment() != null) {
            if (features.supportsCommentOn.booleanValue()) {
                objectResultList.add("comment on table " + t.getTableName() + " is '" + t.getComment() + "'");
            } else {
                logger.warn("Ignore unsupported table comment setting for dialect \"" + (Object)((Object)dialect) + "\" on table \"" + tableName + "\" with value: " + t.getComment());
            }
        }
        for (Column c : columns.values()) {
            if (!features.supportsCommentOn.booleanValue() || c.getComment() == null || !StrUtils.isEmpty(features.columnComment)) continue;
            objectResultList.add("comment on column " + tableName + '.' + c.getColumnName() + " is '" + c.getComment() + "'");
        }
        DDLCreateUtils.buildUniqueDLL(dialect, objectResultList, tableName, columns);
        DDLCreateUtils.buildIndexDLL(dialect, objectResultList, tableName, columns);
    }

    private static void buildSequenceDDL(Dialect dialect, List<String> stringList, List<Sequence> sequenceList) {
        DDLFeatures features = dialect.ddlFeatures;
        for (Sequence seq : sequenceList) {
            DialectException.assureNotEmpty(seq.getName(), "Sequence name can not be empty");
            DialectException.assureNotEmpty(seq.getSequenceName(), "sequenceName can not be empty of \"" + seq.getName() + "\"");
        }
        for (Sequence seq : sequenceList) {
            for (Sequence seq2 : sequenceList) {
                if (seq == seq2 || seq2.getAllocationSize() == 0) continue;
                if (seq.getName().equalsIgnoreCase(seq2.getName())) {
                    seq.setAllocationSize(0);
                    continue;
                }
                if (!seq.getSequenceName().equalsIgnoreCase(seq2.getSequenceName())) continue;
                DialectException.throwEX("Dulplicated Sequence setting \"" + seq.getName() + "\" and \"" + seq2.getName() + "\" found.");
            }
        }
        HashSet<String> sequenceNameExisted = new HashSet<String>();
        for (Sequence seq : sequenceList) {
            String sequenceName;
            if (seq.getAllocationSize() == 0 || sequenceNameExisted.contains(sequenceName = seq.getSequenceName().toLowerCase())) continue;
            if (!features.supportBasicOrPooledSequence()) {
                DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support sequence setting on sequence \"" + seq.getName() + "\"");
            }
            if (features.supportsPooledSequences.booleanValue()) {
                String pooledSequence = StrUtils.replace(features.createPooledSequenceStrings, "_SEQ", seq.getSequenceName());
                pooledSequence = StrUtils.replace(pooledSequence, "11", "" + seq.getInitialValue());
                pooledSequence = StrUtils.replace(pooledSequence, "33", "" + seq.getAllocationSize());
                stringList.add(pooledSequence);
            } else {
                if (seq.getInitialValue() >= 2 || seq.getAllocationSize() >= 2) {
                    DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support initialValue and allocationSize setting on sequence \"" + seq.getName() + "\", try set initialValue and allocationSize to 1 to fix");
                }
                String simepleSeq = StrUtils.replace(features.createSequenceStrings, "_SEQ", seq.getSequenceName());
                stringList.add(simepleSeq);
            }
            sequenceNameExisted.add(sequenceName);
        }
    }

    private static void buildAutoIdGeneratorDDL(Dialect dialect, List<String> stringList, List<AutoIdGenerator> autoIdGenerator) {
        if (autoIdGenerator != null && autoIdGenerator.size() > 0) {
            stringList.add(dialect.ddlFeatures.createTableString + " " + "jdialects_autoid" + " (" + "next_val" + " " + dialect.translateToDDLType(Type.BIGINT, new Integer[0]) + " )");
            stringList.add("insert into jdialects_autoid values ( 1 )");
        }
    }

    private static void buildTableGeneratorDDL(Dialect dialect, List<String> stringList, List<TableGenerator> tbGeneratorList) {
        for (TableGenerator tg : tbGeneratorList) {
            DialectException.assureNotEmpty(tg.getName(), "TableGenerator name can not be empty");
            DialectException.assureNotEmpty(tg.getTableName(), "TableGenerator tableName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnName(), "TableGenerator pkColumnName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnValue(), "TableGenerator pkColumnValue can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getValueColumnName(), "TableGenerator valueColumnName can not be empty of \"" + tg.getName() + "\"");
        }
        for (TableGenerator tg : tbGeneratorList) {
            for (TableGenerator tg2 : tbGeneratorList) {
                if (tg == tg2 || tg2.getAllocationSize() == 0) continue;
                if (tg.getName().equalsIgnoreCase(tg2.getName())) {
                    tg.setAllocationSize(0);
                    continue;
                }
                if (!tg.getTableName().equalsIgnoreCase(tg2.getTableName()) || !tg.getPkColumnName().equalsIgnoreCase(tg2.getPkColumnName()) || !tg.getPkColumnValue().equalsIgnoreCase(tg2.getPkColumnValue()) || !tg.getValueColumnName().equalsIgnoreCase(tg2.getValueColumnName())) continue;
                DialectException.throwEX("Dulplicated tableGenerator setting \"" + tg.getName() + "\" and \"" + tg2.getName() + "\" found.");
            }
        }
        HashSet<String> tableExisted = new HashSet<String>();
        HashSet<String> columnExisted = new HashSet<String>();
        for (TableGenerator tg : tbGeneratorList) {
            if (tg.getAllocationSize() == 0) continue;
            String tableName = tg.getTableName().toLowerCase();
            String tableAndPKColumn = tg.getTableName().toLowerCase() + "..XXOO.." + tg.getPkColumnName();
            String tableAndValColumn = tg.getTableName().toLowerCase() + "..XXOO.." + tg.getValueColumnName();
            if (!tableExisted.contains(tableName)) {
                String s = dialect.ddlFeatures.createTableString + " " + tableName + " (";
                s = s + tg.getPkColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + ",";
                s = s + tg.getValueColumnName() + " " + dialect.translateToDDLType(Type.BIGINT, new Integer[0]) + " )";
                stringList.add(s);
                tableExisted.add(tableName);
                columnExisted.add(tableAndPKColumn);
                columnExisted.add(tableAndValColumn);
                continue;
            }
            if (!columnExisted.contains(tableAndPKColumn)) {
                stringList.add("alter table " + tableName + " " + dialect.ddlFeatures.addColumnString + " " + tg.getPkColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + " " + dialect.ddlFeatures.addColumnSuffixString);
                columnExisted.add(tableAndPKColumn);
            }
            if (columnExisted.contains(tableAndValColumn)) continue;
            stringList.add("alter table " + tableName + " " + dialect.ddlFeatures.addColumnString + " " + tg.getValueColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + " " + dialect.ddlFeatures.addColumnSuffixString);
            columnExisted.add(tableAndValColumn);
        }
    }

    private static void buildFKeyConstraintDDL(Dialect dialect, List<String> stringList, List<InlineFKeyConstraint> fKeyConstraintList) {
        for (InlineFKeyConstraint kfc : fKeyConstraintList) {
            dialect.checkNotEmptyReservedWords(kfc.getFkeyReferenceTable(), "FkeyReferenceTable can not be empty");
            for (String refColName : kfc.getRefColumnNames()) {
                dialect.checkNotEmptyReservedWords(refColName, "FkeyReferenceColumn name can not be empty");
            }
        }
        ArrayList<FKeyConstraint> trueList = new ArrayList<FKeyConstraint>();
        for (int i = 0; i < fKeyConstraintList.size(); ++i) {
            InlineFKeyConstraint fk = fKeyConstraintList.get(i);
            FKeyConstraint temp = new FKeyConstraint(fk);
            temp.getColumnNames().add(fk.getColumnName());
            if (i == 0) {
                trueList.add(temp);
                continue;
            }
            FKeyConstraint found = null;
            for (FKeyConstraint old : trueList) {
                if (!fk.getTableName().equals(old.getTableName()) || !fk.getFkeyReferenceTable().equals(old.getRefTableName()) || !StrUtils.arraysEqual(fk.getRefColumnNames(), old.getRefColumnNames())) continue;
                found = old;
            }
            if (found == null) {
                trueList.add(temp);
                continue;
            }
            found.getColumnNames().add(fk.getColumnName());
        }
        DDLCreateUtils.outputFKeyConstraintDDL(dialect, stringList, trueList);
    }

    private static void outputFKeyConstraintDDL(Dialect dialect, List<String> stringList, List<FKeyConstraint> trueList) {
        if ("NOT_SUPPORT".equals(dialect.ddlFeatures.addForeignKeyConstraintString)) {
            logger.warn("Dialect \"" + (Object)((Object)dialect) + "\" does not support foreign key setting, settings be ignored");
            return;
        }
        for (FKeyConstraint t : trueList) {
            String s = dialect.ddlFeatures.addForeignKeyConstraintString;
            s = StrUtils.replace(s, "_FK1, _FK2", StrUtils.listToString(t.getColumnNames()));
            s = StrUtils.replace(s, "_REF1, _REF2", StrUtils.arrayToString(t.getRefColumnNames()));
            s = StrUtils.replace(s, "_REFTABLE", t.getRefTableName());
            s = StrUtils.replace(s, "_FKEYNAME", "fk_" + t.getTableName().toLowerCase() + "_" + StrUtils.replace(StrUtils.listToString(t.getColumnNames()), ",", "_"));
            stringList.add("alter table " + t.getTableName() + " " + s);
        }
    }

    private static void buildIndexDLL(Dialect dialect, List<Object> objectResultList, String tableName, Map<String, Column> columns) {
        LinkedHashMap<String, String> indexes = new LinkedHashMap<String, String>();
        for (Column column : columns.values()) {
            if (!column.getIndex().booleanValue() || column.getUnique().booleanValue()) continue;
            String[] indexNames = column.getIndexNames();
            if (indexNames == null || indexNames.length == 0) {
                indexNames = new String[]{"IDX_" + tableName + "_" + column.getColumnName()};
            }
            for (String indexName : indexNames) {
                String indexedColumns = (String)indexes.get(indexName);
                if (StrUtils.isEmpty(indexedColumns)) {
                    indexes.put(indexName, column.getColumnName());
                    continue;
                }
                indexedColumns = indexedColumns + "," + column.getColumnName();
                indexes.put(indexName, indexedColumns);
            }
        }
        for (Map.Entry entry : indexes.entrySet()) {
            if (Dialect.Teradata14Dialect.equals((Object)dialect)) {
                objectResultList.add("create index " + (String)entry.getKey() + " (" + (String)entry.getValue() + ") on " + tableName);
                continue;
            }
            objectResultList.add("create index " + (String)entry.getKey() + " on " + tableName + " (" + (String)entry.getValue() + ")");
        }
    }

    private static void buildUniqueDLL(Dialect dialect, List<Object> objectResultList, String tableName, Map<String, Column> columns) {
        LinkedHashMap<String, String> ukMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> ukAllowNullMap = new LinkedHashMap<String, String>();
        for (Column column : columns.values()) {
            if (!column.getUnique().booleanValue()) continue;
            String[] ukNames = column.getUniqueConstraintNames();
            if (ukNames == null || ukNames.length == 0) {
                ukNames = new String[]{"UK_" + tableName + "_" + column.getColumnName()};
            }
            for (String ukName : ukNames) {
                String ukColumnNames = (String)ukMap.get(ukName);
                if (StrUtils.isEmpty(ukColumnNames)) {
                    ukMap.put(ukName, column.getColumnName());
                } else {
                    ukColumnNames = ukColumnNames + "," + column.getColumnName();
                    ukMap.put(ukName, ukColumnNames);
                }
                if (column.getNotNull().booleanValue()) continue;
                ukAllowNullMap.put(ukName, "AllowNull");
            }
        }
        for (Map.Entry entry : ukMap.entrySet()) {
            String template = "alter table $TABLE add constraint $UKNAME unique ($COLUMNS)";
            String DialectName = "" + (Object)((Object)dialect);
            if ((StrUtils.startsWithIgnoreCase(DialectName, "DB2") || StrUtils.startsWithIgnoreCase(DialectName, "DERBY")) && "AllowNull".equals(ukAllowNullMap.get(entry.getKey()))) {
                template = "create unique index $UKNAME on $TABLE ($COLUMNS)";
            } else if (StrUtils.startsWithIgnoreCase(DialectName, "Informix")) {
                template = "alter table $TABLE add constraint unique ($COLUMNS) constraint $UKNAME";
            }
            String uniqueConstraintDDL = StrUtils.replace(template, "$TABLE", tableName);
            uniqueConstraintDDL = StrUtils.replace(uniqueConstraintDDL, "$UKNAME", (String)entry.getKey());
            uniqueConstraintDDL = StrUtils.replace(uniqueConstraintDDL, "$COLUMNS", (String)entry.getValue());
            objectResultList.add(uniqueConstraintDDL);
        }
    }
}

