/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.model.AutoIdGenerator;
import com.github.drinkjava2.jdialects.model.Column;
import com.github.drinkjava2.jdialects.model.FKeyConstraint;
import com.github.drinkjava2.jdialects.model.InlineFKeyConstraint;
import com.github.drinkjava2.jdialects.model.Sequence;
import com.github.drinkjava2.jdialects.model.Table;
import com.github.drinkjava2.jdialects.model.TableGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DDLDropUtils {
    public static String[] toDropDDL(Dialect dialect, Table ... tables) {
        ArrayList<Object> objectResultList = new ArrayList<Object>();
        for (Table table : tables) {
            DDLDropUtils.transferTableToObjectList(dialect, table, objectResultList);
        }
        ArrayList<String> stringResultList = new ArrayList<String>();
        ArrayList<TableGenerator> tbGeneratorList = new ArrayList<TableGenerator>();
        ArrayList<Sequence> sequenceList = new ArrayList<Sequence>();
        ArrayList<AutoIdGenerator> globalIdGeneratorList = new ArrayList<AutoIdGenerator>();
        ArrayList<InlineFKeyConstraint> inlinefKeyConstraintList = new ArrayList<InlineFKeyConstraint>();
        ArrayList<FKeyConstraint> fKeyConstraintList = new ArrayList<FKeyConstraint>();
        for (Object e : objectResultList) {
            if (StrUtils.isEmpty(e)) continue;
            if (e instanceof String) {
                stringResultList.add((String)e);
                continue;
            }
            if (e instanceof TableGenerator) {
                tbGeneratorList.add((TableGenerator)e);
                continue;
            }
            if (e instanceof Sequence) {
                sequenceList.add((Sequence)e);
                continue;
            }
            if (e instanceof AutoIdGenerator) {
                globalIdGeneratorList.add((AutoIdGenerator)e);
                continue;
            }
            if (e instanceof InlineFKeyConstraint) {
                inlinefKeyConstraintList.add((InlineFKeyConstraint)e);
                continue;
            }
            if (!(e instanceof FKeyConstraint)) continue;
            fKeyConstraintList.add((FKeyConstraint)e);
        }
        DDLDropUtils.buildDropSequenceDDL(dialect, stringResultList, sequenceList);
        DDLDropUtils.buildDropTableGeneratorDDL(dialect, stringResultList, tbGeneratorList);
        DDLDropUtils.buildDropGolbalIDGeneratorDDL(dialect, stringResultList, globalIdGeneratorList);
        DDLDropUtils.buildDropFKeyConstraintDDL(dialect, stringResultList, inlinefKeyConstraintList);
        DDLDropUtils.outputDropFKeyConstraintDDL(dialect, stringResultList, fKeyConstraintList);
        return stringResultList.toArray(new String[stringResultList.size()]);
    }

    private static void transferTableToObjectList(Dialect dialect, Table t, List<Object> objectResultList) {
        DDLFeatures features = dialect.ddlFeatures;
        StringBuilder buf = new StringBuilder();
        String tableName = t.getTableName();
        Map<String, Column> columns = t.getColumns();
        dialect.checkNotEmptyReservedWords(tableName, "Table name can not be empty");
        for (Column col : columns.values()) {
            dialect.checkNotEmptyReservedWords(col.getColumnName(), "Column name can not be empty");
            dialect.checkReservedWords(col.getPkeyName());
            dialect.checkReservedWords(col.getUniqueConstraintNames());
            dialect.checkReservedWords(col.getIndexNames());
        }
        for (Column col : columns.values()) {
            if (col.getAutoGenerator().booleanValue()) {
                if (features.supportBasicOrPooledSequence()) {
                    objectResultList.add(new Sequence("jdialects_autoid", "jdialects_autoid", 1, 1));
                } else {
                    objectResultList.add(new AutoIdGenerator());
                }
            }
            if (StrUtils.isEmpty(col.getFkeyReferenceTable())) continue;
            objectResultList.add(new InlineFKeyConstraint(tableName, col.getColumnName(), col.getFkeyReferenceTable(), col.getFkeyReferenceColumns()));
        }
        for (Sequence seq : t.getSequences().values()) {
            objectResultList.add(seq);
        }
        for (TableGenerator tableGenerator : t.getTableGenerators().values()) {
            objectResultList.add(tableGenerator);
        }
        for (FKeyConstraint fkey : t.getFkeyConstraints()) {
            objectResultList.add(fkey);
        }
        buf.append(dialect.dropTableDDL(tableName));
        objectResultList.add(buf.toString());
    }

    private static void buildDropSequenceDDL(Dialect dialect, List<String> stringResultList, List<Sequence> sequenceList) {
        DDLFeatures features = dialect.ddlFeatures;
        for (Sequence seq : sequenceList) {
            DialectException.assureNotEmpty(seq.getName(), "Sequence name can not be empty");
            DialectException.assureNotEmpty(seq.getSequenceName(), "sequenceName can not be empty of \"" + seq.getName() + "\"");
        }
        for (Sequence seq : sequenceList) {
            for (Sequence seq2 : sequenceList) {
                if (seq == seq2 || seq2.getAllocationSize() == 0) continue;
                if (seq.getName().equalsIgnoreCase(seq2.getName())) {
                    seq.setAllocationSize(0);
                    continue;
                }
                if (!seq.getSequenceName().equalsIgnoreCase(seq2.getSequenceName())) continue;
                DialectException.throwEX("Dulplicated Sequence setting \"" + seq.getName() + "\" and \"" + seq2.getName() + "\" found.");
            }
        }
        HashSet<String> sequenceNameExisted = new HashSet<String>();
        for (Sequence seq : sequenceList) {
            String sequenceName;
            if (seq.getAllocationSize() == 0 || sequenceNameExisted.contains(sequenceName = seq.getSequenceName().toLowerCase())) continue;
            if (!features.supportBasicOrPooledSequence()) {
                DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support sequence setting on sequence \"" + seq.getName() + "\"");
            }
            if (!"NOT_SUPPORT".equals(features.dropSequenceStrings) && !StrUtils.isEmpty(features.dropSequenceStrings)) {
                stringResultList.add(0, StrUtils.replace(features.dropSequenceStrings, "_SEQNAME", seq.getSequenceName()));
            } else {
                DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support drop sequence ddl, on sequence \"" + seq.getName() + "\"");
            }
            sequenceNameExisted.add(sequenceName);
        }
    }

    private static void buildDropTableGeneratorDDL(Dialect dialect, List<String> stringResultList, List<TableGenerator> tbGeneratorList) {
        for (TableGenerator tg : tbGeneratorList) {
            DialectException.assureNotEmpty(tg.getName(), "TableGenerator name can not be empty");
            DialectException.assureNotEmpty(tg.getTableName(), "TableGenerator tableName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnName(), "TableGenerator pkColumnName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnValue(), "TableGenerator pkColumnValue can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getValueColumnName(), "TableGenerator valueColumnName can not be empty of \"" + tg.getName() + "\"");
        }
        HashSet<String> tableExisted = new HashSet<String>();
        for (TableGenerator tg : tbGeneratorList) {
            String tableName = tg.getTableName().toLowerCase();
            if (tableExisted.contains(tableName)) continue;
            stringResultList.add(0, dialect.dropTableDDL(tableName));
            tableExisted.add(tableName);
        }
    }

    private static void buildDropGolbalIDGeneratorDDL(Dialect dialect, List<String> stringResultList, List<AutoIdGenerator> globalIdGeneratorList) {
        if (globalIdGeneratorList != null && globalIdGeneratorList.size() > 0) {
            stringResultList.add(0, dialect.dropTableDDL("jdialects_autoid"));
        }
    }

    private static void buildDropFKeyConstraintDDL(Dialect dialect, List<String> stringResultList, List<InlineFKeyConstraint> fKeyConstraintList) {
        for (InlineFKeyConstraint kfc : fKeyConstraintList) {
            dialect.checkNotEmptyReservedWords(kfc.getFkeyReferenceTable(), "FkeyReferenceTable can not be empty");
            for (String refColName : kfc.getRefColumnNames()) {
                dialect.checkNotEmptyReservedWords(refColName, "FkeyReferenceColumn name can not be empty");
            }
        }
        ArrayList<FKeyConstraint> trueList = new ArrayList<FKeyConstraint>();
        for (int i = 0; i < fKeyConstraintList.size(); ++i) {
            InlineFKeyConstraint fk = fKeyConstraintList.get(i);
            FKeyConstraint temp = new FKeyConstraint(fk);
            temp.getColumnNames().add(fk.getColumnName());
            if (i == 0) {
                trueList.add(temp);
                continue;
            }
            FKeyConstraint found = null;
            for (FKeyConstraint old : trueList) {
                if (!fk.getTableName().equals(old.getTableName()) || !fk.getFkeyReferenceTable().equals(old.getRefTableName()) || !StrUtils.arraysEqual(fk.getRefColumnNames(), old.getRefColumnNames())) continue;
                found = old;
            }
            if (found == null) {
                trueList.add(temp);
                continue;
            }
            found.getColumnNames().add(fk.getColumnName());
        }
        DDLDropUtils.outputDropFKeyConstraintDDL(dialect, stringResultList, trueList);
    }

    private static void outputDropFKeyConstraintDDL(Dialect dialect, List<String> stringResultList, List<FKeyConstraint> trueList) {
        if ("NOT_SUPPORT".equals(dialect.ddlFeatures.addForeignKeyConstraintString)) {
            return;
        }
        for (FKeyConstraint t : trueList) {
            String dropStr = dialect.ddlFeatures.dropForeignKeyString;
            String fkname = "fk_" + t.getTableName().toLowerCase() + "_" + StrUtils.replace(StrUtils.listToString(t.getColumnNames()), ",", "_");
            if ("NOT_SUPPORT".equals(dropStr)) {
                DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support drop foreign key, for setting: \"" + "fk_" + fkname + "\"");
            }
            stringResultList.add(0, "alter table " + t.getTableName() + " " + dropStr + " " + fkname);
        }
    }
}

