/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class DialectJdbcUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long hotExecuteQuery(Connection conn, String sql) throws SQLException {
        PreparedStatement pst = null;
        SQLException exception = null;
        try {
            pst = conn.prepareStatement(sql);
            ResultSet rs = pst.executeQuery();
            rs.next();
            Long l = rs.getLong(1);
            return l;
        }
        catch (SQLException e) {
            exception = e;
            Long l = null;
            return l;
        }
        finally {
            DialectJdbcUtils.closeRSandPST(null, pst, exception, sql, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hotExecuteUpdate(Connection conn, String sql) throws SQLException {
        PreparedStatement pst = null;
        SQLException exception = null;
        try {
            pst = conn.prepareStatement(sql);
            int n = pst.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            exception = e;
            int n = 0;
            return n;
        }
        finally {
            DialectJdbcUtils.closeRSandPST(null, pst, exception, sql, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeRSandPST(ResultSet rs, PreparedStatement pst, SQLException exception, String sql, Object ... params) throws SQLException {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                if (exception != null) {
                    e.setNextException(exception);
                }
                exception = e;
            }
            finally {
                rs = null;
            }
        }
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                if (exception != null) {
                    e.setNextException(exception);
                }
                exception = e;
            }
            finally {
                pst = null;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

