/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public abstract class TableModelUtilsOfDb {
    private static final String TABLE_NAME = "TABLE_NAME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableModel[] db2Model(Connection con, Dialect dialect) {
        ArrayList<String> tableNames = new ArrayList<String>();
        ArrayList<TableModel> tableModels = new ArrayList<TableModel>();
        SQLException sqlException = null;
        ResultSet rs = null;
        Statement pst = null;
        try {
            DatabaseMetaData meta = con.getMetaData();
            if (dialect.isOracleFamily()) {
                pst = con.prepareStatement("SELECT TABLE_NAME FROM USER_TABLES");
                rs = pst.executeQuery();
                while (rs.next()) {
                    tableNames.add(rs.getString(TABLE_NAME));
                }
                rs.close();
                pst.close();
            } else {
                rs = meta.getTables(null, null, null, new String[]{"TABLE"});
                while (rs.next()) {
                    tableNames.add(rs.getString(TABLE_NAME));
                }
                rs.close();
            }
            for (String dbTableName : tableNames) {
                rs = con.getMetaData().getColumns(null, null, dbTableName, null);
                TableModel oneTable = new TableModel(dbTableName);
                while (rs.next()) {
                    String colName = rs.getString("COLUMN_NAME");
                    oneTable.column(colName);
                    ColumnModel col = oneTable.getColumnByColName(colName);
                    int javaSqlType = rs.getInt("DATA_TYPE");
                    try {
                        col.setColumnType(TypeUtils.javaSqlTypeToDialectType(javaSqlType));
                    }
                    catch (Exception e1) {
                        throw new DialectException("jDialect does not supported java.sql.types value " + javaSqlType, e1);
                    }
                    col.setLength(rs.getInt("COLUMN_SIZE"));
                    col.setNullable(rs.getInt("NULLABLE") > 0);
                    col.setPrecision(rs.getInt("DECIMAL_DIGITS"));
                    try {
                        if (Boolean.valueOf(true).equals(rs.getBoolean("IS_AUTOINCREMENT"))) {
                            col.identityId();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (!"YES".equalsIgnoreCase(rs.getString("IS_AUTOINCREMENT"))) continue;
                        col.identityId();
                    }
                    catch (Exception e) {}
                }
                tableModels.add(oneTable);
                rs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            sqlException = e;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e1) {
                    if (sqlException != null) {
                        sqlException.setNextException(e1);
                    }
                    sqlException = e1;
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                if (sqlException != null) {
                    sqlException.setNextException(e2);
                }
                sqlException = e2;
            }
        }
        if (sqlException != null) {
            throw new DialectException(sqlException);
        }
        return tableModels.toArray(new TableModel[tableModels.size()]);
    }
}

