/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbProLogger;
import com.github.drinkjava2.jdbpro.DbProRuntimeException;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.template.BasicSqlTemplate;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.id.SnowflakeCreator;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContextConfig;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import com.github.drinkjava2.jsqlbox.SqlMapperDefaultGuesser;
import com.github.drinkjava2.jsqlbox.SqlMapperGuesser;
import com.github.drinkjava2.jsqlbox.SqlMapperUtils;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import com.github.drinkjava2.jsqlbox.handler.EntityListHandler;
import com.github.drinkjava2.jsqlbox.handler.EntityNetHandler;
import com.github.drinkjava2.jsqlbox.sharding.ShardingModTool;
import com.github.drinkjava2.jsqlbox.sharding.ShardingRangeTool;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class SqlBoxContext
extends DbPro {
    public static final String NO_GLOBAL_SQLBOXCONTEXT_FOUND = "No default global SqlBoxContext found, need use method SqlBoxContext.setGlobalSqlBoxContext() to set a global default SqlBoxContext instance at the beginning of appication.";
    protected static SqlBoxContext globalSqlBoxContext = null;
    protected Dialect dialect = SqlBoxContextConfig.globalNextDialect;
    protected SqlMapperGuesser sqlMapperGuesser = SqlBoxContextConfig.globalNextSqlMapperGuesser;
    protected ShardingTool[] shardingTools = SqlBoxContextConfig.globalNextShardingTools;
    protected SnowflakeCreator snowflakeCreator = SqlBoxContextConfig.globalNextSnowflakeCreator;

    public SqlBoxContext() {
        this.dialect = SqlBoxContextConfig.globalNextDialect;
        this.copyConfigs(null);
    }

    public SqlBoxContext(DataSource ds) {
        super(ds);
        this.dialect = Dialect.guessDialect(ds);
        this.copyConfigs(null);
    }

    public SqlBoxContext(SqlBoxContextConfig config) {
        super(config);
        this.copyConfigs(config);
    }

    public SqlBoxContext(DataSource ds, SqlBoxContextConfig config) {
        super(ds, config);
        this.copyConfigs(config);
        if (this.dialect == null) {
            this.dialect = Dialect.guessDialect(ds);
        }
    }

    private void copyConfigs(SqlBoxContextConfig config) {
        if (config == null) {
            this.sqlMapperGuesser = SqlBoxContextConfig.globalNextSqlMapperGuesser;
            this.shardingTools = SqlBoxContextConfig.globalNextShardingTools;
            this.snowflakeCreator = SqlBoxContextConfig.globalNextSnowflakeCreator;
        } else {
            this.dialect = config.getDialect();
            this.sqlMapperGuesser = config.getSqlMapperGuesser();
            this.shardingTools = config.getShardingTools();
            this.snowflakeCreator = config.getSnowflakeCreator();
        }
    }

    protected void miscMethods______________________________() {
    }

    public static void resetGlobalVariants() {
        SqlBoxContextConfig.setGlobalNextAllowShowSql(false);
        SqlBoxContextConfig.setGlobalNextMasterSlaveOption(SqlOption.USE_AUTO);
        SqlBoxContextConfig.setGlobalNextConnectionManager(null);
        SqlBoxContextConfig.setGlobalNextSqlHandlers(null);
        SqlBoxContextConfig.setGlobalNextLogger(DbProLogger.DefaultDbProLogger.getLog(ImprovedQueryRunner.class));
        SqlBoxContextConfig.setGlobalNextBatchSize(300);
        SqlBoxContextConfig.setGlobalNextTemplateEngine(BasicSqlTemplate.instance());
        SqlBoxContextConfig.setGlobalNextDialect(null);
        SqlBoxContextConfig.setGlobalNextSqlMapperGuesser(SqlMapperDefaultGuesser.instance);
        SqlBoxContextConfig.setGlobalNextShardingTools(new ShardingTool[]{new ShardingModTool(), new ShardingRangeTool()});
        SqlBoxContextConfig.setGlobalNextIocTool(null);
        SqlBoxContextConfig.setGlobalNextSsModels(null);
        globalSqlBoxContext = null;
    }

    public static SqlBoxContext gctx() {
        return globalSqlBoxContext;
    }

    public static SqlBoxContext getGlobalSqlBoxContext() {
        return globalSqlBoxContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean dealOneSqlItem(boolean iXxxStyle, PreparedSQL ps, Object item) {
        if (super.dealOneSqlItem(iXxxStyle, ps, item)) {
            return true;
        }
        if (item instanceof SqlOption) {
            if (SqlOption.IGNORE_NULL.equals(item)) {
                ps.setIgnoreNull(true);
                return true;
            } else {
                if (!SqlOption.AUTO_SQL.equals(item)) return false;
                SqlBoxContextUtils.appendLeftJoinSQL(ps);
            }
            return true;
        } else if (item instanceof TableModel) {
            TableModel t = (TableModel)item;
            SqlBoxException.assureNotNull(t.getEntityClass(), new String[0]);
            ps.addModel(item);
            SqlBoxContextUtils.createLastAutoAliasName(ps);
            return true;
        } else if (item instanceof Class) {
            ps.addModel(TableModelUtils.entity2ReadOnlyModel((Class)item));
            SqlBoxContextUtils.createLastAutoAliasName(ps);
            return true;
        } else if (item instanceof SqlItem) {
            SqlItem sqItem = (SqlItem)item;
            SqlOption sqlItemType = sqItem.getType();
            if (SqlOption.SHARD_TABLE.equals((Object)sqlItemType)) {
                this.handleShardTable(ps, sqItem);
                return true;
            } else if (SqlOption.SHARD_DATABASE.equals((Object)sqlItemType)) {
                this.handleShardDatabase(ps, sqItem);
                return true;
            } else if (SqlOption.GIVE.equals((Object)sqlItemType)) {
                Object[] o = ((SqlItem)item).getParameters();
                String[] s = new String[o.length];
                for (int i = 0; i < o.length; ++i) {
                    s[i] = (String)o[i];
                }
                ps.addGives(s);
                return true;
            } else if (SqlOption.GIVE_BOTH.equals((Object)sqlItemType)) {
                Object[] a = ((SqlItem)item).getParameters();
                ps.addGives(new String[]{(String)a[0], (String)a[1]});
                ps.addGives(new String[]{(String)a[1], (String)a[0]});
                return true;
            } else {
                if (!SqlOption.ALIAS.equals((Object)sqlItemType)) return false;
                if (sqItem.getParameters().length == 0) {
                    throw new SqlBoxException("alias method need parameter");
                }
                ps.setLastAliases((String[])sqItem.getParameters());
            }
            return true;
        } else {
            if (!(item instanceof EntityNet)) return false;
            ps.setEntityNet((EntityNet)item);
            ps.addHandler(new EntityNetHandler());
        }
        return true;
    }

    public static <T> T createMapper(Class<?> abstractClass) {
        Class<?> childClass = SqlMapperUtils.createChildClass(abstractClass);
        try {
            return (T)childClass.newInstance();
        }
        catch (Exception e) {
            throw new SqlBoxException(e);
        }
    }

    public String getShardedTB(Object entityOrClass, Object ... shardvalues) {
        String table = SqlBoxContextUtils.getShardedTB(this, entityOrClass, shardvalues);
        if (table == null) {
            throw new SqlBoxException("No found ShardingTool can handle target '" + entityOrClass + "' ");
        }
        return table;
    }

    public SqlBoxContext getShardedDB(Object entityOrClass, Object ... shardvalues) {
        SqlBoxContext ctx = SqlBoxContextUtils.getShardedDB(this, entityOrClass, shardvalues);
        if (ctx == null) {
            throw new SqlBoxException("Not found ShardingTool can handle entity '" + entityOrClass + "' ");
        }
        return ctx;
    }

    protected String handleShardTable(PreparedSQL predSQL, SqlItem item) {
        Object[] params = item.getParameters();
        String table = null;
        if (predSQL.getModels() == null || predSQL.getModels().length == 0) {
            throw new SqlBoxException("ShardTable not found model setting");
        }
        TableModel model = (TableModel)predSQL.getModels()[0];
        if (params.length == 1) {
            table = SqlBoxContextUtils.getShardedTB(this, model, params[0]);
        } else if (params.length == 2) {
            table = SqlBoxContextUtils.getShardedTB(this, model, params[0], params[1]);
        } else {
            throw new SqlBoxException("ShardTable need 1 or 2 parameters");
        }
        if (table == null) {
            throw new SqlBoxException("No ShardTable Tool found.");
        }
        predSQL.addSql(table);
        return table;
    }

    protected DbPro handleShardDatabase(PreparedSQL predSQL, SqlItem item) {
        Object[] params = item.getParameters();
        SqlBoxContext ctx = null;
        if (predSQL.getModels() == null || predSQL.getModels().length == 0) {
            throw new SqlBoxException("ShardTable not found model setting");
        }
        TableModel model = (TableModel)predSQL.getModels()[0];
        if (params.length == 1) {
            ctx = SqlBoxContextUtils.getShardedDB(this, model, params[0]);
        } else if (params.length == 2) {
            ctx = SqlBoxContextUtils.getShardedDB(this, model, params[0], params[1]);
        } else {
            throw new SqlBoxException("ShardDatabase need 1 or 2 parameters");
        }
        if (ctx == null) {
            throw new SqlBoxException("No ShardDatabase Tool found.");
        }
        predSQL.setSwitchTo(ctx);
        return ctx;
    }

    private static void checkOnlyOneRowAffected(int result, String curdType) {
        if (result <= 0) {
            throw new SqlBoxException("No record found in database when do '" + curdType + "' operation.");
        }
        if (result > 1) {
            throw new SqlBoxException("Affect more than 1 row record in database when do '" + curdType + "' operation.");
        }
    }

    public <T> List<T> iQueryForEntityList(Object ... optionItems) {
        return (List)this.iQuery(new EntityListHandler(), optionItems);
    }

    public <T> List<T> pQueryForEntityList(Object ... optionItems) {
        return (List)this.pQuery(new EntityListHandler(), optionItems);
    }

    public <T> List<T> tQueryForEntityList(Object ... optionItems) {
        return (List)this.tQuery(new EntityListHandler(), optionItems);
    }

    protected void entityCrudMethods______________________________() {
    }

    public <T> T entityInsert(T entity, Object ... optionItems) {
        int result = SqlBoxContextUtils.entityInsertTry(this, entity, optionItems);
        SqlBoxContext.checkOnlyOneRowAffected(result, "insert");
        return entity;
    }

    public <T> T entityUpdate(Object entity, Object ... optionItems) {
        int result = SqlBoxContextUtils.entityUpdateTry(this, entity, optionItems);
        SqlBoxContext.checkOnlyOneRowAffected(result, "update");
        return (T)entity;
    }

    public int entityUpdateTry(Object entity, Object ... optionItems) {
        return SqlBoxContextUtils.entityUpdateTry(this, entity, optionItems);
    }

    public void entityDelete(Object entity, Object ... optionItems) {
        int result = SqlBoxContextUtils.entityDeleteTry(this, entity, optionItems);
        SqlBoxContext.checkOnlyOneRowAffected(result, "delete");
    }

    public int entityDeleteTry(Object entity, Object ... optionItems) {
        return SqlBoxContextUtils.entityDeleteTry(this, entity, optionItems);
    }

    public void entityDeleteById(Class<?> entityClass, Object id, Object ... optionItems) {
        int result = SqlBoxContextUtils.entityDeleteByIdTry(this, entityClass, id, optionItems);
        SqlBoxContext.checkOnlyOneRowAffected(result, "deleteById");
    }

    public int entityDeleteByIdTry(Class<?> entityClass, Object id, Object ... optionItems) {
        return SqlBoxContextUtils.entityDeleteByIdTry(this, entityClass, id, optionItems);
    }

    public boolean entityExist(Object entity, Object ... optionItems) {
        return SqlBoxContextUtils.entityExist(this, entity, optionItems);
    }

    public boolean entityExistById(Class<?> entityClass, Object id, Object ... optionItems) {
        return SqlBoxContextUtils.entityExistById(this, entityClass, id, optionItems);
    }

    public int entityCountAll(Class<?> entityClass, Object ... optionItems) {
        return SqlBoxContextUtils.entityCountAll(this, entityClass, optionItems);
    }

    public <T> T entityLoad(T entity, Object ... optionItems) {
        int result = SqlBoxContextUtils.entityLoadTry(this, entity, optionItems);
        SqlBoxContext.checkOnlyOneRowAffected(result, "insert");
        return entity;
    }

    public int entityLoadTry(Object entity, Object ... optionItems) {
        return SqlBoxContextUtils.entityLoadTry(this, entity, optionItems);
    }

    public <T> T entityLoadById(Class<T> entityClass, Object entityId, Object ... optionItems) {
        T entity = SqlBoxContextUtils.entityLoadByIdTry(this, entityClass, entityId, optionItems);
        if (entity == null) {
            throw new SqlBoxException("No record found in database when do 'LoadById' operation.");
        }
        return entity;
    }

    public <T> T entityLoadByIdTry(Class<T> entityClass, Object entityId, Object ... optionItems) {
        return SqlBoxContextUtils.entityLoadByIdTry(this, entityClass, entityId, optionItems);
    }

    public <T> List<T> entityFindAll(Class<T> entityClass, Object ... optionItems) {
        return SqlBoxContextUtils.entityFindAll(this, entityClass, optionItems);
    }

    public <T> List<T> entityFindByIds(Class<T> entityClass, Iterable<?> ids, Object ... optionItems) {
        return SqlBoxContextUtils.entityFindByIds(this, entityClass, ids, optionItems);
    }

    public <T> List<T> entityFindBySQL(Object ... optionItems) {
        return this.iQueryForEntityList(optionItems);
    }

    public <T> List<T> entityFindBySample(Object sampleBean, Object ... optionItems) {
        return SqlBoxContextUtils.entityFindBySample(this, sampleBean, optionItems);
    }

    public EntityNet entityAutoNet(Class<?> ... entityClass) {
        return SqlBoxContextUtils.entityAutoNet(this, entityClass);
    }

    public <E> E entityFindRelatedOne(Object entity, Object ... sqlItems) {
        return SqlBoxContextUtils.entityFindRelatedOne(this, entity, sqlItems);
    }

    public <E> List<E> entityFindRelatedList(Object entityOrIterable, Object ... sqlItems) {
        return SqlBoxContextUtils.entityFindRelatedList(this, entityOrIterable, sqlItems);
    }

    public <E> Set<E> entityFindRelatedSet(Object entity, Object ... sqlItems) {
        return SqlBoxContextUtils.entityFindRelatedSet(this, entity, sqlItems);
    }

    public <E> Map<Object, E> entityFindRelatedMap(Object entity, Object ... sqlItems) {
        return SqlBoxContextUtils.entityFindRelatedMap(this, entity, sqlItems);
    }

    protected void dialectShortcutMethods__________________________() {
    }

    public String pagin(int pageNumber, int pageSize, String sql) {
        this.assertDialectNotNull();
        return this.dialect.pagin(pageNumber, pageSize, sql);
    }

    public String trans(String sql) {
        this.assertDialectNotNull();
        return this.dialect.trans(sql);
    }

    public String paginAndTrans(int pageNumber, int pageSize, String sql) {
        this.assertDialectNotNull();
        return this.dialect.paginAndTrans(pageNumber, pageSize, sql);
    }

    public String[] toCreateDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toCreateDDL(entityClasses);
    }

    public String[] toDropDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toDropDDL(entityClasses);
    }

    public String[] toDropAndCreateDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toDropAndCreateDDL(entityClasses);
    }

    public String[] toCreateDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toCreateDDL(tables);
    }

    public String[] toDropDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toDropDDL(tables);
    }

    public String[] toDropAndCreateDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toDropAndCreateDDL(tables);
    }

    private void assertDialectNotNull() {
        if (this.dialect == null) {
            throw new DbProRuntimeException("Try use a dialect method but dialect is null");
        }
    }

    protected void getteSetters__________________________() {
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    @Deprecated
    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public SqlMapperGuesser getSqlMapperGuesser() {
        return this.sqlMapperGuesser;
    }

    @Deprecated
    public void setSqlMapperGuesser(SqlMapperGuesser sqlMapperGuesser) {
        this.sqlMapperGuesser = sqlMapperGuesser;
    }

    public ShardingTool[] getShardingTools() {
        return this.shardingTools;
    }

    @Deprecated
    public void setShardingTools(ShardingTool[] shardingTools) {
        this.shardingTools = shardingTools;
    }

    public SnowflakeCreator getSnowflakeCreator() {
        return this.snowflakeCreator;
    }

    @Deprecated
    public void setSnowflakeCreator(SnowflakeCreator snowflakeCreator) {
        this.snowflakeCreator = snowflakeCreator;
    }

    public static void setGlobalSqlBoxContext(SqlBoxContext globalSqlBoxContext) {
        SqlBoxContext.globalSqlBoxContext = globalSqlBoxContext;
    }
}

