/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.CustomizedSqlItem;
import com.github.drinkjava2.jdbpro.DbProRuntimeException;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SingleTonHandlers;
import com.github.drinkjava2.jdbpro.SqlHandler;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.Text;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class DbPro
extends ImprovedQueryRunner
implements NormalJdbcTool {
    public DbPro() {
    }

    public DbPro(DataSource ds) {
        super(ds);
    }

    public int quiteExecute(String sql, Object ... params) {
        try {
            return this.execute(sql, params);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void ________prepareMethods________() {
    }

    public PreparedSQL iPrepare(Object ... items) {
        return this.doPrepare(true, items);
    }

    public PreparedSQL pPrepare(Object ... items) {
        return this.doPrepare(false, items);
    }

    private PreparedSQL doPrepare(boolean inlineStyle, Object ... items) {
        PreparedSQL ps = this.dealSqlItems(null, inlineStyle, items);
        ps.addGlobalAndThreadedHandlers(this);
        return ps;
    }

    public PreparedSQL dealSqlItems(PreparedSQL lastPreSql, boolean inlineStyle, Object ... items) {
        if (items == null || items.length == 0) {
            throw new DbProRuntimeException("prepareSQL items can not be empty");
        }
        PreparedSQL predSQL = lastPreSql;
        if (predSQL == null) {
            predSQL = new PreparedSQL();
        }
        for (Object item : items) {
            if (item == null) {
                if (inlineStyle) {
                    throw new DbProRuntimeException("In in-line style,  null value can not append as SQL piece");
                }
                predSQL.addParam(null);
                continue;
            }
            if (this.dealOneSqlItem(inlineStyle, predSQL, item)) continue;
            if (item instanceof SqlItem) {
                throw new DbProRuntimeException("One SqlItem did not find explainer, type=" + (Object)((Object)((SqlItem)item).getType()));
            }
            if (item.getClass().isArray()) {
                Object[] array = (Object[])item;
                if (array.length == 0) continue;
                this.dealSqlItems(predSQL, inlineStyle, (Object[])item);
                continue;
            }
            if (inlineStyle) {
                predSQL.addSql(item);
                continue;
            }
            predSQL.addParam(item);
        }
        predSQL.setSql(predSQL.getSqlBuilder().toString());
        return predSQL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean dealOneSqlItem(boolean inlineStyle, PreparedSQL predSQL, Object item) {
        if (item instanceof String) {
            predSQL.addSqlOrParam(inlineStyle, (String)item);
            return true;
        } else if (item instanceof PreparedSQL) {
            PreparedSQL psItem = (PreparedSQL)item;
            if (psItem.getSql() != null) {
                predSQL.addSql(psItem.getSql());
            }
            if (psItem.getParams() == null) return true;
            for (Object obj : psItem.getParams()) {
                predSQL.addParam(obj);
            }
            return true;
        } else if (item instanceof SqlTemplateEngine) {
            predSQL.setTemplateEngine((SqlTemplateEngine)item);
            return true;
        } else if (item instanceof Map) {
            predSQL.addTemplateMap((Map)item);
            return true;
        } else if (item instanceof SqlOption) {
            if (SqlOption.USE_MASTER.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_MASTER);
                return true;
            } else if (SqlOption.USE_SLAVE.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_SLAVE);
                return true;
            } else if (SqlOption.USE_AUTO.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_AUTO);
                return true;
            } else if (SqlOption.USE_BOTH.equals(item)) {
                predSQL.setMasterSlaveOption(SqlOption.USE_BOTH);
                return true;
            } else if (SqlOption.USE_TEMPLATE.equals(item)) {
                predSQL.setUseTemplate(true);
                return true;
            } else if (SqlOption.EXECUTE.equals(item)) {
                predSQL.setOperationType(SqlOption.EXECUTE);
                return true;
            } else if (SqlOption.UPDATE.equals(item)) {
                predSQL.setOperationType(SqlOption.UPDATE);
                return true;
            } else if (SqlOption.QUERY.equals(item)) {
                predSQL.setOperationType(SqlOption.QUERY);
                return true;
            } else {
                if (!SqlOption.INSERT.equals(item)) return false;
                predSQL.setOperationType(SqlOption.INSERT);
            }
            return true;
        } else if (item instanceof SqlItem) {
            SqlItem sqItem = (SqlItem)item;
            SqlOption sqlItemType = sqItem.getType();
            if (SqlOption.OTHER.equals((Object)sqlItemType)) {
                predSQL.addOther(sqItem);
                return true;
            } else if (SqlOption.PARAM.equals((Object)sqlItemType)) {
                for (Object pm : sqItem.getParameters()) {
                    predSQL.addParam(pm);
                }
                return true;
            } else if (SqlOption.BIND.equals((Object)sqlItemType)) {
                predSQL.addTemplateParam(sqItem);
                return true;
            } else if (SqlOption.SQL.equals((Object)sqlItemType)) {
                for (Object pm : sqItem.getParameters()) {
                    predSQL.addSql(pm);
                }
                return true;
            } else if (SqlOption.QUESTION_PARAM.equals((Object)sqlItemType)) {
                int i = 0;
                for (Object pm : sqItem.getParameters()) {
                    predSQL.addParam(pm);
                    if (i > 0) {
                        predSQL.addSql(",");
                    }
                    predSQL.addSql("?");
                    ++i;
                }
                return true;
            } else if (SqlOption.NOT_NULL.equals((Object)sqlItemType)) {
                Object[] args = sqItem.getParameters();
                if (args.length < 2) {
                    throw new DbProRuntimeException("NOT_NULL type SqlItem need at least 2 args");
                }
                if (args[args.length - 1] == null) return true;
                for (int i = 0; i < args.length - 1; ++i) {
                    this.dealOneSqlItem(true, predSQL, args[i]);
                }
                predSQL.addParam(args[args.length - 1]);
                return true;
            } else if (SqlOption.VALUES_QUESTIONS.equals((Object)sqlItemType)) {
                predSQL.addSql(" values(");
                for (int i = 0; i < predSQL.getParamSize(); ++i) {
                    if (i > 0) {
                        predSQL.addSql(",");
                    }
                    predSQL.addSql("?");
                }
                predSQL.addSql(")");
                return true;
            } else if (SqlOption.ENABLE_HANDLERS.equals((Object)sqlItemType)) {
                predSQL.enableAllHandlers();
                return true;
            } else if (SqlOption.DISABLE_HANDLERS.equals((Object)sqlItemType)) {
                predSQL.disableHandlers(sqItem.getParameters());
                return true;
            } else {
                if (!SqlOption.SWITCHTO.equals((Object)sqlItemType)) return false;
                predSQL.setSwitchTo((DbPro)sqItem.getParameters()[0]);
            }
            return true;
        } else if (item instanceof Text) {
            predSQL.addSql(item.toString());
            return true;
        } else if (item instanceof Connection) {
            predSQL.setConnection((Connection)item);
            return true;
        } else if (item instanceof DbPro) {
            predSQL.setSwitchTo((DbPro)item);
            return true;
        } else if (item instanceof SqlHandler) {
            predSQL.addHandler((SqlHandler)item);
            return true;
        } else if (item instanceof ResultSetHandler) {
            predSQL.setResultSetHandler((ResultSetHandler)item);
            return true;
        } else {
            if (item instanceof Class) {
                if (!Text.class.isAssignableFrom((Class)item)) return false;
                String text = Text.classToString((Class)item);
                predSQL.addSqlOrParam(inlineStyle, text);
                return true;
            }
            if (!(item instanceof CustomizedSqlItem)) return false;
            ((CustomizedSqlItem)item).doPrepare(predSQL);
        }
        return true;
    }

    public void ________iXxxxStyles________() {
    }

    public <T> T iQuery(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.QUERY);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T iQueryForObject(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.QUERY);
        if (ps.getResultSetHandler() == null) {
            ps.setResultSetHandler((ResultSetHandler<?>)new ScalarHandler(1));
        }
        return (T)this.runPreparedSQL(ps);
    }

    public long iQueryForLongValue(Object ... inlineSQL) {
        return ((Number)this.iQueryForObject(inlineSQL)).longValue();
    }

    public String iQueryForString(Object ... inlineSQL) {
        return String.valueOf(this.iQueryForObject(inlineSQL));
    }

    public List<Map<String, Object>> iQueryForMapList(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.addHandler((ResultSetHandler)new MapListHandler());
        ps.ifNullSetType(SqlOption.QUERY);
        return (List)this.runPreparedSQL(ps);
    }

    public int iUpdate(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.UPDATE);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T iInsert(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.INSERT);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T iExecute(Object ... inlineSQL) {
        PreparedSQL ps = this.iPrepare(inlineSQL);
        ps.ifNullSetType(SqlOption.EXECUTE);
        return (T)this.runPreparedSQL(ps);
    }

    public void ________pXxxxStyles________() {
    }

    public <T> T pQuery(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.QUERY);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T pQueryForObject(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.QUERY);
        if (ps.getResultSetHandler() == null) {
            ps.setResultSetHandler((ResultSetHandler<?>)new ScalarHandler(1));
        }
        return (T)this.runPreparedSQL(ps);
    }

    public long pQueryForLongValue(Object ... items) {
        return ((Number)this.pQueryForObject(items)).longValue();
    }

    public String pQueryForString(Object ... items) {
        Object o = this.pQueryForObject(items);
        return String.valueOf(o);
    }

    public List<Map<String, Object>> pQueryForMapList(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.addHandler((ResultSetHandler)new MapListHandler());
        ps.ifNullSetType(SqlOption.QUERY);
        return (List)this.runPreparedSQL(ps);
    }

    public int pUpdate(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.UPDATE);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T pInsert(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.INSERT);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T pExecute(Object ... items) {
        PreparedSQL ps = this.pPrepare(items);
        ps.ifNullSetType(SqlOption.EXECUTE);
        return (T)this.runPreparedSQL(ps);
    }

    public void ________tXxxxStyles________() {
    }

    public <T> T tQuery(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.QUERY);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T tQueryForObject(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.QUERY);
        if (ps.getResultSetHandler() == null) {
            ps.setResultSetHandler((ResultSetHandler<?>)new ScalarHandler(1));
        }
        return (T)this.runPreparedSQL(ps);
    }

    public long tQueryForLongValue(Object ... items) {
        return ((Number)this.tQueryForObject(items)).longValue();
    }

    public String tQueryForString(Object ... items) {
        return String.valueOf(this.tQueryForObject(items));
    }

    public List<Map<String, Object>> tQueryForMapList(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.addHandler((ResultSetHandler)new MapListHandler());
        ps.ifNullSetType(SqlOption.QUERY);
        return (List)this.runPreparedSQL(ps);
    }

    public int tUpdate(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.UPDATE);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T tInsert(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.INSERT);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T tExecute(Object ... items) {
        PreparedSQL ps = this.iPrepare(items);
        ps.ifNullSetUseTemplate(true);
        ps.ifNullSetType(SqlOption.EXECUTE);
        return (T)this.runPreparedSQL(ps);
    }

    public void ________nXxxxStyles________() {
    }

    public <T> T nQuery(Connection conn, ResultSetHandler<T> rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, conn, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    public <T> T nQueryForObject(Connection conn, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, conn, (ResultSetHandler<?>)SingleTonHandlers.scalarHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    public String nQueryForString(Connection conn, String sql, Object ... params) {
        return (String)this.nQueryForObject(conn, sql, params);
    }

    public long nQueryForLongValue(Connection conn, String sql, Object ... params) {
        return ((Number)this.nQueryForObject(conn, sql, params)).longValue();
    }

    public List<Map<String, Object>> nQueryForMapList(Connection conn, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, conn, (ResultSetHandler<?>)SingleTonHandlers.mapListHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (List)this.runPreparedSQL(ps);
    }

    public int nUpdate(Connection conn, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.UPDATE, conn, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T nInsert(Connection conn, ResultSetHandler<T> rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.INSERT, conn, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    public int nExecute(Connection conn, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, conn, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> List<T> nExecute(Connection conn, ResultSetHandler<T> rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, conn, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (List)this.runPreparedSQL(ps);
    }

    public <T> T nQuery(ResultSetHandler<T> rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, null, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    @Override
    public <T> T nQueryForObject(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, null, (ResultSetHandler<?>)SingleTonHandlers.scalarHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    public String nQueryForString(String sql, Object ... params) {
        return String.valueOf(this.nQueryForObject(sql, params));
    }

    public long nQueryForLongValue(String sql, Object ... params) {
        return ((Number)this.nQueryForObject(sql, params)).longValue();
    }

    public List<Map<String, Object>> nQueryForMapList(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.QUERY, null, (ResultSetHandler<?>)SingleTonHandlers.mapListHandler, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (List)this.runPreparedSQL(ps);
    }

    @Override
    public int nUpdate(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.UPDATE, null, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> T nInsert(ResultSetHandler rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.INSERT, null, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (T)this.runPreparedSQL(ps);
    }

    @Override
    public int nExecute(String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, null, null, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (Integer)this.runPreparedSQL(ps);
    }

    public <T> List<T> nExecute(ResultSetHandler rsh, String sql, Object ... params) {
        PreparedSQL ps = new PreparedSQL(SqlOption.EXECUTE, null, rsh, sql, params);
        ps.addGlobalAndThreadedHandlers(this);
        return (List)this.runPreparedSQL(ps);
    }
}

