/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.springsrc.utils.ReflectionUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ClassCacheUtils {
    protected static ConcurrentHashMap<String, Class<?>> classExistCache = new ConcurrentHashMap();
    protected static Map<Class<?>, Map<String, Object>> uniqueMethodCache = new ConcurrentHashMap();
    protected static Map<Class<?>, Map<String, Method>> classReadMethods = new ConcurrentHashMap();
    protected static Map<Class<?>, Map<String, Method>> classWriteMethods = new ConcurrentHashMap();

    public static Class<?> checkClassExist(String className) {
        Class<?> result = classExistCache.get(className);
        if (result != null) {
            if (ClassOrMethodNotExist.class.equals(result)) {
                return null;
            }
            return result;
        }
        try {
            result = Class.forName(className);
            if (result != null) {
                classExistCache.put(className, result);
            } else {
                classExistCache.put(className, ClassOrMethodNotExist.class);
            }
            return result;
        }
        catch (Exception e) {
            DialectException.eatException(e);
            classExistCache.put(className, ClassOrMethodNotExist.class);
            return null;
        }
    }

    public static void registerClass(Class<?> clazz) {
        classExistCache.put(clazz.getName(), clazz);
    }

    public static Method checkMethodExist(Class<?> clazz, String uniqueMethodName) {
        Method[] methods;
        Object result;
        if (clazz == null || StrUtils.isEmpty(uniqueMethodName)) {
            return null;
        }
        Map<String, Object> methodMap = uniqueMethodCache.get(clazz);
        if (methodMap != null && !methodMap.isEmpty() && (result = methodMap.get(uniqueMethodName)) != null) {
            if (ClassOrMethodNotExist.class.equals(result)) {
                return null;
            }
            return (Method)result;
        }
        if (methodMap == null) {
            methodMap = new HashMap<String, Object>();
            uniqueMethodCache.put(clazz, methodMap);
        }
        for (Method method : methods = clazz.getMethods()) {
            if (uniqueMethodName == null || !uniqueMethodName.equals(method.getName())) continue;
            methodMap.put(uniqueMethodName, method);
            return method;
        }
        methodMap.put(uniqueMethodName, ClassOrMethodNotExist.class);
        return null;
    }

    private static LinkedHashMap<String, Method> sortMap(Map<String, Method> map) {
        ArrayList<Map.Entry<String, Method>> list = new ArrayList<Map.Entry<String, Method>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Method>>(){

            @Override
            public int compare(Map.Entry<String, Method> o1, Map.Entry<String, Method> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        LinkedHashMap<String, Method> result = new LinkedHashMap<String, Method>();
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (Method)entry.getValue());
        }
        return result;
    }

    public static synchronized void cacheReadWriteMethodsAndBoxField(Class<?> clazz) {
        BeanInfo beanInfo = null;
        PropertyDescriptor[] pds = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
            pds = beanInfo.getPropertyDescriptors();
        }
        catch (Exception e) {
            DialectException.throwEX("Class '" + clazz + "' can not get bean info", e);
        }
        HashMap<String, Method> readMethods = new HashMap<String, Method>();
        HashMap<String, Method> writeMethods = new HashMap<String, Method>();
        for (PropertyDescriptor pd : pds) {
            String fieldName = pd.getName();
            if ("class".equals(fieldName) || "simpleName".equals(fieldName) || "canonicalName".equals(fieldName) || "box".equals(fieldName)) continue;
            Method readMtd = pd.getReadMethod();
            readMethods.put(fieldName, readMtd);
            Method writeMtd = pd.getWriteMethod();
            if (writeMtd == null) {
                writeMtd = ReflectionUtils.findMethod(clazz, "set" + StrUtils.toUpperCaseFirstOne(fieldName), readMtd.getReturnType());
            }
            writeMethods.put(fieldName, writeMtd);
        }
        classReadMethods.put(clazz, ClassCacheUtils.sortMap(readMethods));
        classWriteMethods.put(clazz, ClassCacheUtils.sortMap(writeMethods));
    }

    public static Map<String, Method> getClassReadMethods(Class<?> clazz) {
        Map<String, Method> readMethods = classReadMethods.get(clazz);
        if (readMethods == null) {
            ClassCacheUtils.cacheReadWriteMethodsAndBoxField(clazz);
            return classReadMethods.get(clazz);
        }
        return readMethods;
    }

    public static Method getClassFieldReadMethod(Class<?> clazz, String fieldName) {
        return ClassCacheUtils.getClassReadMethods(clazz).get(fieldName);
    }

    public static Map<String, Method> getClassWriteMethods(Class<?> clazz) {
        Map<String, Method> writeMethods = classWriteMethods.get(clazz);
        if (writeMethods == null) {
            ClassCacheUtils.cacheReadWriteMethodsAndBoxField(clazz);
            return classWriteMethods.get(clazz);
        }
        return writeMethods;
    }

    public static Method getClassFieldWriteMethod(Class<?> clazz, String fieldName) {
        return ClassCacheUtils.getClassWriteMethods(clazz).get(fieldName);
    }

    public static Object readValueFromBeanField(Object entityBean, String fieldName) {
        Method readMethod = ClassCacheUtils.getClassFieldReadMethod(entityBean.getClass(), fieldName);
        if (readMethod == null) {
            throw new DialectException("No mapping found for field '" + fieldName + "' in '" + entityBean.getClass() + "'");
        }
        try {
            return readMethod.invoke(entityBean, new Object[0]);
        }
        catch (Exception e) {
            throw new DialectException(e);
        }
    }

    public static void writeValueToBeanField(Object entityBean, String fieldName, Object value) {
        Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(entityBean.getClass(), fieldName);
        if (writeMethod == null) {
            throw new DialectException("Can not find Java bean read method '" + fieldName + "'");
        }
        try {
            writeMethod.invoke(entityBean, value);
        }
        catch (Exception e) {
            throw new DialectException("FieldName '" + fieldName + "' can not write with value '" + value + "'", e);
        }
    }

    public static Object createNewEntity(Class<?> entityClass) {
        try {
            return entityClass.newInstance();
        }
        catch (Exception e) {
            throw new DialectException(e);
        }
    }

    protected static class ClassOrMethodNotExist {
        protected ClassOrMethodNotExist() {
        }
    }
}

