/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.handler;

import com.github.drinkjava2.jdbpro.DefaultOrderSqlHandler;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxException;

public class SSHandler
extends DefaultOrderSqlHandler {
    @Override
    public Object handle(ImprovedQueryRunner runner, PreparedSQL ps) {
        Object[] tableModels = ps.getModels();
        if (tableModels == null || tableModels.length == 0) {
            throw new SqlBoxException("TableModel items needed for SSHandler");
        }
        String[] aliases = ps.getAliases();
        if (aliases == null || aliases.length != tableModels.length) {
            throw new SqlBoxException("Alias qty not same as TableModel qty.");
        }
        String sql = this.explainNetQuery(ps);
        ps.setSql(sql);
        return runner.runPreparedSQL(ps);
    }

    private String explainNetQuery(PreparedSQL ps) {
        String sql = StrUtils.formatSQL(ps.getSql());
        SqlBoxException.assureNotEmpty(ps.getSql(), "Sql can not be empty");
        int pos = sql.indexOf(".**");
        if (pos < 0) {
            pos = sql.indexOf(".##");
        }
        while (pos >= 0) {
            StringBuilder aliasSB = new StringBuilder();
            for (int i = pos - 1; i >= 0 && StrUtils.isNormalLetters(sql.charAt(i)); --i) {
                aliasSB.insert(0, sql.charAt(i));
            }
            if (aliasSB.length() == 0) {
                throw new SqlBoxException(".** can not put at front");
            }
            String alias = aliasSB.toString();
            int posAlias = StrUtils.indexOfIgnoreCase(sql = sql + " ", " as " + alias + " ");
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " as " + alias + ",");
            }
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " as " + alias + ")");
            }
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " " + alias + " ");
            }
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " " + alias + ",");
            }
            if (posAlias == -1) {
                posAlias = StrUtils.indexOfIgnoreCase(sql, " " + alias + ")");
            }
            if (posAlias == -1) {
                throw new SqlBoxException("Alias '" + alias + "' not found");
            }
            StringBuilder tableNameSb = new StringBuilder();
            for (int i = posAlias - 1; i >= 0; --i) {
                char c = sql.charAt(i);
                if (StrUtils.isNormalLetters(c)) {
                    tableNameSb.insert(0, c);
                    continue;
                }
                if (tableNameSb.length() > 0) break;
            }
            if (tableNameSb.length() == 0) {
                throw new SqlBoxException("Alias '" + alias + "' not found tablename in SQL");
            }
            String tbStr = tableNameSb.toString();
            pos = (sql = SSHandler.replaceStarStarToColumn(sql, alias, tbStr, ps)).indexOf(".**");
            if (pos >= 0) continue;
            pos = sql.indexOf(".##");
        }
        return sql;
    }

    private static String replaceStarStarToColumn(String sql, String alias, String tableName, PreparedSQL ps) {
        String result = sql;
        if (sql.contains(alias + ".**")) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ps.getModels().length; ++i) {
                TableModel tb = (TableModel)ps.getModels()[i];
                if (!tableName.equalsIgnoreCase(tb.getTableName())) continue;
                if (!alias.equalsIgnoreCase(ps.getAliases()[i])) {
                    throw new SqlBoxException("Alias '" + alias + "' not same as tableModel's alias '" + ps.getAliases()[i] + "'");
                }
                for (ColumnModel col : tb.getColumns()) {
                    if (col.getTransientable().booleanValue()) continue;
                    sb.append(alias).append(".").append(col.getColumnName()).append(" as ").append(alias).append("_").append(col.getColumnName()).append(", ");
                }
                break;
            }
            if (sb.length() == 0) {
                throw new SqlBoxException("In SQL '" + sql + "', Can not find columns in table '" + tableName + "'");
            }
            sb.setLength(sb.length() - 2);
            result = StrUtils.replaceFirst(sql, alias + ".**", sb.toString());
            return result;
        }
        if (sql.contains(alias + ".##")) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ps.getModels().length; ++i) {
                TableModel tb = (TableModel)ps.getModels()[i];
                if (!tableName.equalsIgnoreCase(tb.getTableName())) continue;
                if (!alias.equalsIgnoreCase(ps.getAliases()[i])) {
                    throw new SqlBoxException("Alias '" + alias + "' not same as tableModel's alias");
                }
                for (ColumnModel col : tb.getColumns()) {
                    boolean found = false;
                    if (!col.getTransientable().booleanValue()) {
                        if (col.getPkey().booleanValue()) {
                            found = true;
                        } else {
                            for (FKeyModel tableModel : tb.getFkeyConstraints()) {
                                if (!tableModel.getColumnNames().contains(col.getColumnName())) continue;
                                found = true;
                                break;
                            }
                        }
                    }
                    if (!found) continue;
                    sb.append(alias).append(".").append(col.getColumnName()).append(" as ").append(alias).append("_").append(col.getColumnName()).append(", ");
                }
                break;
            }
            if (sb.length() == 0) {
                throw new SqlBoxException("In SQL '" + sql + "', Can not find key columns in table '" + tableName + "'");
            }
            sb.setLength(sb.length() - 2);
            result = StrUtils.replaceFirst(result, alias + ".##", sb.toString());
        }
        return result;
    }
}

