/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.sqlitem;

import com.github.drinkjava2.jdbpro.CustomizedSqlItem;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.SqlBoxContextUtils;
import com.github.drinkjava2.jsqlbox.SqlBoxException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SampleItem
implements CustomizedSqlItem {
    Object entityBean;
    TableModel model = null;
    List<Object> sqlItems = new ArrayList<Object>();

    public SampleItem(Object entityBean) {
        this.entityBean = entityBean;
    }

    public SampleItem(Object entityBean, TableModel model) {
        this.entityBean = entityBean;
        this.model = model;
    }

    public SampleItem notNullFields() {
        this.sqlItems.add("#NOTNULL_Fields");
        return this;
    }

    public SampleItem nullFields() {
        this.sqlItems.add("#NULL_Fields");
        return this;
    }

    public SampleItem allFields() {
        this.sqlItems.add("#ALL_Fields");
        return this;
    }

    public SampleItem sql(String ... sqlPiece) {
        for (String sql : sqlPiece) {
            this.sqlItems.add(sql);
        }
        return this;
    }

    public SampleItem param(Object ... params) {
        for (Object param : params) {
            this.sqlItems.add(new Object[]{param});
        }
        return this;
    }

    private void dealAllFields(PreparedSQL ps, TableModel model, Boolean nullFieldsOnly) {
        boolean isfirst = true;
        Map<String, Method> writeMethods = ClassCacheUtils.getClassWriteMethods(this.entityBean.getClass());
        for (String fieldName : writeMethods.keySet()) {
            ColumnModel col = model.getColumn(fieldName);
            if (col.getTransientable().booleanValue()) continue;
            Object fieldValue = SqlBoxContextUtils.readValueFromBeanFieldOrTail(this.entityBean, col);
            if (!(fieldValue == null || nullFieldsOnly != null && nullFieldsOnly.booleanValue())) {
                if (!isfirst) {
                    ps.addSql(" and ");
                }
                ps.addSql(col.getColumnName()).append(" =? ");
                ps.addParam(fieldValue);
                isfirst = false;
                continue;
            }
            if (nullFieldsOnly != null && !nullFieldsOnly.booleanValue()) continue;
            if (!isfirst) {
                ps.addSql(" and ");
            }
            ps.addSql(col.getColumnName()).append(" is null ");
            isfirst = false;
        }
        if (isfirst) {
            ps.addSql(" 1=1 ");
        }
    }

    @Override
    public void doPrepare(PreparedSQL ps) {
        if (this.model == null) {
            this.model = SqlBoxContextUtils.findEntityOrClassTableModel(this.entityBean);
        }
        SqlBoxException.assureNotNull(this.model.getEntityClass(), new String[0]);
        if (!this.sqlItems.isEmpty()) {
            for (Object piece : this.sqlItems) {
                String s;
                int colon;
                Object param;
                if ("#NOTNULL_Fields".equals(piece)) {
                    this.dealAllFields(ps, this.model, false);
                    continue;
                }
                if ("#NULL_Fields".equals(piece)) {
                    this.dealAllFields(ps, this.model, true);
                    continue;
                }
                if ("#ALL_Fields".equals(piece)) {
                    this.dealAllFields(ps, this.model, null);
                    continue;
                }
                if (piece instanceof String) {
                    ps.addSql(piece);
                    continue;
                }
                Object realParam = param = ((Object[])piece)[0];
                if (param instanceof String && (colon = (s = (String)param).indexOf(58)) >= 0) {
                    StringBuilder fieldNameSb = new StringBuilder();
                    for (int i = colon + 1; i < s.length() && StrUtils.isNormalLetters(s.charAt(i)); ++i) {
                        fieldNameSb.append(s.charAt(i));
                    }
                    String fieldName = fieldNameSb.toString();
                    SqlBoxException.assureNotEmpty(fieldName, new String[0]);
                    String fieldValue = String.valueOf(ClassCacheUtils.readValueFromBeanField(this.entityBean, fieldName));
                    realParam = StrUtils.replaceFirst(s, ":" + fieldName, fieldValue);
                }
                ps.addParam(realParam);
            }
        }
    }
}

