/*
 * Decompiled with CFR 0.152.
 */
package com.easy.argparse;

import com.easy.argparse.FieldValueManager;
import com.easy.argparse.UsageToken;
import com.easy.argparse.UsageTokenManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentParser {
    private static final Logger logger = LoggerFactory.getLogger(ArgumentParser.class);
    private final Class<?> dataClass;
    private final UsageTokenManager usageTokenManager;
    private final FieldValueManager fieldValueManager;

    public ArgumentParser(String usageExpression, Class<?> dataHolderClass) {
        this(usageExpression, dataHolderClass, ",");
    }

    public ArgumentParser(String usageExpression, Class<?> dataHolderClass, String arrayDelimiter) {
        this.dataClass = dataHolderClass;
        this.usageTokenManager = new UsageTokenManager(usageExpression, dataHolderClass);
        this.fieldValueManager = new FieldValueManager(dataHolderClass, this.usageTokenManager, arrayDelimiter);
    }

    public synchronized Object parse(String[] args) {
        this.initializeAndValidate();
        this.fieldValueManager.updateAvailableValues(args);
        if (this.usageTokenManager.isMissingMandatoryOption(this.fieldValueManager.getAvailableUsageTokens())) {
            throw new IllegalArgumentException("Missing mandatory option from the arguments");
        }
        Object dataHolderObject = this.getDataClassInstance();
        for (UsageToken usageToken : this.fieldValueManager.getAvailableUsageTokens()) {
            this.invokeSetterMethod(usageToken, dataHolderObject);
        }
        return dataHolderObject;
    }

    private Object getDataClassInstance() {
        Object dataHolderObject;
        try {
            dataHolderObject = this.dataClass.newInstance();
        }
        catch (InstantiationException e) {
            logger.warn("Got exception while creating instance of data class: {}", (Throwable)e);
            throw new IllegalArgumentException("Cannot create instance of " + this.dataClass.getCanonicalName() + " (" + e.getMessage() + ")");
        }
        catch (IllegalAccessException e) {
            logger.warn("Got exception while accessing data class for instantiation: {}", (Throwable)e);
            throw new IllegalArgumentException("Cannot access " + this.dataClass.getCanonicalName() + " to create instance (" + e.getMessage() + ")");
        }
        return dataHolderObject;
    }

    private void invokeSetterMethod(UsageToken usageToken, Object dataClassInstance) {
        Method setterMethod = this.usageTokenManager.getSetterMethod(usageToken);
        logger.trace("Invoking setter method: {}", (Object)setterMethod.getName());
        try {
            setterMethod.invoke(dataClassInstance, this.fieldValueManager.getArgValueObject(usageToken));
        }
        catch (InvocationTargetException e) {
            logger.warn("Got exception while invoking setter method: {}", (Throwable)e);
            throw new IllegalArgumentException("Cannot invoke method " + this.dataClass.getCanonicalName() + "." + setterMethod.getName() + " (" + e.getMessage() + ")");
        }
        catch (IllegalAccessException e) {
            logger.warn("Got exception while accessing data class for instantiation: {}", (Throwable)e);
            throw new IllegalArgumentException("Cannot access " + this.dataClass.getCanonicalName() + "." + setterMethod.getName() + " (" + e.getMessage() + ")");
        }
    }

    private void initializeAndValidate() {
        this.initialize();
        this.validate();
    }

    private void initialize() {
        this.usageTokenManager.initialize();
    }

    private void validate() {
        if (this.usageTokenManager.noTokensAvailable()) {
            throw new IllegalArgumentException("No valid arguments found in usage expression");
        }
        this.usageTokenManager.validateVariableNames();
    }
}

