/*
 * Decompiled with CFR 0.152.
 */
package com.easy.argparse;

import com.easy.argparse.UsageToken;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataClassValidator {
    private static final Logger logger = LoggerFactory.getLogger(DataClassValidator.class);
    private static final Set<Class<?>> ALLOWED_NON_PRIMITIVE_FIELD_TYPES = new HashSet<Class>(Arrays.asList(String.class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class));
    private final Class<?> dataClass;

    public DataClassValidator(Class<?> dataClass) {
        this.dataClass = dataClass;
    }

    public void validateVariableNames(List<UsageToken> usageTokens) {
        for (UsageToken usageToken : usageTokens) {
            String variableName = usageToken.getDataVariableName();
            logger.trace("Checking data class for variable: {}", (Object)variableName);
            try {
                Field field = this.dataClass.getDeclaredField(variableName);
                logger.trace("Found variable {} in the data class", (Object)variableName);
                this.validateFieldType(field.getType());
            }
            catch (NoSuchFieldException e) {
                logger.warn("Got exception while looking for field in data class: {}", (Throwable)e);
                throw new IllegalArgumentException("Field " + variableName + " not present in class " + this.dataClass.getCanonicalName() + " (" + e.getMessage() + ")");
            }
            catch (SecurityException e) {
                logger.warn("Got exception while accessing data class for fields: {}", (Throwable)e);
                throw new IllegalArgumentException("Restricted to access field " + variableName + " in class " + this.dataClass.getCanonicalName() + " (" + e.getMessage() + ")");
            }
        }
    }

    private void validateFieldType(Class<?> fieldType) {
        logger.trace("Checking validity of field type: {}", (Object)fieldType.getCanonicalName());
        if (fieldType.isArray()) {
            this.validateFieldType(fieldType.getComponentType());
        } else if (!(fieldType.isPrimitive() || ALLOWED_NON_PRIMITIVE_FIELD_TYPES.contains(fieldType) || fieldType.isEnum())) {
            throw new IllegalArgumentException("Field type " + fieldType.getCanonicalName() + " is not allowed");
        }
    }
}

