/*
 * Decompiled with CFR 0.152.
 */
package com.easy.argparse;

import com.easy.argparse.UsageToken;
import com.easy.argparse.UsageTokenManager;
import com.easy.core.utils.RegexUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldValueManager {
    private static final Logger logger = LoggerFactory.getLogger(FieldValueManager.class);
    private final Class<?> dataClass;
    private final UsageTokenManager usageTokenManager;
    private final String arrayDelimiter;
    private final Map<UsageToken, String> valueMap;

    public FieldValueManager(Class<?> dataClass, UsageTokenManager usageTokenManager, String arrayDelimiter) {
        this.dataClass = dataClass;
        this.usageTokenManager = usageTokenManager;
        this.arrayDelimiter = arrayDelimiter;
        this.valueMap = new ConcurrentHashMap<UsageToken, String>();
    }

    public void updateAvailableValues(String[] args) {
        logger.trace("Parsing the arguments for values");
        for (int index = 0; index < args.length; ++index) {
            String option = args[index];
            if (!option.startsWith("-")) continue;
            UsageToken usageToken = this.usageTokenManager.findUsageToken(option.replaceAll("[-]{1,2}", ""));
            this.updateValueMap(usageToken, args, index);
        }
    }

    public Set<UsageToken> getAvailableUsageTokens() {
        return this.valueMap.keySet();
    }

    private void updateValueMap(UsageToken usageToken, String[] args, int currentIndex) {
        String value = "";
        if (this.needsValue(usageToken)) {
            value = this.getValue(args, currentIndex);
        }
        this.valueMap.put(usageToken, value);
    }

    private String getValue(String[] args, int currentIndex) {
        String value = "";
        try {
            value = args[currentIndex + 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.warn("Got exception trying to get value at index {}: {}", (Object)currentIndex, (Object)e);
            throw new IllegalArgumentException("Missing value for option at index: " + currentIndex);
        }
        if (value.startsWith("-")) {
            throw new IllegalArgumentException("Missing value for option at index: " + currentIndex);
        }
        return value;
    }

    public Object getArgValueObject(UsageToken usageToken) {
        Field field;
        Class<?> fieldType;
        String value = this.valueMap.get(usageToken);
        Object argValue = this.needsValue(usageToken) ? ((fieldType = (field = usageToken.getMappedField(this.dataClass)).getType()).isEnum() ? Enum.valueOf(fieldType, value) : (fieldType.isArray() ? this.getArrayArgValue(value, fieldType) : this.getNonArrayArgValue(value, fieldType))) : Boolean.valueOf(true);
        return argValue;
    }

    private Object getArrayArgValue(String value, Class<?> fieldType) {
        Class<?> arrayComponentFieldType = fieldType.getComponentType();
        String delimiter = RegexUtil.containsSpecialCharacter((String)this.arrayDelimiter) ? RegexUtil.getSpecialCharactersEscaped((String)this.arrayDelimiter) : this.arrayDelimiter;
        String[] vals = value.split(delimiter);
        Object arr = Array.newInstance(arrayComponentFieldType, vals.length);
        for (int index = 0; index < vals.length; ++index) {
            try {
                Array.set(arr, index, this.getNonArrayArgValue(vals[index].trim(), arrayComponentFieldType));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Incorrect data format (" + e.getMessage() + ")");
            }
        }
        return arr;
    }

    private Object getNonArrayArgValue(String value, Class<?> fieldType) {
        Object argValue;
        if (fieldType == String.class) {
            argValue = value;
        } else if (fieldType == Byte.class || fieldType == Byte.TYPE) {
            argValue = Boolean.parseBoolean(value);
        } else if (fieldType == Character.class || fieldType == Character.TYPE) {
            argValue = Character.valueOf(value.charAt(0));
        } else if (fieldType == Short.class || fieldType == Short.TYPE) {
            argValue = Short.parseShort(value);
        } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            argValue = Integer.parseInt(value);
        } else if (fieldType == Long.class || fieldType == Long.TYPE) {
            argValue = Long.parseLong(value);
        } else if (fieldType == Float.class || fieldType == Float.TYPE) {
            argValue = Float.valueOf(Float.parseFloat(value));
        } else if (fieldType == Double.class || fieldType == Double.TYPE) {
            argValue = Double.parseDouble(value);
        } else {
            throw new IllegalArgumentException("Cannot convert (" + value + ") to appropriate data");
        }
        return argValue;
    }

    private boolean needsValue(UsageToken usageToken) {
        Class<?> fieldType = usageToken.getMappedField(this.dataClass).getType();
        return fieldType != Boolean.TYPE && fieldType != Boolean.class;
    }
}

