/*
 * Decompiled with CFR 0.152.
 */
package com.easy.argparse;

import com.easy.core.utils.StringsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageExpressionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(UsageExpressionExtractor.class);
    private final String usageExpression;
    private final List<IndexRange> optionalExpressionIndexRanges;

    UsageExpressionExtractor(String usageExpression) {
        this.usageExpression = usageExpression;
        this.optionalExpressionIndexRanges = Collections.unmodifiableList(this.getOptionalExpressionIndexRanges(usageExpression));
        if (this.hasIllegalBracket()) {
            throw new IllegalArgumentException("Usage (" + usageExpression + ") has incorrect brackets");
        }
    }

    private List<IndexRange> getOptionalExpressionIndexRanges(String expression) {
        logger.debug("Obtaining optional expressions from: {}", (Object)expression);
        int squareBracketStartIndex = 0;
        ArrayList<IndexRange> indexRanges = new ArrayList<IndexRange>();
        while ((squareBracketStartIndex = expression.indexOf(91, squareBracketStartIndex)) != -1) {
            int squareBracketEndIndex = expression.indexOf(93, squareBracketStartIndex);
            if (squareBracketEndIndex == -1) {
                throw new IllegalArgumentException("No matching square bracket at index = " + squareBracketEndIndex + " in (" + expression + ")");
            }
            if (expression.substring(squareBracketStartIndex + 1, squareBracketEndIndex).contains("[")) {
                throw new IllegalArgumentException("Nested opening square bracket in (" + expression + ")");
            }
            logger.trace("Found optional expression between indices: {} and {}", (Object)squareBracketStartIndex, (Object)squareBracketEndIndex);
            indexRanges.add(new IndexRange(squareBracketStartIndex, squareBracketEndIndex));
            squareBracketStartIndex = squareBracketEndIndex;
        }
        return indexRanges;
    }

    private boolean hasIllegalBracket() {
        if (this.usageExpression.contains("(") || this.usageExpression.contains(")") || this.usageExpression.contains("{") || this.usageExpression.contains("}")) {
            return true;
        }
        boolean illegal = false;
        for (int index = 0; index < this.usageExpression.length(); ++index) {
            boolean isSquareBracket;
            char currentChar = this.usageExpression.charAt(index);
            boolean bl = isSquareBracket = currentChar == '[' || currentChar == ']';
            if (!isSquareBracket || this.isPartOfOptionalExpression(index, this.optionalExpressionIndexRanges)) continue;
            illegal = true;
            break;
        }
        return illegal;
    }

    private boolean isPartOfOptionalExpression(int index, List<IndexRange> optionalExpressionIndexRanges) {
        if (optionalExpressionIndexRanges.isEmpty()) {
            return false;
        }
        if (index < optionalExpressionIndexRanges.get(0).startIndex) {
            return false;
        }
        boolean partOfOptionalExpression = false;
        for (IndexRange indexRange : optionalExpressionIndexRanges) {
            if (index < indexRange.startIndex || index > indexRange.endIndex) continue;
            partOfOptionalExpression = true;
            break;
        }
        return partOfOptionalExpression;
    }

    public String getMandatoryExpression() {
        StringBuilder mandatoryExpression = new StringBuilder();
        for (int index = 0; index < this.usageExpression.length(); ++index) {
            if (this.isPartOfOptionalExpression(index, this.optionalExpressionIndexRanges)) continue;
            mandatoryExpression.append(this.usageExpression.charAt(index));
        }
        return StringsUtil.getWhitespaceNormalized((String)mandatoryExpression.toString());
    }

    public String getOptionalExpression() {
        StringBuilder optionalExpression = new StringBuilder();
        for (IndexRange indexRange : this.optionalExpressionIndexRanges) {
            optionalExpression.append(this.getOptionalExpressionPart(this.usageExpression, indexRange)).append(" ");
        }
        return StringsUtil.getWhitespaceNormalized((String)optionalExpression.toString());
    }

    private String getOptionalExpressionPart(String expression, IndexRange indexRange) {
        return expression.substring(indexRange.startIndex + 1, indexRange.endIndex);
    }

    private class IndexRange {
        private final int startIndex;
        private final int endIndex;

        IndexRange(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }
}

