/*
 * Decompiled with CFR 0.152.
 */
package com.easy.argparse;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageToken {
    private static final Logger logger = LoggerFactory.getLogger(UsageToken.class);
    private final String optionName;
    private final String optionAliasName;
    private final String dataVariableName;

    public UsageToken(String optionName, String optionAliasName, String dataVariableName) {
        this.optionName = optionName;
        this.optionAliasName = optionAliasName;
        this.dataVariableName = dataVariableName;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getOptionAliasName() {
        return this.optionAliasName;
    }

    public String getDataVariableName() {
        return this.dataVariableName;
    }

    public Field getMappedField(Class<?> dataClass) {
        try {
            return dataClass.getDeclaredField(this.dataVariableName);
        }
        catch (NoSuchFieldException e) {
            logger.warn("Got exception while looking for field {} in the data class: {}", (Object)this.dataVariableName, (Object)e);
            throw new IllegalArgumentException("Cannot find variable " + dataClass.getName() + ":" + this.dataVariableName, e);
        }
        catch (SecurityException e) {
            logger.warn("Got exception while accessing data class for fields: {}", (Throwable)e);
            throw new IllegalArgumentException("Restricted to find " + dataClass.getName() + ":" + this.dataVariableName, e);
        }
    }

    public Method getSetterMethod(Class<?> dataClass) {
        Method setterMethod;
        String setterMethodName = this.getSetterMethodName();
        try {
            setterMethod = dataClass.getDeclaredMethod(setterMethodName, this.getMappedField(dataClass).getType());
            if (!setterMethod.isAccessible()) {
                setterMethod.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            logger.warn("Got exception looking for method in the data class: {}", (Throwable)e);
            throw new IllegalArgumentException("Cannot find method " + dataClass.getName() + ":" + setterMethodName, e);
        }
        catch (SecurityException e) {
            logger.warn("Got exception accessing method in data class: {}", (Throwable)e);
            throw new IllegalArgumentException("Restricted to access method " + dataClass.getName() + ":" + setterMethodName, e);
        }
        return setterMethod;
    }

    private String getSetterMethodName() {
        StringBuilder setterMethodName = new StringBuilder();
        setterMethodName.append("set");
        setterMethodName.append(Character.toUpperCase(this.dataVariableName.charAt(0)));
        setterMethodName.append(this.dataVariableName.substring(1, this.dataVariableName.length()));
        return setterMethodName.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.optionName != null ? this.optionName.hashCode() : 0);
        hash = 59 * hash + (this.optionAliasName != null ? this.optionAliasName.hashCode() : 0);
        hash = 59 * hash + (this.dataVariableName != null ? this.dataVariableName.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsageToken other = (UsageToken)obj;
        return other.getDataVariableName().equals(this.dataVariableName) && (other.getOptionName().equals(this.optionName) || other.getOptionName().equals(this.optionAliasName));
    }
}

