/*
 * Decompiled with CFR 0.152.
 */
package com.easy.argparse;

import com.easy.argparse.DataClassValidator;
import com.easy.argparse.UsageExpressionExtractor;
import com.easy.argparse.UsageToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageTokenManager {
    private static final Logger logger = LoggerFactory.getLogger(UsageTokenManager.class);
    private final String usageExpression;
    private final Class<?> dataClass;
    private final Map<UsageToken, Method> setterMethodMap;
    private List<UsageToken> mandatoryUsageTokens;
    private List<UsageToken> optionalUsageTokens;

    public UsageTokenManager(String usageExpression, Class<?> dataClass) {
        this.usageExpression = usageExpression;
        this.dataClass = dataClass;
        this.setterMethodMap = new ConcurrentHashMap<UsageToken, Method>();
        this.mandatoryUsageTokens = new ArrayList<UsageToken>();
        this.optionalUsageTokens = new ArrayList<UsageToken>();
    }

    private static List<UsageToken> getUsageTokens(String usageExpression) {
        logger.trace("Parsing ({}) for usage tokens", (Object)usageExpression);
        String regex = "[-]{1,2}([a-zA-Z0-9_]+)([ ]?\\|[ ]?[-]{1,2}([a-zA-Z0-9_]+))? ([a-zA-Z$_][a-zA-Z$_0-9]*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(usageExpression);
        ArrayList<UsageToken> usageTokens = new ArrayList<UsageToken>();
        while (matcher.find()) {
            String optionName = matcher.group(1);
            String optionAliasName = matcher.group(3);
            String dataVariableName = matcher.group(4);
            usageTokens.add(new UsageToken(optionName, optionAliasName, dataVariableName));
            logger.trace("Found usage token: option = {}, alias = {}, variable name = {}", new Object[]{optionName, optionAliasName, dataVariableName});
        }
        return usageTokens;
    }

    public synchronized void initialize() {
        this.reset();
        UsageExpressionExtractor usageExpressionExtractor = new UsageExpressionExtractor(this.usageExpression);
        this.mandatoryUsageTokens = UsageTokenManager.getUsageTokens(usageExpressionExtractor.getMandatoryExpression());
        this.optionalUsageTokens = UsageTokenManager.getUsageTokens(usageExpressionExtractor.getOptionalExpression());
        this.updateSetterMethodMap(this.dataClass);
    }

    private void reset() {
        this.mandatoryUsageTokens.clear();
        this.optionalUsageTokens.clear();
        this.setterMethodMap.clear();
    }

    private void updateSetterMethodMap(Class<?> dataClass) {
        this.updateSetterMethodMap(dataClass, this.mandatoryUsageTokens);
        this.updateSetterMethodMap(dataClass, this.optionalUsageTokens);
    }

    private void updateSetterMethodMap(Class<?> dataClass, List<UsageToken> usageTokens) {
        for (UsageToken usageToken : usageTokens) {
            this.setterMethodMap.put(usageToken, usageToken.getSetterMethod(dataClass));
        }
    }

    public synchronized void validateVariableNames() {
        DataClassValidator dataClassValidator = new DataClassValidator(this.dataClass);
        dataClassValidator.validateVariableNames(this.mandatoryUsageTokens);
        dataClassValidator.validateVariableNames(this.optionalUsageTokens);
    }

    public synchronized boolean isMissingMandatoryOption(Set<UsageToken> availableUsageTokens) {
        boolean missing = false;
        for (UsageToken usageToken : this.mandatoryUsageTokens) {
            if (availableUsageTokens.contains(usageToken)) continue;
            missing = true;
            break;
        }
        return missing;
    }

    public synchronized UsageToken findUsageToken(String option) {
        UsageToken foundUsageToken = this.findUsageToken(option, this.mandatoryUsageTokens);
        if (foundUsageToken == null) {
            foundUsageToken = this.findUsageToken(option, this.optionalUsageTokens);
        }
        if (foundUsageToken == null) {
            throw new IllegalArgumentException("No usage definition could be found for option (" + option + ")");
        }
        return foundUsageToken;
    }

    public synchronized boolean noTokensAvailable() {
        return this.mandatoryUsageTokens.isEmpty() && this.optionalUsageTokens.isEmpty();
    }

    private UsageToken findUsageToken(String option, List<UsageToken> usageTokens) {
        UsageToken foundUsageToken = null;
        for (UsageToken usageToken : usageTokens) {
            if (!option.equals(usageToken.getOptionName()) && !option.equals(usageToken.getOptionAliasName())) continue;
            foundUsageToken = usageToken;
            break;
        }
        return foundUsageToken;
    }

    public Method getSetterMethod(UsageToken usageToken) {
        return this.setterMethodMap.get(usageToken);
    }
}

