/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.data.filter;

import com.eoscode.springapitools.config.StringCaseSensitive;
import com.eoscode.springapitools.data.filter.FilterDefinition;
import com.eoscode.springapitools.util.ObjectUtils;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class DefaultSpecification<T>
implements Specification<T> {
    private Join join;
    private final FilterDefinition criteria;
    private StringCaseSensitive stringCaseSensitive;

    public DefaultSpecification(FilterDefinition filterCriteria) {
        this.criteria = filterCriteria;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return this.build(this.criteria, root, criteriaQuery, criteriaBuilder);
    }

    public DefaultSpecification(Join join, FilterDefinition filterCriteria) {
        this.join = join;
        this.criteria = filterCriteria;
    }

    public String getOriginalFieldName() {
        if (this.join != null) {
            return this.join.getAttribute().getName() + "." + this.criteria.getField();
        }
        return this.criteria.getField();
    }

    public void withStringIgnoreCase(StringCaseSensitive stringCaseSensitive) {
        this.stringCaseSensitive = stringCaseSensitive;
    }

    private Predicate build(FilterDefinition criteria, Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Path path = this.join != null ? this.join.get(criteria.getField()) : root.get(criteria.getField());
        Class javaType = path.getJavaType();
        if (criteria.getOperator().equalsIgnoreCase(Operator.EQ.getValue())) {
            if (path.getJavaType() == String.class) {
                return criteriaBuilder.equal(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), (Object)((Comparable)ObjectUtils.getObject(javaType, criteria.getValue())));
            }
            return criteriaBuilder.equal((Expression)path, (Object)((Comparable)ObjectUtils.getObject(javaType, criteria.getValue())));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.NE.getValue())) {
            if (path.getJavaType() == String.class) {
                return criteriaBuilder.notEqual(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), (Object)((Comparable)ObjectUtils.getObject(javaType, criteria.getValue())));
            }
            return criteriaBuilder.notEqual((Expression)path, (Object)((Comparable)ObjectUtils.getObject(javaType, criteria.getValue())));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.GT.getValue())) {
            if (path.getJavaType() == String.class) {
                return criteriaBuilder.greaterThan(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), (Comparable)ObjectUtils.getObject(javaType, criteria.getValue()));
            }
            return criteriaBuilder.greaterThan((Expression)path, (Comparable)ObjectUtils.getObject(javaType, criteria.getValue()));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.GTE.getValue())) {
            if (path.getJavaType() == String.class) {
                return criteriaBuilder.greaterThanOrEqualTo(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), (Comparable)ObjectUtils.getObject(javaType, criteria.getValue()));
            }
            return criteriaBuilder.greaterThanOrEqualTo((Expression)path, (Comparable)ObjectUtils.getObject(javaType, criteria.getValue()));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.LT.getValue())) {
            if (path.getJavaType() == String.class) {
                return criteriaBuilder.lessThan(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), (Comparable)ObjectUtils.getObject(javaType, criteria.getValue()));
            }
            return criteriaBuilder.lessThan((Expression)path, (Comparable)ObjectUtils.getObject(javaType, criteria.getValue()));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.LTE.getValue())) {
            if (path.getJavaType() == String.class) {
                return criteriaBuilder.lessThanOrEqualTo(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), (Comparable)ObjectUtils.getObject(javaType, criteria.getValue()));
            }
            return criteriaBuilder.lessThanOrEqualTo((Expression)path, (Comparable)ObjectUtils.getObject(javaType, criteria.getValue()));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.LIKE.getValue())) {
            if (path.getJavaType() == String.class) {
                return criteriaBuilder.like(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), "%" + ObjectUtils.getObject(javaType, criteria.getValue()) + "%");
            }
            return criteriaBuilder.equal((Expression)path, (Object)((Comparable)ObjectUtils.getObject(javaType, criteria.getValue())));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.NOT_LIKE.getValue())) {
            if (path.getJavaType() == String.class) {
                return criteriaBuilder.notLike(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), "%" + ObjectUtils.getObject(javaType, criteria.getValue()) + "%");
            }
            return criteriaBuilder.notEqual((Expression)path, (Object)((Comparable)ObjectUtils.getObject(javaType, criteria.getValue())));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.STARTS_WITH.getValue())) {
            return criteriaBuilder.like(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), ObjectUtils.getObject(javaType, criteria.getValue()) + "%");
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.ENDS_WITH.getValue())) {
            return criteriaBuilder.like(this.getStringIgnoreCase(criteriaBuilder, (Expression<String>)path), "%" + ObjectUtils.getObject(javaType, criteria.getValue()));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.IS_NULL.getValue())) {
            return criteriaBuilder.isNull((Expression)path);
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.IS_NOT_NULL.getValue())) {
            return criteriaBuilder.isNotNull((Expression)path);
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.BTW.getValue())) {
            String[] values = criteria.getValue().toString().split(";");
            return criteriaBuilder.between((Expression)path, (Comparable)ObjectUtils.getObject(path.getJavaType(), (Object)values[0]), (Comparable)ObjectUtils.getObject(path.getJavaType(), (Object)values[1]));
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.IN.getValue())) {
            String[] values = criteria.getValue().toString().split(";");
            CriteriaBuilder.In inClause = criteriaBuilder.in((Expression)path);
            for (String in : values) {
                inClause.value((Object)((Comparable)ObjectUtils.getObject(path.getJavaType(), (Object)in)));
            }
            return inClause;
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.SIZE.getValue())) {
            String[] values = criteria.getValue().toString().split(";");
            Expression expression = criteriaBuilder.size((Expression)path);
            return this.buildExpression(values[0], expression, values[1], criteriaBuilder);
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.IS_EMPTY.getValue())) {
            return criteriaBuilder.isEmpty((Expression)path);
        }
        if (criteria.getOperator().equalsIgnoreCase(Operator.IS_NOT_EMPTY.getValue())) {
            return criteriaBuilder.isNotEmpty((Expression)path);
        }
        return null;
    }

    private Predicate buildExpression(String operator, Expression expression, String value, CriteriaBuilder criteriaBuilder) {
        if (operator.equalsIgnoreCase(Operator.EQ.getValue())) {
            return criteriaBuilder.equal(expression, (Object)value);
        }
        if (operator.equalsIgnoreCase(Operator.NE.getValue())) {
            return criteriaBuilder.notEqual(expression, (Object)value);
        }
        if (operator.equalsIgnoreCase(Operator.GT.getValue())) {
            return criteriaBuilder.greaterThan(expression, (Comparable)((Object)value));
        }
        if (operator.equalsIgnoreCase(Operator.GTE.getValue())) {
            return criteriaBuilder.greaterThanOrEqualTo(expression, (Comparable)((Object)value));
        }
        if (operator.equalsIgnoreCase(Operator.LT.getValue())) {
            return criteriaBuilder.lessThan(expression, (Comparable)((Object)value));
        }
        if (operator.equalsIgnoreCase(Operator.LTE.getValue())) {
            return criteriaBuilder.lessThanOrEqualTo(expression, (Comparable)((Object)value));
        }
        return null;
    }

    private Expression<String> getStringIgnoreCase(CriteriaBuilder criteriaBuilder, Expression<String> expression) {
        switch (this.stringCaseSensitive) {
            case lowerCase: {
                return criteriaBuilder.lower(expression);
            }
            case upperCase: {
                return criteriaBuilder.upper(expression);
            }
        }
        return expression;
    }

    static enum Operator {
        EQ("="),
        NE("!="),
        GT(">"),
        LT("<"),
        GTE(">="),
        LTE("<="),
        LIKE("$like"),
        NOT_LIKE("$notLike"),
        STARTS_WITH("$startsWith"),
        ENDS_WITH("$endsWith"),
        IS_NULL("$isNull"),
        IS_NOT_NULL("$isNotNull"),
        IS_EMPTY("$isEmpty"),
        IS_NOT_EMPTY("$isNotEmpty"),
        SIZE("$size"),
        IN("$in"),
        BTW("$btw"),
        OR("$or"),
        AND("$and");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }
}

