/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.data.filter;

import com.eoscode.springapitools.config.StringCaseSensitive;
import com.eoscode.springapitools.data.filter.DefaultSpecification;
import com.eoscode.springapitools.data.filter.FilterDefinition;
import com.eoscode.springapitools.data.filter.JoinDefinition;
import com.eoscode.springapitools.data.filter.QueryDefinition;
import com.eoscode.springapitools.data.filter.SearchException;
import com.eoscode.springapitools.data.filter.SortDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class SpecificationBuilder<T> {
    private Boolean distinct;
    private final List<FilterDefinition> filters;
    private final Set<SortDefinition> sorts;
    private final Set<JoinDefinition> joins;
    private DefaultSpecification.Operator operator;
    private StringCaseSensitive stringCaseSensitive;
    private Specification<T> result = null;
    private final Map<String, Join> joinMap = new Hashtable<String, Join>();

    public SpecificationBuilder() {
        this.filters = new ArrayList<FilterDefinition>();
        this.sorts = new HashSet<SortDefinition>();
        this.joins = new HashSet<JoinDefinition>();
        this.operator = DefaultSpecification.Operator.AND;
    }

    public SpecificationBuilder(boolean distinct) {
        this();
        this.distinct = distinct;
    }

    public SpecificationBuilder distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public SpecificationBuilder withOr() {
        this.operator = DefaultSpecification.Operator.OR;
        return this;
    }

    public SpecificationBuilder withAnd() {
        this.operator = DefaultSpecification.Operator.AND;
        return this;
    }

    public SpecificationBuilder withStringIgnoreCase(StringCaseSensitive stringCaseSensitive) {
        this.stringCaseSensitive = stringCaseSensitive;
        return this;
    }

    public SpecificationBuilder filter(String field, String operation, Object value) {
        this.filter(new FilterDefinition(field, operation, value));
        return this;
    }

    public SpecificationBuilder filter(FilterDefinition filter) {
        String[] fields = filter.getField().split("\\.");
        if (filter.isJoin()) {
            filter.setField(fields[1]);
        }
        this.filters.add(filter);
        return this;
    }

    public SpecificationBuilder filters(List<FilterDefinition> filters) {
        filters.forEach(this::filter);
        return this;
    }

    public SpecificationBuilder join(JoinDefinition joinDefinition) {
        if (joinDefinition != null) {
            this.joins.add(joinDefinition);
        }
        return this;
    }

    public SpecificationBuilder joins(JoinDefinition[] joinDefinitions) {
        if (this.joins != null) {
            this.joins.addAll(Arrays.asList(joinDefinitions));
        }
        return this;
    }

    public SpecificationBuilder joins(List<JoinDefinition> joinDefinitions) {
        if (this.joins != null) {
            this.joins.addAll(joinDefinitions);
        }
        return this;
    }

    public SpecificationBuilder sort(SortDefinition sort) {
        this.sorts.add(sort);
        return this;
    }

    public SpecificationBuilder sorts(List<SortDefinition> sorts) {
        if (sorts != null) {
            this.sorts.addAll(sorts);
        }
        return this;
    }

    public SpecificationBuilder sort(String field, SortDefinition.Direction direction) {
        this.sorts.add(new SortDefinition(field, direction));
        return this;
    }

    public Specification<T> build(QueryDefinition queryDefinition) {
        this.distinct(queryDefinition.isDistinct()).joins(queryDefinition.getJoins()).filters(queryDefinition.getFilters()).sorts(queryDefinition.getSorts());
        if ("or".equalsIgnoreCase(DefaultSpecification.Operator.OR.getValue())) {
            this.withOr();
        }
        return this.build();
    }

    public Specification<T> build() {
        this.filters.forEach(filterDefinition -> {
            boolean isPresent;
            if ((filterDefinition.isFetch() || filterDefinition.isJoin()) && !(isPresent = this.joins.stream().anyMatch(joinDefinition -> joinDefinition.getField().equals(filterDefinition.getPathJoin())))) {
                this.joins.add(new JoinDefinition(filterDefinition.getPathJoin(), filterDefinition.isFetch()));
            }
        });
        this.result = this.operator == DefaultSpecification.Operator.OR ? Specification.where(this.result).or(this.joinAndWhere(this.joins, this.filters)) : Specification.where(this.result).and(this.joinAndWhere(this.joins, this.filters));
        return this.result;
    }

    Specification<T> joinAndWhere(Set<JoinDefinition> joins, List<FilterDefinition> filters) {
        return (Specification & Serializable)(root, query, builder) -> {
            if (this.distinct != null) {
                query.distinct(this.distinct.booleanValue());
            }
            if (this.currentQueryIsCountRecords(query)) {
                this.joinMap.clear();
            }
            joins.forEach(joinDefinition -> {
                JoinType joinType = joinDefinition.getType() == JoinDefinition.JoinType.INNER ? JoinType.INNER : JoinType.LEFT;
                Join join = !this.currentQueryIsCountRecords(query) && joinDefinition.isFetch() ? (Join)root.fetch(joinDefinition.getField(), joinType) : root.join(joinDefinition.getField(), joinType);
                this.joinMap.putIfAbsent(joinDefinition.getField(), join);
            });
            List<Specification> specs = filters.stream().map(filterDefinition -> {
                if (filterDefinition.isJoin()) {
                    Join join = this.joinMap.get(filterDefinition.getPathJoin());
                    DefaultSpecification defaultSpecification = new DefaultSpecification(join, (FilterDefinition)filterDefinition);
                    defaultSpecification.withStringIgnoreCase(this.stringCaseSensitive);
                    return defaultSpecification;
                }
                DefaultSpecification defaultSpecification = new DefaultSpecification((FilterDefinition)filterDefinition);
                defaultSpecification.withStringIgnoreCase(this.stringCaseSensitive);
                return defaultSpecification;
            }).collect(Collectors.toList());
            Predicate[] predicates = this.build(specs, root, query, builder);
            if (this.operator == DefaultSpecification.Operator.OR) {
                return builder.or(predicates);
            }
            return builder.and(predicates);
        };
    }

    public void prepareJoins(Set<JoinDefinition> joins, Root root, CriteriaQuery query, CriteriaBuilder builder) {
    }

    private Predicate[] build(List<Specification> specs, Root root, CriteriaQuery query, CriteriaBuilder builder) {
        return (Predicate[])specs.stream().map(item -> {
            Predicate predicate = item.toPredicate(root, query, builder);
            if (predicate != null) {
                return predicate;
            }
            throw new SearchException(String.format("invalid filter for query, matcher for field '%s' not found.", ((DefaultSpecification)item).getOriginalFieldName()));
        }).toArray(Predicate[]::new);
    }

    private boolean currentQueryIsCountRecords(CriteriaQuery<?> criteriaQuery) {
        return criteriaQuery.getResultType() == Long.class || criteriaQuery.getResultType() == Long.TYPE;
    }
}

