/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.resource;

import com.eoscode.springapitools.data.repository.Repository;
import com.eoscode.springapitools.resource.AbstractResource;
import com.eoscode.springapitools.service.RepositoryService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class AbstractRepositoryResource<Repository extends Repository<Entity, ID>, Entity, ID>
extends AbstractResource<RepositoryService<Repository, Entity, ID>, Entity, ID> {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;
    private RepositoryService<Repository, Entity, ID> repositoryService;
    private final Type repositoryType;
    private final Type entityType;
    private final Type identifierType;

    public AbstractRepositoryResource() {
        Type type = this.getClass().getGenericSuperclass();
        ParameterizedType pType = (ParameterizedType)type;
        this.repositoryType = pType.getActualTypeArguments()[0];
        this.entityType = pType.getActualTypeArguments()[1];
        this.identifierType = pType.getActualTypeArguments()[2];
    }

    @PostConstruct
    private void metaData() {
        this.repositoryService = new RepositoryService(this.applicationContext, this.getRepositoryType(), this.getEntityType(), this.getIdentifierType());
    }

    @Override
    public Type getEntityType() {
        return this.entityType;
    }

    @Override
    public Type getIdentifierType() {
        return this.identifierType;
    }

    public Type getRepositoryType() {
        return this.repositoryType;
    }

    @Override
    public RepositoryService<Repository, Entity, ID> getService() {
        return this.repositoryService;
    }
}

