/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.resource;

import com.eoscode.springapitools.config.QueryView;
import com.eoscode.springapitools.config.SpringApiToolsProperties;
import com.eoscode.springapitools.data.domain.DynamicView;
import com.eoscode.springapitools.data.domain.Identifier;
import com.eoscode.springapitools.data.filter.QueryDefinition;
import com.eoscode.springapitools.data.filter.QueryParameter;
import com.eoscode.springapitools.data.filter.ViewDefinition;
import com.eoscode.springapitools.resource.MethodNotAllowed;
import com.eoscode.springapitools.resource.exception.MethodNotAllowedException;
import com.eoscode.springapitools.service.AbstractService;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.monitorjbl.json.JsonView;
import com.monitorjbl.json.Match;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.Valid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reflections.ReflectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public abstract class AbstractResource<Service extends AbstractService<?, Entity, ID>, Entity, ID> {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SpringApiToolsProperties springApiToolsProperties;
    @Autowired
    private MappingJackson2HttpMessageConverter jackson2HttpMessageConverter;
    private Service service;
    private final Set<HttpMethod> methodNotAllowed = new HashSet<HttpMethod>();
    private final Type serviceType;
    private final Type entityType;
    private final Type identifierType;
    private final Class<Entity> entityClass;
    private boolean queryWithViews = false;

    public AbstractResource() {
        Type type = this.getClass().getGenericSuperclass();
        ParameterizedType pType = (ParameterizedType)type;
        this.serviceType = pType.getActualTypeArguments()[0];
        this.entityType = pType.getActualTypeArguments()[1];
        this.identifierType = pType.getActualTypeArguments()[2];
        this.entityClass = (Class)this.entityType;
    }

    @PostConstruct
    private void metaData() {
        Class serviceClass;
        if (this.applicationContext != null && this.getService() == null && (serviceClass = (Class)this.serviceType).isAnnotationPresent(Service.class)) {
            this.service = (AbstractService)this.applicationContext.getBean(serviceClass);
        }
        if (this.springApiToolsProperties.getQueryWithViews() == QueryView.all) {
            this.queryWithViews = true;
        } else if (this.springApiToolsProperties.getQueryWithViews() == QueryView.entity) {
            this.queryWithViews = this.entityClass.isAnnotationPresent(DynamicView.class);
        } else if (this.springApiToolsProperties.getQueryWithViews() == QueryView.none) {
            this.queryWithViews = false;
        }
        if (this.getClass().isAnnotationPresent(MethodNotAllowed.class)) {
            MethodNotAllowed methodNotAllowedAnnotation = this.getClass().getAnnotation(MethodNotAllowed.class);
            this.methodNotAllowed.addAll(Arrays.stream(methodNotAllowedAnnotation.methods()).collect(Collectors.toSet()));
        }
    }

    public Type getServiceType() {
        return this.serviceType;
    }

    public Type getEntityType() {
        return this.entityType;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    private Class<Entity> getEntityClass() {
        return this.entityClass;
    }

    protected Service getService() {
        return this.service;
    }

    @PostMapping(produces={"application/json"})
    public ResponseEntity<Entity> save(@Valid @RequestBody Entity entity) {
        if (this.methodNotAllowed.contains(HttpMethod.POST)) {
            throw new MethodNotAllowedException(HttpMethod.POST.name());
        }
        entity = ((AbstractService)this.getService()).save(entity);
        Identifier identifier = null;
        if (entity instanceof Identifier) {
            identifier = (Identifier)entity;
        }
        if (identifier != null) {
            URI uri = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{identifier.getId()}).toUri();
            return ResponseEntity.created((URI)uri).build();
        }
        return ResponseEntity.ok().body(entity);
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public <T> T find(@PathVariable ID id, @RequestParam(value="views", required=false, defaultValue="") Set<String> views) {
        if (this.methodNotAllowed.contains(HttpMethod.GET)) {
            throw new MethodNotAllowedException(HttpMethod.GET.name());
        }
        Object entity = ((AbstractService)this.getService()).findById(id);
        return (T)ResponseEntity.ok((Object)this.toJson(ViewDefinition.create(views), entity));
    }

    @GetMapping(value={"/detail/{id}"}, produces={"application/json"})
    public <T> T findDetail(@PathVariable ID id, @RequestParam(value="views", required=false, defaultValue="") Set<String> views) {
        if (this.methodNotAllowed.contains(HttpMethod.GET)) {
            throw new MethodNotAllowedException(HttpMethod.GET.name());
        }
        Object entity = ((AbstractService)this.getService()).findDetailById(id);
        ViewDefinition viewDefinition = ViewDefinition.create(views);
        return (T)ResponseEntity.ok((Object)this.toJson(viewDefinition, entity));
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<Void> update(@Valid @RequestBody Entity entity, @PathVariable ID id) {
        if (this.methodNotAllowed.contains(HttpMethod.PUT)) {
            throw new MethodNotAllowedException(HttpMethod.PUT.name());
        }
        if (entity instanceof Identifier) {
            Identifier identifier = (Identifier)entity;
            identifier.setId(id);
        }
        ((AbstractService)this.getService()).save(entity);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<Void> patch(@Valid @RequestBody Entity entity, @PathVariable ID id) {
        if (this.methodNotAllowed.contains(HttpMethod.PATCH)) {
            throw new MethodNotAllowedException(HttpMethod.PATCH.name());
        }
        if (entity instanceof Identifier) {
            Identifier identifier = (Identifier)entity;
            identifier.setId(id);
        }
        ((AbstractService)this.getService()).update(entity);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<Void> delete(@PathVariable ID id) {
        if (this.methodNotAllowed.contains(HttpMethod.DELETE)) {
            throw new MethodNotAllowedException(HttpMethod.DELETE.name());
        }
        ((AbstractService)this.getService()).deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/page", "/find/page"}, produces={"application/json"})
    public ResponseEntity<Page<Entity>> findWithPage(Entity filterBy, @PageableDefault Pageable pageable) {
        if (this.methodNotAllowed.contains(HttpMethod.GET)) {
            throw new MethodNotAllowedException(HttpMethod.GET.name());
        }
        Page<Entity> page = ((AbstractService)this.getService()).find(filterBy, pageable);
        return ResponseEntity.ok(page);
    }

    @GetMapping(value={"", "/find"}, produces={"application/json"})
    public <T> T find(Entity filterBy, @PageableDefault Pageable pageable, QueryParameter queryParameter) {
        Object result;
        if (this.methodNotAllowed.contains(HttpMethod.GET)) {
            throw new MethodNotAllowedException(HttpMethod.GET.name());
        }
        if (this.isDefaultPageable(queryParameter.getPageable())) {
            result = ((AbstractService)this.getService()).find(filterBy, pageable);
        } else {
            int maxSize = this.getListDefaultSize(queryParameter.getSize());
            if (maxSize > 0) {
                Page<Entity> page = ((AbstractService)this.getService()).find(filterBy, (Pageable)PageRequest.of((int)0, (int)maxSize, (Sort)pageable.getSort()));
                result = page.getContent();
                if (page.getTotalElements() > (long)maxSize) {
                    this.log.warn((Object)String.format("list truncated, %d occurrence of %d. rule list-default-size=%d, list-default-size-override=%s", maxSize, page.getTotalElements(), maxSize, this.springApiToolsProperties.isListDefaultSizeOverride()));
                }
            } else {
                result = ((AbstractService)this.getService()).find(filterBy, pageable.getSort());
            }
        }
        return (T)ResponseEntity.ok(result);
    }

    @GetMapping(value={"/query/page"}, produces={"application/json"})
    public <T> T queryWithPage(@RequestParam(value="opt", required=false, defaultValue="") String query, @RequestParam(value="views", required=false, defaultValue="") Set<String> views, @PageableDefault Pageable pageable, QueryParameter queryParameter) {
        if (this.methodNotAllowed.contains(HttpMethod.GET)) {
            throw new MethodNotAllowedException(HttpMethod.GET.name());
        }
        queryParameter.setPageable(true);
        T result = this.query(query, views, pageable, queryParameter);
        return (T)ResponseEntity.ok(result);
    }

    @GetMapping(value={"/query"}, produces={"application/json"})
    public <T> T query(@RequestParam(value="opt", required=false, defaultValue="") String query, @RequestParam(value="views", required=false, defaultValue="") Set<String> views, @PageableDefault Pageable pageable, QueryParameter queryParameter) {
        Object result;
        if (this.methodNotAllowed.contains(HttpMethod.GET)) {
            throw new MethodNotAllowedException(HttpMethod.GET.name());
        }
        QueryDefinition queryDefinition = ((AbstractService)this.getService()).createQueryDefinition(query, queryParameter);
        queryDefinition.setViews(views);
        if (this.isDefaultPageable(queryParameter.getPageable())) {
            result = this.query(queryDefinition, queryParameter.getPageable(), pageable);
        } else {
            int maxSize = this.getListDefaultSize(queryParameter.getSize());
            if (maxSize > 0) {
                Page page = (Page)this.query(queryDefinition, queryParameter.getPageable(), (Pageable)PageRequest.of((int)0, (int)maxSize, (Sort)pageable.getSort()));
                result = page.getContent();
                if (page.getTotalElements() > (long)maxSize) {
                    this.log.warn((Object)String.format("list truncated, %d occurrence of %d. rule list-default-size=%d, list-default-size-override=%s", maxSize, page.getTotalElements(), maxSize, this.springApiToolsProperties.isListDefaultSizeOverride()));
                }
            } else {
                result = this.query(queryDefinition, false, pageable);
            }
        }
        return result;
    }

    @PostMapping(value={"/query/page"}, produces={"application/json"})
    public <T> T queryWitPage(@RequestBody(required=false) QueryDefinition queryDefinition, @PageableDefault Pageable pageable) {
        if (this.methodNotAllowed.contains(HttpMethod.POST)) {
            throw new MethodNotAllowedException(HttpMethod.POST.name());
        }
        Page result = ((AbstractService)this.getService()).query(queryDefinition, pageable);
        return (T)ResponseEntity.ok((Object)this.toJson(queryDefinition, result));
    }

    @PostMapping(value={"/query"}, produces={"application/json"})
    public <T> T query(@RequestBody(required=false) QueryDefinition queryDefinition, @RequestParam(value="pageable", required=false) Boolean page, @PageableDefault Pageable pageable) {
        if (this.methodNotAllowed.contains(HttpMethod.POST)) {
            throw new MethodNotAllowedException(HttpMethod.POST.name());
        }
        Object result = this.isDefaultPageable(page) ? ((AbstractService)this.getService()).query(queryDefinition, pageable) : ((AbstractService)this.getService()).query(queryDefinition, pageable.getSort());
        return (T)ResponseEntity.ok((Object)this.toJson(queryDefinition, result));
    }

    @GetMapping(value={"/all"}, produces={"application/json"})
    public <T> T findAll(@SortDefault Sort sort, @RequestParam(value="views", required=false, defaultValue="") Set<String> views) {
        if (this.methodNotAllowed.contains(HttpMethod.GET)) {
            throw new MethodNotAllowedException(HttpMethod.GET.name());
        }
        List list = ((AbstractService)this.getService()).findAll(sort);
        ViewDefinition viewDefinition = ViewDefinition.create(views);
        return (T)ResponseEntity.ok((Object)this.toJson(viewDefinition, list));
    }

    @GetMapping(value={"/pages"}, produces={"application/json"})
    public ResponseEntity<String> findAllPageAndSort(@PageableDefault Pageable pageable, @RequestParam(value="views", required=false, defaultValue="") Set<String> views) {
        if (this.methodNotAllowed.contains(HttpMethod.GET)) {
            throw new MethodNotAllowedException(HttpMethod.GET.name());
        }
        Page page = ((AbstractService)this.getService()).findAllWithPage(pageable);
        ViewDefinition viewDefinition = ViewDefinition.create(views);
        return ResponseEntity.ok((Object)this.toJson(viewDefinition, page));
    }

    private boolean isDefaultPageable(Boolean pageable) {
        if (pageable != null) {
            return pageable;
        }
        return this.springApiToolsProperties.isEnableDefaultPageable();
    }

    private int getListDefaultSize(Integer size) {
        if (size != null && this.springApiToolsProperties.isListDefaultSizeOverride()) {
            return size;
        }
        return this.springApiToolsProperties.getListDefaultSize();
    }

    private <T> String toJson(ViewDefinition viewDefinition, T result) {
        ObjectMapper objectMapper = this.jackson2HttpMessageConverter.getObjectMapper();
        if (this.queryWithViews && !viewDefinition.getViews().isEmpty()) {
            Set<String> views = viewDefinition.getViews();
            try {
                Set ignoreAnnotations = ReflectionUtils.getAllFields(this.entityClass, (Predicate[])new Predicate[]{field -> field.isAnnotationPresent(JsonIgnoreProperties.class) || field.isAnnotationPresent(JsonIgnore.class)});
                ArrayList<String> jsonIgnore = new ArrayList<String>();
                ignoreAnnotations.forEach(field -> {
                    if (field.isAnnotationPresent(JsonIgnoreProperties.class)) {
                        JsonIgnoreProperties properties = field.getAnnotation(JsonIgnoreProperties.class);
                        Arrays.stream(properties.value()).forEach(value -> jsonIgnore.add(String.format("%s.%s", field.getName(), value)));
                    } else {
                        jsonIgnore.add(field.getName());
                    }
                });
                jsonIgnore.add("*");
                jsonIgnore.forEach(views::remove);
                Set<String> fetches = viewDefinition.getFetches();
                views = views.stream().filter(view -> {
                    int idx = view.indexOf(".");
                    if (idx == -1) {
                        return true;
                    }
                    try {
                        boolean showField;
                        boolean dynamicView;
                        String fieldName = view.substring(0, idx);
                        Field field = this.entityClass.getDeclaredField(fieldName);
                        if (field.getGenericType() instanceof ParameterizedType) {
                            ParameterizedType pType = (ParameterizedType)field.getGenericType();
                            Class type = (Class)pType.getActualTypeArguments()[0];
                            dynamicView = this.springApiToolsProperties.getQueryWithViews() == QueryView.all || this.springApiToolsProperties.getQueryWithViews() == QueryView.entity && type.isAnnotationPresent(DynamicView.class);
                            field = type.getDeclaredField(view.substring(idx + 1));
                        } else {
                            dynamicView = this.springApiToolsProperties.getQueryWithViews() == QueryView.all || this.springApiToolsProperties.getQueryWithViews() == QueryView.entity && field.getType().isAnnotationPresent(DynamicView.class);
                            field = field.getType().getDeclaredField(view.substring(idx + 1));
                        }
                        boolean fieldWithJsonIgnore = field.isAnnotationPresent(JsonIgnore.class);
                        boolean fieldWithFetch = fetches.contains(fieldName);
                        boolean bl = showField = !fieldWithJsonIgnore && fieldWithFetch && dynamicView;
                        if (!showField) {
                            this.log.debug((Object)String.format("ignore field %s to query view in entity %s. annotation JsonIgnore: %s, fetch: %s, dynamicView: %s", view, this.entityClass.getName(), fieldWithJsonIgnore, fieldWithFetch, dynamicView));
                        }
                        return showField;
                    }
                    catch (NoSuchFieldException e) {
                        this.log.error((Object)String.format("field %s to query view in entity %s. %s", view, this.entityClass.getName(), e.getMessage()), (Throwable)e);
                        return false;
                    }
                }).collect(Collectors.toSet());
                if (result instanceof Page) {
                    Page page = (Page)result;
                    List content = page.getContent();
                    page = new PageImpl(new ArrayList(), page.getPageable(), page.getTotalElements());
                    ObjectNode rootNode = objectMapper.createObjectNode();
                    JsonView jsonView = JsonView.with((Object)content).onClass(this.entityClass, Match.match().exclude(new String[]{"*"}).include(views.toArray(new String[0])));
                    rootNode.putPOJO("content", (Object)jsonView);
                    rootNode.putPOJO("pageable", (Object)page.getPageable());
                    rootNode.put("total", page.getTotalElements());
                    return objectMapper.writeValueAsString((Object)rootNode);
                }
                JsonView jsonView = JsonView.with(result).onClass(this.entityClass, Match.match().exclude(new String[]{"*"}).include(views.toArray(new String[0])));
                return objectMapper.writeValueAsString((Object)jsonView);
            }
            catch (JsonProcessingException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            return objectMapper.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

