/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.resource.exception;

import com.eoscode.springapitools.data.filter.SearchException;
import com.eoscode.springapitools.resource.exception.MethodNotAllowedException;
import com.eoscode.springapitools.resource.exception.StandardError;
import com.eoscode.springapitools.resource.exception.ValidationError;
import com.eoscode.springapitools.service.exceptions.AuthorizationException;
import com.eoscode.springapitools.service.exceptions.EntityNotFoundException;
import com.eoscode.springapitools.service.exceptions.ValidationException;
import java.net.URI;
import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class BaseResourceExceptionHandler {
    protected final Log log = LogFactory.getLog(this.getClass());

    protected URI getPathURI() {
        return ServletUriComponentsBuilder.fromCurrentRequest().build().toUri();
    }

    protected String getPath() {
        return ServletUriComponentsBuilder.fromCurrentRequest().toUriString();
    }

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<StandardError> objectNotFound(EntityNotFoundException e, HttpServletRequest request) {
        StandardError standardError = new StandardError(this.now(), HttpStatus.NOT_FOUND.value(), "Not found", e.getMessage(), request.getRequestURI());
        this.log.error((Object)("objectNotFound -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)standardError);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<StandardError> validation(MethodArgumentNotValidException e, HttpServletRequest request) {
        ValidationError validationError = new ValidationError(this.now(), HttpStatus.UNPROCESSABLE_ENTITY.value(), "Validation error", e.getMessage(), request.getRequestURI());
        for (FieldError fieldError : e.getBindingResult().getFieldErrors()) {
            validationError.addError(fieldError.getField(), fieldError.getDefaultMessage());
        }
        this.log.error((Object)("validation -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)validationError);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<StandardError> constraintViolation(ConstraintViolationException e) {
        ValidationError validationError = new ValidationError(this.now(), HttpStatus.UNPROCESSABLE_ENTITY.value(), "Validation error", e.getMessage(), this.getPathURI().toString());
        if (e.getConstraintViolations() != null) {
            e.getConstraintViolations().forEach(constraintViolation -> validationError.addError("", constraintViolation.getMessage()));
        }
        this.log.error((Object)("constraintViolation -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)validationError);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseEntity<StandardError> dataIntegrityViolationException(DataIntegrityViolationException e) {
        ValidationError validationError = new ValidationError(this.now(), HttpStatus.CONFLICT.value(), "Database error", e.getLocalizedMessage(), this.getPath());
        this.log.error((Object)("dataIntegrityViolationException -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body((Object)validationError);
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<StandardError> validation(ValidationException e, HttpServletRequest request) {
        ValidationError validationError = new ValidationError(this.now(), HttpStatus.UNPROCESSABLE_ENTITY.value(), "Validation error", e.getMessage(), request.getRequestURI());
        this.log.error((Object)("validation -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)validationError);
    }

    @ExceptionHandler(value={SearchException.class})
    public ResponseEntity<StandardError> searchException(SearchException e, HttpServletRequest request) {
        ValidationError validationError = new ValidationError(this.now(), HttpStatus.UNPROCESSABLE_ENTITY.value(), "Search error", e.getMessage(), request.getRequestURI());
        this.log.error((Object)("searchException -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body((Object)validationError);
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public ResponseEntity<StandardError> authorization(AuthorizationException e, HttpServletRequest request) {
        StandardError standardError = new StandardError(this.now(), HttpStatus.UNAUTHORIZED.value(), "Access denied", e.getMessage(), request.getRequestURI());
        this.log.error((Object)("authorization -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)standardError);
    }

    @ExceptionHandler(value={UsernameNotFoundException.class, AuthenticationException.class})
    public ResponseEntity<StandardError> objectNotFound(AuthenticationException e, HttpServletRequest request) {
        StandardError standardError = new StandardError(this.now(), HttpStatus.FORBIDDEN.value(), "Access denied", e.getMessage(), request.getRequestURI());
        this.log.error((Object)("objectNotFound -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)standardError);
    }

    @ExceptionHandler(value={MethodNotAllowedException.class})
    public ResponseEntity<StandardError> methodNotAllowed(MethodNotAllowedException e, HttpServletRequest request) {
        StandardError standardError = new StandardError(this.now(), HttpStatus.METHOD_NOT_ALLOWED.value(), "Method Not Allowed", e.getMessage(), request.getRequestURI());
        this.log.error((Object)("methodNotAllowed -> " + e.getMessage()), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).body((Object)standardError);
    }

    private String now() {
        return Instant.now().toString();
    }
}

