/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class Auth<T extends Serializable>
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private final T id;
    private final String username;
    private final String password;
    private final Collection<? extends GrantedAuthority> authorities;

    public Auth(T id, String username, String password, Set<? extends GrantedAuthority> authorities) {
        this.id = id;
        this.username = username;
        this.password = password;
        this.authorities = authorities;
    }

    public T getId() {
        return this.id;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public <Grant extends GrantedAuthority> boolean hasRole(Grant grant) {
        return this.getAuthorities().contains(grant);
    }
}

