/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.service;

import com.eoscode.springapitools.config.SpringApiToolsProperties;
import com.eoscode.springapitools.data.domain.Find;
import com.eoscode.springapitools.data.domain.FindAttribute;
import com.eoscode.springapitools.data.domain.Identifier;
import com.eoscode.springapitools.data.domain.NoDelete;
import com.eoscode.springapitools.data.filter.FilterDefinition;
import com.eoscode.springapitools.data.filter.JoinDefinition;
import com.eoscode.springapitools.data.filter.QueryDefinition;
import com.eoscode.springapitools.data.filter.QueryParameter;
import com.eoscode.springapitools.data.filter.SearchException;
import com.eoscode.springapitools.data.filter.SortDefinition;
import com.eoscode.springapitools.data.filter.SpecificationBuilder;
import com.eoscode.springapitools.data.repository.CustomDeleteByIdRepository;
import com.eoscode.springapitools.data.repository.CustomFindByIdRepository;
import com.eoscode.springapitools.data.repository.CustomFindDetailByIdRepository;
import com.eoscode.springapitools.data.repository.Repository;
import com.eoscode.springapitools.service.exceptions.EntityNotFoundException;
import com.eoscode.springapitools.util.NullAwareBeanUtilsBean;
import com.eoscode.springapitools.util.ObjectUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.persistence.criteria.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reflections.ReflectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractService<Repository extends Repository<Entity, ID>, Entity, ID> {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CustomDeleteByIdRepository customDeleteByIdRepository;
    @Autowired
    private CustomFindByIdRepository customFindByIdRepository;
    @Autowired
    private CustomFindDetailByIdRepository customFindDetailByIdRepository;
    @Autowired
    private SpringApiToolsProperties springApiToolsProperties;
    private Repository repository;
    private final Type repositoryType;
    private final Type entityType;
    private final Type identifierType;
    private final Class<Entity> entityClass;
    private Set<Field> findAttributeAnnotations = new HashSet<Field>();

    public AbstractService() {
        Type type = this.getClass().getGenericSuperclass();
        ParameterizedType pType = (ParameterizedType)type;
        this.repositoryType = pType.getActualTypeArguments()[0];
        this.entityType = pType.getActualTypeArguments()[1];
        this.identifierType = pType.getActualTypeArguments()[2];
        this.entityClass = (Class)this.entityType;
    }

    public AbstractService(ApplicationContext applicationContext, Type repositoryType, Type entityType, Type identifierType) {
        this.applicationContext = applicationContext;
        this.repositoryType = repositoryType;
        this.entityType = entityType;
        this.identifierType = identifierType;
        this.entityClass = (Class)entityType;
        this.metaData();
    }

    public AbstractService(ApplicationContext applicationContext, Repository repository) {
        this.applicationContext = applicationContext;
        this.repository = repository;
        Class<?> repositoryClass = repository.getClass();
        this.repositoryType = repositoryClass.getGenericInterfaces()[0];
        Type type = ((Class)this.repositoryType).getGenericInterfaces()[0];
        ParameterizedType pType = (ParameterizedType)type;
        this.entityType = pType.getActualTypeArguments()[0];
        this.identifierType = pType.getActualTypeArguments()[1];
        this.entityClass = (Class)this.entityType;
        this.metaData();
    }

    public Type getRepositoryType() {
        return this.repositoryType;
    }

    private Type getEntityType() {
        return this.entityType;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    private Class<Entity> getEntityClass() {
        return this.entityClass;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    @PostConstruct
    private void metaData() {
        this.findAttributeAnnotations = ReflectionUtils.getAllFields(this.entityClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(FindAttribute.class)});
        if (this.applicationContext != null) {
            if (this.getRepository() == null) {
                this.repository = (Repository)this.applicationContext.getBean((Class)this.getRepositoryType());
            }
            if (this.customFindByIdRepository == null) {
                this.customFindByIdRepository = (CustomFindByIdRepository)this.applicationContext.getBean(CustomFindByIdRepository.class);
            }
            if (this.customFindDetailByIdRepository == null) {
                this.customFindDetailByIdRepository = (CustomFindDetailByIdRepository)this.applicationContext.getBean(CustomFindDetailByIdRepository.class);
            }
            if (this.customDeleteByIdRepository == null) {
                this.customDeleteByIdRepository = (CustomDeleteByIdRepository)this.applicationContext.getBean(CustomDeleteByIdRepository.class);
            }
            if (this.springApiToolsProperties == null) {
                this.springApiToolsProperties = (SpringApiToolsProperties)this.applicationContext.getBean(SpringApiToolsProperties.class);
            }
        }
    }

    @Transactional
    public Entity save(Entity entity) {
        Object id = null;
        if (entity instanceof Identifier) {
            id = ((Identifier)entity).getId();
        }
        Class classType = (Class)this.entityType;
        if (id == null && classType.isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = classType.getAnnotation(NoDelete.class);
            try {
                Field field = classType.getDeclaredField(noDelete.field());
                field.setAccessible(true);
                field.set(entity, ObjectUtils.getObject(field, noDelete.defaultValue()));
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return (Entity)this.getRepository().save(entity);
    }

    @Transactional
    public Entity update(Entity entity) throws EntityNotFoundException {
        Object entityOld = null;
        if (entity instanceof Identifier) {
            Object id = ((Identifier)entity).getId();
            entityOld = this.findById(id);
        }
        if (entityOld != null) {
            try {
                NullAwareBeanUtilsBean.getInstance().copyProperties(entityOld, entity);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            return (Entity)this.getRepository().save(entityOld);
        }
        return (Entity)this.getRepository().save(entity);
    }

    public Entity findById(ID id) throws EntityNotFoundException {
        EntityNotFoundException objectNotFound = new EntityNotFoundException("Object not found! Id: " + id + ", Type: " + this.getEntityType().getTypeName());
        Optional<Entity> result = this.customFindByIdRepository.findById(this.getEntityClass(), id);
        return result.orElse(this.getRepository().findById(id).orElseThrow(() -> objectNotFound));
    }

    public Entity findDetailById(ID id) throws EntityNotFoundException {
        Class classType = (Class)this.entityType;
        Optional result = this.customFindDetailByIdRepository.findDetailById(classType, id);
        return (Entity)result.orElseGet(() -> this.findById(id));
    }

    public boolean existsById(ID id) {
        return this.getRepository().existsById(id);
    }

    @Transactional
    public void deleteById(ID id) {
        this.findById(id);
        Class classEntity = (Class)this.entityType;
        if (classEntity.isAnnotationPresent(NoDelete.class)) {
            this.customDeleteByIdRepository.deleteById(this.entityClass, id);
        } else {
            this.getRepository().deleteById(id);
        }
    }

    @Transactional
    public void delete(Entity entity) {
        Class classEntity = (Class)this.entityType;
        if (classEntity.isAnnotationPresent(NoDelete.class)) {
            Object id = ((Identifier)entity).getId();
            this.customDeleteByIdRepository.deleteById(this.entityClass, id);
        } else {
            this.getRepository().delete(entity);
        }
    }

    public List<Entity> find(Entity filterBy) {
        Example<Entity> example = this.getDefaultExample(filterBy);
        return this.getRepository().findAll(example);
    }

    public List<Entity> find(Entity filterBy, Sort sort) {
        Example<Entity> example = this.getDefaultExample(filterBy);
        if (sort != null) {
            return this.getRepository().findAll(example, sort);
        }
        return this.getRepository().findAll(example);
    }

    public Page<Entity> find(Entity filterBy, Pageable pageable) {
        Example<Entity> example = this.getDefaultExample(filterBy);
        return this.getRepository().findAll(example, pageable);
    }

    public List<Entity> query(String query, QueryParameter queryParameter, Sort sort) {
        QueryDefinition queryDefinition = this.createQueryDefinition(query, queryParameter);
        return this.getRepository().findAll(this.getDefaultSpecification(queryDefinition), sort);
    }

    public Page<Entity> query(String query, QueryParameter queryParameter, Pageable pageable) {
        QueryDefinition queryDefinition = this.createQueryDefinition(query, queryParameter);
        return this.query(queryDefinition, pageable);
    }

    public List<Entity> query(QueryDefinition queryDefinition) {
        List<Sort.Order> orders = this.getDefaultSort(queryDefinition.getSorts());
        return this.getRepository().findAll(this.getDefaultSpecification(queryDefinition), Sort.by(orders));
    }

    public List<Entity> query(QueryDefinition queryDefinition, Sort sort) {
        Sort newSort = this.mergeSort(queryDefinition.getSorts(), sort);
        return this.getRepository().findAll(this.getDefaultSpecification(queryDefinition), newSort);
    }

    public Page<Entity> query(QueryDefinition queryDefinition, Pageable pageable) {
        pageable = this.getDefaultSortAndPageRequest(queryDefinition.getSorts(), pageable);
        return this.getRepository().findAll(this.getDefaultSpecification(queryDefinition), pageable);
    }

    public List<Entity> findAll() {
        return this.findAll(Sort.unsorted());
    }

    public List<Entity> findAll(Sort sort) {
        if (this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            Specification specification;
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                specification = Specification.where(this.hasField(noDelete.field(), ObjectUtils.getObject(field, noDelete.defaultValue())));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error in identify noDeleteEntity field for findAll", e);
            }
            return this.getRepository().findAll(specification, sort);
        }
        return this.getRepository().findAll(sort);
    }

    public Page<Entity> findAllWithPage(Pageable pageable) {
        if (this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            Specification specification;
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                specification = Specification.where(this.hasField(noDelete.field(), ObjectUtils.getObject(field, noDelete.defaultValue())));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("error in identify noDeleteEntity field for findAllPages", e);
            }
            return this.getRepository().findAll(specification, pageable);
        }
        return this.getRepository().findAll(pageable);
    }

    Specification<Entity> hasField(String field, Object value) {
        return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(field), value);
    }

    Specification<Entity> getDefaultSpecification(QueryDefinition queryDefinition) {
        List<FilterDefinition> criteria = queryDefinition.getFilters();
        SpecificationBuilder builder = new SpecificationBuilder();
        builder.distinct(queryDefinition.isDistinct());
        builder.sorts(queryDefinition.getSorts());
        builder.withStringIgnoreCase(this.springApiToolsProperties.getStringCaseSensitive());
        if (queryDefinition.getFilters() != null) {
            criteria.forEach(filterDefinition -> {
                if (!this.springApiToolsProperties.isQueryWithJoinConfiguration() && filterDefinition.isFetch()) {
                    this.log.debug((Object)String.format("getDefaultSpecification: disable fetch configuration for '%s'", filterDefinition.getField()));
                    filterDefinition.setFetch(false);
                }
                builder.filter((FilterDefinition)filterDefinition);
            });
        }
        if (this.springApiToolsProperties.isQueryWithJoinConfiguration() && queryDefinition.getJoins() != null) {
            builder.joins(queryDefinition.getJoins());
        }
        if ("or".equalsIgnoreCase(queryDefinition.getOperator())) {
            builder.withOr();
        }
        Specification spec = builder.build();
        boolean ignoreNoDeleteAnnotation = false;
        if (this.getEntityClass().isAnnotationPresent(Find.class)) {
            Find find = this.getEntityClass().getAnnotation(Find.class);
            ignoreNoDeleteAnnotation = find.ignoreNoDeleteAnnotation();
        }
        if (!ignoreNoDeleteAnnotation && this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                spec = Specification.where(spec).and(this.hasField(noDelete.field(), ObjectUtils.getObject(field, noDelete.defaultValue())));
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return spec;
    }

    Example<Entity> getDefaultExample(Entity entity) {
        ExampleMatcher matcher = ExampleMatcher.matching().withStringMatcher(ExampleMatcher.StringMatcher.EXACT).withIgnoreCase();
        HashSet<String> ignores = new HashSet<String>();
        HashSet<String> supportedDefaultValue = new HashSet<String>();
        boolean ignoreNoDeleteAnnotation = false;
        boolean ignoreDefaultValue = true;
        if (this.getEntityClass().isAnnotationPresent(Find.class)) {
            Find findAnnotation = this.getEntityClass().getAnnotation(Find.class);
            ignoreNoDeleteAnnotation = findAnnotation.ignoreNoDeleteAnnotation();
            ignoreDefaultValue = findAnnotation.ignoreDefaultValue();
            supportedDefaultValue.addAll(Arrays.asList(findAnnotation.supportedDefaultValueForAttributes()));
            if (matcher.getIgnoredPaths() != null && !matcher.getIgnoredPaths().isEmpty()) {
                ignores.addAll(matcher.getIgnoredPaths());
            }
            if (findAnnotation.ignoreAttributes().length > 0) {
                ignores.addAll(Arrays.asList(findAnnotation.ignoreAttributes()));
            }
        }
        if (!this.findAttributeAnnotations.isEmpty()) {
            this.findAttributeAnnotations.forEach(field -> {
                FindAttribute findAttributeAnnotation = field.getAnnotation(FindAttribute.class);
                if (findAttributeAnnotation.ignore()) {
                    ignores.add(field.getName());
                } else if (!findAttributeAnnotation.supportedDefaultValue()) {
                    supportedDefaultValue.add(field.getName());
                }
            });
        }
        if (ignoreDefaultValue) {
            matcher = matcher.withIgnoreNullValues();
            ReflectionUtils.getFields(this.entityClass, (Predicate[])new Predicate[]{field -> field.getType() == Integer.TYPE || field.getType() == Long.TYPE || field.getType() == Boolean.TYPE || field.getType() == Double.TYPE}).forEach(field -> {
                field.setAccessible(true);
                try {
                    if (field.getType() == Integer.TYPE) {
                        if ((Integer)field.get(entity) == 0) {
                            ignores.add(field.getName());
                        }
                    } else if (field.getType() == Long.TYPE) {
                        if ((Long)field.get(entity) == 0L) {
                            ignores.add(field.getName());
                        }
                    } else if (field.getType() == Boolean.TYPE) {
                        if (!((Boolean)field.get(entity)).booleanValue()) {
                            ignores.add(field.getName());
                        }
                    } else if (field.getType() == Double.TYPE && (Double)field.get(entity) == 0.0) {
                        ignores.add(field.getName());
                    }
                }
                catch (IllegalAccessException e) {
                    this.log.error((Object)e.getMessage());
                }
            });
        }
        ignores.removeAll(supportedDefaultValue);
        if (!ignores.isEmpty()) {
            matcher = matcher.withIgnorePaths(ignores.toArray(new String[0]));
        }
        if (!ignoreNoDeleteAnnotation && this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Field field2 = this.getEntityClass().getDeclaredField(noDelete.field());
                field2.setAccessible(true);
                field2.set(entity, ObjectUtils.getObject(field2, noDelete.defaultValue()));
                matcher = matcher.withMatcher(noDelete.field(), ExampleMatcher.GenericPropertyMatchers.exact());
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return Example.of(entity, (ExampleMatcher)matcher);
    }

    ExampleMatcher getDefaultNoDeleteMatcher() {
        if (this.getEntityClass().isAnnotationPresent(NoDelete.class)) {
            NoDelete noDelete = this.getEntityClass().getAnnotation(NoDelete.class);
            try {
                Entity entity = this.getEntityClass().newInstance();
                Field field = this.getEntityClass().getDeclaredField(noDelete.field());
                field.setAccessible(true);
                field.set(entity, 1);
                String[] fields = (String[])Arrays.stream(this.getEntityClass().getDeclaredFields()).filter(item -> !item.getName().equals(noDelete.field())).map(Field::getName).toArray(String[]::new);
                return ExampleMatcher.matching().withMatcher(noDelete.field(), ExampleMatcher.GenericPropertyMatchers.exact()).withIgnorePaths(fields);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private List<Sort.Order> getDefaultSort(List<SortDefinition> sorts) {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (sorts != null && sorts.size() > 0) {
            sorts.forEach(sortDefinition -> {
                if (sortDefinition.getDirection() == SortDefinition.Direction.ASC) {
                    orders.add(Sort.Order.asc((String)sortDefinition.getField()));
                } else {
                    orders.add(Sort.Order.desc((String)sortDefinition.getField()));
                }
            });
        }
        return orders;
    }

    private Sort mergeSort(List<SortDefinition> sortDefinitions, Sort sort) {
        List<Sort.Order> orders = this.getDefaultSort(sortDefinitions);
        sort.forEach(orders::add);
        return Sort.by(orders);
    }

    private Pageable getDefaultSortAndPageRequest(List<SortDefinition> sorts, Pageable pageable) {
        if (pageable == null) {
            return null;
        }
        Sort sort = this.mergeSort(sorts, pageable.getSort());
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sort);
    }

    public QueryDefinition createQueryDefinition(String query, QueryParameter queryParameter) {
        ArrayList<FilterDefinition> criteria = new ArrayList<FilterDefinition>();
        ArrayList<String> filters = new ArrayList<String>();
        if (query != null && !query.isEmpty()) {
            filters.addAll(Arrays.asList(query.split(",")));
        }
        if (queryParameter.getFilters() != null) {
            filters.addAll(Arrays.asList(queryParameter.getFilters()));
        }
        Pattern pattern = Pattern.compile("(\\w.*[^><!=])(>=|<=|=|!=|>|<|\\$like|\\$notLike|\\$isNull|\\$isNotNull|\\$startsWith|\\$endsWith|\\$isEmpty|\\$isNotEmpty|\\$btw|\\$in)(\\w.*|(>=|<=|=|!=|>|<)?+;\\d)?", 256);
        for (String filter : filters) {
            Matcher matcher = pattern.matcher(filter);
            if (matcher.find()) {
                criteria.add(new FilterDefinition(matcher.group(1), matcher.group(2), matcher.group(3)));
                continue;
            }
            this.log.error((Object)"createQueryDefinition: invalid filter for query, matcher not found.");
            throw new SearchException("invalid filter for query, matcher not found.");
        }
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setDistinct(queryParameter.isDistinct());
        queryDefinition.setFilters(criteria);
        queryDefinition.setOperator(queryParameter.getOperator());
        if (this.springApiToolsProperties.isQueryWithJoinConfiguration() && queryParameter.getFetches() != null) {
            ArrayList<JoinDefinition> joinDefinitions = new ArrayList<JoinDefinition>();
            queryDefinition.setJoins(joinDefinitions);
            for (String fetch : queryParameter.getFetches()) {
                joinDefinitions.add(new JoinDefinition(fetch, true));
            }
        }
        return queryDefinition;
    }
}

