/*
 * Decompiled with CFR 0.152.
 */
package com.eoscode.springapitools.util;

import com.eoscode.springapitools.util.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Date;

public class ObjectUtils {
    public static <T> T getObject(Field field, String value) {
        return ObjectUtils.getObject(field.getType(), value);
    }

    public static <T> T getObject(Class<?> type, String value) {
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            if ("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
                return (T)Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value)) {
                return (T)Boolean.FALSE;
            }
            return (T)("true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == BigDecimal.class) {
            return (T)BigDecimal.valueOf(Double.parseDouble(value));
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Date.class) {
            if (StringUtils.isNumber(value)) {
                return (T)new Date(Long.parseLong(value));
            }
            Instant instant = Instant.parse(value);
            return (T)Date.from(instant);
        }
        return (T)value;
    }

    public static <T> T getObject(Class<?> type, Object value) {
        if (type == Date.class) {
            if (value.getClass() == String.class) {
                String str = value.toString();
                if (StringUtils.isNumber(str)) {
                    return (T)new Date(Long.parseLong(str));
                }
                Instant instant = Instant.parse(str);
                return (T)Date.from(instant);
            }
            if (value.getClass() == Long.class || value.getClass() == Integer.class) {
                return (T)new Date(Long.parseLong(value.toString()));
            }
        } else if (type != String.class && value.getClass() == String.class) {
            return ObjectUtils.getObject(type, value.toString());
        }
        return (T)value;
    }
}

