/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql;

import com.github.fabienbarbero.sql.HasSQLConnection;
import com.github.fabienbarbero.sql.SQLFaultException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SQLAccess
implements AutoCloseable,
HasSQLConnection {
    private final Connection conn;

    public static SQLAccess of(DataSource ds) {
        return SQLAccess.of(ds, false);
    }

    public static SQLAccess of(DataSource ds, boolean readOnly) {
        try {
            Connection conn = ds.getConnection();
            conn.setAutoCommit(false);
            conn.setReadOnly(readOnly);
            return new SQLAccess(conn);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting sql access", ex);
        }
    }

    public static SQLAccess of(Connection conn) {
        return SQLAccess.of(conn, false);
    }

    public static SQLAccess of(Connection conn, boolean readOnly) {
        try {
            conn.setAutoCommit(false);
            conn.setReadOnly(readOnly);
            return new SQLAccess(conn);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting sql access", ex);
        }
    }

    private SQLAccess(Connection conn) {
        this.conn = conn;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void close() throws Exception {
    }
}

