/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql;

import com.github.fabienbarbero.sql.SQLFaultException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SQLRecord {
    private final ResultSet rs;

    SQLRecord(ResultSet rs) {
        this.rs = rs;
    }

    public List<Column> getColumns() throws SQLFaultException {
        try {
            ResultSetMetaData metaData = this.rs.getMetaData();
            ArrayList<Column> columns = new ArrayList<Column>(metaData.getColumnCount());
            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                columns.add(new Column(metaData.getColumnName(i + 1), metaData.getTableName(i + 1)));
            }
            return Collections.unmodifiableList(columns);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting columns names", ex);
        }
    }

    public Optional<String> getString(String column) throws SQLFaultException {
        try {
            return Optional.ofNullable(this.rs.getString(column));
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public <E extends Enum<E>> Optional<E> getEnum(String column, Class<E> type) throws SQLFaultException {
        return this.getString(column).map(str -> Enum.valueOf(type, str));
    }

    public Optional<Blob> getBlob(String column) throws SQLFaultException {
        try {
            return Optional.ofNullable(this.rs.getBlob(column));
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<Clob> getClob(String column) throws SQLFaultException {
        try {
            return Optional.ofNullable(this.rs.getClob(column));
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<BigDecimal> getBigDecimal(String column) throws SQLFaultException {
        try {
            return Optional.ofNullable(this.rs.getBigDecimal(column));
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<byte[]> getBytes(String column) throws SQLFaultException {
        try {
            return Optional.ofNullable(this.rs.getBytes(column));
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<Integer> getInteger(String column) throws SQLFaultException {
        try {
            int value = this.rs.getInt(column);
            if (this.rs.wasNull()) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<Float> getFloat(String column) throws SQLFaultException {
        try {
            float value = this.rs.getFloat(column);
            if (this.rs.wasNull()) {
                return Optional.empty();
            }
            return Optional.of(Float.valueOf(value));
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<Long> getLong(String column) throws SQLFaultException {
        try {
            long value = this.rs.getLong(column);
            if (this.rs.wasNull()) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<Short> getShort(String column) throws SQLFaultException {
        try {
            short value = this.rs.getShort(column);
            if (this.rs.wasNull()) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<LocalDate> getLocalDate(String column) throws SQLFaultException {
        try {
            Date date = this.rs.getDate(column);
            return Optional.ofNullable(date).map(Date::toLocalDate);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<Instant> getInstant(String column) throws SQLFaultException {
        try {
            Timestamp ts = this.rs.getTimestamp(column);
            return Optional.ofNullable(ts).map(Timestamp::toInstant);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<LocalTime> getLocalTime(String column) throws SQLFaultException {
        try {
            Time time = this.rs.getTime(column);
            return Optional.ofNullable(time).map(Time::toLocalTime);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public Optional<Boolean> getBoolean(String column) throws SQLFaultException {
        try {
            boolean value = this.rs.getBoolean(column);
            if (this.rs.wasNull()) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL value", ex);
        }
    }

    public static class Column {
        private final String name;
        private final String table;

        private Column(String name, String table) {
            this.name = name;
            this.table = table;
        }

        public String getName() {
            return this.name;
        }

        public String getTable() {
            return this.table;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Column) {
                Column col = (Column)obj;
                return this.table.equals(col.table) && this.name.equals(col.name);
            }
            return false;
        }

        public int hashCode() {
            return 253543 + Objects.hash(this.name, this.table);
        }

        public String toString() {
            return this.table + "." + this.name;
        }
    }
}

