/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql;

import com.github.fabienbarbero.sql.SQLFaultException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;

public class SQLSavepoint
implements AutoCloseable {
    private final Savepoint sp;
    private final Connection conn;

    SQLSavepoint(Savepoint sp, Connection conn) {
        this.sp = sp;
        this.conn = conn;
    }

    public String getName() {
        try {
            return this.sp.getSavepointName();
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting savepoint name", ex);
        }
    }

    public void rollback() throws SQLFaultException {
        try {
            this.conn.rollback(this.sp);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Savepoint rollback error", ex);
        }
    }

    @Override
    public void close() throws SQLFaultException {
        try {
            this.conn.releaseSavepoint(this.sp);
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Savepoint release error", ex);
        }
    }
}

