/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql.helper;

import com.github.fabienbarbero.sql.helper.SQLForeignKey;
import com.github.fabienbarbero.sql.helper.SQLIndex;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class SQLColumn {
    private final String name;
    private final int type;
    private final int size;
    private final boolean nullable;
    private final String tableName;
    private final boolean primary;
    private final List<SQLIndex> indexes;
    private final List<SQLForeignKey> foreignKeys;

    SQLColumn(ResultSet rs, boolean primary, String tableName, List<SQLIndex> indexes, List<SQLForeignKey> foreignKeys) throws SQLException {
        this.name = rs.getString("COLUMN_NAME");
        this.type = rs.getInt("DATA_TYPE");
        this.size = rs.getInt("COLUMN_SIZE");
        this.nullable = rs.getBoolean("NULLABLE");
        this.primary = primary;
        this.tableName = tableName;
        this.indexes = indexes;
        this.foreignKeys = foreignKeys;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public int getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<SQLIndex> getIndexes() {
        return this.indexes;
    }

    public boolean isIndexed() {
        return !this.indexes.isEmpty();
    }

    public List<SQLForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLColumn) {
            SQLColumn col = (SQLColumn)obj;
            return this.name.equals(col.name) && this.tableName.equals(col.tableName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.name);
        hash = 61 * hash + Objects.hashCode(this.tableName);
        return hash;
    }
}

