/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;

public class SQLForeignKey {
    private final String name;
    private final String pkTableName;
    private final String pkColumnName;
    private final String fkTableName;
    private final String fkColumnName;
    private final Rule updateRule;
    private final Rule deleteRule;

    SQLForeignKey(ResultSet rs, Rule updateRule, Rule deleteRule) throws SQLException {
        this.name = rs.getString("FK_NAME");
        this.pkTableName = rs.getString("PKTABLE_NAME");
        this.pkColumnName = rs.getString("PKCOLUMN_NAME");
        this.fkTableName = rs.getString("FKTABLE_NAME");
        this.fkColumnName = rs.getString("FKCOLUMN_NAME");
        this.updateRule = updateRule;
        this.deleteRule = deleteRule;
    }

    public String getName() {
        return this.name;
    }

    public String getPKTableName() {
        return this.pkTableName;
    }

    public String getPKColumnName() {
        return this.pkColumnName;
    }

    public String getFKTableName() {
        return this.fkTableName;
    }

    public String getFKColumnName() {
        return this.fkColumnName;
    }

    public Rule getUpdateRule() {
        return this.updateRule;
    }

    public Rule getDeleteRule() {
        return this.deleteRule;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLForeignKey) {
            SQLForeignKey key = (SQLForeignKey)obj;
            return this.name.equals(key.name) && this.pkTableName.equals(key.pkTableName) && this.pkColumnName.equals(key.pkColumnName) && this.fkTableName.equals(key.fkTableName) && this.fkColumnName.equals(key.fkColumnName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.name);
        hash = 53 * hash + Objects.hashCode(this.pkTableName);
        hash = 53 * hash + Objects.hashCode(this.pkColumnName);
        hash = 53 * hash + Objects.hashCode(this.fkTableName);
        hash = 53 * hash + Objects.hashCode(this.fkColumnName);
        return hash;
    }

    public static enum Rule {
        SET_DEFAULT(4),
        RESTRICT(1),
        SET_NULL(2),
        CASCADE(0),
        NO_ACTION(3);

        private final int value;

        private Rule(int value) {
            this.value = value;
        }

        static Rule from(int value) {
            return Arrays.stream(Rule.values()).filter(rule -> rule.value == value).findFirst().get();
        }
    }
}

