/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql.helper;

import com.github.fabienbarbero.sql.HasSQLConnection;
import com.github.fabienbarbero.sql.SQLFaultException;
import com.github.fabienbarbero.sql.helper.SQLColumn;
import com.github.fabienbarbero.sql.helper.SQLForeignKey;
import com.github.fabienbarbero.sql.helper.SQLIndex;
import com.github.fabienbarbero.sql.helper.SQLTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SQLHelper {
    private final Connection conn;

    public SQLHelper(Connection conn) {
        this.conn = conn;
    }

    public SQLHelper(HasSQLConnection conn) {
        this.conn = conn.getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTableExists(String tableName) throws SQLFaultException {
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            try (ResultSet rs = metaData.getTables(null, null, tableName, null);){
                boolean bl = rs.next();
                return bl;
            }
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL tables", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTableColumnExists(String tableName, String columnName) throws SQLFaultException {
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(null, null, tableName, columnName);){
                boolean bl = rs.next();
                return bl;
            }
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL columns", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SQLTable> getTables() throws SQLFaultException {
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            try (ResultSet rs = metaData.getTables(null, null, "%", null);){
                ArrayList<SQLTable> tables = new ArrayList<SQLTable>();
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    tables.add(new SQLTable(tableName, this.getColumns(tableName, metaData)));
                }
                ArrayList<SQLTable> arrayList = tables;
                return arrayList;
            }
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL tables", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SQLTable getTable(String tableName) throws SQLFaultException {
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            try (ResultSet rs = metaData.getTables(null, null, tableName, null);){
                if (rs.next()) {
                    SQLTable sQLTable = new SQLTable(tableName, this.getColumns(tableName, metaData));
                    return sQLTable;
                }
                SQLTable sQLTable = null;
                return sQLTable;
            }
        }
        catch (SQLException ex) {
            throw new SQLFaultException("Error getting SQL tables", ex);
        }
    }

    private List<SQLColumn> getColumns(String tableName, DatabaseMetaData metaData) throws SQLException {
        List<String> primaryColumns = this.getPrimaryKeys(tableName, metaData);
        List<SQLIndex> indexes = this.getIndexes(tableName, metaData);
        List<SQLForeignKey> foreignKeys = this.getForeignKeys(tableName, metaData);
        try (ResultSet rs = metaData.getColumns(null, null, tableName, null);){
            ArrayList<SQLColumn> columns = new ArrayList<SQLColumn>();
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                List<SQLIndex> colIndexes = indexes.stream().filter(idx -> idx.getColumnName().equalsIgnoreCase(colName)).collect(Collectors.toList());
                List<SQLForeignKey> colForeignKeys = foreignKeys.stream().filter(key -> key.getFKColumnName().equalsIgnoreCase(colName)).collect(Collectors.toList());
                columns.add(new SQLColumn(rs, primaryColumns.contains(colName), tableName, colIndexes, colForeignKeys));
            }
            ArrayList<SQLColumn> arrayList = columns;
            return arrayList;
        }
    }

    private List<SQLForeignKey> getForeignKeys(String tableName, DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getImportedKeys(null, null, tableName);){
            ArrayList<SQLForeignKey> keys = new ArrayList<SQLForeignKey>();
            while (rs.next()) {
                keys.add(new SQLForeignKey(rs, SQLForeignKey.Rule.from(rs.getShort("UPDATE_RULE")), SQLForeignKey.Rule.from(rs.getShort("DELETE_RULE"))));
            }
            ArrayList<SQLForeignKey> arrayList = keys;
            return arrayList;
        }
    }

    private List<String> getPrimaryKeys(String tableName, DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getImportedKeys(null, null, tableName);){
            ArrayList<String> keys = new ArrayList<String>();
            while (rs.next()) {
                keys.add(rs.getString("PKCOLUMN_NAME"));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
    }

    private List<SQLIndex> getIndexes(String tableName, DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getIndexInfo(null, null, tableName, false, false);){
            ArrayList<SQLIndex> indexes = new ArrayList<SQLIndex>();
            while (rs.next()) {
                indexes.add(new SQLIndex(rs));
            }
            ArrayList<SQLIndex> arrayList = indexes;
            return arrayList;
        }
    }
}

