/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.sql;

import com.github.fabienbarbero.sql.AbstractDAO;
import com.github.fabienbarbero.sql.BaseDAO;
import com.github.fabienbarbero.sql.BaseEntity;
import com.github.fabienbarbero.sql.HasSQLConnection;
import com.github.fabienbarbero.sql.SQLFaultException;
import com.github.fabienbarbero.sql.SQLQueryBuilder;

public abstract class AbstractBaseDAO<E extends BaseEntity<PK>, PK>
extends AbstractDAO<E>
implements BaseDAO<E, PK> {
    private final String primaryColumnName;

    public AbstractBaseDAO(String tableName, String primaryColumnName, HasSQLConnection conn) {
        super(tableName, conn);
        this.primaryColumnName = primaryColumnName;
    }

    @Override
    public E find(PK key) throws SQLFaultException {
        return (E)((BaseEntity)this.querySingle(this, new SQLQueryBuilder("select * from " + this.tableName + " where " + this.primaryColumnName + " = ?", key)));
    }

    @Override
    public void deleteEntity(PK key) throws SQLFaultException {
        this.execute(new SQLQueryBuilder("delete from " + this.tableName + " where " + this.primaryColumnName + " = ?", key));
    }

    @Override
    public void deleteEntity(E entity) throws SQLFaultException {
        this.deleteEntity((E)entity.getPrimaryKey());
    }
}

